/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.AST;
import de.fraunhofer.aisec.cpg.graph.ArgumentHolder;
import de.fraunhofer.aisec.cpg.graph.HasBase;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ProblemExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.RangeExpression;
import de.fraunhofer.aisec.cpg.graph.types.HasType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0001H\u0016J\u001e\u0010\u0018\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001bH\u0002J\b\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u0001H\u0016J\u0018\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R&\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00018\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u00018\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u000b\u00a8\u0006+"}, d2={"Lde/fraunhofer/aisec/cpg/graph/statements/expressions/SubscriptExpression;", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "Lde/fraunhofer/aisec/cpg/graph/HasBase;", "Lde/fraunhofer/aisec/cpg/graph/types/HasType$TypeObserver;", "Lde/fraunhofer/aisec/cpg/graph/ArgumentHolder;", "()V", "value", "arrayExpression", "getArrayExpression", "()Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "setArrayExpression", "(Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;)V", "base", "getBase", "operatorCode", "", "getOperatorCode", "()Ljava/lang/String;", "subscriptExpression", "getSubscriptExpression", "setSubscriptExpression", "addArgument", "", "expression", "assignedTypeChanged", "assignedTypes", "", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "src", "Lde/fraunhofer/aisec/cpg/graph/types/HasType;", "equals", "", "other", "", "getSubscriptType", "arrayType", "hashCode", "", "replaceArgument", "old", "new", "typeChanged", "newType", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nSubscriptExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubscriptExpression.kt\nde/fraunhofer/aisec/cpg/graph/statements/expressions/SubscriptExpression\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1549#2:125\n1620#2,3:126\n*S KotlinDebug\n*F\n+ 1 SubscriptExpression.kt\nde/fraunhofer/aisec/cpg/graph/statements/expressions/SubscriptExpression\n*L\n91#1:125\n91#1:126,3\n*E\n"})
public final class SubscriptExpression
extends Expression
implements HasBase,
HasType.TypeObserver,
ArgumentHolder {
    @AST
    @NotNull
    private Expression arrayExpression = new ProblemExpression("could not parse array expression", null, 2, null);
    @AST
    @NotNull
    private Expression subscriptExpression = new ProblemExpression("could not parse index expression", null, 2, null);

    @NotNull
    public final Expression getArrayExpression() {
        return this.arrayExpression;
    }

    public final void setArrayExpression(@NotNull Expression value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.arrayExpression.unregisterTypeObserver(this);
        this.arrayExpression = value;
        this.setType(this.getSubscriptType(value.getType()));
        value.registerTypeObserver(this);
    }

    @NotNull
    public final Expression getSubscriptExpression() {
        return this.subscriptExpression;
    }

    public final void setSubscriptExpression(@NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"<set-?>");
        this.subscriptExpression = expression;
    }

    @Override
    @NotNull
    public Expression getBase() {
        return this.arrayExpression;
    }

    @Override
    @NotNull
    public String getOperatorCode() {
        return "[]";
    }

    private final Type getSubscriptType(Type arrayType) {
        return this.subscriptExpression instanceof RangeExpression ? arrayType : arrayType.dereference();
    }

    @Override
    public void typeChanged(@NotNull Type newType, @NotNull HasType src) {
        Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (!Intrinsics.areEqual((Object)src, (Object)this.arrayExpression)) {
            return;
        }
        this.setType(this.getSubscriptType(newType));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void assignedTypeChanged(@NotNull Set<? extends Type> assignedTypes, @NotNull HasType src) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(assignedTypes, (String)"assignedTypes");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (!Intrinsics.areEqual((Object)src, (Object)this.arrayExpression)) {
            return;
        }
        Iterable iterable = assignedTypes;
        SubscriptExpression subscriptExpression = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Type type = (Type)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getSubscriptType((Type)it));
        }
        subscriptExpression.addAssignedTypes(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
    }

    @Override
    public void addArgument(@NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (this.arrayExpression instanceof ProblemExpression) {
            this.setArrayExpression(expression);
        } else if (this.subscriptExpression instanceof ProblemExpression) {
            this.subscriptExpression = expression;
        }
    }

    @Override
    public boolean replaceArgument(@NotNull Expression old, @NotNull Expression expression) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"new");
        if (Intrinsics.areEqual((Object)this.arrayExpression, (Object)old)) {
            this.setArrayExpression(expression);
            bl = true;
        } else if (Intrinsics.areEqual((Object)this.subscriptExpression, (Object)old)) {
            this.subscriptExpression = expression;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SubscriptExpression)) {
            return false;
        }
        return super.equals(other) && Intrinsics.areEqual((Object)this.arrayExpression, (Object)((SubscriptExpression)other).arrayExpression) && Intrinsics.areEqual((Object)this.subscriptExpression, (Object)((SubscriptExpression)other).subscriptExpression);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{super.hashCode(), this.arrayExpression, this.subscriptExpression};
        return Objects.hash(objectArray);
    }

    @Override
    public boolean removeArgument(@NotNull Expression expression) {
        return ArgumentHolder.DefaultImpls.removeArgument(this, expression);
    }

    @Override
    public void plusAssign(@NotNull Expression node) {
        ArgumentHolder.DefaultImpls.plusAssign(this, node);
    }

    @Override
    public void minusAssign(@NotNull Expression node) {
        ArgumentHolder.DefaultImpls.minusAssign(this, node);
    }
}

