/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.AST;
import de.fraunhofer.aisec.cpg.graph.ArgumentHolder;
import de.fraunhofer.aisec.cpg.graph.HasBase;
import de.fraunhofer.aisec.cpg.graph.NameKt;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ProblemExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Reference;
import de.fraunhofer.aisec.cpg.graph.types.HasType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0016J\b\u0010\u001e\u001a\u00020\rH\u0016J\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0013H\u0002R&\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0016@VX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lde/fraunhofer/aisec/cpg/graph/statements/expressions/MemberExpression;", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Reference;", "Lde/fraunhofer/aisec/cpg/graph/ArgumentHolder;", "Lde/fraunhofer/aisec/cpg/graph/HasBase;", "()V", "value", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "base", "getBase", "()Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "setBase", "(Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;)V", "operatorCode", "", "getOperatorCode", "()Ljava/lang/String;", "setOperatorCode", "(Ljava/lang/String;)V", "addArgument", "", "expression", "equals", "", "other", "", "hashCode", "", "replaceArgument", "old", "new", "toString", "typeChanged", "newType", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "src", "Lde/fraunhofer/aisec/cpg/graph/types/HasType;", "updateName", "cpg-core"})
public final class MemberExpression
extends Reference
implements ArgumentHolder,
HasBase {
    @AST
    @NotNull
    private Expression base = new ProblemExpression("could not parse base expression", null, 2, null);
    @Nullable
    private String operatorCode;

    @Override
    @NotNull
    public Expression getBase() {
        return this.base;
    }

    public void setBase(@NotNull Expression value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.base.unregisterTypeObserver(this);
        this.base = value;
        this.updateName();
        value.registerTypeObserver(this);
    }

    @Override
    @Nullable
    public String getOperatorCode() {
        return this.operatorCode;
    }

    public void setOperatorCode(@Nullable String string) {
        this.operatorCode = string;
    }

    @Override
    @NotNull
    public String toString() {
        String string = new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("base", (Object)this.getBase()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public void addArgument(@NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.setBase(expression);
    }

    @Override
    public boolean replaceArgument(@NotNull Expression old, @NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"new");
        if (Intrinsics.areEqual((Object)old, (Object)this.getBase())) {
            this.setBase(expression);
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MemberExpression)) {
            return false;
        }
        return super.equals(other) && Intrinsics.areEqual((Object)this.getBase(), (Object)((MemberExpression)other).getBase());
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{super.hashCode(), this.getBase()};
        return Objects.hash(objectArray);
    }

    @Override
    public void typeChanged(@NotNull Type newType, @NotNull HasType src) {
        Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (Intrinsics.areEqual((Object)src, (Object)this.getBase())) {
            this.updateName();
        } else {
            super.typeChanged(newType, src);
        }
    }

    private final void updateName() {
        this.setName(NameKt.fqn(this.getBase().getType().getRoot().getName(), this.getName().getLocalName()));
    }

    @Override
    public boolean removeArgument(@NotNull Expression expression) {
        return ArgumentHolder.DefaultImpls.removeArgument(this, expression);
    }

    @Override
    public void plusAssign(@NotNull Expression node) {
        ArgumentHolder.DefaultImpls.plusAssign(this, node);
    }

    @Override
    public void minusAssign(@NotNull Expression node) {
        ArgumentHolder.DefaultImpls.minusAssign(this, node);
    }
}

