/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.AST;
import de.fraunhofer.aisec.cpg.graph.ArgumentHolder;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001H\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0001H\u0016R \u0010\u0004\u001a\u0004\u0018\u00010\u00018\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0004\u0018\u00010\u00018\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\u0018"}, d2={"Lde/fraunhofer/aisec/cpg/graph/statements/expressions/KeyValueExpression;", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "Lde/fraunhofer/aisec/cpg/graph/ArgumentHolder;", "()V", "key", "getKey", "()Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "setKey", "(Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;)V", "value", "getValue", "setValue", "addArgument", "", "expression", "equals", "", "other", "", "hashCode", "", "replaceArgument", "old", "new", "cpg-core"})
public final class KeyValueExpression
extends Expression
implements ArgumentHolder {
    @AST
    @Nullable
    private Expression key;
    @AST
    @Nullable
    private Expression value;

    @Nullable
    public final Expression getKey() {
        return this.key;
    }

    public final void setKey(@Nullable Expression expression) {
        this.key = expression;
    }

    @Nullable
    public final Expression getValue() {
        return this.value;
    }

    public final void setValue(@Nullable Expression expression) {
        this.value = expression;
    }

    @Override
    public void addArgument(@NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (this.key == null) {
            this.key = expression;
        } else if (this.value == null) {
            this.value = expression;
        }
    }

    @Override
    public boolean replaceArgument(@NotNull Expression old, @NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"new");
        if (Intrinsics.areEqual((Object)this.key, (Object)old)) {
            this.key = expression;
            return true;
        }
        if (Intrinsics.areEqual((Object)this.value, (Object)old)) {
            this.value = expression;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KeyValueExpression)) {
            return false;
        }
        return super.equals(other) && Intrinsics.areEqual((Object)this.key, (Object)((KeyValueExpression)other).key) && Intrinsics.areEqual((Object)this.value, (Object)((KeyValueExpression)other).value);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{super.hashCode(), this.key, this.value};
        return Objects.hash(objectArray);
    }

    @Override
    public boolean removeArgument(@NotNull Expression expression) {
        return ArgumentHolder.DefaultImpls.removeArgument(this, expression);
    }

    @Override
    public void plusAssign(@NotNull Expression node) {
        ArgumentHolder.DefaultImpls.plusAssign(this, node);
    }

    @Override
    public void minusAssign(@NotNull Expression node) {
        ArgumentHolder.DefaultImpls.minusAssign(this, node);
    }
}

