/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.TypeBuilderKt;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.types.AutoType;
import de.fraunhofer.aisec.cpg.graph.types.HasType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import de.fraunhofer.aisec.cpg.helpers.IdentitySetKt;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Transient;

@NodeEntity
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R0\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\f\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\t\u00a8\u0006\u001d"}, d2={"Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "Lde/fraunhofer/aisec/cpg/graph/statements/Statement;", "Lde/fraunhofer/aisec/cpg/graph/types/HasType;", "()V", "value", "", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "assignedTypes", "getAssignedTypes", "()Ljava/util/Set;", "setAssignedTypes", "(Ljava/util/Set;)V", "type", "getType", "()Lde/fraunhofer/aisec/cpg/graph/types/Type;", "setType", "(Lde/fraunhofer/aisec/cpg/graph/types/Type;)V", "typeObservers", "", "Lde/fraunhofer/aisec/cpg/graph/types/HasType$TypeObserver;", "getTypeObservers", "equals", "", "other", "", "hashCode", "", "toString", "", "cpg-core"})
public abstract class Expression
extends Statement
implements HasType {
    @Transient
    @NotNull
    private final Set<HasType.TypeObserver> typeObservers = IdentitySetKt.identitySetOf(new HasType.TypeObserver[0]);
    @NotNull
    private Type type = TypeBuilderKt.unknownType(this);
    @NotNull
    private Set<? extends Type> assignedTypes = new LinkedHashSet();

    @Override
    @NotNull
    public Set<HasType.TypeObserver> getTypeObservers() {
        return this.typeObservers;
    }

    @Override
    @NotNull
    public Type getType() {
        return this.type;
    }

    @Override
    public void setType(@NotNull Type value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Type old = this.type;
        this.type = value;
        if (!Intrinsics.areEqual((Object)old, (Object)value)) {
            this.informObservers(HasType.TypeObserver.ChangeType.TYPE);
        }
        if (!(value instanceof UnknownType) && !(value instanceof AutoType)) {
            this.addAssignedType(value);
        }
    }

    @Override
    @NotNull
    public Set<Type> getAssignedTypes() {
        return this.assignedTypes;
    }

    @Override
    public void setAssignedTypes(@NotNull Set<? extends Type> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (Intrinsics.areEqual(this.assignedTypes, value)) {
            return;
        }
        this.assignedTypes = value;
        this.informObservers(HasType.TypeObserver.ChangeType.ASSIGNED_TYPE);
    }

    @Override
    @NotNull
    public String toString() {
        String string = new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("type", (Object)this.getType()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Expression)) {
            return false;
        }
        return super.equals(other) && Intrinsics.areEqual((Object)this.getType(), (Object)((Expression)other).getType());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void addAssignedType(@NotNull Type type) {
        HasType.DefaultImpls.addAssignedType(this, type);
    }

    @Override
    public void addAssignedTypes(@NotNull Set<? extends Type> types2) {
        HasType.DefaultImpls.addAssignedTypes(this, types2);
    }

    @Override
    public void informObservers(@NotNull HasType.TypeObserver.ChangeType changeType) {
        HasType.DefaultImpls.informObservers(this, changeType);
    }

    @Override
    public void registerTypeObserver(@NotNull HasType.TypeObserver typeObserver) {
        HasType.DefaultImpls.registerTypeObserver(this, typeObserver);
    }

    @Override
    public void unregisterTypeObserver(@NotNull HasType.TypeObserver typeObserver) {
        HasType.DefaultImpls.unregisterTypeObserver(this, typeObserver);
    }
}

