/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.AST;
import de.fraunhofer.aisec.cpg.graph.ArgumentHolder;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.TypeBuilderKt;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ProblemExpression;
import de.fraunhofer.aisec.cpg.graph.types.HasType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 %2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0001H\u0016J\u001e\u0010\u0013\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u0001H\u0016J\u000e\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u001dJ\u0018\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00018\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006&"}, d2={"Lde/fraunhofer/aisec/cpg/graph/statements/expressions/CastExpression;", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "Lde/fraunhofer/aisec/cpg/graph/ArgumentHolder;", "Lde/fraunhofer/aisec/cpg/graph/types/HasType$TypeObserver;", "()V", "value", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "castType", "getCastType", "()Lde/fraunhofer/aisec/cpg/graph/types/Type;", "setCastType", "(Lde/fraunhofer/aisec/cpg/graph/types/Type;)V", "expression", "getExpression", "()Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "setExpression", "(Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;)V", "addArgument", "", "assignedTypeChanged", "assignedTypes", "", "src", "Lde/fraunhofer/aisec/cpg/graph/types/HasType;", "equals", "", "other", "", "hashCode", "", "replaceArgument", "old", "new", "setCastOperator", "operatorCode", "typeChanged", "newType", "Companion", "cpg-core"})
public final class CastExpression
extends Expression
implements ArgumentHolder,
HasType.TypeObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @AST
    @NotNull
    private Expression expression = new ProblemExpression("could not parse inner expression", null, 2, null);
    @NotNull
    private Type castType = TypeBuilderKt.unknownType(this);
    private static final Logger log = LoggerFactory.getLogger(CastExpression.class);

    @NotNull
    public final Expression getExpression() {
        return this.expression;
    }

    public final void setExpression(@NotNull Expression value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.expression.unregisterTypeObserver(this);
        this.expression = value;
        value.registerTypeObserver(this);
    }

    @NotNull
    public final Type getCastType() {
        return this.castType;
    }

    public final void setCastType(@NotNull Type value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.castType = value;
        this.setType(value);
    }

    public final void setCastOperator(int operatorCode) {
        String localName = null;
        switch (operatorCode) {
            case 0: {
                localName = "cast";
                break;
            }
            case 1: {
                localName = "dynamic_cast";
                break;
            }
            case 2: {
                localName = "static_cast";
                break;
            }
            case 3: {
                localName = "reinterpret_cast";
                break;
            }
            case 4: {
                localName = "const_cast";
                break;
            }
            default: {
                log.error("unknown operator {}", (Object)operatorCode);
            }
        }
        if (localName != null) {
            this.setName(new Name(localName, null, this.getLanguage()));
        }
    }

    @Override
    public void addArgument(@NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.setExpression(expression);
    }

    @Override
    public boolean replaceArgument(@NotNull Expression old, @NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"new");
        if (Intrinsics.areEqual((Object)this.expression, (Object)old)) {
            this.setExpression(expression);
            return true;
        }
        return false;
    }

    @Override
    public void typeChanged(@NotNull Type newType, @NotNull HasType src) {
        Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
    }

    @Override
    public void assignedTypeChanged(@NotNull Set<? extends Type> assignedTypes, @NotNull HasType src) {
        Intrinsics.checkNotNullParameter(assignedTypes, (String)"assignedTypes");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (Intrinsics.areEqual((Object)src, (Object)this.expression)) {
            this.addAssignedTypes(assignedTypes);
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CastExpression)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.expression, (Object)((CastExpression)other).expression) && Intrinsics.areEqual((Object)this.castType, (Object)((CastExpression)other).castType);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{super.hashCode(), this.expression, this.castType};
        return Objects.hash(objectArray);
    }

    @Override
    public boolean removeArgument(@NotNull Expression expression) {
        return ArgumentHolder.DefaultImpls.removeArgument(this, expression);
    }

    @Override
    public void plusAssign(@NotNull Expression node) {
        ArgumentHolder.DefaultImpls.plusAssign(this, node);
    }

    @Override
    public void minusAssign(@NotNull Expression node) {
        ArgumentHolder.DefaultImpls.minusAssign(this, node);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fraunhofer/aisec/cpg/graph/statements/expressions/CastExpression$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

