/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.graph.AST;
import de.fraunhofer.aisec.cpg.graph.AccessValues;
import de.fraunhofer.aisec.cpg.graph.ArgumentHolder;
import de.fraunhofer.aisec.cpg.graph.HasBase;
import de.fraunhofer.aisec.cpg.graph.HasOperatorCode;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ProblemExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Reference;
import de.fraunhofer.aisec.cpg.graph.types.HasType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0001H\u0016J\u001e\u0010\u001b\u001a\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u0001H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0001H\u0002J\b\u0010#\u001a\u00020\u0019H\u0002J\b\u0010$\u001a\u00020\u0019H\u0002J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J'\u0010)\u001a\u0004\u0018\u0001H*\"\n\b\u0000\u0010**\u0004\u0018\u00010\u00012\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H*0,\u00a2\u0006\u0002\u0010-J'\u0010.\u001a\u0004\u0018\u0001H*\"\n\b\u0000\u0010**\u0004\u0018\u00010\u00012\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H*0,\u00a2\u0006\u0002\u0010-J\b\u0010/\u001a\u000200H\u0016J\u0018\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020\u00012\u0006\u00103\u001a\u00020\u0001H\u0016J\b\u00104\u001a\u00020\u000fH\u0016J\u0018\u00105\u001a\u00020\u00192\u0006\u00106\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR&\u0010\u000b\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00018\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000eR(\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R&\u0010\u0015\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00018\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\t\"\u0004\b\u0017\u0010\u000e\u00a8\u00067"}, d2={"Lde/fraunhofer/aisec/cpg/graph/statements/expressions/BinaryOperator;", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "Lde/fraunhofer/aisec/cpg/graph/HasBase;", "Lde/fraunhofer/aisec/cpg/graph/HasOperatorCode;", "Lde/fraunhofer/aisec/cpg/graph/ArgumentHolder;", "Lde/fraunhofer/aisec/cpg/graph/types/HasType$TypeObserver;", "()V", "base", "getBase", "()Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "value", "lhs", "getLhs", "setLhs", "(Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;)V", "", "operatorCode", "getOperatorCode", "()Ljava/lang/String;", "setOperatorCode", "(Ljava/lang/String;)V", "rhs", "getRhs", "setRhs", "addArgument", "", "expression", "assignedTypeChanged", "assignedTypes", "", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "src", "Lde/fraunhofer/aisec/cpg/graph/types/HasType;", "connectNewLhs", "connectNewRhs", "disconnectOldLhs", "disconnectOldRhs", "equals", "", "other", "", "getLhsAs", "T", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "getRhsAs", "hashCode", "", "replaceArgument", "old", "new", "toString", "typeChanged", "newType", "cpg-core"})
public class BinaryOperator
extends Expression
implements HasBase,
HasOperatorCode,
ArgumentHolder,
HasType.TypeObserver {
    @AST
    @NotNull
    private Expression lhs = new ProblemExpression("could not parse lhs", null, 2, null);
    @AST
    @NotNull
    private Expression rhs = new ProblemExpression("could not parse rhs", null, 2, null);
    @Nullable
    private String operatorCode;

    @NotNull
    public final Expression getLhs() {
        return this.lhs;
    }

    public final void setLhs(@NotNull Expression value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.disconnectOldLhs();
        this.lhs = value;
        this.connectNewLhs(value);
    }

    @NotNull
    public final Expression getRhs() {
        return this.rhs;
    }

    public final void setRhs(@NotNull Expression value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.disconnectOldRhs();
        this.rhs = value;
        this.connectNewRhs(value);
    }

    @Override
    @Nullable
    public String getOperatorCode() {
        return this.operatorCode;
    }

    public void setOperatorCode(@Nullable String value) {
        this.operatorCode = value;
        Language<?> language = this.getLanguage();
        if (language == null || (language = language.getCompoundAssignmentOperators()) == null) {
            language = SetsKt.emptySet();
        }
        if (CollectionsKt.contains((Iterable)((Iterable)((Object)language)), (Object)this.getOperatorCode()) || Intrinsics.areEqual((Object)this.getOperatorCode(), (Object)"=")) {
            throw new TranslationException("Creating a BinaryOperator with an assignment operator code is not allowed. The class AssignExpression should be used instead.");
        }
    }

    @Nullable
    public final <T extends Expression> T getLhsAs(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return (T)(clazz.isInstance(this.lhs) ? (Expression)clazz.cast(this.lhs) : null);
    }

    private final void connectNewLhs(Expression lhs) {
        lhs.registerTypeObserver(this);
        if (lhs instanceof Reference && Intrinsics.areEqual((Object)"=", (Object)this.getOperatorCode())) {
            ((Reference)lhs).setAccess(AccessValues.WRITE);
        } else if (lhs instanceof Reference) {
            Language<?> language = this.getLanguage();
            if (language == null || (language = language.getCompoundAssignmentOperators()) == null) {
                language = SetsKt.emptySet();
            }
            if (CollectionsKt.contains((Iterable)((Iterable)((Object)language)), (Object)this.getOperatorCode())) {
                ((Reference)lhs).setAccess(AccessValues.READWRITE);
            }
        }
    }

    private final void disconnectOldLhs() {
        this.lhs.unregisterTypeObserver(this);
    }

    @Nullable
    public final <T extends Expression> T getRhsAs(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return (T)(clazz.isInstance(this.rhs) ? (Expression)clazz.cast(this.rhs) : null);
    }

    private final void connectNewRhs(Expression rhs) {
        rhs.registerTypeObserver(this);
    }

    private final void disconnectOldRhs() {
        this.rhs.unregisterTypeObserver(this);
    }

    @Override
    @NotNull
    public String toString() {
        String string = new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).append("lhs", (Object)this.lhs.getName()).append("rhs", (Object)this.rhs.getName()).append("operatorCode", (Object)this.getOperatorCode()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public void typeChanged(@NotNull Type newType, @NotNull HasType src) {
        Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (Intrinsics.areEqual((Object)this.getOperatorCode(), (Object)".*") || Intrinsics.areEqual((Object)this.getOperatorCode(), (Object)"->*") && src == this.rhs) {
            this.setType(newType);
        } else {
            Type type;
            Language<?> language = this.getLanguage();
            Type type2 = type = language != null ? language.propagateTypeOfBinaryOperation(this) : null;
            if (type != null) {
                this.setType(type);
            }
        }
    }

    @Override
    public void assignedTypeChanged(@NotNull Set<? extends Type> assignedTypes, @NotNull HasType src) {
        Intrinsics.checkNotNullParameter(assignedTypes, (String)"assignedTypes");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BinaryOperator)) {
            return false;
        }
        return super.equals(other) && Intrinsics.areEqual((Object)this.lhs, (Object)((BinaryOperator)other).lhs) && Intrinsics.areEqual((Object)this.rhs, (Object)((BinaryOperator)other).rhs) && Intrinsics.areEqual((Object)this.getOperatorCode(), (Object)((BinaryOperator)other).getOperatorCode());
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{super.hashCode(), this.lhs, this.rhs, this.getOperatorCode()};
        return Objects.hash(objectArray);
    }

    @Override
    public void addArgument(@NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (this.lhs instanceof ProblemExpression) {
            this.setLhs(expression);
        } else {
            this.setRhs(expression);
        }
    }

    @Override
    public boolean replaceArgument(@NotNull Expression old, @NotNull Expression expression) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"new");
        if (Intrinsics.areEqual((Object)this.lhs, (Object)old)) {
            this.setLhs(expression);
            bl = true;
        } else if (Intrinsics.areEqual((Object)this.rhs, (Object)old)) {
            this.setRhs(expression);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @Nullable
    public Expression getBase() {
        return Intrinsics.areEqual((Object)this.getOperatorCode(), (Object)".*") || Intrinsics.areEqual((Object)this.getOperatorCode(), (Object)"->*") ? this.lhs : null;
    }

    @Override
    public boolean removeArgument(@NotNull Expression expression) {
        return ArgumentHolder.DefaultImpls.removeArgument(this, expression);
    }

    @Override
    public void plusAssign(@NotNull Expression node) {
        ArgumentHolder.DefaultImpls.plusAssign(this, node);
    }

    @Override
    public void minusAssign(@NotNull Expression node) {
        ArgumentHolder.DefaultImpls.minusAssign(this, node);
    }
}

