/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.graph.AST;
import de.fraunhofer.aisec.cpg.graph.AccessValues;
import de.fraunhofer.aisec.cpg.graph.ArgumentHolder;
import de.fraunhofer.aisec.cpg.graph.Assignment;
import de.fraunhofer.aisec.cpg.graph.AssignmentHolder;
import de.fraunhofer.aisec.cpg.graph.HasOperatorCode;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Reference;
import de.fraunhofer.aisec.cpg.graph.types.HasType;
import de.fraunhofer.aisec.cpg.graph.types.TupleType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 =2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0001=B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0001H\u0016J\u001e\u0010.\u001a\u00020,2\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u000203H\u0016J\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\u0006\u00105\u001a\u000203J\u0010\u00106\u001a\u0004\u0018\u00010\u00012\u0006\u00107\u001a\u000203J\u0018\u00108\u001a\u00020\u00162\u0006\u00109\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u0001H\u0016J\u0018\u0010;\u001a\u00020,2\u0006\u0010<\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R2\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\b8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u000b\"\u0004\b\u001d\u0010\u0011R\u001a\u0010\u001e\u001a\u00020\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R2\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\b8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u000b\"\u0004\b&\u0010\u0011R\u001a\u0010'\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0017\"\u0004\b)\u0010*\u00a8\u0006>"}, d2={"Lde/fraunhofer/aisec/cpg/graph/statements/expressions/AssignExpression;", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "Lde/fraunhofer/aisec/cpg/graph/AssignmentHolder;", "Lde/fraunhofer/aisec/cpg/graph/ArgumentHolder;", "Lde/fraunhofer/aisec/cpg/graph/types/HasType$TypeObserver;", "Lde/fraunhofer/aisec/cpg/graph/HasOperatorCode;", "()V", "assignments", "", "Lde/fraunhofer/aisec/cpg/graph/Assignment;", "getAssignments", "()Ljava/util/List;", "declarations", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/VariableDeclaration;", "getDeclarations", "setDeclarations", "(Ljava/util/List;)V", "expressionValue", "getExpressionValue", "()Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "isCompoundAssignment", "", "()Z", "isSimpleAssignment", "isSingleValue", "value", "lhs", "getLhs", "setLhs", "operatorCode", "", "getOperatorCode", "()Ljava/lang/String;", "setOperatorCode", "(Ljava/lang/String;)V", "rhs", "getRhs", "setRhs", "usedAsExpression", "getUsedAsExpression", "setUsedAsExpression", "(Z)V", "addArgument", "", "expression", "assignedTypeChanged", "assignedTypes", "", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "src", "Lde/fraunhofer/aisec/cpg/graph/types/HasType;", "findTargets", "rhsExpression", "findValue", "lhsExpression", "replaceArgument", "old", "new", "typeChanged", "newType", "Companion", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nAssignExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssignExpression.kt\nde/fraunhofer/aisec/cpg/graph/statements/expressions/AssignExpression\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Util.kt\nde/fraunhofer/aisec/cpg/helpers/Util\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,262:1\n1855#2,2:263\n1855#2,2:265\n1855#2,2:267\n1855#2,2:274\n1855#2,2:276\n1549#2:278\n1620#2,3:279\n1864#2,3:282\n1855#2,2:285\n1855#2,2:288\n202#3,5:269\n1#4:287\n*S KotlinDebug\n*F\n+ 1 AssignExpression.kt\nde/fraunhofer/aisec/cpg/graph/statements/expressions/AssignExpression\n*L\n64#1:263,2\n72#1:265,2\n74#1:267,2\n92#1:274,2\n94#1:276,2\n197#1:278\n197#1:279,3\n220#1:282,3\n223#1:285,2\n239#1:288,2\n80#1:269,5\n*E\n"})
public final class AssignExpression
extends Expression
implements AssignmentHolder,
ArgumentHolder,
HasType.TypeObserver,
HasOperatorCode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String operatorCode = "=";
    @AST
    @NotNull
    private List<? extends Expression> lhs = CollectionsKt.emptyList();
    @AST
    @NotNull
    private List<? extends Expression> rhs = CollectionsKt.emptyList();
    private boolean usedAsExpression;
    @AST
    @NotNull
    private List<VariableDeclaration> declarations = new ArrayList();
    @NotNull
    private static final Logger log;

    @Override
    @NotNull
    public String getOperatorCode() {
        return this.operatorCode;
    }

    public void setOperatorCode(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.operatorCode = string;
    }

    @NotNull
    public final List<Expression> getLhs() {
        return this.lhs;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLhs(@NotNull List<? extends Expression> value) {
        Object[] objectArray;
        Expression it;
        Object element$iv;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.lhs = value;
        Object $this$forEach$iv = this.lhs;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            MemberExpression base;
            element$iv = object.next();
            it = (Expression)element$iv;
            boolean bl = false;
            MemberExpression memberExpression = it instanceof MemberExpression ? (MemberExpression)it : null;
            objectArray = memberExpression != null ? memberExpression.getBase() : null;
            MemberExpression memberExpression2 = base = objectArray instanceof MemberExpression ? (MemberExpression)objectArray : null;
            while (base != null) {
                base.setAccess(AccessValues.READWRITE);
                MemberExpression memberExpression3 = base;
                MemberExpression memberExpression4 = memberExpression3 instanceof MemberExpression ? memberExpression3 : null;
                objectArray = memberExpression4 != null ? memberExpression4.getBase() : null;
                base = objectArray instanceof MemberExpression ? (MemberExpression)objectArray : null;
            }
        }
        if (this.isSimpleAssignment()) {
            $this$forEach$iv = this.lhs;
            $i$f$forEach = false;
            object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                element$iv = object.next();
                it = (Expression)element$iv;
                boolean bl = false;
                Reference reference = it instanceof Reference ? (Reference)it : null;
                if (reference == null) continue;
                reference.setAccess(AccessValues.WRITE);
            }
        } else {
            $this$forEach$iv = this.lhs;
            $i$f$forEach = false;
            object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                element$iv = object.next();
                it = (Expression)element$iv;
                boolean bl = false;
                Reference reference = it instanceof Reference ? (Reference)it : null;
                if (reference == null) continue;
                reference.setAccess(AccessValues.READWRITE);
            }
            if (!this.isCompoundAssignment()) {
                void arguments$iv;
                void log$iv;
                void format$iv;
                $this$forEach$iv = Util.INSTANCE;
                Logger $i$f$forEach2 = log;
                object = "Assignment is neither a simple nor a compound assignment. This is suspicious.";
                element$iv = new Object[]{};
                boolean $i$f$warnWithFileLocation = false;
                String string = "%s: %s";
                objectArray = new Object[]{PhysicalLocation.Companion.locationLink(((Node)this).getLocation()), format$iv};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                log$iv.warn(string2, (Object[])Arrays.copyOf(arguments$iv, ((void)arguments$iv).length));
            }
        }
    }

    @NotNull
    public final List<Expression> getRhs() {
        return this.rhs;
    }

    public final void setRhs(@NotNull List<? extends Expression> value) {
        Expression it;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Iterable $this$forEach$iv = this.rhs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Expression)element$iv;
            boolean bl = false;
            it.unregisterTypeObserver(this);
        }
        this.rhs = value;
        $this$forEach$iv = value;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Expression)element$iv;
            boolean bl = false;
            it.registerTypeObserver(this);
        }
    }

    public final boolean getUsedAsExpression() {
        return this.usedAsExpression;
    }

    public final void setUsedAsExpression(boolean bl) {
        this.usedAsExpression = bl;
    }

    @Nullable
    public final Expression getExpressionValue() {
        return this.usedAsExpression ? (Expression)CollectionsKt.firstOrNull(this.rhs) : null;
    }

    private final boolean isSingleValue() {
        return this.lhs.size() == 1 && this.rhs.size() == 1;
    }

    public final boolean isCompoundAssignment() {
        Language<?> language = this.getLanguage();
        if (language == null || (language = language.getCompoundAssignmentOperators()) == null) {
            language = SetsKt.emptySet();
        }
        return language.contains(this.getOperatorCode()) && this.isSingleValue();
    }

    public final boolean isSimpleAssignment() {
        Language<?> language = this.getLanguage();
        if (language == null || (language = language.getSimpleAssignmentOperators()) == null) {
            language = SetsKt.emptySet();
        }
        return language.contains(this.getOperatorCode());
    }

    @NotNull
    public List<VariableDeclaration> getDeclarations() {
        return this.declarations;
    }

    public void setDeclarations(@NotNull List<VariableDeclaration> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.declarations = list2;
    }

    @Nullable
    public final Expression findValue(@NotNull HasType lhsExpression) {
        int idx;
        Intrinsics.checkNotNullParameter((Object)lhsExpression, (String)"lhsExpression");
        return this.lhs.size() > 1 ? (Expression)CollectionsKt.singleOrNull(this.rhs) : ((idx = CollectionsKt.indexOf(this.lhs, (Object)lhsExpression)) == -1 ? null : (Expression)CollectionsKt.getOrNull(this.rhs, (int)idx));
    }

    @NotNull
    public final List<Expression> findTargets(@NotNull HasType rhsExpression) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)rhsExpression, (String)"rhsExpression");
        Type type = rhsExpression.getType();
        if (type instanceof TupleType) {
            if (this.lhs.size() != ((TupleType)type).getTypes().size()) {
                log.info("Tuple type size on RHS does not match number of LHS expressions");
                list2 = CollectionsKt.emptyList();
            } else {
                list2 = this.lhs;
            }
        } else {
            int idx = CollectionsKt.indexOf(this.rhs, (Object)rhsExpression);
            list2 = idx == -1 ? CollectionsKt.emptyList() : CollectionsKt.listOfNotNull((Object)CollectionsKt.getOrNull(this.lhs, (int)idx));
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Assignment> getAssignments() {
        List list2 = new ArrayList();
        for (Expression expression : this.rhs) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.findTargets(expression);
            List list3 = list2;
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Expression expression2 = (Expression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Assignment(expression, (HasType)it, this));
            }
            list3.addAll((List)destination$iv$iv);
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void typeChanged(@NotNull Type newType, @NotNull HasType src) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            if (!CollectionsKt.contains((Iterable)this.rhs, (Object)src)) {
                return;
            }
            if (newType instanceof TupleType) {
                List<Expression> targets = this.findTargets(src);
                if (targets.size() == ((TupleType)newType).getTypes().size()) {
                    Iterable $this$forEachIndexed$iv = ((TupleType)newType).getTypes();
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        Type type = (Type)item$iv;
                        int idx = n;
                        boolean bl = false;
                        Expression expression = (Expression)CollectionsKt.getOrNull(this.lhs, (int)idx);
                        if (expression != null) {
                            void t;
                            expression.addAssignedType((Type)t);
                        }
                    }
                }
            } else {
                Iterable $this$forEach$iv = this.findTargets(src);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Expression it = (Expression)element$iv;
                    boolean bl = false;
                    it.addAssignedType(newType);
                }
            }
            if (!this.usedAsExpression) break block9;
            Node node = this.getExpressionValue();
            if (node != null && (node = node.getType()) != null) {
                Node it = node;
                boolean bl = false;
                this.setType((Type)it);
            }
        }
    }

    @Override
    public void assignedTypeChanged(@NotNull Set<? extends Type> assignedTypes, @NotNull HasType src) {
        Intrinsics.checkNotNullParameter(assignedTypes, (String)"assignedTypes");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (!CollectionsKt.contains((Iterable)this.rhs, (Object)src)) {
            return;
        }
        Iterable $this$forEach$iv = this.findTargets(src);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Expression it = (Expression)element$iv;
            boolean bl = false;
            it.addAssignedTypes(assignedTypes);
        }
    }

    @Override
    public void addArgument(@NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (this.lhs.isEmpty()) {
            this.setLhs(CollectionsKt.listOf((Object)expression));
        } else {
            this.setRhs(CollectionsKt.listOf((Object)expression));
        }
    }

    @Override
    public boolean replaceArgument(@NotNull Expression old, @NotNull Expression expression) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"new");
        if (Intrinsics.areEqual(this.lhs, (Object)CollectionsKt.listOf((Object)old))) {
            this.setLhs(CollectionsKt.listOf((Object)expression));
            bl = true;
        } else if (Intrinsics.areEqual(this.rhs, (Object)CollectionsKt.listOf((Object)old))) {
            this.setRhs(CollectionsKt.listOf((Object)expression));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean removeArgument(@NotNull Expression expression) {
        return ArgumentHolder.DefaultImpls.removeArgument(this, expression);
    }

    @Override
    public void plusAssign(@NotNull Expression node) {
        ArgumentHolder.DefaultImpls.plusAssign(this, node);
    }

    @Override
    public void minusAssign(@NotNull Expression node) {
        ArgumentHolder.DefaultImpls.minusAssign(this, node);
    }

    static {
        Logger logger = LoggerFactory.getLogger(Node.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lde/fraunhofer/aisec/cpg/graph/statements/expressions/AssignExpression$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

