/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.scopes;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.scopes.Breakable;
import de.fraunhofer.aisec.cpg.graph.scopes.Continuable;
import de.fraunhofer.aisec.cpg.graph.scopes.ValueDeclarationScope;
import de.fraunhofer.aisec.cpg.graph.statements.AssertStatement;
import de.fraunhofer.aisec.cpg.graph.statements.BreakStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ContinueStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DoStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ForEachStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ForStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.WhileStatement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001cB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0012H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000bR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lde/fraunhofer/aisec/cpg/graph/scopes/LoopScope;", "Lde/fraunhofer/aisec/cpg/graph/scopes/ValueDeclarationScope;", "Lde/fraunhofer/aisec/cpg/graph/scopes/Breakable;", "Lde/fraunhofer/aisec/cpg/graph/scopes/Continuable;", "loopStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/Statement;", "(Lde/fraunhofer/aisec/cpg/graph/statements/Statement;)V", "breakStatements", "", "Lde/fraunhofer/aisec/cpg/graph/statements/BreakStatement;", "getBreakStatements", "()Ljava/util/List;", "breaks", "", "conditions", "Lde/fraunhofer/aisec/cpg/graph/Node;", "getConditions", "continueStatements", "Lde/fraunhofer/aisec/cpg/graph/statements/ContinueStatement;", "getContinueStatements", "continues", "starts", "getStarts", "addBreakStatement", "", "breakStatement", "addContinueStatement", "continueStatement", "Companion", "cpg-core"})
public final class LoopScope
extends ValueDeclarationScope
implements Breakable,
Continuable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<BreakStatement> breaks;
    @NotNull
    private final List<ContinueStatement> continues;
    private static final Logger LOGGER = LoggerFactory.getLogger(LoopScope.class);

    public LoopScope(@NotNull Statement loopStatement) {
        Intrinsics.checkNotNullParameter((Object)loopStatement, (String)"loopStatement");
        super(loopStatement);
        this.breaks = new ArrayList();
        this.continues = new ArrayList();
    }

    @NotNull
    public final List<Node> getStarts() {
        List<Node> list2;
        Node loopStatement = this.getAstNode();
        if (loopStatement instanceof WhileStatement) {
            list2 = ((WhileStatement)loopStatement).getConditionDeclaration() != null ? SubgraphWalker.INSTANCE.getEOGPathEdges(((WhileStatement)loopStatement).getConditionDeclaration()).getEntries() : (((WhileStatement)loopStatement).getCondition() != null ? SubgraphWalker.INSTANCE.getEOGPathEdges(((WhileStatement)loopStatement).getCondition()).getEntries() : SubgraphWalker.INSTANCE.getEOGPathEdges(((WhileStatement)loopStatement).getStatement()).getEntries());
        } else if (loopStatement instanceof ForStatement) {
            list2 = ((ForStatement)loopStatement).getConditionDeclaration() != null ? SubgraphWalker.INSTANCE.getEOGPathEdges(((ForStatement)loopStatement).getConditionDeclaration()).getEntries() : (((ForStatement)loopStatement).getCondition() != null ? SubgraphWalker.INSTANCE.getEOGPathEdges(((ForStatement)loopStatement).getCondition()).getEntries() : SubgraphWalker.INSTANCE.getEOGPathEdges(((ForStatement)loopStatement).getStatement()).getEntries());
        } else if (loopStatement instanceof ForEachStatement) {
            list2 = SubgraphWalker.INSTANCE.getEOGPathEdges(loopStatement).getEntries();
        } else if (loopStatement instanceof DoStatement) {
            list2 = SubgraphWalker.INSTANCE.getEOGPathEdges(((DoStatement)loopStatement).getStatement()).getEntries();
        } else {
            Node node = this.getAstNode();
            LOGGER.error("Currently the component {} is not supported as loop scope.", node != null ? node.getClass() : null);
            list2 = new ArrayList();
        }
        return list2;
    }

    @NotNull
    public final List<Node> getConditions() {
        List list2;
        Node node = this.getAstNode();
        if (node instanceof WhileStatement) {
            Object[] objectArray = new Node[]{((WhileStatement)node).getCondition(), ((WhileStatement)node).getConditionDeclaration()};
            list2 = CollectionsKt.filterNotNull((Iterable)CollectionsKt.mutableListOf((Object[])objectArray));
        } else if (node instanceof ForStatement) {
            Object[] objectArray = new Expression[]{((ForStatement)node).getCondition()};
            list2 = CollectionsKt.filterNotNull((Iterable)CollectionsKt.mutableListOf((Object[])objectArray));
        } else if (node instanceof ForEachStatement) {
            Object[] objectArray = new Statement[]{((ForEachStatement)node).getVariable()};
            list2 = CollectionsKt.filterNotNull((Iterable)CollectionsKt.mutableListOf((Object[])objectArray));
        } else if (node instanceof DoStatement) {
            Object[] objectArray = new Expression[]{((DoStatement)node).getCondition()};
            list2 = CollectionsKt.filterNotNull((Iterable)CollectionsKt.mutableListOf((Object[])objectArray));
        } else if (node instanceof AssertStatement) {
            Object[] objectArray = new Expression[]{((AssertStatement)node).getCondition()};
            list2 = CollectionsKt.filterNotNull((Iterable)CollectionsKt.mutableListOf((Object[])objectArray));
        } else if (node == null) {
            LOGGER.error("Ast node of loop scope is null.");
            list2 = new ArrayList();
        } else {
            LOGGER.error("Currently the component {} is not supported as loop scope.", node.getClass());
            list2 = new ArrayList();
        }
        return list2;
    }

    @Override
    public void addBreakStatement(@NotNull BreakStatement breakStatement) {
        Intrinsics.checkNotNullParameter((Object)breakStatement, (String)"breakStatement");
        this.breaks.add(breakStatement);
    }

    @Override
    public void addContinueStatement(@NotNull ContinueStatement continueStatement) {
        Intrinsics.checkNotNullParameter((Object)continueStatement, (String)"continueStatement");
        this.continues.add(continueStatement);
    }

    @Override
    @NotNull
    public List<BreakStatement> getBreakStatements() {
        return this.breaks;
    }

    @Override
    @NotNull
    public List<ContinueStatement> getContinueStatements() {
        return this.continues;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fraunhofer/aisec/cpg/graph/scopes/LoopScope$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

