/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.edge;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.Persistable;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdgeConverter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.annotation.typeconversion.Convert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RelationshipEntity
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u0017\u0018\u0000 -*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001-B\u0017\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006B\u0015\b\u0016\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\bB-\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u001c\u001a\u00020\u001d2\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u001fJ\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\fJ\u001c\u0010#\u001a\u00020$2\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\u001fJ\u0013\u0010&\u001a\u00020$2\b\u0010'\u001a\u0004\u0018\u00010\fH\u0096\u0002J\u0010\u0010(\u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\u000bJ\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020$2\b\u0010,\u001a\u0004\u0018\u00010\fR \u0010\u0005\u001a\u00028\u00008\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00148\u0002X\u0083\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R \u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000f\"\u0004\b\u001b\u0010\u0011\u00a8\u0006."}, d2={"Lde/fraunhofer/aisec/cpg/graph/edge/PropertyEdge;", "T", "Lde/fraunhofer/aisec/cpg/graph/Node;", "Lde/fraunhofer/aisec/cpg/graph/Persistable;", "start", "end", "(Lde/fraunhofer/aisec/cpg/graph/Node;Lde/fraunhofer/aisec/cpg/graph/Node;)V", "propertyEdge", "(Lde/fraunhofer/aisec/cpg/graph/edge/PropertyEdge;)V", "properties", "", "Lde/fraunhofer/aisec/cpg/graph/edge/Properties;", "", "(Lde/fraunhofer/aisec/cpg/graph/Node;Lde/fraunhofer/aisec/cpg/graph/Node;Ljava/util/Map;)V", "getEnd", "()Lde/fraunhofer/aisec/cpg/graph/Node;", "setEnd", "(Lde/fraunhofer/aisec/cpg/graph/Node;)V", "Lde/fraunhofer/aisec/cpg/graph/Node;", "id", "", "Ljava/lang/Long;", "label", "", "getLabel", "()Ljava/lang/String;", "getStart", "setStart", "addProperties", "", "propertyMap", "", "addProperty", "property", "value", "containsProperties", "", "props", "equals", "other", "getProperty", "hashCode", "", "propertyEquals", "obj", "Companion", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nPropertyEdge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyEdge.kt\nde/fraunhofer/aisec/cpg/graph/edge/PropertyEdge\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,406:1\n1#2:407\n*E\n"})
public class PropertyEdge<T extends Node>
implements Persistable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Id
    @GeneratedValue
    @Nullable
    private final Long id;
    @StartNode
    @NotNull
    private Node start;
    @EndNode
    @NotNull
    private T end;
    @NotNull
    private final String label;
    @Convert(value=PropertyEdgeConverter.class)
    @NotNull
    private Map<Properties, Object> properties;
    private static final Logger log = LoggerFactory.getLogger(PropertyEdge.class);

    @NotNull
    public final Node getStart() {
        return this.start;
    }

    public final void setStart(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"<set-?>");
        this.start = node;
    }

    @NotNull
    public final T getEnd() {
        return this.end;
    }

    public final void setEnd(@NotNull T t) {
        Intrinsics.checkNotNullParameter(t, (String)"<set-?>");
        this.end = t;
    }

    public PropertyEdge(@NotNull Node start, @NotNull T end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        this.label = "EDGE";
        this.start = start;
        this.end = end;
        this.properties = new EnumMap(Properties.class);
    }

    public PropertyEdge(@NotNull PropertyEdge<T> propertyEdge) {
        Intrinsics.checkNotNullParameter(propertyEdge, (String)"propertyEdge");
        this.label = "EDGE";
        this.start = propertyEdge.start;
        this.end = propertyEdge.end;
        this.properties = new EnumMap(Properties.class);
        this.properties.putAll(propertyEdge.properties);
    }

    public PropertyEdge(@NotNull Node start, @NotNull T end, @NotNull Map<Properties, Object> properties) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this.label = "EDGE";
        this.start = start;
        this.end = end;
        this.properties = properties;
    }

    @NotNull
    public String getLabel() {
        return this.label;
    }

    @Nullable
    public final Object getProperty(@NotNull Properties property) {
        Intrinsics.checkNotNullParameter((Object)((Object)property), (String)"property");
        return this.properties.getOrDefault((Object)property, null);
    }

    public final void addProperty(@NotNull Properties property, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)((Object)property), (String)"property");
        this.properties.put(property, value);
    }

    public final void addProperties(@Nullable Map<Properties, ? extends Object> propertyMap) {
        block0: {
            Map<Properties, ? extends Object> map = propertyMap;
            if (map == null) break block0;
            Map<Properties, ? extends Object> it = map;
            boolean bl = false;
            this.properties.putAll(it);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PropertyEdge)) {
            return false;
        }
        return Intrinsics.areEqual(this.properties, ((PropertyEdge)other).properties) && Intrinsics.areEqual((Object)this.start, (Object)((PropertyEdge)other).start) && Intrinsics.areEqual(this.end, ((PropertyEdge)other).end);
    }

    public final boolean propertyEquals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PropertyEdge)) {
            return false;
        }
        return Intrinsics.areEqual(this.properties, ((PropertyEdge)obj).properties);
    }

    public final boolean containsProperties(@NotNull Map<Properties, ? extends Object> props) {
        Intrinsics.checkNotNullParameter(props, (String)"props");
        return ((Collection)this.properties.entrySet()).containsAll((Collection)props.entrySet());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.end, this.properties};
        return Objects.hash(objectArray);
    }

    @JvmStatic
    @NotNull
    public static final <T extends Node> List<PropertyEdge<T>> wrap(@NotNull List<? extends T> nodes, @NotNull Node commonRelationshipNode, boolean outgoing) {
        return Companion.wrap(nodes, commonRelationshipNode, outgoing);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final <T extends Node> List<T> unwrap(@NotNull List<? extends PropertyEdge<T>> collection, boolean outgoing) {
        return Companion.unwrap(collection, outgoing);
    }

    @JvmStatic
    @NotNull
    public static final Object unwrapPropertyEdge(@NotNull Object obj, boolean outgoing) {
        return Companion.unwrapPropertyEdge(obj, outgoing);
    }

    @JvmStatic
    public static final boolean checkForPropertyEdge(@NotNull Field f, @Nullable Object obj) {
        return Companion.checkForPropertyEdge(f, obj);
    }

    @JvmStatic
    @NotNull
    public static final <T extends Node> List<PropertyEdge<T>> removeElementFromList(@NotNull List<? extends PropertyEdge<T>> propertyEdges, @NotNull T element, boolean end) {
        return Companion.removeElementFromList(propertyEdges, element, end);
    }

    @JvmStatic
    public static final <E extends Node> boolean propertyEqualsList(@Nullable List<? extends PropertyEdge<E>> propertyEdges, @Nullable List<? extends PropertyEdge<E>> propertyEdges2) {
        return Companion.propertyEqualsList(propertyEdges, propertyEdges2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final <T extends Node> List<T> unwrap(@NotNull List<? extends PropertyEdge<T>> collection) {
        return Companion.unwrap(collection);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010!\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\n0\t\"\b\b\u0001\u0010\u000b*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\n0\tJ\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0007J$\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\f\u0012\u0002\b\u00030\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001J>\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00160\t\"\u000e\b\u0001\u0010\u0016*\b\u0012\u0002\b\u0003\u0018\u00010\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020\u000f0\u001aJ>\u0010\u001b\u001a\u00020\u000f\"\b\b\u0001\u0010\u001c*\u00020\f2\u0014\u0010\r\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001c0\n\u0018\u00010\t2\u0014\u0010\u001d\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001c0\n\u0018\u00010\tH\u0007JG\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\n0\t\"\b\b\u0001\u0010\u000b*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\n0\t2\u0006\u0010\u001f\u001a\u0002H\u000b2\u0006\u0010 \u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010!J6\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u000b0\t\"\b\b\u0001\u0010\u000b*\u00020\f2\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\n0\t2\b\b\u0002\u0010$\u001a\u00020\u000fH\u0007J\u0018\u0010%\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u000fH\u0007J\u001c\u0010&\u001a\u00020\u00012\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010$\u001a\u00020\u000fH\u0002J>\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\n0(\"\b\b\u0001\u0010\u000b*\u00020\f2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H\u000b0\t2\u0006\u0010*\u001a\u00020\f2\b\b\u0002\u0010$\u001a\u00020\u000fH\u0007R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006+"}, d2={"Lde/fraunhofer/aisec/cpg/graph/edge/PropertyEdge$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "applyIndexProperty", "", "Lde/fraunhofer/aisec/cpg/graph/edge/PropertyEdge;", "T", "Lde/fraunhofer/aisec/cpg/graph/Node;", "propertyEdges", "checkForPropertyEdge", "", "f", "Ljava/lang/reflect/Field;", "obj", "member", "Lkotlin/reflect/KProperty1;", "findPropertyEdgesByPredicate", "S", "edges", "", "predicate", "Lkotlin/Function1;", "propertyEqualsList", "E", "propertyEdges2", "removeElementFromList", "element", "end", "(Ljava/util/List;Lde/fraunhofer/aisec/cpg/graph/Node;Z)Ljava/util/List;", "unwrap", "collection", "outgoing", "unwrapPropertyEdge", "unwrapPropertyEdgeCollection", "wrap", "", "nodes", "commonRelationshipNode", "cpg-core"})
    @SourceDebugExtension(value={"SMAP\nPropertyEdge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyEdge.kt\nde/fraunhofer/aisec/cpg/graph/edge/PropertyEdge$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,406:1\n766#2:407\n857#2,2:408\n1549#2:410\n1620#2,3:411\n800#2,11:414\n1747#2,3:425\n*S KotlinDebug\n*F\n+ 1 PropertyEdge.kt\nde/fraunhofer/aisec/cpg/graph/edge/PropertyEdge$Companion\n*L\n141#1:407\n141#1:408,2\n201#1:410\n201#1:411,3\n224#1:414,11\n299#1:425,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        protected final Logger getLog() {
            return log;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final <S extends PropertyEdge<?>> List<S> findPropertyEdgesByPredicate(@NotNull Collection<? extends S> edges, @NotNull Function1<? super S, Boolean> predicate) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(edges, (String)"edges");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Iterable $this$filter$iv = edges;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                if (!((Boolean)predicate.invoke(element$iv$iv)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final <T extends Node> List<PropertyEdge<T>> applyIndexProperty(@NotNull List<? extends PropertyEdge<T>> propertyEdges) {
            Intrinsics.checkNotNullParameter(propertyEdges, (String)"propertyEdges");
            Iterator<PropertyEdge<T>> iterator = propertyEdges.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int counter = n++;
                PropertyEdge<T> propertyEdge = iterator.next();
                propertyEdge.addProperty(Properties.INDEX, counter);
            }
            return propertyEdges;
        }

        @JvmStatic
        @NotNull
        public final <T extends Node> List<PropertyEdge<T>> wrap(@NotNull List<? extends T> nodes, @NotNull Node commonRelationshipNode, boolean outgoing) {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            Intrinsics.checkNotNullParameter((Object)commonRelationshipNode, (String)"commonRelationshipNode");
            List propertyEdges = new ArrayList();
            for (Node n : nodes) {
                PropertyEdge<Node> propertyEdge = outgoing ? new PropertyEdge<Node>(commonRelationshipNode, n) : new PropertyEdge<Node>(n, commonRelationshipNode);
                propertyEdge.addProperty(Properties.INDEX, propertyEdges.size());
                propertyEdges.add(propertyEdge);
            }
            return propertyEdges;
        }

        public static /* synthetic */ List wrap$default(Companion companion, List list2, Node node, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.wrap(list2, node, bl);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final <T extends Node> List<T> unwrap(@NotNull List<? extends PropertyEdge<T>> collection, boolean outgoing) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(collection, (String)"collection");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object object;
                PropertyEdge propertyEdge = (PropertyEdge)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                if (outgoing) {
                    object = it.getEnd();
                } else {
                    Node node = it.getStart();
                    object = node;
                    Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type T of de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge.Companion.unwrap$lambda$0");
                }
                collection2.add(object);
            }
            return (List)destination$iv$iv;
        }

        public static /* synthetic */ List unwrap$default(Companion companion, List list2, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.unwrap(list2, bl);
        }

        /*
         * WARNING - void declaration
         */
        private final Object unwrapPropertyEdgeCollection(Collection<?> collection, boolean outgoing) {
            Object element = null;
            Optional<?> value = collection.stream().findAny();
            if (value.isPresent()) {
                element = value.get();
            }
            if (element instanceof PropertyEdge) {
                try {
                    void $this$filterIsInstanceTo$iv$iv;
                    void $this$filterIsInstance$iv;
                    Object obj = collection.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Intrinsics.checkNotNullExpressionValue(obj, (String)"newInstance(...)");
                    Iterable iterable = (Iterable)obj;
                    boolean $i$f$filterIsInstance = false;
                    void var8_8 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof Node)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List outputCollection = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                    for (Object obj2 : collection) {
                        if (!(obj2 instanceof PropertyEdge)) continue;
                        if (outgoing) {
                            outputCollection.add(((PropertyEdge)obj2).getEnd());
                            continue;
                        }
                        outputCollection.add(((PropertyEdge)obj2).getStart());
                    }
                    return outputCollection;
                }
                catch (InstantiationException e) {
                    this.getLog().warn("PropertyEdges could not be unwrapped");
                }
                catch (IllegalAccessException e) {
                    this.getLog().warn("PropertyEdges could not be unwrapped");
                }
                catch (InvocationTargetException e) {
                    this.getLog().warn("PropertyEdges could not be unwrapped");
                }
                catch (NoSuchMethodException e) {
                    this.getLog().warn("PropertyEdges could not be unwrapped");
                }
            }
            return collection;
        }

        @JvmStatic
        @NotNull
        public final Object unwrapPropertyEdge(@NotNull Object obj, boolean outgoing) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            if (obj instanceof PropertyEdge) {
                return outgoing ? ((PropertyEdge)obj).getEnd() : ((PropertyEdge)obj).getStart();
            }
            if (obj instanceof Collection && !((Collection)obj).isEmpty()) {
                return this.unwrapPropertyEdgeCollection((Collection)obj, outgoing);
            }
            return obj;
        }

        @JvmStatic
        public final boolean checkForPropertyEdge(@NotNull Field f, @Nullable Object obj) {
            Intrinsics.checkNotNullParameter((Object)f, (String)"f");
            if (obj instanceof PropertyEdge) {
                return true;
            }
            if (obj instanceof Collection) {
                Type type = f.getGenericType();
                Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
                Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
                Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getActualTypeArguments(...)");
                Type[] typeArray2 = typeArray;
                List collectionTypes = CollectionsKt.listOf((Object[])Arrays.copyOf(typeArray2, typeArray2.length));
                for (Type t : collectionTypes) {
                    if (t instanceof ParameterizedType) {
                        return Intrinsics.areEqual((Object)((ParameterizedType)t).getRawType(), PropertyEdge.class);
                    }
                    if (!Intrinsics.areEqual(PropertyEdge.class, (Object)t)) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean checkForPropertyEdge(@NotNull KProperty1<? extends Node, ?> member, @Nullable Object obj) {
            KType kType;
            Intrinsics.checkNotNullParameter(member, (String)"member");
            if (obj instanceof PropertyEdge) {
                return true;
            }
            if (!(obj instanceof Collection)) return false;
            KType returnType = member.getReturnType();
            if (!Intrinsics.areEqual((Object)returnType.getClassifier(), (Object)Reflection.getOrCreateKotlinClass(List.class))) return false;
            Iterable $this$any$iv = returnType.getArguments();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                KTypeProjection it = (KTypeProjection)element$iv;
                boolean bl = false;
                kType = it.getType();
            } while (!Intrinsics.areEqual((Object)(kType != null ? kType.getClassifier() : null), (Object)Reflection.getOrCreateKotlinClass(PropertyEdge.class)));
            return true;
        }

        @JvmStatic
        @NotNull
        public final <T extends Node> List<PropertyEdge<T>> removeElementFromList(@NotNull List<? extends PropertyEdge<T>> propertyEdges, @NotNull T element, boolean end) {
            Intrinsics.checkNotNullParameter(propertyEdges, (String)"propertyEdges");
            Intrinsics.checkNotNullParameter(element, (String)"element");
            List newPropertyEdges = new ArrayList();
            for (PropertyEdge<T> propertyEdge : propertyEdges) {
                if (end && !Intrinsics.areEqual(propertyEdge.getEnd(), element)) {
                    newPropertyEdges.add(propertyEdge);
                }
                if (end || Intrinsics.areEqual((Object)propertyEdge.getStart(), element)) continue;
                newPropertyEdges.add(propertyEdge);
            }
            return this.applyIndexProperty(newPropertyEdges);
        }

        @JvmStatic
        public final <E extends Node> boolean propertyEqualsList(@Nullable List<? extends PropertyEdge<E>> propertyEdges, @Nullable List<? extends PropertyEdge<E>> propertyEdges2) {
            if (propertyEdges == null) {
                return propertyEdges2 == null;
            }
            boolean bl = propertyEdges2 != null ? propertyEdges.size() == propertyEdges2.size() : false;
            if (bl) {
                int n = propertyEdges.size();
                for (int i = 0; i < n; ++i) {
                    if (propertyEdges.get(i).propertyEquals(propertyEdges2.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final <T extends Node> List<T> unwrap(@NotNull List<? extends PropertyEdge<T>> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"collection");
            return de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge$Companion.unwrap$default(this, collection, false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

