/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.aisec.cpg.PopulatedByPass;
import de.fraunhofer.aisec.cpg.TranslationContext;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.graph.AST;
import de.fraunhofer.aisec.cpg.graph.Annotation;
import de.fraunhofer.aisec.cpg.graph.ContextProvider;
import de.fraunhofer.aisec.cpg.graph.LanguageProvider;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.Persistable;
import de.fraunhofer.aisec.cpg.graph.ScopeProvider;
import de.fraunhofer.aisec.cpg.graph.edge.CallingContext;
import de.fraunhofer.aisec.cpg.graph.edge.ContextSensitiveDataflow;
import de.fraunhofer.aisec.cpg.graph.edge.Dataflow;
import de.fraunhofer.aisec.cpg.graph.edge.DataflowKt;
import de.fraunhofer.aisec.cpg.graph.edge.DependenceType;
import de.fraunhofer.aisec.cpg.graph.edge.Granularity;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdgeDelegate;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdgeSetDelegate;
import de.fraunhofer.aisec.cpg.graph.scopes.Scope;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.helpers.neo4j.LocationConverter;
import de.fraunhofer.aisec.cpg.helpers.neo4j.NameConverter;
import de.fraunhofer.aisec.cpg.passes.ControlDependenceGraphPass;
import de.fraunhofer.aisec.cpg.passes.ControlFlowSensitiveDFGPass;
import de.fraunhofer.aisec.cpg.passes.DFGPass;
import de.fraunhofer.aisec.cpg.passes.EvaluationOrderGraphPass;
import de.fraunhofer.aisec.cpg.passes.FilenameMapper;
import de.fraunhofer.aisec.cpg.passes.ProgramDependenceGraphPass;
import de.fraunhofer.aisec.cpg.processing.IStrategy;
import de.fraunhofer.aisec.cpg.processing.IVisitable;
import de.fraunhofer.aisec.cpg.processing.IVisitor;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.Transient;
import org.neo4j.ogm.annotation.typeconversion.Convert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b8\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0012\b\u0016\u0018\u0000 \u00c3\u00012\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0002\u00c3\u0001B\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u009d\u0001\u001a\u00030\u009e\u00012\u000e\u0010\u009f\u0001\u001a\t\u0012\u0004\u0012\u00020\u00000\u00a0\u00012\n\b\u0002\u0010\u00a1\u0001\u001a\u00030\u00a2\u00012\f\b\u0002\u0010\u00a3\u0001\u001a\u0005\u0018\u00010\u00a4\u0001J\"\u0010\u00a5\u0001\u001a\u00030\u009e\u00012\u000e\u0010\u009f\u0001\u001a\t\u0012\u0004\u0012\u00020\u00000\u00a0\u00012\b\u0010\u00a6\u0001\u001a\u00030\u00a7\u0001J(\u0010\u00a8\u0001\u001a\u00030\u009e\u00012\u0014\u0010\u009f\u0001\u001a\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000Q0\u00a0\u00012\b\u0010\u00a6\u0001\u001a\u00030\u00a7\u0001J\u0017\u0010\u00a9\u0001\u001a\u00030\u009e\u00012\r\u0010\u0007\u001a\t\u0012\u0004\u0012\u00020\t0\u00a0\u0001J+\u0010\u00aa\u0001\u001a\u00030\u009e\u00012\u0007\u0010\u00ab\u0001\u001a\u00020\u00002\n\b\u0002\u0010\u00a1\u0001\u001a\u00030\u00a2\u00012\f\b\u0002\u0010\u00a3\u0001\u001a\u0005\u0018\u00010\u00a4\u0001J\u0017\u0010\u00ac\u0001\u001a\u00030\u009e\u00012\r\u0010\u00ad\u0001\u001a\b\u0012\u0004\u0012\u00020\u00000QJ-\u0010\u00ae\u0001\u001a\u00030\u009e\u00012\u0007\u0010\u009f\u0001\u001a\u00020\u00002\u001a\b\u0002\u0010\u00af\u0001\u001a\u0013\u0012\u0005\u0012\u00030\u00b1\u0001\u0012\u0007\u0012\u0005\u0018\u00010\u00b2\u00010\u00b0\u0001J-\u0010\u00b3\u0001\u001a\u00030\u009e\u00012\u0007\u0010\u009f\u0001\u001a\u00020\u00002\n\b\u0002\u0010\u00a1\u0001\u001a\u00030\u00a2\u00012\f\b\u0002\u0010\u00a3\u0001\u001a\u0005\u0018\u00010\u00a4\u0001H\u0016J\u0017\u0010\u00b4\u0001\u001a\u00030\u009e\u00012\r\u0010\u00ad\u0001\u001a\b\u0012\u0004\u0012\u00020\u00000QJ\b\u0010\u00b5\u0001\u001a\u00030\u009e\u0001J\b\u0010\u00b6\u0001\u001a\u00030\u009e\u0001J\b\u0010\u00b7\u0001\u001a\u00030\u009e\u0001J\b\u0010\u00b8\u0001\u001a\u00030\u009e\u0001J\u0016\u0010\u00b9\u0001\u001a\u0002032\n\u0010\u00ba\u0001\u001a\u0005\u0018\u00010\u00b2\u0001H\u0096\u0002J\t\u0010\u00bb\u0001\u001a\u00020\u000fH\u0016J\u0013\u0010\u00bc\u0001\u001a\u00030\u009e\u00012\t\u0010\u00ab\u0001\u001a\u0004\u0018\u00010\u0000J\u0013\u0010\u00bd\u0001\u001a\u00030\u009e\u00012\t\u0010\u009f\u0001\u001a\u0004\u0018\u00010\u0000J\u0019\u0010\u00be\u0001\u001a\u00030\u009e\u00012\r\u0010\u00bf\u0001\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015H\u0002J\u0011\u0010\u00c0\u0001\u001a\u00030\u009e\u00012\u0007\u0010\u00c1\u0001\u001a\u00020\u0000J\t\u0010\u00c2\u0001\u001a\u00020\u0019H\u0016R$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u00158F@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000b\"\u0004\b\u0017\u0010\rR\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR \u0010!\u001a\u0004\u0018\u00010\"8W@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R&\u0010'\u001a\u0004\u0018\u00010\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b(\u0010\u0006\u001a\u0004\b)\u0010\u001b\"\u0004\b*\u0010\u001dR\"\u0010+\u001a\u0004\u0018\u00010,8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u00101\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00102\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00104\"\u0004\b8\u00106R$\u00109\u001a\b\u0012\u0002\b\u0003\u0018\u00010:8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R \u0010?\u001a\u0004\u0018\u00010@8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u001e\u0010E\u001a\u00020F8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR7\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00000\u00152\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00000\u00158F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bO\u0010P\u001a\u0004\bM\u0010\u000b\"\u0004\bN\u0010\rRD\u0010R\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000Q0\b2\u0012\u0010K\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000Q0\b8\u0006@DX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bS\u0010\u0006\u001a\u0004\bT\u0010\u000b\"\u0004\bU\u0010\rR=\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00000V2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00000V8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b]\u0010^\u0012\u0004\bX\u0010\u0006\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R8\u0010`\u001a\b\u0012\u0004\u0012\u00020_0\b2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020_0\b8\u0006@DX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\ba\u0010\u0006\u001a\u0004\bb\u0010\u000b\"\u0004\bc\u0010\rR=\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00000\u00152\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00000\u00158F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\bh\u0010P\u0012\u0004\be\u0010\u0006\u001a\u0004\bf\u0010\u000b\"\u0004\bg\u0010\rRD\u0010i\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000Q0\b2\u0012\u0010K\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000Q0\b8\u0006@DX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bj\u0010\u0006\u001a\u0004\bk\u0010\u000b\"\u0004\bl\u0010\rR7\u0010m\u001a\b\u0012\u0004\u0012\u00020\u00000V2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00000V8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bp\u0010^\u001a\u0004\bn\u0010Z\"\u0004\bo\u0010\\RD\u0010q\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000Q0V2\u0012\u0010K\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000Q0V8\u0006@DX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\br\u0010\u0006\u001a\u0004\bs\u0010Z\"\u0004\bt\u0010\\R7\u0010u\u001a\b\u0012\u0004\u0012\u00020\u00000\u00152\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00000\u00158F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bx\u0010P\u001a\u0004\bv\u0010\u000b\"\u0004\bw\u0010\rRD\u0010y\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000Q0\b2\u0012\u0010K\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000Q0\b8\u0006@DX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bz\u0010\u0006\u001a\u0004\b{\u0010\u000b\"\u0004\b|\u0010\rR?\u0010}\u001a\b\u0012\u0004\u0012\u00020\u00000V2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00000V8F@FX\u0087\u008e\u0002\u00a2\u0006\u001a\n\u0005\b\u0081\u0001\u0010^\u0012\u0004\b~\u0010\u0006\u001a\u0004\b\u007f\u0010Z\"\u0005\b\u0080\u0001\u0010\\R<\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020_0\b2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020_0\b8\u0006@DX\u0087\u000e\u00a2\u0006\u0017\n\u0000\u0012\u0005\b\u0083\u0001\u0010\u0006\u001a\u0005\b\u0084\u0001\u0010\u000b\"\u0005\b\u0085\u0001\u0010\rRB\u0010\u0086\u0001\u001a\b\u0012\u0004\u0012\u00020\u00000\u00152\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00000\u00158F@FX\u0087\u008e\u0002\u00a2\u0006\u001c\n\u0005\b\u008a\u0001\u0010P\u0012\u0005\b\u0087\u0001\u0010\u0006\u001a\u0005\b\u0088\u0001\u0010\u000b\"\u0005\b\u0089\u0001\u0010\rRH\u0010\u008b\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000Q0\b2\u0012\u0010K\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000Q0\b8\u0006@DX\u0087\u000e\u00a2\u0006\u0017\n\u0000\u0012\u0005\b\u008c\u0001\u0010\u0006\u001a\u0005\b\u008d\u0001\u0010\u000b\"\u0005\b\u008e\u0001\u0010\rR;\u0010\u008f\u0001\u001a\b\u0012\u0004\u0012\u00020\u00000V2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00000V8F@FX\u0086\u008e\u0002\u00a2\u0006\u0015\n\u0005\b\u0092\u0001\u0010^\u001a\u0005\b\u0090\u0001\u0010Z\"\u0005\b\u0091\u0001\u0010\\RH\u0010\u0093\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000Q0V2\u0012\u0010K\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000Q0V8\u0006@DX\u0087\u000e\u00a2\u0006\u0017\n\u0000\u0012\u0005\b\u0094\u0001\u0010\u0006\u001a\u0005\b\u0095\u0001\u0010Z\"\u0005\b\u0096\u0001\u0010\\R&\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u0098\u00018\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0099\u0001\u0010\u009a\u0001\"\u0006\b\u009b\u0001\u0010\u009c\u0001\u00a8\u0006\u00c4\u0001"}, d2={"Lde/fraunhofer/aisec/cpg/graph/Node;", "Lde/fraunhofer/aisec/cpg/processing/IVisitable;", "Lde/fraunhofer/aisec/cpg/graph/Persistable;", "Lde/fraunhofer/aisec/cpg/graph/LanguageProvider;", "Lde/fraunhofer/aisec/cpg/graph/ScopeProvider;", "Lde/fraunhofer/aisec/cpg/graph/ContextProvider;", "()V", "annotations", "", "Lde/fraunhofer/aisec/cpg/graph/Annotation;", "getAnnotations", "()Ljava/util/List;", "setAnnotations", "(Ljava/util/List;)V", "argumentIndex", "", "getArgumentIndex", "()I", "setArgumentIndex", "(I)V", "astChildren", "", "getAstChildren", "setAstChildren", "code", "", "getCode", "()Ljava/lang/String;", "setCode", "(Ljava/lang/String;)V", "comment", "getComment", "setComment", "ctx", "Lde/fraunhofer/aisec/cpg/TranslationContext;", "getCtx", "()Lde/fraunhofer/aisec/cpg/TranslationContext;", "setCtx", "(Lde/fraunhofer/aisec/cpg/TranslationContext;)V", "file", "getFile$annotations", "getFile", "setFile", "id", "", "getId", "()Ljava/lang/Long;", "setId", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "isImplicit", "", "()Z", "setImplicit", "(Z)V", "isInferred", "setInferred", "language", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "getLanguage", "()Lde/fraunhofer/aisec/cpg/frontends/Language;", "setLanguage", "(Lde/fraunhofer/aisec/cpg/frontends/Language;)V", "location", "Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "getLocation", "()Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "setLocation", "(Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;)V", "name", "Lde/fraunhofer/aisec/cpg/graph/Name;", "getName", "()Lde/fraunhofer/aisec/cpg/graph/Name;", "setName", "(Lde/fraunhofer/aisec/cpg/graph/Name;)V", "<set-?>", "nextCDG", "getNextCDG", "setNextCDG", "nextCDG$delegate", "Lde/fraunhofer/aisec/cpg/graph/edge/PropertyEdgeDelegate;", "Lde/fraunhofer/aisec/cpg/graph/edge/PropertyEdge;", "nextCDGEdges", "getNextCDGEdges$annotations", "getNextCDGEdges", "setNextCDGEdges", "", "nextDFG", "getNextDFG$annotations", "getNextDFG", "()Ljava/util/Set;", "setNextDFG", "(Ljava/util/Set;)V", "nextDFG$delegate", "Lde/fraunhofer/aisec/cpg/graph/edge/PropertyEdgeSetDelegate;", "Lde/fraunhofer/aisec/cpg/graph/edge/Dataflow;", "nextDFGEdges", "getNextDFGEdges$annotations", "getNextDFGEdges", "setNextDFGEdges", "nextEOG", "getNextEOG$annotations", "getNextEOG", "setNextEOG", "nextEOG$delegate", "nextEOGEdges", "getNextEOGEdges$annotations", "getNextEOGEdges", "setNextEOGEdges", "nextPDG", "getNextPDG", "setNextPDG", "nextPDG$delegate", "nextPDGEdges", "getNextPDGEdges$annotations", "getNextPDGEdges", "setNextPDGEdges", "prevCDG", "getPrevCDG", "setPrevCDG", "prevCDG$delegate", "prevCDGEdges", "getPrevCDGEdges$annotations", "getPrevCDGEdges", "setPrevCDGEdges", "prevDFG", "getPrevDFG$annotations", "getPrevDFG", "setPrevDFG", "prevDFG$delegate", "prevDFGEdges", "getPrevDFGEdges$annotations", "getPrevDFGEdges", "setPrevDFGEdges", "prevEOG", "getPrevEOG$annotations", "getPrevEOG", "setPrevEOG", "prevEOG$delegate", "prevEOGEdges", "getPrevEOGEdges$annotations", "getPrevEOGEdges", "setPrevEOGEdges", "prevPDG", "getPrevPDG", "setPrevPDG", "prevPDG$delegate", "prevPDGEdges", "getPrevPDGEdges$annotations", "getPrevPDGEdges", "setPrevPDGEdges", "scope", "Lde/fraunhofer/aisec/cpg/graph/scopes/Scope;", "getScope", "()Lde/fraunhofer/aisec/cpg/graph/scopes/Scope;", "setScope", "(Lde/fraunhofer/aisec/cpg/graph/scopes/Scope;)V", "addAllPrevDFG", "", "prev", "", "granularity", "Lde/fraunhofer/aisec/cpg/graph/edge/Granularity;", "callingContext", "Lde/fraunhofer/aisec/cpg/graph/edge/CallingContext;", "addAllPrevPDG", "dependenceType", "Lde/fraunhofer/aisec/cpg/graph/edge/DependenceType;", "addAllPrevPDGEdges", "addAnnotations", "addNextDFG", "next", "addNextEOG", "propertyEdge", "addPrevCDG", "properties", "", "Lde/fraunhofer/aisec/cpg/graph/edge/Properties;", "", "addPrevDFG", "addPrevEOG", "clearNextDFG", "clearNextEOG", "clearPrevDFG", "disconnectFromGraph", "equals", "other", "hashCode", "removeNextDFG", "removePrevDFG", "removePrevEOGEntries", "prevEOGs", "removePrevEOGEntry", "eog", "toString", "Companion", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Node.kt\nde/fraunhofer/aisec/cpg/graph/Node\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,458:1\n1855#2,2:459\n1549#2:461\n1620#2,3:462\n1855#2:465\n1856#2:467\n1#3:466\n*S KotlinDebug\n*F\n+ 1 Node.kt\nde/fraunhofer/aisec/cpg/graph/Node\n*L\n315#1:459,2\n319#1:461\n319#1:462,3\n323#1:465\n323#1:467\n*E\n"})
public class Node
implements IVisitable<Node>,
Persistable,
LanguageProvider,
ScopeProvider,
ContextProvider {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @Transient
    @Nullable
    private TranslationContext ctx;
    @Convert(value=NameConverter.class)
    @NotNull
    private Name name = new Name("", null, null, 6, null);
    @Nullable
    private String code;
    @Relationship(value="LANGUAGE", direction=Relationship.Direction.OUTGOING)
    @JsonBackReference
    @Nullable
    private Language<?> language;
    @Relationship(value="SCOPE", direction=Relationship.Direction.OUTGOING)
    @JsonBackReference
    @Nullable
    private Scope scope;
    @Nullable
    private String comment;
    @Convert(value=LocationConverter.class)
    @Nullable
    private PhysicalLocation location;
    @Nullable
    private String file;
    @Relationship(value="EOG", direction=Relationship.Direction.INCOMING)
    @NotNull
    private List<PropertyEdge<Node>> prevEOGEdges = new ArrayList();
    @Relationship(value="EOG", direction=Relationship.Direction.OUTGOING)
    @NotNull
    private List<PropertyEdge<Node>> nextEOGEdges = new ArrayList();
    @Relationship(value="CDG", direction=Relationship.Direction.OUTGOING)
    @NotNull
    private List<PropertyEdge<Node>> nextCDGEdges = new ArrayList();
    @NotNull
    private final PropertyEdgeDelegate nextCDG$delegate = new PropertyEdgeDelegate((KProperty1)nextCDG.2.INSTANCE, true);
    @Relationship(value="CDG", direction=Relationship.Direction.INCOMING)
    @NotNull
    private List<PropertyEdge<Node>> prevCDGEdges = new ArrayList();
    @NotNull
    private final PropertyEdgeDelegate prevCDG$delegate = new PropertyEdgeDelegate((KProperty1)prevCDG.2.INSTANCE, false);
    @Relationship(value="AST")
    @NotNull
    private List<? extends Node> astChildren = CollectionsKt.emptyList();
    @NotNull
    private final PropertyEdgeDelegate prevEOG$delegate = new PropertyEdgeDelegate((KProperty1)prevEOG.2.INSTANCE, false);
    @NotNull
    private final PropertyEdgeDelegate nextEOG$delegate = new PropertyEdgeDelegate((KProperty1)nextEOG.2.INSTANCE, false, 2, null);
    @Relationship(value="DFG", direction=Relationship.Direction.INCOMING)
    @NotNull
    private List<Dataflow> prevDFGEdges = new ArrayList();
    @NotNull
    private final PropertyEdgeSetDelegate prevDFG$delegate = new PropertyEdgeSetDelegate((KProperty1)prevDFG.2.INSTANCE, false);
    @Relationship(value="DFG", direction=Relationship.Direction.OUTGOING)
    @NotNull
    private List<Dataflow> nextDFGEdges = new ArrayList();
    @NotNull
    private final PropertyEdgeSetDelegate nextDFG$delegate = new PropertyEdgeSetDelegate((KProperty1)nextDFG.2.INSTANCE, true);
    @Relationship(value="PDG", direction=Relationship.Direction.OUTGOING)
    @NotNull
    private Set<PropertyEdge<Node>> nextPDGEdges = new LinkedHashSet();
    @NotNull
    private final PropertyEdgeSetDelegate nextPDG$delegate = new PropertyEdgeSetDelegate((KProperty1)nextPDG.2.INSTANCE, true);
    @Relationship(value="PDG", direction=Relationship.Direction.INCOMING)
    @NotNull
    private Set<PropertyEdge<Node>> prevPDGEdges = new LinkedHashSet();
    @NotNull
    private final PropertyEdgeSetDelegate prevPDG$delegate = new PropertyEdgeSetDelegate((KProperty1)prevPDG.2.INSTANCE, false);
    private boolean isInferred;
    private boolean isImplicit;
    @Id
    @GeneratedValue
    @Nullable
    private Long id;
    private int argumentIndex;
    @AST
    @NotNull
    private List<Annotation> annotations = new ArrayList();
    @JvmField
    @NotNull
    public static ToStringStyle TO_STRING_STYLE;
    @NotNull
    private static final Logger log;
    @NotNull
    public static final String EMPTY_NAME = "";

    @Override
    @JsonIgnore
    @Nullable
    public TranslationContext getCtx() {
        return this.ctx;
    }

    public void setCtx(@Nullable TranslationContext translationContext) {
        this.ctx = translationContext;
    }

    @NotNull
    public Name getName() {
        return this.name;
    }

    public void setName(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"<set-?>");
        this.name = name2;
    }

    @Nullable
    public final String getCode() {
        return this.code;
    }

    public final void setCode(@Nullable String string) {
        this.code = string;
    }

    @Override
    @Nullable
    public Language<?> getLanguage() {
        return this.language;
    }

    public void setLanguage(@Nullable Language<?> language) {
        this.language = language;
    }

    @Override
    @Nullable
    public Scope getScope() {
        return this.scope;
    }

    public void setScope(@Nullable Scope scope) {
        this.scope = scope;
    }

    @Nullable
    public final String getComment() {
        return this.comment;
    }

    public final void setComment(@Nullable String string) {
        this.comment = string;
    }

    @Nullable
    public final PhysicalLocation getLocation() {
        return this.location;
    }

    public final void setLocation(@Nullable PhysicalLocation physicalLocation) {
        this.location = physicalLocation;
    }

    @Nullable
    public final String getFile() {
        return this.file;
    }

    public final void setFile(@Nullable String string) {
        this.file = string;
    }

    @PopulatedByPass(value={FilenameMapper.class})
    public static /* synthetic */ void getFile$annotations() {
    }

    @NotNull
    public final List<PropertyEdge<Node>> getPrevEOGEdges() {
        return this.prevEOGEdges;
    }

    protected final void setPrevEOGEdges(@NotNull List<PropertyEdge<Node>> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.prevEOGEdges = list2;
    }

    @PopulatedByPass(value={EvaluationOrderGraphPass.class})
    public static /* synthetic */ void getPrevEOGEdges$annotations() {
    }

    @NotNull
    public final List<PropertyEdge<Node>> getNextEOGEdges() {
        return this.nextEOGEdges;
    }

    protected final void setNextEOGEdges(@NotNull List<PropertyEdge<Node>> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.nextEOGEdges = list2;
    }

    @PopulatedByPass(value={EvaluationOrderGraphPass.class})
    public static /* synthetic */ void getNextEOGEdges$annotations() {
    }

    @NotNull
    public final List<PropertyEdge<Node>> getNextCDGEdges() {
        return this.nextCDGEdges;
    }

    protected final void setNextCDGEdges(@NotNull List<PropertyEdge<Node>> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.nextCDGEdges = list2;
    }

    @PopulatedByPass(value={ControlDependenceGraphPass.class})
    public static /* synthetic */ void getNextCDGEdges$annotations() {
    }

    @NotNull
    public final List<Node> getNextCDG() {
        return this.nextCDG$delegate.getValue(this, $$delegatedProperties[0]);
    }

    public final void setNextCDG(@NotNull List<? extends Node> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.nextCDG$delegate.setValue(this, $$delegatedProperties[0], list2);
    }

    @NotNull
    public final List<PropertyEdge<Node>> getPrevCDGEdges() {
        return this.prevCDGEdges;
    }

    protected final void setPrevCDGEdges(@NotNull List<PropertyEdge<Node>> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.prevCDGEdges = list2;
    }

    @PopulatedByPass(value={ControlDependenceGraphPass.class})
    public static /* synthetic */ void getPrevCDGEdges$annotations() {
    }

    @NotNull
    public final List<Node> getPrevCDG() {
        return this.prevCDG$delegate.getValue(this, $$delegatedProperties[1]);
    }

    public final void setPrevCDG(@NotNull List<? extends Node> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.prevCDG$delegate.setValue(this, $$delegatedProperties[1], list2);
    }

    @NotNull
    public final List<Node> getAstChildren() {
        return SubgraphWalker.getAstChildren(this);
    }

    public final void setAstChildren(@NotNull List<? extends Node> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.astChildren = list2;
    }

    @NotNull
    public final List<Node> getPrevEOG() {
        return this.prevEOG$delegate.getValue(this, $$delegatedProperties[2]);
    }

    public final void setPrevEOG(@NotNull List<? extends Node> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.prevEOG$delegate.setValue(this, $$delegatedProperties[2], list2);
    }

    @PopulatedByPass(value={EvaluationOrderGraphPass.class})
    public static /* synthetic */ void getPrevEOG$annotations() {
    }

    @NotNull
    public final List<Node> getNextEOG() {
        return this.nextEOG$delegate.getValue(this, $$delegatedProperties[3]);
    }

    public final void setNextEOG(@NotNull List<? extends Node> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.nextEOG$delegate.setValue(this, $$delegatedProperties[3], list2);
    }

    @PopulatedByPass(value={EvaluationOrderGraphPass.class})
    public static /* synthetic */ void getNextEOG$annotations() {
    }

    @NotNull
    public final List<Dataflow> getPrevDFGEdges() {
        return this.prevDFGEdges;
    }

    protected final void setPrevDFGEdges(@NotNull List<Dataflow> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.prevDFGEdges = list2;
    }

    @PopulatedByPass(value={DFGPass.class, ControlFlowSensitiveDFGPass.class})
    public static /* synthetic */ void getPrevDFGEdges$annotations() {
    }

    @NotNull
    public final Set<Node> getPrevDFG() {
        return this.prevDFG$delegate.getValue(this, $$delegatedProperties[4]);
    }

    public final void setPrevDFG(@NotNull Set<Node> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.prevDFG$delegate.setValue(this, $$delegatedProperties[4], set);
    }

    @PopulatedByPass(value={DFGPass.class, ControlFlowSensitiveDFGPass.class})
    public static /* synthetic */ void getPrevDFG$annotations() {
    }

    @NotNull
    public final List<Dataflow> getNextDFGEdges() {
        return this.nextDFGEdges;
    }

    protected final void setNextDFGEdges(@NotNull List<Dataflow> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.nextDFGEdges = list2;
    }

    @PopulatedByPass(value={DFGPass.class, ControlFlowSensitiveDFGPass.class})
    public static /* synthetic */ void getNextDFGEdges$annotations() {
    }

    @NotNull
    public final Set<Node> getNextDFG() {
        return this.nextDFG$delegate.getValue(this, $$delegatedProperties[5]);
    }

    public final void setNextDFG(@NotNull Set<Node> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.nextDFG$delegate.setValue(this, $$delegatedProperties[5], set);
    }

    @PopulatedByPass(value={DFGPass.class, ControlFlowSensitiveDFGPass.class})
    public static /* synthetic */ void getNextDFG$annotations() {
    }

    @NotNull
    public final Set<PropertyEdge<Node>> getNextPDGEdges() {
        return this.nextPDGEdges;
    }

    protected final void setNextPDGEdges(@NotNull Set<PropertyEdge<Node>> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.nextPDGEdges = set;
    }

    @PopulatedByPass(value={ProgramDependenceGraphPass.class})
    public static /* synthetic */ void getNextPDGEdges$annotations() {
    }

    @NotNull
    public final Set<Node> getNextPDG() {
        return this.nextPDG$delegate.getValue(this, $$delegatedProperties[6]);
    }

    public final void setNextPDG(@NotNull Set<Node> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.nextPDG$delegate.setValue(this, $$delegatedProperties[6], set);
    }

    @NotNull
    public final Set<PropertyEdge<Node>> getPrevPDGEdges() {
        return this.prevPDGEdges;
    }

    protected final void setPrevPDGEdges(@NotNull Set<PropertyEdge<Node>> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.prevPDGEdges = set;
    }

    @PopulatedByPass(value={ProgramDependenceGraphPass.class})
    public static /* synthetic */ void getPrevPDGEdges$annotations() {
    }

    @NotNull
    public final Set<Node> getPrevPDG() {
        return this.prevPDG$delegate.getValue(this, $$delegatedProperties[7]);
    }

    public final void setPrevPDG(@NotNull Set<Node> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.prevPDG$delegate.setValue(this, $$delegatedProperties[7], set);
    }

    public final boolean isInferred() {
        return this.isInferred;
    }

    public final void setInferred(boolean bl) {
        this.isInferred = bl;
    }

    public final boolean isImplicit() {
        return this.isImplicit;
    }

    public final void setImplicit(boolean bl) {
        this.isImplicit = bl;
    }

    @Nullable
    public final Long getId() {
        return this.id;
    }

    public final void setId(@Nullable Long l) {
        this.id = l;
    }

    public final int getArgumentIndex() {
        return this.argumentIndex;
    }

    public final void setArgumentIndex(int n) {
        this.argumentIndex = n;
    }

    @NotNull
    public final List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public final void setAnnotations(@NotNull List<Annotation> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.annotations = list2;
    }

    public final void removePrevEOGEntry(@NotNull Node eog) {
        Intrinsics.checkNotNullParameter((Object)eog, (String)"eog");
        this.removePrevEOGEntries(CollectionsKt.listOf((Object)eog));
    }

    private final void removePrevEOGEntries(List<? extends Node> prevEOGs) {
        for (Node node : prevEOGs) {
            List remove2 = PropertyEdge.Companion.findPropertyEdgesByPredicate((Collection)this.prevEOGEdges, (Function1)new Function1<PropertyEdge<Node>, Boolean>(node){
                final /* synthetic */ Node $n;
                {
                    this.$n = $n;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PropertyEdge<Node> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return it.getStart() == this.$n;
                }
            });
            this.prevEOGEdges.removeAll(remove2);
        }
    }

    public final void addPrevEOG(@NotNull PropertyEdge<Node> propertyEdge) {
        Intrinsics.checkNotNullParameter(propertyEdge, (String)"propertyEdge");
        this.prevEOGEdges.add(propertyEdge);
    }

    public final void addNextEOG(@NotNull PropertyEdge<Node> propertyEdge) {
        Intrinsics.checkNotNullParameter(propertyEdge, (String)"propertyEdge");
        this.nextEOGEdges.add(propertyEdge);
    }

    public final void clearNextEOG() {
        this.nextEOGEdges.clear();
    }

    public final void addNextDFG(@NotNull Node next, @NotNull Granularity granularity, @Nullable CallingContext callingContext) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        Intrinsics.checkNotNullParameter((Object)granularity, (String)"granularity");
        Dataflow edge = callingContext != null ? (Dataflow)new ContextSensitiveDataflow(this, next, callingContext, granularity) : new Dataflow(this, next, granularity);
        this.nextDFGEdges.add(edge);
        next.prevDFGEdges.add(edge);
    }

    public static /* synthetic */ void addNextDFG$default(Node node, Node node2, Granularity granularity, CallingContext callingContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addNextDFG");
        }
        if ((n & 2) != 0) {
            granularity = DataflowKt.default();
        }
        if ((n & 4) != 0) {
            callingContext = null;
        }
        node.addNextDFG(node2, granularity, callingContext);
    }

    public final void removeNextDFG(@Nullable Node next) {
        if (next != null) {
            List thisRemove2 = PropertyEdge.Companion.findPropertyEdgesByPredicate((Collection)this.nextDFGEdges, (Function1)new Function1<Dataflow, Boolean>(next){
                final /* synthetic */ Node $next;
                {
                    this.$next = $next;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Dataflow it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getEnd() == this.$next;
                }
            });
            this.nextDFGEdges.removeAll(thisRemove2);
            List nextRemove2 = PropertyEdge.Companion.findPropertyEdgesByPredicate((Collection)next.prevDFGEdges, (Function1)new Function1<Dataflow, Boolean>(this){
                final /* synthetic */ Node this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Dataflow it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getStart(), (Object)this.this$0);
                }
            });
            next.prevDFGEdges.removeAll(nextRemove2);
        }
    }

    public void addPrevDFG(@NotNull Node prev, @NotNull Granularity granularity, @Nullable CallingContext callingContext) {
        Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
        Intrinsics.checkNotNullParameter((Object)granularity, (String)"granularity");
        Dataflow edge = callingContext != null ? (Dataflow)new ContextSensitiveDataflow(prev, this, callingContext, granularity) : new Dataflow(prev, this, granularity);
        this.prevDFGEdges.add(edge);
        prev.nextDFGEdges.add(edge);
    }

    public static /* synthetic */ void addPrevDFG$default(Node node, Node node2, Granularity granularity, CallingContext callingContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addPrevDFG");
        }
        if ((n & 2) != 0) {
            granularity = DataflowKt.default();
        }
        if ((n & 4) != 0) {
            callingContext = null;
        }
        node.addPrevDFG(node2, granularity, callingContext);
    }

    public final void addPrevCDG(@NotNull Node prev, @NotNull Map<Properties, Object> properties) {
        Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        PropertyEdge<Node> edge = new PropertyEdge<Node>(prev, this, properties);
        this.prevCDGEdges.add(edge);
        prev.nextCDGEdges.add(edge);
    }

    public static /* synthetic */ void addPrevCDG$default(Node node, Node node2, Map map, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addPrevCDG");
        }
        if ((n & 2) != 0) {
            map = new EnumMap(Properties.class);
        }
        node.addPrevCDG(node2, map);
    }

    public final void addAllPrevDFG(@NotNull Collection<? extends Node> prev, @NotNull Granularity granularity, @Nullable CallingContext callingContext) {
        Intrinsics.checkNotNullParameter(prev, (String)"prev");
        Intrinsics.checkNotNullParameter((Object)granularity, (String)"granularity");
        Iterable $this$forEach$iv = prev;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            this.addPrevDFG(it, granularity, callingContext);
        }
    }

    public static /* synthetic */ void addAllPrevDFG$default(Node node, Collection collection, Granularity granularity, CallingContext callingContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addAllPrevDFG");
        }
        if ((n & 2) != 0) {
            granularity = DataflowKt.full();
        }
        if ((n & 4) != 0) {
            callingContext = null;
        }
        node.addAllPrevDFG(collection, granularity, callingContext);
    }

    /*
     * WARNING - void declaration
     */
    public final void addAllPrevPDG(@NotNull Collection<? extends Node> prev, @NotNull DependenceType dependenceType) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(prev, (String)"prev");
        Intrinsics.checkNotNullParameter((Object)((Object)dependenceType), (String)"dependenceType");
        Iterable iterable = prev;
        Node node = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Node node2 = (Node)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PropertyEdge<Node>((Node)it, this));
        }
        node.addAllPrevPDGEdges((List)destination$iv$iv, dependenceType);
    }

    public final void addAllPrevPDGEdges(@NotNull Collection<? extends PropertyEdge<Node>> prev, @NotNull DependenceType dependenceType) {
        Intrinsics.checkNotNullParameter(prev, (String)"prev");
        Intrinsics.checkNotNullParameter((Object)((Object)dependenceType), (String)"dependenceType");
        Iterable $this$forEach$iv = prev;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PropertyEdge propertyEdge;
            PropertyEdge it = (PropertyEdge)element$iv;
            boolean bl = false;
            PropertyEdge $this$addAllPrevPDGEdges_u24lambda_u243_u24lambda_u242 = propertyEdge = new PropertyEdge(it);
            boolean bl2 = false;
            $this$addAllPrevPDGEdges_u24lambda_u243_u24lambda_u242.addProperty(Properties.DEPENDENCE, (Object)dependenceType);
            PropertyEdge edge = propertyEdge;
            this.prevPDGEdges.add(edge);
            Node other = !Intrinsics.areEqual((Object)it.getStart(), (Object)this) ? it.getStart() : it.getEnd();
            other.nextPDGEdges.add(edge);
        }
    }

    public final void removePrevDFG(@Nullable Node prev) {
        if (prev != null) {
            List thisRemove2 = PropertyEdge.Companion.findPropertyEdgesByPredicate((Collection)this.prevDFGEdges, (Function1)new Function1<Dataflow, Boolean>(prev){
                final /* synthetic */ Node $prev;
                {
                    this.$prev = $prev;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Dataflow it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getStart() == this.$prev;
                }
            });
            this.prevDFGEdges.removeAll(thisRemove2);
            List prevRemove2 = PropertyEdge.Companion.findPropertyEdgesByPredicate((Collection)prev.nextDFGEdges, (Function1)new Function1<Dataflow, Boolean>(this){
                final /* synthetic */ Node this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Dataflow it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getEnd() == this.this$0;
                }
            });
            prev.nextDFGEdges.removeAll(prevRemove2);
        }
    }

    public final void clearPrevDFG() {
        for (Node prev : new ArrayList(this.getPrevDFG())) {
            this.removePrevDFG(prev);
        }
    }

    public final void clearNextDFG() {
        for (Node prev : new ArrayList(this.getNextDFG())) {
            this.removeNextDFG(prev);
        }
    }

    public final void addAnnotations(@NotNull Collection<Annotation> annotations) {
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        this.annotations.addAll(annotations);
    }

    public final void disconnectFromGraph() {
        List remove2;
        for (Dataflow dataflow : this.nextDFGEdges) {
            List remove22 = PropertyEdge.Companion.findPropertyEdgesByPredicate((Collection)((Node)dataflow.getEnd()).prevDFGEdges, (Function1)new Function1<Dataflow, Boolean>(this){
                final /* synthetic */ Node this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Dataflow it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getStart(), (Object)this.this$0);
                }
            });
            ((Node)dataflow.getEnd()).prevDFGEdges.removeAll(remove22);
        }
        this.nextDFGEdges.clear();
        for (Dataflow dataflow : this.prevDFGEdges) {
            remove2 = PropertyEdge.Companion.findPropertyEdgesByPredicate((Collection)dataflow.getStart().nextDFGEdges, (Function1)new Function1<Dataflow, Boolean>(this){
                final /* synthetic */ Node this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Dataflow it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual(it.getEnd(), (Object)this.this$0);
                }
            });
            dataflow.getStart().nextDFGEdges.removeAll(remove2);
        }
        this.prevDFGEdges.clear();
        for (PropertyEdge propertyEdge : this.nextEOGEdges) {
            remove2 = PropertyEdge.Companion.findPropertyEdgesByPredicate((Collection)((Node)propertyEdge.getEnd()).prevEOGEdges, (Function1)new Function1<PropertyEdge<Node>, Boolean>(this){
                final /* synthetic */ Node this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PropertyEdge<Node> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getStart(), (Object)this.this$0);
                }
            });
            ((Node)propertyEdge.getEnd()).prevEOGEdges.removeAll(remove2);
        }
        this.nextEOGEdges.clear();
        for (PropertyEdge propertyEdge : this.prevEOGEdges) {
            remove2 = PropertyEdge.Companion.findPropertyEdgesByPredicate((Collection)propertyEdge.getStart().nextEOGEdges, (Function1)new Function1<PropertyEdge<Node>, Boolean>(this){
                final /* synthetic */ Node this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PropertyEdge<Node> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getEnd(), (Object)this.this$0);
                }
            });
            propertyEdge.getStart().nextEOGEdges.removeAll(remove2);
        }
        this.prevEOGEdges.clear();
    }

    @NotNull
    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, TO_STRING_STYLE);
        if (((CharSequence)this.getName()).length() > 0) {
            builder.append("name", (Object)this.getName());
        }
        String string = builder.append("location", (Object)this.location).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Node)) {
            return false;
        }
        return this.location == null || ((Node)other).location == null ? false : Intrinsics.areEqual((Object)this.getName(), (Object)((Node)other).getName()) && Intrinsics.areEqual((Object)this.code, (Object)((Node)other).code) && Intrinsics.areEqual((Object)this.comment, (Object)((Node)other).comment) && Intrinsics.areEqual((Object)this.location, (Object)((Node)other).location) && this.isImplicit == ((Node)other).isImplicit;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getName(), this.location, this.getClass()};
        return Objects.hash(objectArray);
    }

    @Override
    public void accept(@NotNull IStrategy<Node> strategy2, @NotNull IVisitor<Node> visitor2) {
        IVisitable.DefaultImpls.accept(this, strategy2, visitor2);
    }

    @NotNull
    protected static final Logger getLog() {
        return Companion.getLog();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Node.class, "nextCDG", "getNextCDG()Ljava/util/List;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Node.class, "prevCDG", "getPrevCDG()Ljava/util/List;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Node.class, "prevEOG", "getPrevEOG()Ljava/util/List;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Node.class, "nextEOG", "getNextEOG()Ljava/util/List;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Node.class, "prevDFG", "getPrevDFG()Ljava/util/Set;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Node.class, "nextDFG", "getNextDFG()Ljava/util/Set;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Node.class, "nextPDG", "getNextPDG()Ljava/util/Set;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Node.class, "prevPDG", "getPrevPDG()Ljava/util/Set;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        ToStringStyle toStringStyle = ToStringStyle.SHORT_PREFIX_STYLE;
        Intrinsics.checkNotNullExpressionValue((Object)toStringStyle, (String)"SHORT_PREFIX_STYLE");
        TO_STRING_STYLE = toStringStyle;
        Logger logger = LoggerFactory.getLogger(Node.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u00020\b8\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lde/fraunhofer/aisec/cpg/graph/Node$Companion;", "", "()V", "EMPTY_NAME", "", "TO_STRING_STYLE", "Lorg/apache/commons/lang3/builder/ToStringStyle;", "log", "Lorg/slf4j/Logger;", "getLog$annotations", "getLog", "()Lorg/slf4j/Logger;", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLog() {
            return log;
        }

        @JvmStatic
        protected static /* synthetic */ void getLog$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

