/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.graph.NameKt;
import java.util.Objects;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\u0010\u000f\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0002\b\r\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\u00020\u0003B)\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u0012\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0005J\b\u0010\u001b\u001a\u00020\u0000H\u0016J\u0011\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010\u001d\u001a\u0004\u0018\u00010 H\u0096\u0002J\u0011\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0013H\u0096\u0002J\b\u0010$\u001a\u00020\u0013H\u0016J\u0006\u0010%\u001a\u00020\u001fJ\u000e\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u0000J\u000e\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u0005J\u0016\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005J\u0018\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u0013H\u0016J\b\u0010.\u001a\u00020\u0005H\u0016R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006/"}, d2={"Lde/fraunhofer/aisec/cpg/graph/Name;", "", "", "", "localName", "", "parent", "language", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "(Ljava/lang/String;Lde/fraunhofer/aisec/cpg/graph/Name;Lde/fraunhofer/aisec/cpg/frontends/Language;)V", "delimiter", "(Ljava/lang/String;Lde/fraunhofer/aisec/cpg/graph/Name;Ljava/lang/String;)V", "getDelimiter", "()Ljava/lang/String;", "fullName", "getFullName", "fullName$delegate", "Lkotlin/Lazy;", "length", "", "getLength", "()I", "getLocalName", "getParent", "()Lde/fraunhofer/aisec/cpg/graph/Name;", "append", "s", "clone", "compareTo", "other", "equals", "", "", "get", "", "index", "hashCode", "isQualified", "lastPartsMatch", "ending", "replace", "oldValue", "newValue", "subSequence", "startIndex", "endIndex", "toString", "cpg-core"})
public final class Name
implements Cloneable,
Comparable<Name>,
CharSequence {
    @NotNull
    private final String localName;
    @Nullable
    private final Name parent;
    @NotNull
    private final String delimiter;
    @NotNull
    private final Lazy fullName$delegate;
    private final int length;

    public Name(@NotNull String localName, @Nullable Name parent, @NotNull String delimiter) {
        Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        this.localName = localName;
        this.parent = parent;
        this.delimiter = delimiter;
        this.fullName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Name this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return (String)(this.this$0.getParent() != null ? this.this$0.getParent() + this.this$0.getDelimiter() : "") + this.this$0.getLocalName();
            }
        }));
        this.length = this.getFullName().length();
    }

    public /* synthetic */ Name(String string, Name name2, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            name2 = null;
        }
        if ((n & 4) != 0) {
            string2 = ".";
        }
        this(string, name2, string2);
    }

    @NotNull
    public final String getLocalName() {
        return this.localName;
    }

    @Nullable
    public final Name getParent() {
        return this.parent;
    }

    @NotNull
    public final String getDelimiter() {
        return this.delimiter;
    }

    public Name(@NotNull String localName, @Nullable Name parent, @Nullable Language<?> language) {
        Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
        Language<?> language2 = language;
        if (language2 == null || (language2 = language2.getNamespaceDelimiter()) == null) {
            language2 = ".";
        }
        this(localName, parent, (String)((Object)language2));
    }

    public /* synthetic */ Name(String string, Name name2, Language language, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            name2 = null;
        }
        this(string, name2, language);
    }

    private final String getFullName() {
        Lazy lazy = this.fullName$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public Name clone() {
        Name name2 = this.parent;
        return new Name(this.localName, name2 != null ? name2.clone() : null, this.delimiter);
    }

    @Override
    @NotNull
    public String toString() {
        return this.getFullName();
    }

    public int getLength() {
        return this.length;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.localName, (Object)((Name)other).localName) && Intrinsics.areEqual((Object)this.parent, (Object)((Name)other).parent) && Intrinsics.areEqual((Object)this.delimiter, (Object)((Name)other).delimiter);
    }

    public char get(int index) {
        return this.getFullName().charAt(index);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.localName, this.parent, this.delimiter};
        return Objects.hash(objectArray);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int startIndex, int endIndex) {
        return this.getFullName().subSequence(startIndex, endIndex);
    }

    public final boolean lastPartsMatch(@NotNull Name ending) {
        Intrinsics.checkNotNullParameter((Object)ending, (String)"ending");
        return Intrinsics.areEqual((Object)this.localName, (Object)ending.localName) && (ending.parent == null || this.parent != null && this.parent.lastPartsMatch(ending.parent));
    }

    public final boolean lastPartsMatch(@NotNull String ending) {
        Intrinsics.checkNotNullParameter((Object)ending, (String)"ending");
        return this.lastPartsMatch(NameKt.parseName(ending, this.delimiter, new String[0]));
    }

    @NotNull
    public final Name append(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return new Name(this.localName + s, this.parent, this.delimiter);
    }

    @NotNull
    public final Name replace(@NotNull String oldValue, @NotNull String newValue) {
        Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        return new Name(StringsKt.replace$default((String)this.localName, (String)oldValue, (String)newValue, (boolean)false, (int)4, null), this.parent, this.delimiter);
    }

    @Override
    public int compareTo(@NotNull Name other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getFullName().compareTo(other.toString());
    }

    public final boolean isQualified() {
        return this.parent != null;
    }
}

