/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.MermaidPrinterKt;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.edge.Dataflow;
import de.fraunhofer.aisec.cpg.graph.edge.PartialDataflowGranularity;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.helpers.IdentitySet;
import de.fraunhofer.aisec.cpg.helpers.IdentitySetKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0002\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0002\u001a\u0014\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\t\u001aX\u0010\n\u001a\u00020\u0001\"\u000e\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u00020\u00020\u0006*\u00020\u00022\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\u000e0\r2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\u000e0\r2\b\b\u0002\u0010\b\u001a\u00020\t\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0010"}, d2={"nodeLabel", "", "Lde/fraunhofer/aisec/cpg/graph/Node;", "getNodeLabel", "(Lde/fraunhofer/aisec/cpg/graph/Node;)Ljava/lang/String;", "label", "Lde/fraunhofer/aisec/cpg/graph/edge/PropertyEdge;", "printDFG", "maxConnections", "", "printGraph", "T", "nextEdgeGetter", "Lkotlin/reflect/KProperty1;", "", "prevEdgeGetter", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nMermaidPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MermaidPrinter.kt\nde/fraunhofer/aisec/cpg/graph/MermaidPrinterKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n766#2:131\n857#2,2:132\n1045#2:134\n766#2:135\n857#2,2:136\n1045#2:138\n766#2:139\n857#2,2:140\n1045#2:142\n766#2:143\n857#2,2:144\n1045#2:146\n*S KotlinDebug\n*F\n+ 1 MermaidPrinter.kt\nde/fraunhofer/aisec/cpg/graph/MermaidPrinterKt\n*L\n91#1:131\n91#1:132,2\n91#1:134\n94#1:135\n94#1:136,2\n94#1:138\n97#1:139\n97#1:140,2\n97#1:142\n100#1:143\n100#1:144,2\n100#1:146\n*E\n"})
public final class MermaidPrinterKt {
    @NotNull
    public static final String printDFG(@NotNull Node $this$printDFG, int maxConnections) {
        Intrinsics.checkNotNullParameter((Object)$this$printDFG, (String)"<this>");
        return MermaidPrinterKt.printGraph($this$printDFG, (KProperty1)printDFG.1.INSTANCE, (KProperty1)printDFG.2.INSTANCE, maxConnections);
    }

    public static /* synthetic */ String printDFG$default(Node node, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 25;
        }
        return MermaidPrinterKt.printDFG(node, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T extends PropertyEdge<Node>> String printGraph(@NotNull Node $this$printGraph, @NotNull KProperty1<Node, ? extends List<T>> nextEdgeGetter, @NotNull KProperty1<Node, ? extends List<T>> prevEdgeGetter, int maxConnections) {
        Intrinsics.checkNotNullParameter((Object)$this$printGraph, (String)"<this>");
        Intrinsics.checkNotNullParameter(nextEdgeGetter, (String)"nextEdgeGetter");
        Intrinsics.checkNotNullParameter(prevEdgeGetter, (String)"prevEdgeGetter");
        StringBuilder builder = new StringBuilder();
        builder.append("```mermaid\n");
        builder.append("flowchart TD\n");
        LinkedHashSet worklist = new LinkedHashSet();
        IdentitySet<PropertyEdge> alreadySeen = IdentitySetKt.identitySetOf(new PropertyEdge[0]);
        int conns = 0;
        worklist.addAll((Collection)nextEdgeGetter.get((Object)$this$printGraph));
        while (!((Collection)worklist).isEmpty() && conns < maxConnections) {
            void $this$sortedBy$iv;
            Iterable $this$filterTo$iv$iv;
            void $this$sortedBy$iv2;
            void $this$filterTo$iv$iv2;
            PropertyEdge edge = (PropertyEdge)CollectionsKt.first((Iterable)worklist);
            worklist.remove(edge);
            ((Collection)alreadySeen).add(edge);
            Node start = edge.getStart();
            Object end = edge.getEnd();
            builder.append(start.hashCode() + "[\"" + MermaidPrinterKt.getNodeLabel(start) + "\"]-->|" + MermaidPrinterKt.label(edge) + "|" + ((Node)end).hashCode() + "[\"" + MermaidPrinterKt.getNodeLabel(end) + "\"]\n");
            ++conns;
            Iterable $this$filter$iv = (Iterable)nextEdgeGetter.get(end);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                PropertyEdge it = (PropertyEdge)element$iv$iv;
                boolean bl = false;
                if (!(!alreadySeen.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            List next = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PropertyEdge it = (PropertyEdge)a;
                    boolean bl = false;
                    Comparable comparable = ((Node)it.getEnd()).getName();
                    it = (PropertyEdge)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Node)it.getEnd()).getName());
                }
            });
            CollectionsKt.addAll((Collection)worklist, (Iterable)next);
            Iterable $this$filter$iv2 = (Iterable)prevEdgeGetter.get(end);
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PropertyEdge it = (PropertyEdge)element$iv$iv;
                boolean bl = false;
                if (!(!alreadySeen.contains(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$sortedBy2 = false;
            List prev = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PropertyEdge it = (PropertyEdge)a;
                    boolean bl = false;
                    Comparable comparable = it.getStart().getName();
                    it = (PropertyEdge)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getStart().getName());
                }
            });
            CollectionsKt.addAll((Collection)worklist, (Iterable)prev);
            $this$filter$iv2 = (Iterable)nextEdgeGetter.get((Object)start);
            $i$f$filter2 = false;
            $this$filterTo$iv$iv = $this$filter$iv2;
            destination$iv$iv2 = new ArrayList();
            $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PropertyEdge it = (PropertyEdge)element$iv$iv;
                boolean bl = false;
                if (!(!alreadySeen.contains(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            $i$f$sortedBy2 = false;
            next = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PropertyEdge it = (PropertyEdge)a;
                    boolean bl = false;
                    Comparable comparable = ((Node)it.getEnd()).getName();
                    it = (PropertyEdge)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Node)it.getEnd()).getName());
                }
            });
            CollectionsKt.addAll((Collection)worklist, (Iterable)next);
            $this$filter$iv2 = (Iterable)prevEdgeGetter.get((Object)start);
            $i$f$filter2 = false;
            $this$filterTo$iv$iv = $this$filter$iv2;
            destination$iv$iv2 = new ArrayList();
            $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PropertyEdge it = (PropertyEdge)element$iv$iv;
                boolean bl = false;
                if (!(!alreadySeen.contains(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            $i$f$sortedBy2 = false;
            prev = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PropertyEdge it = (PropertyEdge)a;
                    boolean bl = false;
                    Comparable comparable = it.getStart().getName();
                    it = (PropertyEdge)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getStart().getName());
                }
            });
            CollectionsKt.addAll((Collection)worklist, (Iterable)prev);
        }
        builder.append("```");
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String printGraph$default(Node node, KProperty1 kProperty1, KProperty1 kProperty12, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 25;
        }
        return MermaidPrinterKt.printGraph(node, kProperty1, kProperty12, n);
    }

    private static final String label(PropertyEdge<Node> $this$label) {
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        builder.append($this$label.getLabel());
        if ($this$label instanceof Dataflow) {
            if (((Dataflow)$this$label).getGranularity() instanceof PartialDataflowGranularity) {
                Declaration declaration = ((PartialDataflowGranularity)((Dataflow)$this$label).getGranularity()).getPartialTarget();
                builder.append(" (partial, " + (declaration != null ? declaration.getName() : null) + ")");
            } else {
                builder.append(" (full)");
            }
        }
        builder.append("\"");
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final String getNodeLabel(Node $this$nodeLabel) {
        return $this$nodeLabel.getName() + "\n(" + Reflection.getOrCreateKotlinClass($this$nodeLabel.getClass()).getSimpleName() + ")\n" + $this$nodeLabel.getLocation();
    }
}

