/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends;

import de.fraunhofer.aisec.cpg.TranslationContext;
import de.fraunhofer.aisec.cpg.frontends.HandlerInterface;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.ProcessedListener;
import de.fraunhofer.aisec.cpg.graph.CodeAndLocationProvider;
import de.fraunhofer.aisec.cpg.graph.ContextProvider;
import de.fraunhofer.aisec.cpg.graph.LanguageProvider;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.NamespaceProvider;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.ProblemNode;
import de.fraunhofer.aisec.cpg.graph.RawNodeTypeProvider;
import de.fraunhofer.aisec.cpg.graph.ScopeProvider;
import de.fraunhofer.aisec.cpg.graph.scopes.Scope;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 @*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u0002*\u0004\b\u0001\u0010\u0003*\u0014\b\u0002\u0010\u0004*\u000e\u0012\u0006\b\u0000\u0012\u0002H\u0003\u0012\u0002\b\u00030\u00052\u00020\u00062\b\u0012\u0004\u0012\u0002H\u00030\u00072\u00020\b2\u00020\t2\u00020\n2\b\u0012\u0004\u0012\u0002H\u00030\u000b:\u0001@B\u001b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u0006\u0010\u000e\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0018\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u00028\u0001H\u0096\u0001\u00a2\u0006\u0002\u00106J\u0016\u00107\u001a\b\u0012\u0002\b\u0003\u0018\u00010%2\u0006\u00108\u001a\u000209H\u0002J\u0017\u0010:\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0012\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010;J\u0018\u0010<\u001a\u0004\u0018\u00010=2\u0006\u00105\u001a\u00028\u0001H\u0096\u0001\u00a2\u0006\u0002\u0010>J\u000e\u0010?\u001a\b\u0012\u0002\b\u0003\u0018\u00010%H\u0002R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u000e\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001aX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!RX\u0010#\u001aF\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00010%\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010&0$j\"\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00010%\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010&`'X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u0004\u0018\u00010+X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u0004\u0018\u00010/X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0014\u00102\u001a\b\u0012\u0002\b\u0003\u0018\u00010%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/Handler;", "ResultNode", "Lde/fraunhofer/aisec/cpg/graph/Node;", "HandlerNode", "L", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "Lde/fraunhofer/aisec/cpg/graph/LanguageProvider;", "Lde/fraunhofer/aisec/cpg/graph/CodeAndLocationProvider;", "Lde/fraunhofer/aisec/cpg/graph/ScopeProvider;", "Lde/fraunhofer/aisec/cpg/graph/NamespaceProvider;", "Lde/fraunhofer/aisec/cpg/graph/ContextProvider;", "Lde/fraunhofer/aisec/cpg/graph/RawNodeTypeProvider;", "configConstructor", "Ljava/util/function/Supplier;", "frontend", "(Ljava/util/function/Supplier;Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;)V", "getConfigConstructor", "()Ljava/util/function/Supplier;", "ctx", "Lde/fraunhofer/aisec/cpg/TranslationContext;", "getCtx", "()Lde/fraunhofer/aisec/cpg/TranslationContext;", "getFrontend", "()Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "language", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "getLanguage", "()Lde/fraunhofer/aisec/cpg/frontends/Language;", "lastNode", "getLastNode", "()Lde/fraunhofer/aisec/cpg/graph/Node;", "setLastNode", "(Lde/fraunhofer/aisec/cpg/graph/Node;)V", "Lde/fraunhofer/aisec/cpg/graph/Node;", "map", "Ljava/util/HashMap;", "Ljava/lang/Class;", "Lde/fraunhofer/aisec/cpg/frontends/HandlerInterface;", "Lkotlin/collections/HashMap;", "getMap", "()Ljava/util/HashMap;", "namespace", "Lde/fraunhofer/aisec/cpg/graph/Name;", "getNamespace", "()Lde/fraunhofer/aisec/cpg/graph/Name;", "scope", "Lde/fraunhofer/aisec/cpg/graph/scopes/Scope;", "getScope", "()Lde/fraunhofer/aisec/cpg/graph/scopes/Scope;", "typeOfT", "codeOf", "", "astNode", "(Ljava/lang/Object;)Ljava/lang/String;", "getBaseClass", "type", "Ljava/lang/reflect/Type;", "handle", "(Ljava/lang/Object;)Lde/fraunhofer/aisec/cpg/graph/Node;", "locationOf", "Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "(Ljava/lang/Object;)Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "retrieveTypeParameter", "Companion", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Handler.kt\nde/fraunhofer/aisec/cpg/frontends/Handler\n+ 2 Util.kt\nde/fraunhofer/aisec/cpg/helpers/Util\n*L\n1#1,177:1\n181#2,9:178\n181#2,9:187\n181#2,9:196\n*S KotlinDebug\n*F\n+ 1 Handler.kt\nde/fraunhofer/aisec/cpg/frontends/Handler\n*L\n95#1:178,9\n113#1:187,9\n129#1:196,9\n*E\n"})
public abstract class Handler<ResultNode extends Node, HandlerNode, L extends LanguageFrontend<? super HandlerNode, ?>>
implements LanguageProvider,
CodeAndLocationProvider<HandlerNode>,
ScopeProvider,
NamespaceProvider,
ContextProvider,
RawNodeTypeProvider<HandlerNode> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Supplier<ResultNode> configConstructor;
    @NotNull
    private final L frontend;
    @NotNull
    private final HashMap<Class<? extends HandlerNode>, HandlerInterface<ResultNode, HandlerNode>> map;
    @Nullable
    private final Class<?> typeOfT;
    @Nullable
    private ResultNode lastNode;
    @NotNull
    private static final Logger log;

    public Handler(@NotNull Supplier<ResultNode> configConstructor, @NotNull L frontend) {
        Intrinsics.checkNotNullParameter(configConstructor, (String)"configConstructor");
        Intrinsics.checkNotNullParameter(frontend, (String)"frontend");
        this.configConstructor = configConstructor;
        this.frontend = frontend;
        this.map = new HashMap();
        this.typeOfT = this.retrieveTypeParameter();
    }

    @NotNull
    protected final Supplier<ResultNode> getConfigConstructor() {
        return this.configConstructor;
    }

    @NotNull
    public final L getFrontend() {
        return this.frontend;
    }

    @Override
    @Nullable
    public Language<?> getLanguage() {
        return ((LanguageFrontend)this.frontend).getLanguage();
    }

    @Override
    @Nullable
    public String codeOf(HandlerNode astNode) {
        return ((LanguageFrontend)this.frontend).codeOf(astNode);
    }

    @Override
    @Nullable
    public PhysicalLocation locationOf(HandlerNode astNode) {
        return ((LanguageFrontend)this.frontend).locationOf(astNode);
    }

    @Override
    @Nullable
    public Scope getScope() {
        return ((LanguageFrontend)this.frontend).getScope();
    }

    @Override
    @Nullable
    public Name getNamespace() {
        return ((LanguageFrontend)this.frontend).getNamespace();
    }

    @Override
    @Nullable
    public TranslationContext getCtx() {
        return ((LanguageFrontend)this.frontend).getCtx();
    }

    @NotNull
    protected final HashMap<Class<? extends HandlerNode>, HandlerInterface<ResultNode, HandlerNode>> getMap() {
        return this.map;
    }

    @Nullable
    public final ResultNode getLastNode() {
        return this.lastNode;
    }

    public final void setLastNode(@Nullable ResultNode ResultNode) {
        this.lastNode = ResultNode;
    }

    @Nullable
    public ResultNode handle(HandlerNode ctx) {
        Object problem;
        Object[] arguments$iv;
        Object log$iv;
        Object[] objectArray;
        String format$iv;
        L lang$iv;
        String string;
        boolean $i$f$errorWithFileLocation;
        Object ret = null;
        if (ctx == null) {
            log.error("ctx is NULL. This can happen when ast children are optional in " + this.getClass() + ". Called by " + Thread.currentThread().getStackTrace()[2]);
            return null;
        }
        Class<?> toHandle = ctx.getClass();
        HandlerInterface handler = (HandlerInterface)((Map)this.map).get(toHandle);
        while (handler == null) {
            Intrinsics.checkNotNullExpressionValue(toHandle.getSuperclass(), (String)"getSuperclass(...)");
            handler = (HandlerInterface)((Map)this.map).get(toHandle);
            if (handler != null) {
                String string2 = ctx.getClass().getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
                if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"LiteralExpr", (boolean)false, (int)2, null)) {
                    Util util = Util.INSTANCE;
                    L l = this.frontend;
                    Logger logger = log;
                    String string3 = "No handler for type " + ctx.getClass() + ", resolving for its superclass " + toHandle + ".";
                    Object[] objectArray2 = new Object[]{};
                    $i$f$errorWithFileLocation = false;
                    string = "%s: %s";
                    objectArray = new Object[]{PhysicalLocation.Companion.locationLink(((LanguageFrontend)lang$iv).locationOf(ctx)), format$iv};
                    String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
                    log$iv.error(string4, Arrays.copyOf(arguments$iv, arguments$iv.length));
                }
            }
            if (!Intrinsics.areEqual(toHandle, this.typeOfT) && (this.typeOfT == null || this.typeOfT.isAssignableFrom(toHandle))) continue;
        }
        if (handler != null) {
            s = (Node)handler.handle(ctx);
            if (s != null) {
                ((LanguageFrontend)this.frontend).setComment((Node)s, ctx);
            }
            ret = s;
        } else {
            s = Util.INSTANCE;
            lang$iv = this.frontend;
            log$iv = log;
            format$iv = "Parsing of type " + ctx.getClass() + " is not supported (yet)";
            arguments$iv = new Object[]{};
            $i$f$errorWithFileLocation = false;
            string = "%s: %s";
            objectArray = new Object[]{PhysicalLocation.Companion.locationLink(((LanguageFrontend)lang$iv).locationOf(ctx)), format$iv};
            String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
            log$iv.error(string5, Arrays.copyOf(arguments$iv, arguments$iv.length));
            ret = (Node)this.configConstructor.get();
            if (ret instanceof ProblemNode) {
                problem = ret;
                ProblemNode problemNode = (ProblemNode)problem;
                log$iv = "Parsing of type " + ctx.getClass() + " is not supported (yet)";
                format$iv = new Object[]{};
                String string6 = String.format((String)log$iv, Arrays.copyOf(format$iv, ((Object[])format$iv).length));
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(format, *args)");
                problemNode.setProblem(string6);
            }
        }
        if (ret == null) {
            problem = Util.INSTANCE;
            lang$iv = this.frontend;
            log$iv = log;
            format$iv = "Parsing of type " + ctx.getClass() + " did not produce a proper CPG node";
            arguments$iv = new Object[]{};
            $i$f$errorWithFileLocation = false;
            string = "%s: %s";
            objectArray = new Object[]{PhysicalLocation.Companion.locationLink(((LanguageFrontend)lang$iv).locationOf(ctx)), format$iv};
            String string7 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(format, *args)");
            log$iv.error(string7, Arrays.copyOf(arguments$iv, arguments$iv.length));
            ret = (Node)this.configConstructor.get();
        }
        if (ret != null) {
            ((ProcessedListener)this.frontend).process(ctx, (Node)ret);
            this.lastNode = ret;
        }
        return (ResultNode)ret;
    }

    private final Class<?> retrieveTypeParameter() {
        Class<?> clazz = this.getClass();
        while (clazz.getSuperclass() != null && !Intrinsics.areEqual(clazz.getSuperclass(), Handler.class)) {
            Intrinsics.checkNotNullExpressionValue(clazz.getSuperclass(), (String)"getSuperclass(...)");
        }
        Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getActualTypeArguments()[1];
            Intrinsics.checkNotNull((Object)rawType);
            return this.getBaseClass(rawType);
        }
        log.error("Could not determine generic type of raw AST node in handler");
        return null;
    }

    private final Class<?> getBaseClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            Type type2 = ((ParameterizedType)type).getRawType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getRawType(...)");
            return this.getBaseClass(type2);
        }
        return null;
    }

    @NotNull
    protected static final Logger getLog() {
        return Companion.getLog();
    }

    static {
        Logger logger = LoggerFactory.getLogger(Handler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/Handler$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog$annotations", "getLog", "()Lorg/slf4j/Logger;", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLog() {
            return log;
        }

        @JvmStatic
        protected static /* synthetic */ void getLog$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

