/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.TypeManager;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.DeclarationBuilderKt;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TypedefDeclaration;
import de.fraunhofer.aisec.cpg.graph.scopes.Scope;
import de.fraunhofer.aisec.cpg.graph.scopes.TemplateScope;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.ParameterizedType;
import de.fraunhofer.aisec.cpg.graph.types.SecondOrderType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 22\u00020\u0001:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\fJ$\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001cJ&\u0010\u001d\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030 2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0016\u001a\u00020\u0010J\u001a\u0010$\u001a\u0004\u0018\u00010\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010%\u001a\u00020\u001aJ\u001a\u0010$\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u001aH\u0002J\"\u0010&\u001a\u0002H'\"\n\b\u0000\u0010'\u0018\u0001*\u00020\u00052\u0006\u0010(\u001a\u0002H'H\u0086\b\u00a2\u0006\u0002\u0010)J\u0016\u0010*\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010+\u001a\u00020,J\u001a\u0010-\u001a\u0004\u0018\u00010\f2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010%\u001a\u00020\u001aJ\u000e\u00100\u001a\u0002012\u0006\u0010%\u001a\u00020\u001aR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00110\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lde/fraunhofer/aisec/cpg/TypeManager;", "", "()V", "firstOrderTypes", "", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "getFirstOrderTypes", "()Ljava/util/Set;", "recordToTypeParameters", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "", "Lde/fraunhofer/aisec/cpg/graph/types/ParameterizedType;", "secondOrderTypes", "getSecondOrderTypes", "templateToTypeParameters", "Lde/fraunhofer/aisec/cpg/graph/declarations/TemplateDeclaration;", "", "addTypeParameter", "", "recordDeclaration", "typeParameters", "templateDeclaration", "typeParameter", "createOrGetTypeParameter", "typeName", "", "language", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "createTypeAlias", "Lde/fraunhofer/aisec/cpg/graph/declarations/Declaration;", "frontend", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "target", "alias", "getAllParameterizedType", "getTypeParameter", "name", "registerType", "T", "t", "(Lde/fraunhofer/aisec/cpg/graph/types/Type;)Lde/fraunhofer/aisec/cpg/graph/types/Type;", "resolvePossibleTypedef", "scopeManager", "Lde/fraunhofer/aisec/cpg/ScopeManager;", "searchTemplateScopeForDefinedParameterizedTypes", "scope", "Lde/fraunhofer/aisec/cpg/graph/scopes/Scope;", "typeExists", "", "Companion", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nTypeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeManager.kt\nde/fraunhofer/aisec/cpg/TypeManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,419:1\n223#2,2:420\n223#2,2:422\n*S KotlinDebug\n*F\n+ 1 TypeManager.kt\nde/fraunhofer/aisec/cpg/TypeManager\n*L\n205#1:420,2\n219#1:422,2\n*E\n"})
public final class TypeManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<RecordDeclaration, List<ParameterizedType>> recordToTypeParameters = new ConcurrentHashMap();
    @NotNull
    private final Map<TemplateDeclaration, List<ParameterizedType>> templateToTypeParameters = new ConcurrentHashMap();
    @NotNull
    private final Set<Type> firstOrderTypes;
    @NotNull
    private final Set<Type> secondOrderTypes;
    @NotNull
    private static final Logger log;

    public TypeManager() {
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        this.firstOrderTypes = keySetView;
        ConcurrentHashMap.KeySetView keySetView2 = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView2, (String)"newKeySet(...)");
        this.secondOrderTypes = keySetView2;
    }

    @NotNull
    public final Set<Type> getFirstOrderTypes() {
        return this.firstOrderTypes;
    }

    @NotNull
    public final Set<Type> getSecondOrderTypes() {
        return this.secondOrderTypes;
    }

    @Nullable
    public final ParameterizedType getTypeParameter(@Nullable RecordDeclaration recordDeclaration, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (this.recordToTypeParameters.containsKey(recordDeclaration)) {
            List list2 = this.recordToTypeParameters.get(recordDeclaration);
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            for (ParameterizedType parameterizedType : list2) {
                if (!Intrinsics.areEqual((Object)parameterizedType.getName().toString(), (Object)name2)) continue;
                return parameterizedType;
            }
        }
        return null;
    }

    public final void addTypeParameter(@NotNull RecordDeclaration recordDeclaration, @NotNull List<ParameterizedType> typeParameters) {
        Intrinsics.checkNotNullParameter((Object)recordDeclaration, (String)"recordDeclaration");
        Intrinsics.checkNotNullParameter(typeParameters, (String)"typeParameters");
        this.recordToTypeParameters.put(recordDeclaration, typeParameters);
    }

    private final ParameterizedType getTypeParameter(TemplateDeclaration templateDeclaration, String name2) {
        if (this.templateToTypeParameters.containsKey(templateDeclaration)) {
            List list2 = this.templateToTypeParameters.get(templateDeclaration);
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            for (ParameterizedType parameterizedType : list2) {
                if (!Intrinsics.areEqual((Object)parameterizedType.getName().toString(), (Object)name2)) continue;
                return parameterizedType;
            }
        }
        return null;
    }

    @NotNull
    public final List<ParameterizedType> getAllParameterizedType(@NotNull TemplateDeclaration templateDeclaration) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)templateDeclaration, (String)"templateDeclaration");
        if (this.templateToTypeParameters.containsKey(templateDeclaration)) {
            list2 = this.templateToTypeParameters.get(templateDeclaration);
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
        } else {
            list2 = new ArrayList();
        }
        return list2;
    }

    @Nullable
    public final ParameterizedType searchTemplateScopeForDefinedParameterizedTypes(@Nullable Scope scope, @NotNull String name2) {
        ParameterizedType parameterizedType;
        Node node;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (scope instanceof TemplateScope && (node = ((TemplateScope)scope).getAstNode()) instanceof TemplateDeclaration && (parameterizedType = this.getTypeParameter((TemplateDeclaration)node, name2)) != null) {
            return parameterizedType;
        }
        Scope scope2 = scope;
        Intrinsics.checkNotNull((Object)scope2);
        return scope2.getParent() != null ? this.searchTemplateScopeForDefinedParameterizedTypes(scope.getParent(), name2) : null;
    }

    public final void addTypeParameter(@NotNull TemplateDeclaration templateDeclaration, @NotNull ParameterizedType typeParameter) {
        Intrinsics.checkNotNullParameter((Object)templateDeclaration, (String)"templateDeclaration");
        Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
        List list2 = this.templateToTypeParameters.computeIfAbsent(templateDeclaration, arg_0 -> TypeManager.addTypeParameter$lambda$0(addTypeParameter.parameters.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"computeIfAbsent(...)");
        List parameters2 = list2;
        ((Collection)parameters2).add(typeParameter);
    }

    @NotNull
    public final ParameterizedType createOrGetTypeParameter(@NotNull TemplateDeclaration templateDeclaration, @NotNull String typeName, @Nullable Language<?> language) {
        Intrinsics.checkNotNullParameter((Object)templateDeclaration, (String)"templateDeclaration");
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        ParameterizedType parameterizedType = this.getTypeParameter(templateDeclaration, typeName);
        if (parameterizedType == null) {
            parameterizedType = new ParameterizedType(typeName, language);
            this.addTypeParameter(templateDeclaration, parameterizedType);
        }
        return parameterizedType;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final /* synthetic */ <T extends Type> T registerType(T t) {
        Object element$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter(t, (String)"t");
        boolean $i$f$registerType = false;
        if (t instanceof ParameterizedType) {
            return t;
        }
        if (!t.isFirstOrderType()) {
            if (!(t instanceof SecondOrderType)) return t;
            if (this.getSecondOrderTypes().add(t)) {
                Companion.getLog().trace("Registering unique second order type {}", (Object)t.getName());
                return t;
            }
        } else {
            Object element$iv2;
            boolean bl2;
            if (this.getFirstOrderTypes().add(t)) {
                Object object;
                Companion.getLog().trace("Registering unique first order type {}{}", (Object)t.getName(), ((object = t instanceof ObjectType ? (ObjectType)t : null) != null && (object = ((ObjectType)object).getGenerics()) != null ? !((Collection)object).isEmpty() : false) ? " with generics " + CollectionsKt.joinToString$default((Iterable)((ObjectType)t).getGenerics(), (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)registerType.2.INSTANCE, (int)24, null) : "");
                return t;
            }
            Iterable $this$first$iv = this.getFirstOrderTypes();
            boolean $i$f$first = false;
            Iterator iterator = $this$first$iv.iterator();
            do {
                if (!iterator.hasNext()) throw new NoSuchElementException("Collection contains no element matching the predicate.");
                element$iv2 = iterator.next();
                Type it = (Type)element$iv2;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)it, t)) {
                    Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                    if (it instanceof Type) {
                        bl2 = true;
                        continue;
                    }
                }
                bl2 = false;
            } while (!bl2);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return (T)((Type)element$iv2);
        }
        Iterable $this$first$iv = this.getSecondOrderTypes();
        boolean $i$f$first = false;
        Iterator iterator = $this$first$iv.iterator();
        do {
            if (!iterator.hasNext()) throw new NoSuchElementException("Collection contains no element matching the predicate.");
            element$iv = iterator.next();
            Type it = (Type)element$iv;
            boolean bl4 = false;
            if (Intrinsics.areEqual((Object)it, t)) {
                Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                if (it instanceof Type) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)((Type)element$iv);
    }

    public final boolean typeExists(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.firstOrderTypes.stream().anyMatch(arg_0 -> TypeManager.typeExists$lambda$3((Function1)new Function1<Type, Boolean>(name2){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Type type) {
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                return Intrinsics.areEqual((Object)type.getRoot().getName().toString(), (Object)this.$name);
            }
        }, arg_0));
    }

    @NotNull
    public final Declaration createTypeAlias(@NotNull LanguageFrontend<?, ?> frontend, @NotNull Type target, @NotNull Type alias) {
        Intrinsics.checkNotNullParameter(frontend, (String)"frontend");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        TypedefDeclaration typedef = DeclarationBuilderKt.newTypedefDeclaration$default(frontend, target, alias, null, 4, null);
        frontend.getScopeManager().addTypedef(typedef);
        return typedef;
    }

    @NotNull
    public final Type resolvePossibleTypedef(@NotNull Type alias, @NotNull ScopeManager scopeManager) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter((Object)scopeManager, (String)"scopeManager");
        Type finalToCheck = alias.getRoot();
        Type applicable = scopeManager.typedefFor(finalToCheck);
        Type type = applicable;
        if (type == null) {
            type = alias;
        }
        return type;
    }

    private static final List addTypeParameter$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final boolean typeExists$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Logger logger = LoggerFactory.getLogger(TypeManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/fraunhofer/aisec/cpg/TypeManager$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

