/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.TranslationContext;
import de.fraunhofer.aisec.cpg.TranslationManager;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.TypeManager;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.SupportsParallelParsing;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.graph.Component;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.ParameterizedType;
import de.fraunhofer.aisec.cpg.graph.types.SecondOrderType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.helpers.Benchmark;
import de.fraunhofer.aisec.cpg.helpers.MeasurementHolder;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.PassKt;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u0000 *2\u00020\u0001:\u0002)*B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\b\u0010\u0011\u001a\u00020\u0010H\u0002J\"\u0010\u0012\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J@\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00102\u0014\u0010\u001a\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00130\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\u000e\u0010\u001d\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013H\u0002J\u0006\u0010\u0007\u001a\u00020\u001eJ*\u0010\u001f\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J<\u0010\"\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00130#2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00162\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0&H\u0002J<\u0010'\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00130#2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0&H\u0002J&\u0010(\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00130#2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006+"}, d2={"Lde/fraunhofer/aisec/cpg/TranslationManager;", "", "config", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "(Lde/fraunhofer/aisec/cpg/TranslationConfiguration;)V", "getConfig", "()Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "isCancelled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "language", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "Ljava/io/File;", "getLanguage", "(Ljava/io/File;)Lde/fraunhofer/aisec/cpg/frontends/Language;", "analyze", "Ljava/util/concurrent/CompletableFuture;", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "analyzeNonAsync", "getFrontend", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "file", "ctx", "Lde/fraunhofer/aisec/cpg/TranslationContext;", "handleCompletion", "", "result", "usedFrontends", "", "sourceLocation", "f", "", "parse", "component", "Lde/fraunhofer/aisec/cpg/graph/Component;", "parseParallel", "", "globalCtx", "sourceLocations", "", "parseSequentially", "runFrontends", "Builder", "Companion", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nTranslationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranslationManager.kt\nde/fraunhofer/aisec/cpg/TranslationManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 TypeManager.kt\nde/fraunhofer/aisec/cpg/TypeManager\n*L\n1#1,419:1\n1855#2,2:420\n1360#2:422\n1446#2,2:423\n288#2,2:426\n1448#2,3:428\n1855#2,2:431\n1549#2:433\n1620#2,3:434\n1855#2:438\n223#2,2:447\n1856#2:468\n288#2,2:469\n20#3:425\n1#4:437\n198#5,8:439\n207#5,19:449\n*S KotlinDebug\n*F\n+ 1 TranslationManager.kt\nde/fraunhofer/aisec/cpg/TranslationManager\n*L\n114#1:420,2\n151#1:422\n151#1:423,2\n165#1:426,2\n151#1:428,3\n184#1:431,2\n289#1:433\n289#1:434,3\n369#1:438\n369#1:447,2\n369#1:468\n394#1:469,2\n165#1:425\n369#1:439,8\n369#1:449,19\n*E\n"})
public final class TranslationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TranslationConfiguration config;
    @NotNull
    private final AtomicBoolean isCancelled;
    private static final Logger log = LoggerFactory.getLogger(TranslationManager.class);

    private TranslationManager(TranslationConfiguration config) {
        this.config = config;
        this.isCancelled = new AtomicBoolean(false);
    }

    @NotNull
    public final TranslationConfiguration getConfig() {
        return this.config;
    }

    @NotNull
    public final CompletableFuture<TranslationResult> analyze() {
        CompletableFuture<TranslationResult> completableFuture = CompletableFuture.supplyAsync(() -> TranslationManager.analyze$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TranslationResult analyzeNonAsync() {
        Set<LanguageFrontend<?, ?>> executedFrontends = SetsKt.emptySet();
        TranslationContext ctx = new TranslationContext(this.config, new ScopeManager(), new TypeManager());
        TranslationResult result = new TranslationResult(this, ctx);
        Benchmark outerBench = new Benchmark(TranslationManager.class, "Translation into full graph", false, result);
        try {
            Benchmark bench = new Benchmark(this.getClass(), "Executing Language Frontend", false, result);
            executedFrontends = this.runFrontends(ctx, result);
            MeasurementHolder.addMeasurement$default(bench, null, null, 3, null);
            if (this.config.getUseParallelPasses()) {
                for (List<Object> list2 : this.config.getRegisteredPasses()) {
                    PassKt.executePassesInParallel(list2, ctx, result, (Collection)executedFrontends);
                    if (!result.isCancelled()) continue;
                    log.warn("Analysis interrupted, stopping Pass evaluation");
                }
            } else {
                for (KClass kClass : CollectionsKt.flatten((Iterable)this.config.getRegisteredPasses())) {
                    PassKt.executePass((KClass<? extends Pass<? extends Node>>)kClass, ctx, result, (Collection)executedFrontends);
                    if (!result.isCancelled()) continue;
                    log.warn("Analysis interrupted, stopping Pass evaluation");
                }
            }
        }
        catch (TranslationException ex) {
            throw new CompletionException(ex);
        }
        finally {
            MeasurementHolder.addMeasurement$default(outerBench, null, null, 3, null);
            if (!this.config.getDisableCleanup()) {
                log.debug("Cleaning up {} Frontends", (Object)executedFrontends.size());
                Iterable $this$forEach$iv = executedFrontends;
                boolean bl = false;
                for (Object element$iv : $this$forEach$iv) {
                    LanguageFrontend it = (LanguageFrontend)element$iv;
                    boolean bl2 = false;
                    it.cleanup();
                }
            }
        }
        return result;
    }

    public final boolean isCancelled() {
        return this.isCancelled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Set<LanguageFrontend<?, ?>> runFrontends(TranslationContext ctx, TranslationResult result) throws TranslationException {
        usedFrontends = new LinkedHashSet<E>();
        for (String sc : ctx.getConfig().getSoftwareComponents().keySet()) {
            component = new Component();
            component.setName(new Name(sc, null, null, 6, null));
            result.addComponent(component);
            v0 = ctx.getConfig().getSoftwareComponents().get(sc);
            if (v0 == null) {
                v0 = CollectionsKt.emptyList();
            }
            sourceLocations = v0;
            useParallelFrontends = false;
            useParallelFrontends = ctx.getConfig().getUseParallelFrontends();
            $this$flatMap$iv = sourceLocations;
            $i$f$flatMap = false;
            var12_13 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$flatMapTo = false;
            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                block20: {
                    block17: {
                        block19: {
                            file = (File)element$iv$iv;
                            $i$a$-flatMap-TranslationManager$runFrontends$list$1 = false;
                            if (!file.isDirectory()) break block19;
                            v1 = files = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)file).onEnter((Function1)runFrontends.list.1.files.1.INSTANCE)), (Function1)runFrontends.list.1.files.2.INSTANCE));
                            break block20;
                        }
                        v2 = this.getLanguage(file);
                        frontendClass = v2 != null ? v2.getFrontend() : null;
                        var20_25 = this.getLanguage(file);
                        if (var20_25 == null || (var21_27 = var20_25.getFrontend()) == null) ** GOTO lbl-1000
                        var22_28 = (KAnnotatedElement)var21_27;
                        $i$f$findAnnotation = false;
                        $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                        $i$f$firstOrNull = false;
                        for (T element$iv$iv : $this$firstOrNull$iv$iv) {
                            it$iv = (Annotation)element$iv$iv;
                            $i$a$-firstOrNull-KAnnotatedElements$findAnnotation$1$iv = false;
                            if (!(it$iv instanceof SupportsParallelParsing)) continue;
                            v3 = element$iv$iv;
                            break block17;
                        }
                        v3 = null;
                    }
                    if ((var30_36 = (SupportsParallelParsing)((Annotation)v3)) != null) {
                        v4 = var30_36.supported();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = supportsParallelParsing = true;
                    }
                    if (useParallelFrontends && !supportsParallelParsing) {
                        v5 = frontendClass;
                        TranslationManager.log.warn("Parallel frontends are not yet supported for the language frontend " + (v5 != null ? v5.getSimpleName() : null));
                        useParallelFrontends = false;
                    }
                    v1 = CollectionsKt.listOf((Object)file);
                }
                list$iv$iv = v1;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
            if (ctx.getConfig().getUseUnityBuild()) {
                tmpFile = Files.createTempFile("compile", ".cpp", new FileAttribute[0]).toFile();
                tmpFile.deleteOnExit();
                var11_12 = new PrintWriter(tmpFile);
                var12_13 = null;
                try {
                    writer = (PrintWriter)var11_12;
                    $i$a$-use-TranslationManager$runFrontends$1 = false;
                    $this$forEach$iv = list;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (File)element$iv;
                        $i$a$-forEach-TranslationManager$runFrontends$1$1 = false;
                        var21_27 = new String[]{"c", "cpp", "cc", "cxx"};
                        cxxExtensions = CollectionsKt.listOf((Object[])var21_27);
                        if (!cxxExtensions.contains(FilesKt.getExtension((File)it))) continue;
                        if (ctx.getConfig().getTopLevel() != null) {
                            topLevel = ctx.getConfig().getTopLevel().toPath();
                            writer.write(StringsKt.trimIndent((String)("\n#include \"" + topLevel.relativize(it.toPath()) + "\"\n\n")));
                            continue;
                        }
                        writer.write(StringsKt.trimIndent((String)("\n#include \"" + it.getAbsolutePath() + "\"\n\n")));
                    }
                    var13_14 = Unit.INSTANCE;
                }
                catch (Throwable var13_15) {
                    var12_13 = var13_15;
                    throw var13_15;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var11_12, (Throwable)var12_13);
                }
                sourceLocations = CollectionsKt.listOf((Object)tmpFile);
                if (ctx.getConfig().getCompilationDatabase() != null) {
                    v6 = ctx.getConfig().getCompilationDatabase();
                    Intrinsics.checkNotNull((Object)tmpFile);
                    v6.addIncludePath(tmpFile, ctx.getConfig().getCompilationDatabase().getAllIncludePaths());
                }
            } else {
                sourceLocations = list;
            }
            usedFrontends.addAll((Collection)(useParallelFrontends != false ? this.parseParallel(component, result, ctx, sourceLocations) : this.parseSequentially(component, result, ctx, sourceLocations)));
        }
        return usedFrontends;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<LanguageFrontend<?, ?>> parseParallel(Component component, TranslationResult result, TranslationContext globalCtx, Collection<? extends File> sourceLocations) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Set usedFrontends = new LinkedHashSet();
        log.info("Parallel parsing started");
        List futures2 = new ArrayList();
        List parallelContexts = new ArrayList();
        Map futureToFile = new IdentityHashMap();
        for (File file : sourceLocations) {
            TranslationContext ctx = new TranslationContext(globalCtx.getConfig(), new ScopeManager(), globalCtx.getTypeManager());
            parallelContexts.add(ctx);
            CompletableFuture<LanguageFrontend> future = CompletableFuture.supplyAsync(() -> TranslationManager.parseParallel$lambda$5(this, component, ctx, file));
            Intrinsics.checkNotNull(future);
            futures2.add(future);
            futureToFile.put(future, file);
        }
        for (CompletableFuture completableFuture : futures2) {
            try {
                LanguageFrontend f = (LanguageFrontend)completableFuture.get();
                if (f == null) continue;
                this.handleCompletion(result, usedFrontends, (File)futureToFile.get(completableFuture), f);
            }
            catch (InterruptedException e) {
                log.error("Error parsing " + futureToFile.get(completableFuture), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                log.error("Error parsing " + futureToFile.get(completableFuture), (Throwable)e);
            }
        }
        Iterable iterable = parallelContexts;
        ScopeManager scopeManager = globalCtx.getScopeManager();
        boolean bl = false;
        void e = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TranslationContext translationContext = (TranslationContext)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getScopeManager());
        }
        scopeManager.mergeFrom((List)destination$iv$iv);
        log.info("Parallel parsing completed");
        return usedFrontends;
    }

    private final Set<LanguageFrontend<?, ?>> parseSequentially(Component component, TranslationResult result, TranslationContext ctx, Collection<? extends File> sourceLocations) throws TranslationException {
        Set usedFrontends = new LinkedHashSet();
        for (File file : sourceLocations) {
            LanguageFrontend<?, ?> f = this.parse(component, ctx, file);
            if (f == null) continue;
            this.handleCompletion(result, usedFrontends, file, f);
        }
        return usedFrontends;
    }

    private final void handleCompletion(TranslationResult result, Set<LanguageFrontend<?, ?>> usedFrontends, File sourceLocation, LanguageFrontend<?, ?> f) {
        block0: {
            usedFrontends.add(f);
            Object object = result.getScratch().computeIfAbsent("sourceLocationsToFrontend", arg_0 -> TranslationManager.handleCompletion$lambda$7(handleCompletion.sfToFe.1.INSTANCE, arg_0));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.String>");
            Map sfToFe2 = TypeIntrinsics.asMutableMap((Object)object);
            Object object2 = sourceLocation;
            if (object2 == null || (object2 = ((File)object2).getName()) == null) break block0;
            Object it = object2;
            boolean bl = false;
            Map map = sfToFe2;
            String string = f.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            String string2 = string;
            map.put(it, string2);
        }
    }

    private final LanguageFrontend<?, ?> parse(Component component, TranslationContext ctx, File sourceLocation) throws TranslationException {
        LanguageFrontend<?, ?> frontend;
        block4: {
            log.info("Parsing {}", (Object)sourceLocation.getAbsolutePath());
            frontend = null;
            try {
                frontend = this.getFrontend(sourceLocation, ctx);
                if (frontend == null) {
                    log.error("Found no parser frontend for " + sourceLocation.getName());
                    if (this.config.getFailOnError()) {
                        throw new TranslationException("Found no parser frontend for " + sourceLocation.getName());
                    }
                    return null;
                }
                component.addTranslationUnit(frontend.parse(sourceLocation));
            }
            catch (TranslationException ex) {
                log.error("An error occurred during parsing of " + sourceLocation.getName() + ": " + ex.getMessage());
                if (!this.config.getFailOnError()) break block4;
                throw ex;
            }
        }
        return frontend;
    }

    private final LanguageFrontend<?, ?> getFrontend(File file, TranslationContext ctx) {
        LanguageFrontend<?, ?> languageFrontend;
        Language<?> language = this.getLanguage(file);
        if (language != null) {
            Object obj;
            try {
                Iterable $this$forEach$iv = language.getBuiltInTypes().values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Type it$iv;
                    Object element$iv$iv2;
                    boolean $i$f$first;
                    Iterable $this$first$iv$iv;
                    Type it = (Type)element$iv;
                    boolean bl = false;
                    TypeManager this_$iv = ctx.getTypeManager();
                    boolean $i$f$registerType = false;
                    if (it instanceof ParameterizedType) continue;
                    if (it.isFirstOrderType()) {
                        Object object;
                        if (!this_$iv.getFirstOrderTypes().add(it)) {
                            block13: {
                                $this$first$iv$iv = this_$iv.getFirstOrderTypes();
                                $i$f$first = false;
                                for (Object element$iv$iv2 : $this$first$iv$iv) {
                                    it$iv = (Type)element$iv$iv2;
                                    boolean bl2 = false;
                                    if (!(Intrinsics.areEqual((Object)it$iv, (Object)it) && it$iv instanceof Type)) continue;
                                    break block13;
                                }
                                throw new NoSuchElementException("Collection contains no element matching the predicate.");
                            }
                            Object t = element$iv$iv2;
                            if (t == null) {
                                throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.types.Type");
                            }
                            Type cfr_ignored_0 = (Type)t;
                            continue;
                        }
                        TypeManager.Companion.getLog().trace("Registering unique first order type {}{}", (Object)it.getName(), ((object = it instanceof ObjectType ? (ObjectType)it : null) != null && (object = ((ObjectType)object).getGenerics()) != null ? !((Collection)object).isEmpty() : false) ? " with generics " + CollectionsKt.joinToString$default((Iterable)((ObjectType)it).getGenerics(), (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)TypeManager.registerType.2.INSTANCE, (int)24, null) : "");
                        continue;
                    }
                    if (!(it instanceof SecondOrderType)) continue;
                    if (!this_$iv.getSecondOrderTypes().add(it)) {
                        block14: {
                            $this$first$iv$iv = this_$iv.getSecondOrderTypes();
                            $i$f$first = false;
                            for (Object element$iv$iv2 : $this$first$iv$iv) {
                                it$iv = (Type)element$iv$iv2;
                                boolean bl3 = false;
                                if (!(Intrinsics.areEqual((Object)it$iv, (Object)it) && it$iv instanceof Type)) continue;
                                break block14;
                            }
                            throw new NoSuchElementException("Collection contains no element matching the predicate.");
                        }
                        Object t = element$iv$iv2;
                        if (t == null) {
                            throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.types.Type");
                        }
                        Type cfr_ignored_1 = (Type)t;
                        continue;
                    }
                    TypeManager.Companion.getLog().trace("Registering unique second order type {}", (Object)it.getName());
                }
                obj = language.newFrontend(ctx);
            }
            catch (Exception e) {
                Exception exception = e;
                if (!(((exception instanceof InstantiationException ? true : exception instanceof IllegalAccessException) ? true : exception instanceof InvocationTargetException) ? true : exception instanceof NoSuchMethodException)) {
                    throw e;
                }
                log.error("Could not instantiate language frontend {}", (Object)language.getFrontend().getSimpleName(), (Object)e);
                obj = null;
            }
            languageFrontend = (LanguageFrontend<?, ?>)obj;
        } else {
            languageFrontend = null;
        }
        return languageFrontend;
    }

    private final Language<?> getLanguage(File $this$language) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.config.getLanguages();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Language it = (Language)element$iv;
                boolean bl = false;
                if (!it.handlesFile($this$language)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final TranslationResult analyze$lambda$0(TranslationManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.analyzeNonAsync();
    }

    private static final LanguageFrontend parseParallel$lambda$5(TranslationManager this$0, Component $component, TranslationContext $ctx, File $sourceLocation) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$component, (String)"$component");
        Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
        Intrinsics.checkNotNullParameter((Object)$sourceLocation, (String)"$sourceLocation");
        try {
            return this$0.parse($component, $ctx, $sourceLocation);
        }
        catch (TranslationException e) {
            throw new RuntimeException("Error parsing " + $sourceLocation, e);
        }
    }

    private static final Object handleCompletion$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    public /* synthetic */ TranslationManager(TranslationConfiguration config, DefaultConstructorMarker $constructor_marker) {
        this(config);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lde/fraunhofer/aisec/cpg/TranslationManager$Builder;", "", "()V", "config", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "build", "Lde/fraunhofer/aisec/cpg/TranslationManager;", "cpg-core"})
    public static final class Builder {
        @NotNull
        private TranslationConfiguration config = TranslationConfiguration.Companion.builder().build();

        @NotNull
        public final Builder config(@NotNull TranslationConfiguration config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.config = config;
            return this;
        }

        @NotNull
        public final TranslationManager build() {
            return new TranslationManager(this.config, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/fraunhofer/aisec/cpg/TranslationManager$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "builder", "Lde/fraunhofer/aisec/cpg/TranslationManager$Builder;", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

