/*
 * Copyright (c) 2023, Fraunhofer AISEC. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *                    $$$$$$\  $$$$$$$\   $$$$$$\
 *                   $$  __$$\ $$  __$$\ $$  __$$\
 *                   $$ /  \__|$$ |  $$ |$$ /  \__|
 *                   $$ |      $$$$$$$  |$$ |$$$$\
 *                   $$ |      $$  ____/ $$ |\_$$ |
 *                   $$ |  $$\ $$ |      $$ |  $$ |
 *                   \$$$$$   |$$ |      \$$$$$   |
 *                    \______/ \__|       \______/
 *
 */
package de.fraunhofer.aisec.cpg.graph.types

import de.fraunhofer.aisec.cpg.graph.declarations.TypeParameterDeclaration
import de.fraunhofer.aisec.cpg.passes.TypeResolver

/**
 * The [TypeResolver] needs to be aware of all outgoing edges to types in order to merge equal types
 * to the same node. For the primary type edge, this is achieved through the [HasType] interface. If
 * a node has additional type edges (e.g. [TypeParameterDeclaration.default]) the node must
 * implement the [updateType] method, so that the current type is always replaced with the merged
 * one.
 */
fun interface HasSecondaryTypeEdge {
    fun updateType(typeState: Collection<Type>)
}
