/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg;

import de.fraunhofer.aisec.cpg.TestUtils;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.TranslationManager;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.CompilationDatabase;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.test.AssertionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014H\u0007J8\u0010\f\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014H\u0007J8\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014H\u0007J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\u0006\u0010\u001c\u001a\u00020\u0015J(\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00042\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$J\u001a\u0010%\u001a\u00020 2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)J\u001a\u0010*\u001a\u00020 2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010,J$\u0010.\u001a\u00020 2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010/\u001a\u0004\u0018\u00010,2\b\u00100\u001a\u0004\u0018\u00010,J\u001e\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u000205J,\u00106\u001a\b\u0012\u0004\u0012\u0002H807\"\b\b\u0000\u00108*\u00020,2\f\u00109\u001a\b\u0012\u0004\u0012\u0002H8072\u0006\u0010:\u001a\u00020\u000fJ+\u0010;\u001a\u0002H8\"\b\b\u0000\u00108*\u00020,2\f\u00109\u001a\b\u0012\u0004\u0012\u0002H8072\u0006\u0010:\u001a\u00020\u000f\u00a2\u0006\u0002\u0010<J3\u0010=\u001a\u0002H8\"\n\b\u0000\u00108*\u0004\u0018\u00010,2\f\u00109\u001a\b\u0012\u0004\u0012\u0002H8072\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H80?\u00a2\u0006\u0002\u0010@R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006A"}, d2={"Lde/fraunhofer/aisec/cpg/TestUtils;", "", "()V", "ENFORCE_MEMBER_EXPRESSION", "", "getENFORCE_MEMBER_EXPRESSION", "()Z", "setENFORCE_MEMBER_EXPRESSION", "(Z)V", "ENFORCE_REFERENCES", "getENFORCE_REFERENCES", "setENFORCE_REFERENCES", "analyze", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "fileExtension", "", "topLevel", "Ljava/nio/file/Path;", "usePasses", "configModifier", "Ljava/util/function/Consumer;", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration$Builder;", "files", "", "Ljava/io/File;", "analyzeAndGetFirstTU", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "analyzeWithBuilder", "builder", "analyzeWithCompilationDatabase", "jsonCompilationDatabase", "assertInvokes", "", "call", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/CallExpression;", "func", "Lde/fraunhofer/aisec/cpg/graph/declarations/FunctionDeclaration;", "assertRefersTo", "expression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "b", "Lde/fraunhofer/aisec/cpg/graph/declarations/Declaration;", "assertUsageOf", "usingNode", "Lde/fraunhofer/aisec/cpg/graph/Node;", "usedNode", "assertUsageOfMemberAndBase", "usedBase", "usedMember", "compareLineFromLocationIfExists", "n", "startLine", "toCompare", "", "findByName", "", "S", "nodes", "name", "findByUniqueName", "(Ljava/util/Collection;Ljava/lang/String;)Lde/fraunhofer/aisec/cpg/graph/Node;", "findByUniquePredicate", "predicate", "Ljava/util/function/Predicate;", "(Ljava/util/Collection;Ljava/util/function/Predicate;)Lde/fraunhofer/aisec/cpg/graph/Node;", "cpg-core_testFixtures"})
@SourceDebugExtension(value={"SMAP\nTestUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestUtils.kt\nde/fraunhofer/aisec/cpg/TestUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,302:1\n766#2:303\n857#2,2:304\n766#2:306\n857#2,2:307\n*S KotlinDebug\n*F\n+ 1 TestUtils.kt\nde/fraunhofer/aisec/cpg/TestUtils\n*L\n57#1:303\n57#1:304,2\n76#1:306\n76#1:307,2\n*E\n"})
public final class TestUtils {
    @NotNull
    public static final TestUtils INSTANCE = new TestUtils();
    private static boolean ENFORCE_REFERENCES;
    private static boolean ENFORCE_MEMBER_EXPRESSION;

    private TestUtils() {
    }

    public final boolean getENFORCE_REFERENCES() {
        return ENFORCE_REFERENCES;
    }

    public final void setENFORCE_REFERENCES(boolean bl) {
        ENFORCE_REFERENCES = bl;
    }

    public final boolean getENFORCE_MEMBER_EXPRESSION() {
        return ENFORCE_MEMBER_EXPRESSION;
    }

    public final void setENFORCE_MEMBER_EXPRESSION(boolean bl) {
        ENFORCE_MEMBER_EXPRESSION = bl;
    }

    /*
     * WARNING - void declaration
     */
    public final <S extends Node> S findByUniquePredicate(@NotNull Collection<? extends S> nodes, @NotNull Predicate<S> predicate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Iterable $this$filter$iv = nodes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Node it = (Node)element$iv$iv;
            boolean bl = false;
            if (!predicate.test(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List results = (List)destination$iv$iv;
        AssertionsKt.assertEquals((Object)1, (Object)results.size(), (String)("Expected exactly one node matching the predicate: " + CollectionsKt.joinToString$default((Iterable)results, (CharSequence)",", null, null, (int)0, null, (Function1)findByUniquePredicate.1.INSTANCE, (int)30, null)));
        Node node = (Node)CollectionsKt.firstOrNull((List)results);
        AssertionsKt.assertNotNull$default((Object)node, null, (int)2, null);
        return (S)node;
    }

    @NotNull
    public final <S extends Node> S findByUniqueName(@NotNull Collection<? extends S> nodes, @NotNull String name) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (S)this.findByUniquePredicate(nodes, arg_0 -> TestUtils.findByUniqueName$lambda$1(name, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <S extends Node> Collection<S> findByName(@NotNull Collection<? extends S> nodes, @NotNull String name) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$filter$iv = nodes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Node m = (Node)element$iv$iv;
            boolean bl = false;
            if (!m.getName().lastPartsMatch(name)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmOverloads
    @NotNull
    public final TranslationResult analyze(@Nullable String fileExtension, @NotNull Path topLevel, boolean usePasses, @Nullable Consumer<TranslationConfiguration.Builder> configModifier) throws Exception {
        Intrinsics.checkNotNullParameter((Object)topLevel, (String)"topLevel");
        List files2 = Files.walk(topLevel, Integer.MAX_VALUE, new FileVisitOption[0]).map(arg_0 -> TestUtils.analyze$lambda$3(analyze.files.1.INSTANCE, arg_0)).filter(arg_0 -> TestUtils.analyze$lambda$4(analyze.files.2.INSTANCE, arg_0)).filter(arg_0 -> TestUtils.analyze$lambda$5((Function1)new Function1<File, Boolean>(fileExtension){
            final /* synthetic */ String $fileExtension;
            {
                this.$fileExtension = $fileExtension;
                super(1);
            }

            @NotNull
            public final Boolean invoke(File it) {
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                String string2 = this.$fileExtension;
                Intrinsics.checkNotNull((Object)string2);
                return StringsKt.endsWith$default((String)string, (String)string2, (boolean)false, (int)2, null);
            }
        }, arg_0)).sorted().collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(files2, (String)"files");
        return this.analyze(files2, topLevel, usePasses, configModifier);
    }

    public static /* synthetic */ TranslationResult analyze$default(TestUtils testUtils, String string, Path path, boolean bl, Consumer consumer, int n, Object object) throws Exception {
        if ((n & 8) != 0) {
            consumer = null;
        }
        return testUtils.analyze(string, path, bl, (Consumer<TranslationConfiguration.Builder>)consumer);
    }

    @JvmOverloads
    @NotNull
    public final TranslationResult analyze(@NotNull List<? extends File> files2, @NotNull Path topLevel, boolean usePasses, @Nullable Consumer<TranslationConfiguration.Builder> configModifier) throws Exception {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)topLevel, (String)"topLevel");
        TranslationConfiguration.Builder builder = TranslationConfiguration.Companion.builder().sourceLocations(files2).topLevel(topLevel.toFile()).loadIncludes(true).disableCleanup().debugParser(true).failOnError(true).typeSystemActiveInFrontend(false).useParallelFrontends(true).defaultLanguages();
        if (usePasses) {
            builder.defaultPasses();
        }
        Consumer<TranslationConfiguration.Builder> consumer = configModifier;
        if (consumer != null) {
            consumer.accept(builder);
        }
        TranslationConfiguration config = builder.build();
        TranslationManager analyzer = TranslationManager.Companion.builder().config(config).build();
        Object t = analyzer.analyze().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"analyzer.analyze().get()");
        return (TranslationResult)t;
    }

    public static /* synthetic */ TranslationResult analyze$default(TestUtils testUtils, List list, Path path, boolean bl, Consumer consumer, int n, Object object) throws Exception {
        if ((n & 8) != 0) {
            consumer = null;
        }
        return testUtils.analyze(list, path, bl, (Consumer<TranslationConfiguration.Builder>)consumer);
    }

    @NotNull
    public final List<TranslationUnitDeclaration> analyzeWithBuilder(@NotNull TranslationConfiguration.Builder builder) throws Exception {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        TranslationConfiguration config = builder.build();
        TranslationManager analyzer = TranslationManager.Companion.builder().config(config).build();
        return ((TranslationResult)analyzer.analyze().get()).getTranslationUnits();
    }

    @JvmOverloads
    @NotNull
    public final TranslationUnitDeclaration analyzeAndGetFirstTU(@NotNull List<? extends File> files2, @NotNull Path topLevel, boolean usePasses, @Nullable Consumer<TranslationConfiguration.Builder> configModifier) throws Exception {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)topLevel, (String)"topLevel");
        TranslationResult result = this.analyze(files2, topLevel, usePasses, configModifier);
        return (TranslationUnitDeclaration)CollectionsKt.first((List)result.getTranslationUnits());
    }

    public static /* synthetic */ TranslationUnitDeclaration analyzeAndGetFirstTU$default(TestUtils testUtils, List list, Path path, boolean bl, Consumer consumer, int n, Object object) throws Exception {
        if ((n & 8) != 0) {
            consumer = null;
        }
        return testUtils.analyzeAndGetFirstTU(list, path, bl, consumer);
    }

    @NotNull
    public final TranslationResult analyzeWithCompilationDatabase(@NotNull File jsonCompilationDatabase, boolean usePasses, @Nullable Consumer<TranslationConfiguration.Builder> configModifier) throws Exception {
        Intrinsics.checkNotNullParameter((Object)jsonCompilationDatabase, (String)"jsonCompilationDatabase");
        List list = CollectionsKt.emptyList();
        Path path = jsonCompilationDatabase.getParentFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"jsonCompilationDatabase.parentFile.toPath()");
        return this.analyze(list, path, usePasses, arg_0 -> TestUtils.analyzeWithCompilationDatabase$lambda$6(jsonCompilationDatabase, configModifier, arg_0));
    }

    public static /* synthetic */ TranslationResult analyzeWithCompilationDatabase$default(TestUtils testUtils, File file, boolean bl, Consumer consumer, int n, Object object) throws Exception {
        if ((n & 4) != 0) {
            consumer = null;
        }
        return testUtils.analyzeWithCompilationDatabase(file, bl, consumer);
    }

    public final boolean compareLineFromLocationIfExists(@NotNull Node n, boolean startLine, int toCompare) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        PhysicalLocation physicalLocation = n.getLocation();
        if (physicalLocation == null) {
            return false;
        }
        PhysicalLocation loc = physicalLocation;
        return startLine ? loc.getRegion().startLine == toCompare : loc.getRegion().getEndLine() == toCompare;
    }

    public final void assertRefersTo(@Nullable Expression expression, @Nullable Declaration b) {
        if (!(expression instanceof DeclaredReferenceExpression)) {
            AssertionsKt.fail((String)"not a reference");
            throw new KotlinNothingValueException();
        }
        AssertionsKt.assertEquals$default((Object)b, (Object)((DeclaredReferenceExpression)expression).getRefersTo(), null, (int)4, null);
    }

    public final void assertInvokes(@NotNull CallExpression call, @Nullable FunctionDeclaration func) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        AssertionsKt.assertContains$default((Iterable)call.getInvokes(), (Object)func, null, (int)4, null);
    }

    public final void assertUsageOf(@Nullable Node usingNode, @Nullable Node usedNode) {
        AssertionsKt.assertNotNull$default((Object)usingNode, null, (int)2, null);
        if (!(usingNode instanceof DeclaredReferenceExpression) && !ENFORCE_REFERENCES) {
            AssertionsKt.assertSame$default((Object)usedNode, (Object)usingNode, null, (int)4, null);
        } else {
            DeclaredReferenceExpression reference;
            AssertionsKt.assertTrue$default((boolean)(usingNode instanceof DeclaredReferenceExpression), null, (int)2, null);
            DeclaredReferenceExpression declaredReferenceExpression = reference = usingNode instanceof DeclaredReferenceExpression ? (DeclaredReferenceExpression)usingNode : null;
            AssertionsKt.assertEquals$default((Object)usedNode, (Object)(declaredReferenceExpression != null ? declaredReferenceExpression.getRefersTo() : null), null, (int)4, null);
        }
    }

    public final void assertUsageOfMemberAndBase(@Nullable Node usingNode, @Nullable Node usedBase, @Nullable Node usedMember) {
        AssertionsKt.assertNotNull$default((Object)usingNode, null, (int)2, null);
        if (!(usingNode instanceof MemberExpression) && !ENFORCE_MEMBER_EXPRESSION) {
            this.assertUsageOf(usingNode, usedMember);
        } else {
            AssertionsKt.assertTrue$default((boolean)(usingNode instanceof MemberExpression), null, (int)2, null);
            MemberExpression memberExpression = (MemberExpression)usingNode;
            AssertionsKt.assertNotNull$default((Object)memberExpression, null, (int)2, null);
            Expression base = memberExpression.getBase();
            this.assertUsageOf((Node)base, usedBase);
            this.assertUsageOf((Node)memberExpression.getRefersTo(), usedMember);
        }
    }

    @JvmOverloads
    @NotNull
    public final TranslationResult analyze(@Nullable String fileExtension, @NotNull Path topLevel, boolean usePasses) throws Exception {
        Intrinsics.checkNotNullParameter((Object)topLevel, (String)"topLevel");
        return TestUtils.analyze$default(this, fileExtension, topLevel, usePasses, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final TranslationResult analyze(@NotNull List<? extends File> files2, @NotNull Path topLevel, boolean usePasses) throws Exception {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)topLevel, (String)"topLevel");
        return TestUtils.analyze$default(this, files2, topLevel, usePasses, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final TranslationUnitDeclaration analyzeAndGetFirstTU(@NotNull List<? extends File> files2, @NotNull Path topLevel, boolean usePasses) throws Exception {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)topLevel, (String)"topLevel");
        return TestUtils.analyzeAndGetFirstTU$default(this, files2, topLevel, usePasses, null, 8, null);
    }

    private static final boolean findByUniqueName$lambda$1(String $name, Node m) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        return m.getName().lastPartsMatch($name);
    }

    private static final File analyze$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (File)$tmp0.invoke(p0);
    }

    private static final boolean analyze$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean analyze$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void analyzeWithCompilationDatabase$lambda$6(File $jsonCompilationDatabase, Consumer $configModifier, TranslationConfiguration.Builder it) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)$jsonCompilationDatabase, (String)"$jsonCompilationDatabase");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            CompilationDatabase db = CompilationDatabase.Companion.fromFile($jsonCompilationDatabase);
            if (!((Collection)db).isEmpty()) {
                it.useCompilationDatabase(db);
                Map map = db.getComponents();
                Intrinsics.checkNotNull((Object)map, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.collections.List<java.io.File>>");
                it.softwareComponents(TypeIntrinsics.asMutableMap((Object)map));
                Consumer consumer = $configModifier;
                if (consumer != null) {
                    consumer.accept(it);
                }
            }
            Consumer consumer = $configModifier;
            if (consumer == null) break block2;
            consumer.accept(it);
        }
    }
}

