/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.sarif;

import de.fraunhofer.aisec.cpg.sarif.Region;
import java.net.URI;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhysicalLocation {
    @NotNull
    private final ArtifactLocation artifactLocation;
    @NotNull
    private Region region;

    @NotNull
    public static String locationLink(@Nullable PhysicalLocation location) {
        if (location != null) {
            return location.getArtifactLocation().getUri().getPath() + ":" + location.getRegion().getStartLine() + ":" + location.getRegion().getStartColumn();
        }
        return "unknown";
    }

    public PhysicalLocation(URI uri, @NotNull Region region) {
        this.artifactLocation = new ArtifactLocation(uri);
        this.region = region;
    }

    public void setRegion(@NotNull Region region) {
        this.region = region;
    }

    @NotNull
    public Region getRegion() {
        return this.region;
    }

    @NotNull
    public ArtifactLocation getArtifactLocation() {
        return this.artifactLocation;
    }

    public String toString() {
        return this.artifactLocation + "(" + this.region + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhysicalLocation)) {
            return false;
        }
        PhysicalLocation that = (PhysicalLocation)o;
        return Objects.equals(this.artifactLocation, that.artifactLocation) && Objects.equals(this.region, that.region);
    }

    public int hashCode() {
        return Objects.hash(this.artifactLocation, this.region);
    }

    public static class ArtifactLocation {
        @NotNull
        private final URI uri;

        public ArtifactLocation(@NotNull URI uri) {
            this.uri = uri;
        }

        @NotNull
        public URI getUri() {
            return this.uri;
        }

        public String toString() {
            return this.uri.getPath().substring(this.uri.getPath().lastIndexOf(47) + 1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ArtifactLocation)) {
                return false;
            }
            ArtifactLocation that = (ArtifactLocation)o;
            return Objects.equals(this.uri, that.uri);
        }

        public int hashCode() {
            return Objects.hashCode(this.uri);
        }
    }
}

