/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes.inference;

import de.fraunhofer.aisec.cpg.frontends.HasClasses;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.DeclarationBuilderKt;
import de.fraunhofer.aisec.cpg.graph.DeclarationHolder;
import de.fraunhofer.aisec.cpg.graph.LanguageProvider;
import de.fraunhofer.aisec.cpg.graph.MetadataProvider;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionTemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TypeParamDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.TypeExpression;
import de.fraunhofer.aisec.cpg.graph.types.FunctionPointerType;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.ParameterizedType;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.ReferenceType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.passes.inference.InferenceKt;
import de.fraunhofer.aisec.cpg.passes.inference.IsInferredProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017J<\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00072\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00172\b\u0010 \u001a\u0004\u0018\u00010\u0018J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00172\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017J\u0018\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0018H\u0002J\u000e\u0010+\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u001eJ\"\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u00020\u001eJ\u000e\u00102\u001a\u0002032\u0006\u0010\u001b\u001a\u00020\u001eR\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u001e\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00064"}, d2={"Lde/fraunhofer/aisec/cpg/passes/inference/Inference;", "Lde/fraunhofer/aisec/cpg/graph/LanguageProvider;", "Lde/fraunhofer/aisec/cpg/passes/inference/IsInferredProvider;", "start", "Lde/fraunhofer/aisec/cpg/graph/Node;", "(Lde/fraunhofer/aisec/cpg/graph/Node;)V", "isInferred", "", "()Z", "language", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "getLanguage", "()Lde/fraunhofer/aisec/cpg/frontends/Language;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "getStart", "()Lde/fraunhofer/aisec/cpg/graph/Node;", "createInferredConstructor", "Lde/fraunhofer/aisec/cpg/graph/declarations/ConstructorDeclaration;", "signature", "", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "createInferredFunctionDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/FunctionDeclaration;", "name", "", "code", "", "isStatic", "returnType", "createInferredFunctionTemplate", "Lde/fraunhofer/aisec/cpg/graph/declarations/FunctionTemplateDeclaration;", "call", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/CallExpression;", "createInferredParameters", "Lde/fraunhofer/aisec/cpg/graph/declarations/ParamVariableDeclaration;", "generateParamName", "i", "", "targetType", "inferNonTypeTemplateParameter", "inferRecordDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "type", "currentTU", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "kind", "inferTemplateParameter", "Lde/fraunhofer/aisec/cpg/graph/declarations/TypeParamDeclaration;", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nInference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Inference.kt\nde/fraunhofer/aisec/cpg/passes/inference/Inference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,344:1\n1549#2:345\n1620#2,3:346\n1#3:349\n*S KotlinDebug\n*F\n+ 1 Inference.kt\nde/fraunhofer/aisec/cpg/passes/inference/Inference\n*L\n76#1:345\n76#1:346,3\n*E\n"})
public final class Inference
implements LanguageProvider,
IsInferredProvider {
    @NotNull
    private final Node start;
    @NotNull
    private final Logger log;

    public Inference(@NotNull Node start) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        this.start = start;
        Logger logger = LoggerFactory.getLogger(Inference.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(Inference::class.java)");
        this.log = logger;
    }

    @NotNull
    public final Node getStart() {
        return this.start;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @Override
    @Nullable
    public Language<? extends LanguageFrontend> getLanguage() {
        return this.start.getLanguage();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FunctionDeclaration createInferredFunctionDeclaration(@Nullable CharSequence name2, @Nullable String code, boolean isStatic, @NotNull List<? extends Type> signature2, @Nullable Type returnType) {
        FunctionDeclaration inferred;
        block10: {
            RecordDeclaration declarationHolder;
            block9: {
                FunctionDeclaration functionDeclaration;
                Declaration declaration;
                Collection<Name> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                TranslationUnitDeclaration tu;
                Intrinsics.checkNotNullParameter(signature2, (String)"signature");
                Node node = this.start;
                RecordDeclaration record = node instanceof RecordDeclaration ? (RecordDeclaration)node : null;
                Object object = this.start;
                TranslationUnitDeclaration translationUnitDeclaration = tu = object instanceof TranslationUnitDeclaration ? (TranslationUnitDeclaration)object : null;
                if (record == null && tu == null) {
                    throw new UnsupportedOperationException("Starting inference with the wrong type of start node");
                }
                object = signature2;
                CharSequence charSequence = name2;
                Logger logger = this.log;
                boolean $i$f$map = false;
                void var10_13 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Type type = (Type)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    void v1 = it;
                    collection.add(v1 != null ? v1.getName() : null);
                }
                collection = (List)destination$iv$iv;
                logger.debug("Inferring a new function declaration " + charSequence + " with parameter types " + (List)collection);
                RecordDeclaration recordDeclaration = record;
                boolean bl = recordDeclaration != null ? recordDeclaration.isInferred() : false;
                if (bl && Intrinsics.areEqual((Object)record.getKind(), (Object)"struct") && record.getLanguage() instanceof HasClasses) {
                    record.setKind("class");
                }
                if ((declaration = record) == null) {
                    declaration = tu;
                }
                declarationHolder = declaration;
                List<ParamVariableDeclaration> parameters2 = this.createInferredParameters(signature2);
                if (record != null) {
                    MetadataProvider metadataProvider = this;
                    CharSequence charSequence2 = name2;
                    if (charSequence2 == null) {
                        charSequence2 = "";
                    }
                    functionDeclaration = DeclarationBuilderKt.newMethodDeclaration$default(metadataProvider, charSequence2, code, isStatic, record, null, 16, null);
                } else {
                    MetadataProvider metadataProvider = this;
                    CharSequence charSequence3 = name2;
                    if (charSequence3 == null) {
                        charSequence3 = "";
                    }
                    functionDeclaration = DeclarationBuilderKt.newFunctionDeclaration$default(metadataProvider, charSequence3, code, null, 4, null);
                }
                inferred = functionDeclaration;
                inferred.setParameters(parameters2);
                Type type = returnType;
                if (type != null) {
                    Type it = type;
                    boolean bl2 = false;
                    inferred.setReturnTypes(CollectionsKt.listOf((Object)it));
                }
                inferred.setType(returnType);
                if (!(declarationHolder instanceof RecordDeclaration)) break block9;
                Intrinsics.checkNotNull((Object)inferred, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration");
                declarationHolder.addMethod((MethodDeclaration)inferred);
                if (!isStatic) break block10;
                declarationHolder.getStaticImports().add(inferred);
                break block10;
            }
            RecordDeclaration recordDeclaration = declarationHolder;
            if (recordDeclaration == null) break block10;
            ((DeclarationHolder)recordDeclaration).addDeclaration(inferred);
        }
        return inferred;
    }

    @NotNull
    public final ConstructorDeclaration createInferredConstructor(@NotNull List<? extends Type> signature2) {
        ConstructorDeclaration inferred;
        block0: {
            Intrinsics.checkNotNullParameter(signature2, (String)"signature");
            Node node = this.start;
            inferred = DeclarationBuilderKt.newConstructorDeclaration$default(this, this.start.getName().getLocalName(), "", node instanceof RecordDeclaration ? (RecordDeclaration)node : null, null, 8, null);
            inferred.setParameters(this.createInferredParameters(signature2));
            Node node2 = this.start;
            RecordDeclaration recordDeclaration = node2 instanceof RecordDeclaration ? (RecordDeclaration)node2 : null;
            if (recordDeclaration == null) break block0;
            recordDeclaration.addConstructor(inferred);
        }
        return inferred;
    }

    @NotNull
    public final List<ParamVariableDeclaration> createInferredParameters(@NotNull List<? extends Type> signature2) {
        Intrinsics.checkNotNullParameter(signature2, (String)"signature");
        List params = new ArrayList();
        int n = signature2.size();
        for (int i = 0; i < n; ++i) {
            Type targetType;
            Type type = targetType = signature2.get(i);
            Intrinsics.checkNotNull((Object)type);
            String paramName = this.generateParamName(i, type);
            ParamVariableDeclaration param = DeclarationBuilderKt.newParamVariableDeclaration$default(this, paramName, targetType, false, "", null, 16, null);
            param.setArgumentIndex(i);
            params.add(param);
        }
        return params;
    }

    private final String generateParamName(int i, Type targetType) {
        Deque hierarchy = new ArrayDeque();
        Type currLevel = targetType;
        while (currLevel != null) {
            Type type;
            Type type2 = currLevel;
            if (type2 instanceof FunctionPointerType) {
                hierarchy.push("Fptr");
                type = null;
            } else if (type2 instanceof PointerType) {
                hierarchy.push("Ptr");
                type = ((PointerType)currLevel).getElementType();
            } else if (type2 instanceof ReferenceType) {
                hierarchy.push("Ref");
                type = ((ReferenceType)currLevel).getElementType();
            } else {
                hierarchy.push(currLevel.getTypeName());
                type = null;
            }
            currLevel = type;
        }
        StringBuilder paramName = new StringBuilder();
        while (!hierarchy.isEmpty()) {
            String string;
            String part = (String)hierarchy.pop();
            Intrinsics.checkNotNullExpressionValue((Object)part, (String)"part");
            if (((CharSequence)part).length() == 0) continue;
            if (((CharSequence)paramName).length() > 0) {
                Intrinsics.checkNotNullExpressionValue((Object)part.substring(0, 1), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                String string2 = string.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
                paramName.append(string2);
                if (part.length() < 2) continue;
                String string3 = part.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                paramName.append(string3);
                continue;
            }
            string = part;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string4 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
            paramName.append(string4);
        }
        paramName.append(i);
        String string = paramName.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"paramName.toString()");
        return string;
    }

    @NotNull
    public final ParamVariableDeclaration inferNonTypeTemplateParameter(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Node node = this.start;
        Expression expression = node instanceof Expression ? (Expression)node : null;
        if (expression == null) {
            throw new UnsupportedOperationException("Starting inference with the wrong type of start node");
        }
        Expression expr = expression;
        return DeclarationBuilderKt.newParamVariableDeclaration$default(this, name2, expr.getType(), false, name2, null, 16, null);
    }

    @NotNull
    public final TypeParamDeclaration inferTemplateParameter(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        ParameterizedType parameterizedType = new ParameterizedType(name2, this.getLanguage());
        Node node = this.start;
        TypeManager.getInstance().addTypeParameter(node instanceof FunctionTemplateDeclaration ? (FunctionTemplateDeclaration)node : null, parameterizedType);
        TypeParamDeclaration decl = DeclarationBuilderKt.newTypeParamDeclaration$default(this, name2, name2, null, 4, null);
        decl.setType(parameterizedType);
        return decl;
    }

    @NotNull
    public final FunctionTemplateDeclaration createInferredFunctionTemplate(@NotNull CallExpression call) {
        FunctionDeclaration functionDeclaration;
        TranslationUnitDeclaration tu;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Node node = this.start;
        RecordDeclaration record = node instanceof RecordDeclaration ? (RecordDeclaration)node : null;
        Node node2 = this.start;
        TranslationUnitDeclaration translationUnitDeclaration = tu = node2 instanceof TranslationUnitDeclaration ? (TranslationUnitDeclaration)node2 : null;
        if (record == null && tu == null) {
            throw new UnsupportedOperationException("Starting inference with the wrong type of start node");
        }
        String name2 = call.getName().getLocalName();
        String code = call.getCode();
        FunctionTemplateDeclaration inferred = DeclarationBuilderKt.newFunctionTemplateDeclaration$default(this, name2, code, null, 4, null);
        inferred.setInferred(true);
        if (record != null) {
            record.addDeclaration(inferred);
            functionDeclaration = InferenceKt.inferMethod$default(record, call, false, 2, null);
        } else {
            TranslationUnitDeclaration translationUnitDeclaration2 = tu;
            Intrinsics.checkNotNull((Object)translationUnitDeclaration2);
            translationUnitDeclaration2.addDeclaration(inferred);
            functionDeclaration = InferenceKt.inferFunction$default(tu, call, false, 2, null);
        }
        FunctionDeclaration inferredRealization = functionDeclaration;
        inferred.addRealization(inferredRealization);
        int typeCounter = 0;
        int nonTypeCounter = 0;
        for (Node node3 : call.getTemplateParameters()) {
            if (node3 instanceof TypeExpression) {
                String inferredTypeIdentifier = "T" + typeCounter;
                TypeParamDeclaration typeParamDeclaration = InferenceKt.startInference(inferred).inferTemplateParameter(inferredTypeIdentifier);
                ++typeCounter;
                inferred.addParameter(typeParamDeclaration);
                continue;
            }
            if (!(node3 instanceof Expression)) continue;
            String inferredNonTypeIdentifier = "N" + nonTypeCounter;
            ParamVariableDeclaration paramVariableDeclaration = InferenceKt.startInference(node3).inferNonTypeTemplateParameter(inferredNonTypeIdentifier);
            paramVariableDeclaration.addPrevDFG(node3);
            node3.addNextDFG(paramVariableDeclaration);
            ++nonTypeCounter;
            inferred.addParameter(paramVariableDeclaration);
        }
        return inferred;
    }

    @Nullable
    public final RecordDeclaration inferRecordDeclaration(@NotNull Type type, @NotNull TranslationUnitDeclaration currentTU, @NotNull String kind) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)currentTU, (String)"currentTU");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        if (!(type instanceof ObjectType)) {
            this.log.error("Trying to infer a record declaration of a non-object type. Not sure what to do? Should we change the type?");
            return null;
        }
        this.log.debug("Encountered an unknown record type " + ((ObjectType)type).getTypeName() + " during a call. We are going to infer that record");
        MetadataProvider metadataProvider = currentTU;
        String string = ((ObjectType)type).getTypeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.typeName");
        RecordDeclaration declaration = DeclarationBuilderKt.newRecordDeclaration$default(metadataProvider, string, kind, "", null, 8, null);
        declaration.setInferred(true);
        ((ObjectType)type).setRecordDeclaration(declaration);
        currentTU.addDeclaration(declaration);
        return declaration;
    }

    public static /* synthetic */ RecordDeclaration inferRecordDeclaration$default(Inference inference, Type type, TranslationUnitDeclaration translationUnitDeclaration, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "class";
        }
        return inference.inferRecordDeclaration(type, translationUnitDeclaration, string);
    }

    @Override
    public boolean isInferred() {
        return true;
    }
}

