/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.frontends.HasSuperClasses;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.EnumDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.types.IncompleteType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.Pass;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0004J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0004J\u0010\u0010'\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0004J\u0010\u0010(\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0004J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0004J,\u0010-\u001a\u00020**\u00020.2\u0006\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u000b2\u000e\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0014H\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR&\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00140\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u00062"}, d2={"Lde/fraunhofer/aisec/cpg/passes/SymbolResolverPass;", "Lde/fraunhofer/aisec/cpg/passes/Pass;", "()V", "currentTU", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "getCurrentTU", "()Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "setCurrentTU", "(Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;)V", "enumMap", "", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "Lde/fraunhofer/aisec/cpg/graph/declarations/EnumDeclaration;", "getEnumMap", "()Ljava/util/Map;", "recordMap", "Lde/fraunhofer/aisec/cpg/graph/Name;", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "getRecordMap", "superTypesMap", "", "getSuperTypesMap", "templateList", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/TemplateDeclaration;", "getTemplateList", "()Ljava/util/List;", "walker", "Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$ScopedWalker;", "getWalker", "()Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$ScopedWalker;", "setWalker", "(Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$ScopedWalker;)V", "cleanup", "", "collectSupertypes", "findEnums", "node", "Lde/fraunhofer/aisec/cpg/graph/Node;", "findRecords", "findTemplates", "isSuperclassReference", "", "reference", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/DeclaredReferenceExpression;", "matches", "Lde/fraunhofer/aisec/cpg/graph/declarations/FunctionDeclaration;", "name", "returnType", "signature", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nSymbolResolverPass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymbolResolverPass.kt\nde/fraunhofer/aisec/cpg/passes/SymbolResolverPass\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n442#2:106\n392#2:107\n1238#3,4:108\n*S KotlinDebug\n*F\n+ 1 SymbolResolverPass.kt\nde/fraunhofer/aisec/cpg/passes/SymbolResolverPass\n*L\n86#1:106\n86#1:107\n86#1:108,4\n*E\n"})
public abstract class SymbolResolverPass
extends Pass {
    protected SubgraphWalker.ScopedWalker walker;
    public TranslationUnitDeclaration currentTU;
    @NotNull
    private final Map<Name, RecordDeclaration> recordMap = new LinkedHashMap();
    @NotNull
    private final Map<Type, EnumDeclaration> enumMap = new LinkedHashMap();
    @NotNull
    private final List<TemplateDeclaration> templateList = new ArrayList();
    @NotNull
    private final Map<Name, List<Type>> superTypesMap = new LinkedHashMap();

    @NotNull
    protected final SubgraphWalker.ScopedWalker getWalker() {
        SubgraphWalker.ScopedWalker scopedWalker = this.walker;
        if (scopedWalker != null) {
            return scopedWalker;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"walker");
        return null;
    }

    protected final void setWalker(@NotNull SubgraphWalker.ScopedWalker scopedWalker) {
        Intrinsics.checkNotNullParameter((Object)scopedWalker, (String)"<set-?>");
        this.walker = scopedWalker;
    }

    @NotNull
    public final TranslationUnitDeclaration getCurrentTU() {
        TranslationUnitDeclaration translationUnitDeclaration = this.currentTU;
        if (translationUnitDeclaration != null) {
            return translationUnitDeclaration;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentTU");
        return null;
    }

    public final void setCurrentTU(@NotNull TranslationUnitDeclaration translationUnitDeclaration) {
        Intrinsics.checkNotNullParameter((Object)translationUnitDeclaration, (String)"<set-?>");
        this.currentTU = translationUnitDeclaration;
    }

    @NotNull
    public final Map<Name, RecordDeclaration> getRecordMap() {
        return this.recordMap;
    }

    @NotNull
    protected final Map<Type, EnumDeclaration> getEnumMap() {
        return this.enumMap;
    }

    @NotNull
    protected final List<TemplateDeclaration> getTemplateList() {
        return this.templateList;
    }

    @NotNull
    protected final Map<Name, List<Type>> getSuperTypesMap() {
        return this.superTypesMap;
    }

    protected final void findRecords(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof RecordDeclaration) {
            this.recordMap.putIfAbsent(node.getName(), (RecordDeclaration)node);
        }
    }

    protected final void findEnums(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof EnumDeclaration) {
            Type type = TypeParser.createFrom(node.getName(), node.getLanguage());
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"createFrom(node.name, node.language)");
            Type type2 = type;
            this.enumMap.putIfAbsent(type2, (EnumDeclaration)node);
        }
    }

    protected final void findTemplates(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof TemplateDeclaration) {
            this.templateList.add((TemplateDeclaration)node);
        }
    }

    protected final boolean matches(@NotNull FunctionDeclaration $this$matches, @NotNull Name name2, @NotNull Type returnType, @NotNull List<? extends Type> signature2) {
        Intrinsics.checkNotNullParameter((Object)$this$matches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter(signature2, (String)"signature");
        Type thisReturnType = $this$matches.getReturnTypes().isEmpty() ? (Type)new IncompleteType() : $this$matches.getReturnTypes().get(0);
        return $this$matches.getName().lastPartsMatch(name2) && Intrinsics.areEqual((Object)thisReturnType, (Object)returnType) && $this$matches.hasSignature(signature2);
    }

    /*
     * WARNING - void declaration
     */
    protected final void collectSupertypes() {
        void $this$mapValuesTo$iv$iv;
        Map<Name, RecordDeclaration> $this$mapValues$iv = this.recordMap;
        boolean $i$f$mapValues = false;
        Map<Name, RecordDeclaration> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            RecordDeclaration value = (RecordDeclaration)entry2.getValue();
            List<Type> list2 = value.getSuperTypes();
            map3.put(k, list2);
        }
        Map currSuperTypes = destination$iv$iv;
        this.superTypesMap.putAll(currSuperTypes);
    }

    protected final boolean isSuperclassReference(@NotNull DeclaredReferenceExpression reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Language<? extends LanguageFrontend> language = reference.getLanguage();
        return language instanceof HasSuperClasses && StringsKt.endsWith$default((CharSequence)reference.getName(), (CharSequence)((HasSuperClasses)((Object)language)).getSuperClassKeyword(), (boolean)false, (int)2, null);
    }

    @Override
    public void cleanup() {
        this.superTypesMap.clear();
        this.recordMap.clear();
        this.enumMap.clear();
        this.templateList.clear();
    }
}

