/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.passes.order.DependsOn;
import de.fraunhofer.aisec.cpg.passes.order.ExecuteBefore;
import de.fraunhofer.aisec.cpg.passes.order.ExecuteFirst;
import de.fraunhofer.aisec.cpg.passes.order.ExecuteLast;
import de.fraunhofer.aisec.cpg.passes.order.RequiredFrontend;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 /2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001/B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010$\u001a\u00020%2\u0010\u0010&\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00000\fJ\b\u0010'\u001a\u00020%H&J\u0014\u0010(\u001a\u00020\u00122\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*J\u0016\u0010,\u001a\u00020\u00122\u000e\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0.R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\"\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00000\f0\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\"\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00000\f0\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\"\u0010\"\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00000\f0\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000e\u00a8\u00060"}, d2={"Lde/fraunhofer/aisec/cpg/passes/Pass;", "Ljava/util/function/Consumer;", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "()V", "config", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "getConfig", "()Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "setConfig", "(Lde/fraunhofer/aisec/cpg/TranslationConfiguration;)V", "executeBefore", "", "Ljava/lang/Class;", "getExecuteBefore$cpg_core", "()Ljava/util/Set;", "hardDependencies", "getHardDependencies$cpg_core", "isFirstPass", "", "()Z", "isLastPass", "<set-?>", "", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "scopeManager", "Lde/fraunhofer/aisec/cpg/ScopeManager;", "getScopeManager", "()Lde/fraunhofer/aisec/cpg/ScopeManager;", "setScopeManager", "(Lde/fraunhofer/aisec/cpg/ScopeManager;)V", "softDependencies", "getSoftDependencies$cpg_core", "addSoftDependency", "", "toAdd", "cleanup", "runsWithCurrentFrontend", "usedFrontends", "", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "supportsLanguage", "language", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "Companion", "cpg-core"})
public abstract class Pass
implements Consumer<TranslationResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String name;
    @NotNull
    private final Set<Class<? extends Pass>> softDependencies;
    @NotNull
    private final Set<Class<? extends Pass>> hardDependencies;
    @NotNull
    private final Set<Class<? extends Pass>> executeBefore;
    public ScopeManager scopeManager;
    @Nullable
    private TranslationConfiguration config;
    @NotNull
    private static final Logger log;

    protected Pass() {
        Annotation[] dependencies;
        String string = this.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.javaClass.name");
        this.name = string;
        this.hardDependencies = new HashSet();
        this.softDependencies = new HashSet();
        this.executeBefore = new HashSet();
        Annotation[] annotationArray = this.getClass().getAnnotationsByType(DependsOn.class);
        Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"this.javaClass.getAnnota\u2026pe(DependsOn::class.java)");
        if (!(((Object[])annotationArray).length == 0)) {
            dependencies = (DependsOn[])this.getClass().getAnnotationsByType(DependsOn.class);
            Intrinsics.checkNotNullExpressionValue((Object)dependencies, (String)"dependencies");
            for (Annotation d : dependencies) {
                if (d.softDependency()) {
                    this.softDependencies.add(d.value());
                    continue;
                }
                this.hardDependencies.add(d.value());
            }
        }
        Annotation[] annotationArray2 = this.getClass().getAnnotationsByType(ExecuteBefore.class);
        Intrinsics.checkNotNullExpressionValue((Object)annotationArray2, (String)"this.javaClass.getAnnota\u2026xecuteBefore::class.java)");
        if (!(((Object[])annotationArray2).length == 0)) {
            dependencies = (ExecuteBefore[])this.getClass().getAnnotationsByType(ExecuteBefore.class);
            Intrinsics.checkNotNullExpressionValue((Object)dependencies, (String)"dependencies");
            for (Annotation d : dependencies) {
                this.executeBefore.add(d.other());
            }
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    protected final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final Set<Class<? extends Pass>> getSoftDependencies$cpg_core() {
        return this.softDependencies;
    }

    @NotNull
    public final Set<Class<? extends Pass>> getHardDependencies$cpg_core() {
        return this.hardDependencies;
    }

    @NotNull
    public final Set<Class<? extends Pass>> getExecuteBefore$cpg_core() {
        return this.executeBefore;
    }

    public final void addSoftDependency(@NotNull Class<? extends Pass> toAdd) {
        Intrinsics.checkNotNullParameter(toAdd, (String)"toAdd");
        this.softDependencies.add(toAdd);
    }

    @NotNull
    public final ScopeManager getScopeManager() {
        ScopeManager scopeManager = this.scopeManager;
        if (scopeManager != null) {
            return scopeManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"scopeManager");
        return null;
    }

    public final void setScopeManager(@NotNull ScopeManager scopeManager) {
        Intrinsics.checkNotNullParameter((Object)scopeManager, (String)"<set-?>");
        this.scopeManager = scopeManager;
    }

    @Nullable
    protected final TranslationConfiguration getConfig() {
        return this.config;
    }

    protected final void setConfig(@Nullable TranslationConfiguration translationConfiguration) {
        this.config = translationConfiguration;
    }

    public abstract void cleanup();

    public final boolean supportsLanguage(@NotNull Language<? extends LanguageFrontend> language) {
        Intrinsics.checkNotNullParameter(language, (String)"language");
        return true;
    }

    public final boolean isLastPass() {
        boolean bl;
        try {
            bl = this.getClass().isAnnotationPresent(ExecuteLast.class);
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    public final boolean isFirstPass() {
        boolean bl;
        try {
            bl = this.getClass().isAnnotationPresent(ExecuteFirst.class);
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    public final boolean runsWithCurrentFrontend(@NotNull Collection<? extends LanguageFrontend> usedFrontends) {
        Intrinsics.checkNotNullParameter(usedFrontends, (String)"usedFrontends");
        if (!this.getClass().isAnnotationPresent(RequiredFrontend.class)) {
            return true;
        }
        Class<? extends LanguageFrontend> requiredFrontend = this.getClass().getAnnotation(RequiredFrontend.class).value();
        for (LanguageFrontend languageFrontend : usedFrontends) {
            if (!Intrinsics.areEqual(languageFrontend.getClass(), requiredFrontend)) continue;
            return true;
        }
        return false;
    }

    static {
        Logger logger = LoggerFactory.getLogger(Pass.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(Pass::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/fraunhofer/aisec/cpg/passes/Pass$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

