/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguage;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.CallResolver;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u00a8\u0006\b"}, d2={"handleSpecificSupertype", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "Lde/fraunhofer/aisec/cpg/passes/CallResolver;", "callee", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/MemberExpression;", "curClass", "handleSuperCall", "", "cpg-core"})
public final class JavaCallResolverHelperKt {
    public static final boolean handleSuperCall(@NotNull CallResolver $this$handleSuperCall, @NotNull MemberExpression callee, @NotNull RecordDeclaration curClass) {
        Intrinsics.checkNotNullParameter((Object)$this$handleSuperCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
        Intrinsics.checkNotNullParameter((Object)curClass, (String)"curClass");
        FunctionDeclaration func = $this$handleSuperCall.getScopeManager().getCurrentFunction();
        if (func instanceof MethodDeclaration) {
            DeclaredReferenceExpression declaredReferenceExpression = (DeclaredReferenceExpression)callee.getBase();
            if (declaredReferenceExpression != null) {
                declaredReferenceExpression.setRefersTo(((MethodDeclaration)func).getReceiver());
            }
        }
        RecordDeclaration target = null;
        if (Intrinsics.areEqual((Object)callee.getBase().getName().toString(), (Object)new JavaLanguage().getSuperClassKeyword())) {
            if (!((Collection)curClass.getSuperClasses()).isEmpty()) {
                target = $this$handleSuperCall.getRecordMap().get(curClass.getSuperClasses().get(0).getRoot().getName());
            } else {
                Util.warnWithFileLocation(callee, CallResolver.Companion.getLOGGER(), "super call without direct superclass! Expected java.lang.Object to be present at least!", new Object[0]);
            }
        } else {
            target = JavaCallResolverHelperKt.handleSpecificSupertype($this$handleSuperCall, callee, curClass);
        }
        if (target != null) {
            Type superType = target.toType();
            callee.getBase().setType(superType);
            callee.getBase().updatePossibleSubtypes(CollectionsKt.listOf((Object)superType));
            return true;
        }
        return false;
    }

    @Nullable
    public static final RecordDeclaration handleSpecificSupertype(@NotNull CallResolver $this$handleSpecificSupertype, @NotNull MemberExpression callee, @NotNull RecordDeclaration curClass) {
        Intrinsics.checkNotNullParameter((Object)$this$handleSpecificSupertype, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
        Intrinsics.checkNotNullParameter((Object)curClass, (String)"curClass");
        Name name2 = callee.getBase().getName().getParent();
        if (name2 == null) {
            return null;
        }
        Name baseName = name2;
        if (curClass.getImplementedInterfaces().contains(TypeParser.createFrom(baseName, curClass.getLanguage()))) {
            return $this$handleSpecificSupertype.getRecordMap().get(baseName);
        }
        RecordDeclaration base = $this$handleSpecificSupertype.getRecordMap().get(baseName);
        if (base != null) {
            if (!((Collection)base.getSuperClasses()).isEmpty()) {
                return $this$handleSpecificSupertype.getRecordMap().get(base.getSuperClasses().get(0).getRoot().getName());
            }
            Util.warnWithFileLocation(callee, CallResolver.Companion.getLOGGER(), "super call without direct superclass! Expected java.lang.Object to be present at least!", new Object[0]);
        }
        return null;
    }
}

