/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.HasShortCircuitOperators;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.ProcessedListener;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.StatementHolder;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.IncludeDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.NamespaceDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.scopes.BlockScope;
import de.fraunhofer.aisec.cpg.graph.scopes.FunctionScope;
import de.fraunhofer.aisec.cpg.graph.scopes.LoopScope;
import de.fraunhofer.aisec.cpg.graph.scopes.Scope;
import de.fraunhofer.aisec.cpg.graph.scopes.SwitchScope;
import de.fraunhofer.aisec.cpg.graph.scopes.TryScope;
import de.fraunhofer.aisec.cpg.graph.scopes.ValueDeclarationScope;
import de.fraunhofer.aisec.cpg.graph.statements.AssertStatement;
import de.fraunhofer.aisec.cpg.graph.statements.BreakStatement;
import de.fraunhofer.aisec.cpg.graph.statements.CaseStatement;
import de.fraunhofer.aisec.cpg.graph.statements.CatchClause;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ContinueStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DeclarationStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DefaultStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DoStatement;
import de.fraunhofer.aisec.cpg.graph.statements.EmptyStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ForEachStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ForStatement;
import de.fraunhofer.aisec.cpg.graph.statements.GotoStatement;
import de.fraunhofer.aisec.cpg.graph.statements.IfStatement;
import de.fraunhofer.aisec.cpg.graph.statements.LabelStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.SwitchStatement;
import de.fraunhofer.aisec.cpg.graph.statements.SynchronizedStatement;
import de.fraunhofer.aisec.cpg.graph.statements.TryStatement;
import de.fraunhofer.aisec.cpg.graph.statements.WhileStatement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArrayCreationExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArraySubscriptionExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CastExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CompoundStatementExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConditionalExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeleteExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ExpressionList;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberCallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.NewExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.TypeIdExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.UnaryOperator;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.CallResolver;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.order.DependsOn;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DependsOn(value=CallResolver.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 x2\u00020\u0001:\u0001xB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u001e\u0010\u001a\u001a\u00020\u000f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\b\u0010\u001d\u001a\u00020\u000fH\u0016J\b\u0010\u001e\u001a\u00020\u000fH\u0004J\u0012\u0010\u001f\u001a\u00020\u000f2\b\u0010 \u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u0018\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0004J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020(H\u0004J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020*H\u0004J\u0010\u0010+\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020,H\u0004J\u0010\u0010-\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020.H\u0004J\u0010\u0010/\u001a\u00020\u000f2\u0006\u0010 \u001a\u000200H\u0004J\u0010\u00101\u001a\u00020\u000f2\u0006\u0010 \u001a\u000202H\u0004J\u0010\u00103\u001a\u00020\u000f2\u0006\u0010 \u001a\u000204H\u0004J\u0010\u00105\u001a\u00020\u000f2\u0006\u0010 \u001a\u000206H\u0004J\u0010\u00107\u001a\u00020\u000f2\u0006\u0010 \u001a\u000208H\u0004J\u0010\u00109\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020:H\u0004J\u0010\u0010;\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020<H\u0004J\u0010\u0010=\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020>H\u0004J\u0010\u0010?\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020@H\u0004J\u0010\u0010A\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020BH\u0004J\u0010\u0010C\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0005H\u0004J\u0010\u0010D\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020EH\u0004J\u0010\u0010F\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020GH\u0004J\u0010\u0010H\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020IH\u0004J\u0010\u0010J\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020KH\u0004J\u0010\u0010L\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020MH\u0004J\u0010\u0010N\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020OH\u0004J\u0010\u0010P\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020QH\u0004J\u0010\u0010R\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020SH\u0004J\u0010\u0010T\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020UH\u0004J\u0010\u0010V\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020WH\u0004J\u0010\u0010X\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020YH\u0004J\u0010\u0010Z\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020[H\u0004J\u0010\u0010\\\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020]H\u0004J\u0010\u0010^\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020_H\u0004J\u0010\u0010`\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020aH\u0004J\u0010\u0010b\u001a\u00020\u000f2\u0006\u0010c\u001a\u00020dH\u0004J\u0010\u0010e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020fH\u0004J\u0010\u0010g\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020hH\u0004J\u0010\u0010i\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020jH\u0004J\u0010\u0010k\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020lH\u0004J\u0010\u0010m\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020nH\u0004J\u0010\u0010o\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020pH\u0004J\u0010\u0010q\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020rH\u0004J\u000e\u0010s\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0005J\u0010\u0010t\u001a\u00020\u000f2\u0006\u0010u\u001a\u00020jH\u0002J\u0014\u0010v\u001a\u00020\u000f2\f\u0010w\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u000b\u001a\"\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u000e0\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006y"}, d2={"Lde/fraunhofer/aisec/cpg/passes/EvaluationOrderGraphPass;", "Lde/fraunhofer/aisec/cpg/passes/Pass;", "()V", "currentEOG", "", "Lde/fraunhofer/aisec/cpg/graph/Node;", "currentProperties", "Ljava/util/EnumMap;", "Lde/fraunhofer/aisec/cpg/graph/edge/Properties;", "", "intermediateNodes", "map", "", "Ljava/lang/Class;", "Lkotlin/Function1;", "", "getMap", "()Ljava/util/Map;", "processedListener", "Lde/fraunhofer/aisec/cpg/frontends/ProcessedListener;", "accept", "result", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "addEOGEdge", "prev", "next", "addMultipleIncomingEOGEdges", "prevs", "", "cleanup", "connectCurrentToLoopStart", "createEOG", "node", "doNothing", "exitLoop", "loopStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/Statement;", "loopScope", "Lde/fraunhofer/aisec/cpg/graph/scopes/LoopScope;", "handleArrayCreationExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ArrayCreationExpression;", "handleArraySubscriptionExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ArraySubscriptionExpression;", "handleAssertStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/AssertStatement;", "handleBinaryOperator", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/BinaryOperator;", "handleBreakStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/BreakStatement;", "handleCallExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/CallExpression;", "handleCaseStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/CaseStatement;", "handleCastExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/CastExpression;", "handleCompoundStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/CompoundStatement;", "handleCompoundStatementExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/CompoundStatementExpression;", "handleConditionalExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ConditionalExpression;", "handleConstructExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ConstructExpression;", "handleContinueStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/ContinueStatement;", "handleDeclarationStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/DeclarationStatement;", "handleDefault", "handleDeleteExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/DeleteExpression;", "handleDoStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/DoStatement;", "handleExpressionList", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ExpressionList;", "handleForEachStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/ForEachStatement;", "handleForStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/ForStatement;", "handleFunctionDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/FunctionDeclaration;", "handleGotoStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/GotoStatement;", "handleIfStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/IfStatement;", "handleInitializerListExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/InitializerListExpression;", "handleLabelStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/LabelStatement;", "handleMemberExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/MemberExpression;", "handleNamespaceDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/NamespaceDeclaration;", "handleNewExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/NewExpression;", "handleRecordDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "handleReturnStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/ReturnStatement;", "handleStatementHolder", "statementHolder", "Lde/fraunhofer/aisec/cpg/graph/StatementHolder;", "handleSwitchStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/SwitchStatement;", "handleSynchronizedStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/SynchronizedStatement;", "handleTranslationUnitDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "handleTryStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/TryStatement;", "handleUnaryOperator", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/UnaryOperator;", "handleVariableDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/VariableDeclaration;", "handleWhileStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/WhileStatement;", "pushToEOG", "removeUnreachableEOGEdges", "tu", "setCurrentEOGs", "nodes", "Companion", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nEvaluationOrderGraphPass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EvaluationOrderGraphPass.kt\nde/fraunhofer/aisec/cpg/passes/EvaluationOrderGraphPass\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,981:1\n766#2:982\n857#2,2:983\n766#2:985\n857#2,2:986\n1360#2:988\n1446#2,5:989\n766#2:994\n857#2,2:995\n1855#2,2:997\n766#2:999\n857#2,2:1000\n766#2:1002\n857#2,2:1003\n1855#2,2:1006\n1855#2,2:1008\n1747#2,3:1010\n1360#2:1013\n1446#2,5:1014\n1549#2:1019\n1620#2,3:1020\n1855#2,2:1023\n1855#2,2:1025\n1855#2,2:1027\n1#3:1005\n*S KotlinDebug\n*F\n+ 1 EvaluationOrderGraphPass.kt\nde/fraunhofer/aisec/cpg/passes/EvaluationOrderGraphPass\n*L\n179#1:982\n179#1:983,2\n183#1:985\n183#1:986,2\n192#1:988\n192#1:989,5\n192#1:994\n192#1:995,2\n196#1:997,2\n251#1:999\n251#1:1000,2\n252#1:1002\n252#1:1003,2\n544#1:1006,2\n565#1:1008,2\n569#1:1010,3\n576#1:1013\n576#1:1014,5\n715#1:1019\n715#1:1020,3\n716#1:1023,2\n729#1:1025,2\n752#1:1027,2\n*E\n"})
public class EvaluationOrderGraphPass
extends Pass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Class<? extends Node>, Function1<Node, Unit>> map = new LinkedHashMap();
    @NotNull
    private List<Node> currentEOG = new ArrayList();
    @NotNull
    private final EnumMap<Properties, Object> currentProperties = new EnumMap(Properties.class);
    @NotNull
    private final ProcessedListener processedListener = new ProcessedListener();
    @NotNull
    private final List<Node> intermediateNodes = new ArrayList();
    private static final Logger LOGGER = LoggerFactory.getLogger(EvaluationOrderGraphPass.class);

    public EvaluationOrderGraphPass() {
        this.map.put(IncludeDeclaration.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.doNothing(it);
            }
        });
        this.map.put(TranslationUnitDeclaration.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleTranslationUnitDeclaration((TranslationUnitDeclaration)it);
            }
        });
        this.map.put(NamespaceDeclaration.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleNamespaceDeclaration((NamespaceDeclaration)it);
            }
        });
        this.map.put(RecordDeclaration.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleRecordDeclaration((RecordDeclaration)it);
            }
        });
        this.map.put(FunctionDeclaration.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleFunctionDeclaration((FunctionDeclaration)it);
            }
        });
        this.map.put(VariableDeclaration.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleVariableDeclaration((VariableDeclaration)it);
            }
        });
        this.map.put(CallExpression.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleCallExpression((CallExpression)it);
            }
        });
        this.map.put(MemberExpression.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleMemberExpression((MemberExpression)it);
            }
        });
        this.map.put(ArraySubscriptionExpression.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleArraySubscriptionExpression((ArraySubscriptionExpression)it);
            }
        });
        this.map.put(ArrayCreationExpression.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleArrayCreationExpression((ArrayCreationExpression)it);
            }
        });
        this.map.put(DeclarationStatement.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleDeclarationStatement((DeclarationStatement)it);
            }
        });
        this.map.put(ReturnStatement.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleReturnStatement((ReturnStatement)it);
            }
        });
        this.map.put(BinaryOperator.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleBinaryOperator((BinaryOperator)it);
            }
        });
        this.map.put(UnaryOperator.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleUnaryOperator((UnaryOperator)it);
            }
        });
        this.map.put(CompoundStatement.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleCompoundStatement((CompoundStatement)it);
            }
        });
        this.map.put(CompoundStatementExpression.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleCompoundStatementExpression((CompoundStatementExpression)it);
            }
        });
        this.map.put(IfStatement.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleIfStatement((IfStatement)it);
            }
        });
        this.map.put(AssertStatement.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleAssertStatement((AssertStatement)it);
            }
        });
        this.map.put(WhileStatement.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleWhileStatement((WhileStatement)it);
            }
        });
        this.map.put(DoStatement.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleDoStatement((DoStatement)it);
            }
        });
        this.map.put(ForStatement.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleForStatement((ForStatement)it);
            }
        });
        this.map.put(ForEachStatement.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleForEachStatement((ForEachStatement)it);
            }
        });
        this.map.put(TryStatement.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleTryStatement((TryStatement)it);
            }
        });
        this.map.put(ContinueStatement.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleContinueStatement((ContinueStatement)it);
            }
        });
        this.map.put(DeleteExpression.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleDeleteExpression((DeleteExpression)it);
            }
        });
        this.map.put(BreakStatement.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleBreakStatement((BreakStatement)it);
            }
        });
        this.map.put(SwitchStatement.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleSwitchStatement((SwitchStatement)it);
            }
        });
        this.map.put(LabelStatement.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleLabelStatement((LabelStatement)it);
            }
        });
        this.map.put(GotoStatement.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleGotoStatement((GotoStatement)it);
            }
        });
        this.map.put(CaseStatement.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleCaseStatement((CaseStatement)it);
            }
        });
        this.map.put(SynchronizedStatement.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleSynchronizedStatement((SynchronizedStatement)it);
            }
        });
        this.map.put(NewExpression.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleNewExpression((NewExpression)it);
            }
        });
        this.map.put(CastExpression.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleCastExpression((CastExpression)it);
            }
        });
        this.map.put(ExpressionList.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleExpressionList((ExpressionList)it);
            }
        });
        this.map.put(ConditionalExpression.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleConditionalExpression((ConditionalExpression)it);
            }
        });
        this.map.put(InitializerListExpression.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleInitializerListExpression((InitializerListExpression)it);
            }
        });
        this.map.put(ConstructExpression.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleConstructExpression((ConstructExpression)it);
            }
        });
        this.map.put(EmptyStatement.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleDefault((EmptyStatement)it);
            }
        });
        this.map.put(Literal.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleDefault(it);
            }
        });
        this.map.put(DefaultStatement.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleDefault(it);
            }
        });
        this.map.put(TypeIdExpression.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleDefault(it);
            }
        });
        this.map.put(DeclaredReferenceExpression.class, new Function1<Node, Unit>(){

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.handleDefault(it);
            }
        });
    }

    @NotNull
    protected final Map<Class<? extends Node>, Function1<Node, Unit>> getMap() {
        return this.map;
    }

    private final void doNothing(Node node) {
    }

    @Override
    public void cleanup() {
        this.intermediateNodes.clear();
        this.currentEOG.clear();
    }

    @Override
    public void accept(@NotNull TranslationResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.setScopeManager(result.getScopeManager());
        for (TranslationUnitDeclaration tu : result.getTranslationUnits()) {
            this.createEOG(tu);
            this.removeUnreachableEOGEdges(tu);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeUnreachableEOGEdges(TranslationUnitDeclaration tu) {
        Iterable $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2 = SubgraphWalker.INSTANCE.flattenAST(tu);
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Node it = (Node)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !((Collection)it.getPrevEOG()).isEmpty() || !((Collection)it.getNextEOG()).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List eognodes = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        Iterable $i$f$filter22 = eognodes;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Node node = (Node)element$iv$iv;
            boolean bl = false;
            boolean bl3 = node instanceof FunctionDeclaration || node instanceof RecordDeclaration || node instanceof NamespaceDeclaration || node instanceof TranslationUnitDeclaration;
            if (!bl3) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set validStarts = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        while (!((Collection)validStarts).isEmpty()) {
            Node it;
            void $this$flatMapTo$iv$iv;
            eognodes.removeAll(validStarts);
            Iterable $this$flatMap$iv = validStarts;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (Node)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getNextEOG();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv2;
            $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Node)element$iv$iv;
                boolean bl = false;
                if (!eognodes.contains(it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            validStarts = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        }
        for (Node unvisitedNode : eognodes) {
            Iterable $this$forEach$iv = unvisitedNode.getNextEOGEdges();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PropertyEdge next = (PropertyEdge)element$iv;
                boolean bl = false;
                ((Node)next.getEnd()).removePrevEOGEntry(unvisitedNode);
            }
            unvisitedNode.getNextEOGEdges().clear();
        }
    }

    protected final void handleTranslationUnitDeclaration(@NotNull TranslationUnitDeclaration node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.handleStatementHolder(node);
        for (Declaration child : node.getDeclarations()) {
            this.createEOG(child);
        }
        this.processedListener.clearProcessed();
    }

    protected final void handleNamespaceDeclaration(@NotNull NamespaceDeclaration node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.handleStatementHolder(node);
        for (Declaration child : node.getDeclarations()) {
            this.createEOG(child);
        }
        this.processedListener.clearProcessed();
    }

    protected final void handleVariableDeclaration(@NotNull VariableDeclaration node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.createEOG(node.getInitializer());
        this.pushToEOG(node);
    }

    protected final void handleRecordDeclaration(@NotNull RecordDeclaration node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.getScopeManager().enterScope(node);
        this.handleStatementHolder(node);
        this.currentEOG.clear();
        for (ConstructorDeclaration constructor : node.getConstructors()) {
            this.createEOG(constructor);
        }
        for (MethodDeclaration method : node.getMethods()) {
            this.createEOG(method);
        }
        for (RecordDeclaration records2 : node.getRecords()) {
            this.createEOG(records2);
        }
        this.getScopeManager().leaveScope(node);
    }

    /*
     * WARNING - void declaration
     */
    protected final void handleStatementHolder(@NotNull StatementHolder statementHolder) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)statementHolder, (String)"statementHolder");
        List<Statement> code = statementHolder.getStatements();
        Iterable $this$filter$iv = code;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Statement it = (Statement)element$iv$iv;
            boolean bl = false;
            CompoundStatement compoundStatement = it instanceof CompoundStatement ? (CompoundStatement)it : null;
            boolean bl2 = compoundStatement != null ? !compoundStatement.isStaticBlock() : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonStaticCode = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = code;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Statement it = (Statement)element$iv$iv;
            boolean bl = false;
            if (!(!nonStaticCode.contains(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List staticCode = (List)destination$iv$iv2;
        this.pushToEOG((Node)((Object)statementHolder));
        for (Statement staticStatement : staticCode) {
            this.createEOG(staticStatement);
        }
        this.currentEOG.clear();
        this.pushToEOG((Node)((Object)statementHolder));
        for (Statement nonStaticStatement : nonStaticCode) {
            this.createEOG(nonStaticStatement);
        }
        this.currentEOG.clear();
    }

    protected final void handleFunctionDeclaration(@NotNull FunctionDeclaration node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.currentEOG.clear();
        boolean needToLeaveRecord = false;
        if (node instanceof MethodDeclaration && ((MethodDeclaration)node).getRecordDeclaration() != null && ((MethodDeclaration)node).getRecordDeclaration() != this.getScopeManager().getCurrentRecord()) {
            ScopeManager scopeManager = this.getScopeManager();
            RecordDeclaration recordDeclaration = ((MethodDeclaration)node).getRecordDeclaration();
            Intrinsics.checkNotNull((Object)recordDeclaration);
            scopeManager.enterScope(recordDeclaration);
            needToLeaveRecord = true;
        }
        this.getScopeManager().enterScope(node);
        this.pushToEOG(node);
        this.createEOG(node.getBody());
        Scope currentScope = this.getScopeManager().getCurrentScope();
        if (!(currentScope instanceof FunctionScope)) {
            Util.errorWithFileLocation(node, Pass.Companion.getLog(), "Scope of function declaration is not a function scope. EOG of function might be incorrect.", new Object[0]);
            this.getScopeManager().leaveScope(node);
            this.currentEOG.clear();
            return;
        }
        List uncaughtEOGThrows = CollectionsKt.flatten((Iterable)((FunctionScope)currentScope).getCatchesOrRelays().values());
        Statement statement = node.getBody();
        if (statement != null) {
            Statement it = statement;
            boolean bl = false;
            this.addMultipleIncomingEOGEdges(uncaughtEOGThrows, it);
        }
        this.getScopeManager().leaveScope(node);
        if (node instanceof MethodDeclaration && ((MethodDeclaration)node).getRecordDeclaration() != null && needToLeaveRecord) {
            ScopeManager scopeManager = this.getScopeManager();
            RecordDeclaration recordDeclaration = ((MethodDeclaration)node).getRecordDeclaration();
            Intrinsics.checkNotNull((Object)recordDeclaration);
            scopeManager.leaveScope(recordDeclaration);
        }
        List<Node> funcDeclNextEOG = node.getNextEOG();
        this.currentEOG.clear();
        this.currentEOG.add(node);
        Expression defaultArg = null;
        for (ParamVariableDeclaration paramVariableDeclaration : node.getParameters()) {
            if (paramVariableDeclaration.getDefault() == null) continue;
            Expression expression = defaultArg = paramVariableDeclaration.getDefault();
            Intrinsics.checkNotNull((Object)expression);
            this.pushToEOG(expression);
            this.currentEOG.clear();
            this.currentEOG.add(defaultArg);
            this.currentEOG.add(node);
        }
        if (defaultArg != null) {
            for (Node nextEOG : funcDeclNextEOG) {
                this.currentEOG.clear();
                this.currentEOG.add(defaultArg);
                this.pushToEOG(nextEOG);
            }
        }
        this.currentEOG.clear();
    }

    private final void createEOG(Node node) {
        if (node == null) {
            return;
        }
        this.intermediateNodes.add(node);
        Class<?> toHandle = node.getClass();
        Function1<Node, Unit> callable = this.map.get(toHandle);
        while (callable == null) {
            Intrinsics.checkNotNullExpressionValue(toHandle.getSuperclass(), (String)"toHandle.superclass");
            callable = this.map.get(toHandle);
            if (!Intrinsics.areEqual(toHandle, Node.class) && Node.class.isAssignableFrom(toHandle)) continue;
        }
        if (callable != null) {
            callable.invoke((Object)node);
        } else {
            LOGGER.info("Parsing of type " + node.getClass() + " is not supported (yet)");
        }
    }

    protected final void handleDefault(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.pushToEOG(node);
    }

    protected final void handleCallExpression(@NotNull CallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof MemberCallExpression && ((MemberCallExpression)node).getBase() != null) {
            Expression expression = ((MemberCallExpression)node).getBase();
            Intrinsics.checkNotNull((Object)expression);
            this.createEOG(expression);
        }
        for (Expression arg : node.getArguments()) {
            this.createEOG(arg);
        }
        this.pushToEOG(node);
    }

    protected final void handleMemberExpression(@NotNull MemberExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.createEOG(node.getBase());
        this.pushToEOG(node);
    }

    protected final void handleArraySubscriptionExpression(@NotNull ArraySubscriptionExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.createEOG(node.getArrayExpression());
        this.createEOG(node.getSubscriptExpression());
        this.pushToEOG(node);
    }

    protected final void handleArrayCreationExpression(@NotNull ArrayCreationExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        for (Expression dimension : node.getDimensions()) {
            this.createEOG(dimension);
        }
        this.createEOG(node.getInitializer());
        this.pushToEOG(node);
    }

    protected final void handleDeclarationStatement(@NotNull DeclarationStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        for (Declaration declaration : node.getDeclarations()) {
            if (declaration instanceof VariableDeclaration) {
                this.createEOG(declaration);
                continue;
            }
            if (!(declaration instanceof FunctionDeclaration)) continue;
            ArrayList oldEOG = new ArrayList(this.currentEOG);
            this.createEOG(declaration);
            this.currentEOG = oldEOG;
        }
        this.pushToEOG(node);
    }

    protected final void handleReturnStatement(@NotNull ReturnStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.createEOG(node.getReturnValue());
        this.pushToEOG(node);
        this.currentEOG.clear();
    }

    protected final void handleBinaryOperator(@NotNull BinaryOperator node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.createEOG(node.getLhs());
        Language<? extends LanguageFrontend> lang = node.getLanguage();
        if (lang != null && lang instanceof HasShortCircuitOperators && (CollectionsKt.contains((Iterable)((HasShortCircuitOperators)((Object)lang)).getConjunctiveOperators(), (Object)node.getOperatorCode()) || CollectionsKt.contains((Iterable)((HasShortCircuitOperators)((Object)lang)).getDisjunctiveOperators(), (Object)node.getOperatorCode()))) {
            List shortCircuitNodes = new ArrayList();
            shortCircuitNodes.addAll((Collection)this.currentEOG);
            ((Map)this.currentProperties).put(Properties.BRANCH, CollectionsKt.contains((Iterable)((HasShortCircuitOperators)((Object)lang)).getConjunctiveOperators(), (Object)node.getOperatorCode()));
            this.createEOG(node.getRhs());
            this.pushToEOG(node);
            this.setCurrentEOGs(shortCircuitNodes);
            ((Map)this.currentProperties).put(Properties.BRANCH, !CollectionsKt.contains((Iterable)((HasShortCircuitOperators)((Object)lang)).getConjunctiveOperators(), (Object)node.getOperatorCode()));
        } else {
            this.createEOG(node.getRhs());
        }
        this.pushToEOG(node);
    }

    protected final void handleCompoundStatement(@NotNull CompoundStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.getScopeManager().enterScopeIfExists(node);
        for (Statement child : node.getStatements()) {
            this.createEOG(child);
        }
        if (this.getScopeManager().getCurrentScope() instanceof BlockScope) {
            this.getScopeManager().leaveScope(node);
        }
        this.pushToEOG(node);
    }

    /*
     * Unable to fully structure code
     */
    protected final void handleUnaryOperator(@NotNull UnaryOperator node) {
        block9: {
            block6: {
                block8: {
                    block7: {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        input = node.getInput();
                        if (input != null) {
                            this.createEOG(input);
                        }
                        if (!Intrinsics.areEqual((Object)node.getOperatorCode(), (Object)"throw")) break block6;
                        catchingScope = ScopeManager.firstScopeOrNull$default(this.getScopeManager(), null, (Predicate<Scope>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, handleUnaryOperator$lambda$8(de.fraunhofer.aisec.cpg.graph.scopes.Scope ), (Lde/fraunhofer/aisec/cpg/graph/scopes/Scope;)Z)(), 1, null);
                        if (input == null) break block7;
                        v0 = input.getType();
                        break block8;
                    }
                    decl = ScopeManager.firstScopeOrNull$default(this.getScopeManager(), null, (Predicate<Scope>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, handleUnaryOperator$lambda$9(de.fraunhofer.aisec.cpg.graph.scopes.Scope ), (Lde/fraunhofer/aisec/cpg/graph/scopes/Scope;)Z)(), 1, null);
                    if (decl == null || !(decl.getAstNode() instanceof CatchClause)) ** GOTO lbl-1000
                    v1 = (CatchClause)decl.getAstNode();
                    Intrinsics.checkNotNull((Object)v1);
                    if (v1.getParameter() != null) {
                        v2 = (CatchClause)decl.getAstNode();
                        Intrinsics.checkNotNull((Object)v2);
                        v3 = v2.getParameter();
                        Intrinsics.checkNotNull((Object)v3);
                        param = v3;
                        v0 = param.getType();
                    } else lbl-1000:
                    // 2 sources

                    {
                        EvaluationOrderGraphPass.LOGGER.info("Unknown throw type, potentially throw; in a method");
                        v0 = TypeParser.createFrom("UNKNOWN_THROW_TYPE", node.getLanguage());
                    }
                }
                throwType = v0;
                this.pushToEOG(node);
                if (catchingScope instanceof TryScope) {
                    v4 = ((TryScope)catchingScope).getCatchesOrRelays();
                    Intrinsics.checkNotNullExpressionValue((Object)throwType, (String)"throwType");
                    v4.put(throwType, new ArrayList<E>(this.currentEOG));
                } else if (catchingScope instanceof FunctionScope) {
                    v5 = ((FunctionScope)catchingScope).getCatchesOrRelays();
                    Intrinsics.checkNotNullExpressionValue((Object)throwType, (String)"throwType");
                    v5.put(throwType, new ArrayList<E>(this.currentEOG));
                }
                this.currentEOG.clear();
                break block9;
            }
            this.pushToEOG(node);
        }
    }

    protected final void handleCompoundStatementExpression(@NotNull CompoundStatementExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.createEOG(node.getStatement());
        this.pushToEOG(node);
    }

    protected final void handleAssertStatement(@NotNull AssertStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.createEOG(node.getCondition());
        ArrayList openConditionEOGs = new ArrayList(this.currentEOG);
        this.createEOG(node.getMessage());
        this.setCurrentEOGs(openConditionEOGs);
        this.pushToEOG(node);
    }

    /*
     * WARNING - void declaration
     */
    protected final void handleTryStatement(@NotNull TryStatement node) {
        boolean bl;
        Iterable $this$any$iv;
        Map<Type, List<Node>> catchesOrRelays;
        ArrayList tmpEOGNodes;
        block15: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.getScopeManager().enterScope(node);
            TryScope tryScope = (TryScope)this.getScopeManager().getCurrentScope();
            Iterable $this$forEach$iv = node.getResources();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Statement it = (Statement)element$iv;
                boolean bl2 = false;
                this.createEOG(it);
            }
            this.createEOG(node.getTryBlock());
            tmpEOGNodes = new ArrayList(this.currentEOG);
            TryScope tryScope2 = tryScope;
            Intrinsics.checkNotNull((Object)tryScope2);
            catchesOrRelays = tryScope2.getCatchesOrRelays();
            for (CatchClause catchClause : node.getCatchClauses()) {
                this.currentEOG.clear();
                Set toRemove = new LinkedHashSet();
                for (Map.Entry<Type, List<Node>> entry : catchesOrRelays.entrySet()) {
                    Type throwType = entry.getKey();
                    List<Node> eogEdges = entry.getValue();
                    if (catchClause.getParameter() == null) {
                        this.currentEOG.addAll((Collection<Node>)eogEdges);
                        continue;
                    }
                    TypeManager typeManager = TypeManager.getInstance();
                    VariableDeclaration variableDeclaration = catchClause.getParameter();
                    Intrinsics.checkNotNull((Object)variableDeclaration);
                    if (!typeManager.isSupertypeOf(variableDeclaration.getType(), throwType, node)) continue;
                    this.currentEOG.addAll((Collection<Node>)eogEdges);
                    toRemove.add(throwType);
                }
                Iterable $this$forEach$iv2 = toRemove;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    Type it = (Type)element$iv;
                    boolean bl3 = false;
                    catchesOrRelays.remove(it);
                }
                this.createEOG(catchClause.getBody());
                tmpEOGNodes.addAll(this.currentEOG);
            }
            $this$any$iv = tmpEOGNodes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Node it = (Node)element$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!Companion.reachableFromValidEOGRoot(it)) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        boolean canTerminateExceptionfree = bl;
        this.currentEOG.clear();
        this.currentEOG.addAll(tmpEOGNodes);
        if (node.getFinallyBlock() != null) {
            void $this$flatMapTo$iv$iv;
            Iterator<Map.Entry<Type, List<Node>>> $this$flatMap$iv;
            $this$any$iv = catchesOrRelays.entrySet();
            List<Node> list2 = this.currentEOG;
            boolean $i$f$flatMap = false;
            void $this$forEach$iv2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Map.Entry bl3 = (Map.Entry)element$iv$iv;
                boolean bl5 = false;
                List value = (List)bl3.getValue();
                Iterable list$iv$iv = value;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list2.addAll((List)destination$iv$iv);
            this.createEOG(node.getFinallyBlock());
            $this$flatMap$iv = catchesOrRelays.entrySet().iterator();
            while ($this$flatMap$iv.hasNext()) {
                List<Node> value = $this$flatMap$iv.next().getValue();
                value.clear();
                value.addAll((Collection<Node>)this.currentEOG);
            }
        }
        ScopeManager scopeManager = this.getScopeManager();
        Scope scope = this.getScopeManager().getCurrentScope();
        Intrinsics.checkNotNull((Object)scope);
        Scope outerScope = scopeManager.firstScopeOrNull(scope.getParent(), EvaluationOrderGraphPass::handleTryStatement$lambda$14);
        if (outerScope != null) {
            Map<Type, List<Node>> outerCatchesOrRelays = outerScope instanceof TryScope ? ((TryScope)outerScope).getCatchesOrRelays() : ((FunctionScope)outerScope).getCatchesOrRelays();
            for (Map.Entry<Type, List<Node>> entry : catchesOrRelays.entrySet()) {
                Type key = entry.getKey();
                List<Node> value = entry.getValue();
                List list3 = outerCatchesOrRelays.get(key);
                if (list3 == null) {
                    list3 = new ArrayList();
                }
                List catches = list3;
                catches.addAll((Collection)value);
                outerCatchesOrRelays.put(key, catches);
            }
        }
        this.getScopeManager().leaveScope(node);
        if (!canTerminateExceptionfree) {
            this.currentEOG.clear();
        }
        this.pushToEOG(node);
    }

    protected final void handleContinueStatement(@NotNull ContinueStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.pushToEOG(node);
        this.getScopeManager().addContinueStatement(node);
        this.currentEOG.clear();
    }

    protected final void handleDeleteExpression(@NotNull DeleteExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.createEOG(node.getOperand());
        this.pushToEOG(node);
    }

    protected final void handleBreakStatement(@NotNull BreakStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.pushToEOG(node);
        this.getScopeManager().addBreakStatement(node);
        this.currentEOG.clear();
    }

    protected final void handleLabelStatement(@NotNull LabelStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.getScopeManager().addLabelStatement(node);
        this.createEOG(node.getSubStatement());
    }

    protected final void handleGotoStatement(@NotNull GotoStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.pushToEOG(node);
        if (node.getTargetLabel() != null) {
            LabelStatement labelStatement = node.getTargetLabel();
            Intrinsics.checkNotNullExpressionValue((Object)labelStatement, (String)"node.targetLabel");
            this.processedListener.registerObjectListener(labelStatement, (arg_0, arg_1) -> EvaluationOrderGraphPass.handleGotoStatement$lambda$15(this, node, arg_0, arg_1));
        }
        this.currentEOG.clear();
    }

    protected final void handleCaseStatement(@NotNull CaseStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.createEOG(node.getCaseExpression());
        this.pushToEOG(node);
    }

    protected final void handleNewExpression(@NotNull NewExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.createEOG(node.getInitializer());
        this.pushToEOG(node);
    }

    protected final void handleCastExpression(@NotNull CastExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.createEOG(node.getExpression());
        this.pushToEOG(node);
    }

    protected final void handleExpressionList(@NotNull ExpressionList node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        for (Statement expr : node.getExpressions()) {
            this.createEOG(expr);
        }
        this.pushToEOG(node);
    }

    protected final void handleInitializerListExpression(@NotNull InitializerListExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        for (Expression inits : node.getInitializers()) {
            this.createEOG(inits);
        }
        this.pushToEOG(node);
    }

    protected final void handleConstructExpression(@NotNull ConstructExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        for (Expression arg : node.getArguments()) {
            this.createEOG(arg);
        }
        this.pushToEOG(node);
    }

    public final void pushToEOG(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        LOGGER.trace("Pushing " + node.getClass().getSimpleName() + " " + node + " to EOG");
        for (Node intermediate : this.intermediateNodes) {
            this.processedListener.process(intermediate, node);
        }
        this.addMultipleIncomingEOGEdges(this.currentEOG, node);
        this.intermediateNodes.clear();
        this.currentEOG.clear();
        this.currentProperties.clear();
        this.currentEOG.add(node);
    }

    public final void setCurrentEOGs(@NotNull List<? extends Node> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        LOGGER.trace("Setting " + nodes + " to EOGs");
        this.currentEOG = new ArrayList(nodes);
    }

    /*
     * WARNING - void declaration
     */
    protected final void exitLoop(@NotNull Statement loopStatement, @NotNull LoopScope loopScope) {
        Intrinsics.checkNotNullParameter((Object)loopStatement, (String)"loopStatement");
        Intrinsics.checkNotNullParameter((Object)loopScope, (String)"loopScope");
        this.currentEOG.addAll((Collection<Node>)loopScope.getBreakStatements());
        ArrayList continues = new ArrayList(loopScope.getContinueStatements());
        if (!((Collection)continues).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = loopScope.getConditions();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Node node = (Node)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SubgraphWalker.INSTANCE.getEOGPathEdges((Node)it).getEntries());
            }
            List conditions = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            Iterable $this$forEach$iv = conditions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Node node = (Node)element$iv;
                boolean bl = false;
                this.addMultipleIncomingEOGEdges(continues, node);
            }
        }
    }

    protected final void connectCurrentToLoopStart() {
        LoopScope loopScope;
        Scope scope = ScopeManager.firstScopeOrNull$default(this.getScopeManager(), null, EvaluationOrderGraphPass::connectCurrentToLoopStart$lambda$18, 1, null);
        LoopScope loopScope2 = loopScope = scope instanceof LoopScope ? (LoopScope)scope : null;
        if (loopScope == null) {
            LOGGER.error("I am unexpectedly not in a loop, cannot add edge to loop start");
            return;
        }
        Iterable $this$forEach$iv = loopScope.getStarts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node node = (Node)element$iv;
            boolean bl = false;
            this.addMultipleIncomingEOGEdges(this.currentEOG, node);
        }
    }

    private final void addEOGEdge(Node prev, Node next) {
        PropertyEdge<Node> propertyEdge = new PropertyEdge<Node>(prev, next);
        propertyEdge.addProperties((Map<Properties, Object>)this.currentProperties);
        propertyEdge.addProperty(Properties.INDEX, prev.getNextEOG().size());
        propertyEdge.addProperty(Properties.UNREACHABLE, false);
        prev.addNextEOG(propertyEdge);
        next.addPrevEOG(propertyEdge);
    }

    private final void addMultipleIncomingEOGEdges(List<? extends Node> prevs, Node next) {
        Iterable $this$forEach$iv = prevs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node prev = (Node)element$iv;
            boolean bl = false;
            this.addEOGEdge(prev, next);
        }
    }

    protected final void handleSynchronizedStatement(@NotNull SynchronizedStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.createEOG(node.getExpression());
        this.pushToEOG(node);
        this.createEOG(node.getBlockStatement());
    }

    protected final void handleConditionalExpression(@NotNull ConditionalExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List openBranchNodes = new ArrayList();
        this.createEOG(node.getCondition());
        this.pushToEOG(node);
        ArrayList openConditionEOGs = new ArrayList(this.currentEOG);
        ((Map)this.currentProperties).put(Properties.BRANCH, true);
        this.createEOG(node.getThenExpr());
        openBranchNodes.addAll((Collection)this.currentEOG);
        this.setCurrentEOGs(openConditionEOGs);
        ((Map)this.currentProperties).put(Properties.BRANCH, false);
        this.createEOG(node.getElseExpr());
        openBranchNodes.addAll((Collection)this.currentEOG);
        this.setCurrentEOGs(openBranchNodes);
    }

    protected final void handleDoStatement(@NotNull DoStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.getScopeManager().enterScope(node);
        this.createEOG(node.getStatement());
        this.createEOG(node.getCondition());
        Expression expression = node.getCondition();
        if (expression != null) {
            Expression it = expression;
            boolean bl = false;
            node.addPrevDFG(it);
        }
        this.pushToEOG(node);
        ((Map)this.currentProperties).put(Properties.BRANCH, true);
        this.connectCurrentToLoopStart();
        ((Map)this.currentProperties).put(Properties.BRANCH, false);
        LoopScope currentLoopScope = (LoopScope)this.getScopeManager().leaveScope(node);
        if (currentLoopScope != null) {
            this.exitLoop(node, currentLoopScope);
        } else {
            LOGGER.error("Trying to exit do loop, but no loop scope: " + node);
        }
    }

    protected final void handleForEachStatement(@NotNull ForEachStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.getScopeManager().enterScope(node);
        this.createEOG(node.getIterable());
        this.createEOG(node.getVariable());
        Statement statement = node.getVariable();
        if (statement != null) {
            Statement it = statement;
            boolean bl = false;
            node.addPrevDFG(it);
        }
        this.pushToEOG(node);
        ((Map)this.currentProperties).put(Properties.BRANCH, true);
        ArrayList tmpEOGNodes = new ArrayList(this.currentEOG);
        this.createEOG(node.getStatement());
        this.connectCurrentToLoopStart();
        this.currentEOG.clear();
        LoopScope currentLoopScope = (LoopScope)this.getScopeManager().leaveScope(node);
        if (currentLoopScope != null) {
            this.exitLoop(node, currentLoopScope);
        } else {
            LOGGER.error("Trying to exit foreach loop, but not in loop scope: " + node);
        }
        this.currentEOG.addAll(tmpEOGNodes);
        ((Map)this.currentProperties).put(Properties.BRANCH, false);
    }

    protected final void handleForStatement(@NotNull ForStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.getScopeManager().enterScope(node);
        this.createEOG(node.getInitializerStatement());
        this.createEOG(node.getConditionDeclaration());
        this.createEOG(node.getCondition());
        this.pushToEOG(node);
        ((Map)this.currentProperties).put(Properties.BRANCH, true);
        ArrayList tmpEOGNodes = new ArrayList(this.currentEOG);
        this.createEOG(node.getStatement());
        this.createEOG(node.getIterationStatement());
        this.connectCurrentToLoopStart();
        this.currentEOG.clear();
        LoopScope currentLoopScope = (LoopScope)this.getScopeManager().leaveScope(node);
        if (currentLoopScope != null) {
            this.exitLoop(node, currentLoopScope);
        } else {
            LOGGER.error("Trying to exit for loop, but no loop scope: " + node);
        }
        this.currentEOG.addAll(tmpEOGNodes);
        ((Map)this.currentProperties).put(Properties.BRANCH, false);
    }

    protected final void handleIfStatement(@NotNull IfStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List openBranchNodes = new ArrayList();
        this.getScopeManager().enterScopeIfExists(node);
        this.createEOG(node.getInitializerStatement());
        this.createEOG(node.getConditionDeclaration());
        this.createEOG(node.getCondition());
        this.pushToEOG(node);
        ArrayList openConditionEOGs = new ArrayList(this.currentEOG);
        ((Map)this.currentProperties).put(Properties.BRANCH, true);
        this.createEOG(node.getThenStatement());
        openBranchNodes.addAll((Collection)this.currentEOG);
        if (node.getElseStatement() != null) {
            this.setCurrentEOGs(openConditionEOGs);
            ((Map)this.currentProperties).put(Properties.BRANCH, false);
            this.createEOG(node.getElseStatement());
            openBranchNodes.addAll((Collection)this.currentEOG);
        } else {
            openBranchNodes.addAll(openConditionEOGs);
        }
        this.getScopeManager().leaveScope(node);
        this.setCurrentEOGs(openBranchNodes);
    }

    protected final void handleSwitchStatement(@NotNull SwitchStatement node) {
        CompoundStatement compoundStatement;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.getScopeManager().enterScopeIfExists(node);
        this.createEOG(node.getInitializerStatement());
        this.createEOG(node.getSelectorDeclaration());
        this.createEOG(node.getSelector());
        this.pushToEOG(node);
        ArrayList tmp = new ArrayList(this.currentEOG);
        if (node.getStatement() instanceof DoStatement) {
            this.createEOG(node.getStatement());
            Statement statement = node.getStatement();
            Intrinsics.checkNotNull((Object)statement, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.DoStatement");
            Statement statement2 = ((DoStatement)statement).getStatement();
            Intrinsics.checkNotNull((Object)statement2, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement");
            compoundStatement = (CompoundStatement)statement2;
        } else {
            Statement statement = node.getStatement();
            Intrinsics.checkNotNull((Object)statement, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement");
            compoundStatement = (CompoundStatement)statement;
        }
        CompoundStatement compound = compoundStatement;
        this.currentEOG = new ArrayList();
        for (Statement subStatement : compound.getStatements()) {
            if (subStatement instanceof CaseStatement || subStatement instanceof DefaultStatement) {
                this.currentEOG.addAll(tmp);
            }
            this.createEOG(subStatement);
        }
        this.pushToEOG(compound);
        SwitchScope switchScope = (SwitchScope)this.getScopeManager().leaveScope(node);
        if (switchScope != null) {
            this.currentEOG.addAll((Collection<Node>)switchScope.getBreakStatements());
        } else {
            LOGGER.error("Handling switch statement, but not in switch scope: " + node);
        }
    }

    protected final void handleWhileStatement(@NotNull WhileStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.getScopeManager().enterScope(node);
        this.createEOG(node.getConditionDeclaration());
        this.createEOG(node.getCondition());
        this.pushToEOG(node);
        ((Map)this.currentProperties).put(Properties.BRANCH, true);
        ArrayList tmpEOGNodes = new ArrayList(this.currentEOG);
        this.createEOG(node.getStatement());
        this.connectCurrentToLoopStart();
        this.currentEOG.clear();
        LoopScope currentLoopScope = (LoopScope)this.getScopeManager().leaveScope(node);
        if (currentLoopScope != null) {
            this.exitLoop(node, currentLoopScope);
        } else {
            LOGGER.error("Trying to exit while loop, but no loop scope: " + node);
        }
        this.currentEOG.addAll(tmpEOGNodes);
        ((Map)this.currentProperties).put(Properties.BRANCH, false);
    }

    private static final boolean handleUnaryOperator$lambda$8(Scope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return scope instanceof TryScope || scope instanceof FunctionScope;
    }

    private static final boolean handleUnaryOperator$lambda$9(Scope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return Intrinsics.areEqual(scope.getClass(), ValueDeclarationScope.class);
    }

    private static final boolean handleTryStatement$lambda$14(Scope scope) {
        return scope instanceof TryScope || scope instanceof FunctionScope;
    }

    private static final void handleGotoStatement$lambda$15(EvaluationOrderGraphPass this$0, GotoStatement $node, Object object, Object to2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        Node node = $node;
        Intrinsics.checkNotNull((Object)to2, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.Node");
        this$0.addEOGEdge(node, (Node)to2);
    }

    private static final boolean connectCurrentToLoopStart$lambda$18(Scope it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof LoopScope;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0004R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/fraunhofer/aisec/cpg/passes/EvaluationOrderGraphPass$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "checkEOGInvariant", "", "n", "Lde/fraunhofer/aisec/cpg/graph/Node;", "reachableFromValidEOGRoot", "node", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        protected final boolean reachableFromValidEOGRoot(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Set passedBy = new LinkedHashSet();
            ArrayList<Node> workList = new ArrayList<Node>((Collection)node.getPrevEOG());
            while (!((Collection)workList).isEmpty()) {
                Node toProcess = (Node)workList.get(0);
                workList.remove(toProcess);
                Intrinsics.checkNotNullExpressionValue((Object)toProcess, (String)"toProcess");
                passedBy.add(toProcess);
                if (toProcess instanceof FunctionDeclaration) {
                    return true;
                }
                for (Node pred : toProcess.getPrevEOG()) {
                    if (passedBy.contains(pred) || workList.contains(pred)) continue;
                    workList.add(pred);
                }
            }
            return false;
        }

        public final boolean checkEOGInvariant(@NotNull Node n) {
            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
            List<Node> allNodes = SubgraphWalker.INSTANCE.flattenAST(n);
            boolean ret = true;
            for (Node node : allNodes) {
                for (Node next : node.getNextEOG()) {
                    if (next.getPrevEOG().contains(node)) continue;
                    LOGGER.warn("Violation to EOG invariant found: Node " + node + " does not have a back-reference from his EOG-successor " + next + ".");
                    ret = false;
                }
                for (Node prev : node.getPrevEOG()) {
                    if (prev.getNextEOG().contains(node)) continue;
                    LOGGER.warn("Violation to EOG invariant found: Node " + node + " does not have a reference from his EOG-predecessor " + prev + ".");
                    ret = false;
                }
            }
            return ret;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

