/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.Edge;
import de.fraunhofer.aisec.cpg.passes.EdgeType;
import de.fraunhofer.aisec.cpg.passes.Edges;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.processing.IVisitable;
import de.fraunhofer.aisec.cpg.processing.IVisitor;
import de.fraunhofer.aisec.cpg.processing.strategy.Strategy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lde/fraunhofer/aisec/cpg/passes/EdgeCachePass;", "Lde/fraunhofer/aisec/cpg/passes/Pass;", "()V", "accept", "", "result", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "cleanup", "visitAST", "n", "Lde/fraunhofer/aisec/cpg/graph/Node;", "visitDFG", "visitEOG", "cpg-core"})
public final class EdgeCachePass
extends Pass {
    @Override
    public void accept(@NotNull TranslationResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Edges.INSTANCE.clear();
        for (TranslationUnitDeclaration tu : result.getTranslationUnits()) {
            tu.accept(Strategy::AST_FORWARD, new IVisitor<Node>(this){
                final /* synthetic */ EdgeCachePass this$0;
                {
                    this.this$0 = $receiver;
                }

                public void visit(@NotNull Node n) {
                    Intrinsics.checkNotNullParameter((Object)n, (String)"n");
                    EdgeCachePass.access$visitAST(this.this$0, n);
                    EdgeCachePass.access$visitDFG(this.this$0, n);
                    EdgeCachePass.access$visitEOG(this.this$0, n);
                    super.visit((IVisitable)n);
                }
            });
        }
    }

    private final void visitAST(Node n) {
        for (Node node : SubgraphWalker.getAstChildren(n)) {
            Edge edge = new Edge(n, node, EdgeType.AST);
            Edges.INSTANCE.add(edge);
        }
    }

    private final void visitDFG(Node n) {
        Edge edge;
        for (Node dfg : n.getPrevDFG()) {
            edge = new Edge(dfg, n, EdgeType.DFG);
            Edges.INSTANCE.add(edge);
        }
        for (Node dfg : n.getNextDFG()) {
            edge = new Edge(n, dfg, EdgeType.DFG);
            Edges.INSTANCE.add(edge);
        }
    }

    private final void visitEOG(Node n) {
        Edge edge;
        for (Node eog : n.getPrevEOG()) {
            edge = new Edge(eog, n, EdgeType.EOG);
            Edges.INSTANCE.add(edge);
        }
        for (Node eog : n.getNextEOG()) {
            edge = new Edge(n, eog, EdgeType.EOG);
            Edges.INSTANCE.add(edge);
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ void access$visitAST(EdgeCachePass $this, Node n) {
        $this.visitAST(n);
    }

    public static final /* synthetic */ void access$visitDFG(EdgeCachePass $this, Node n) {
        $this.visitDFG(n);
    }

    public static final /* synthetic */ void access$visitEOG(EdgeCachePass $this, Node n) {
        $this.visitEOG(n);
    }
}

