/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.InferenceConfiguration;
import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.HasComplexCallResolution;
import de.fraunhofer.aisec.cpg.frontends.HasDefaultArguments;
import de.fraunhofer.aisec.cpg.frontends.HasTemplates;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.cpp.CPPLanguage;
import de.fraunhofer.aisec.cpg.graph.ExpressionBuilderKt;
import de.fraunhofer.aisec.cpg.graph.LanguageProvider;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.NameKt;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.ClassTemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ExplicitConstructorInvocation;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberCallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.TypeExpression;
import de.fraunhofer.aisec.cpg.graph.types.FunctionPointerType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.CXXCallResolverHelperKt;
import de.fraunhofer.aisec.cpg.passes.JavaCallResolverHelperKt;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.SymbolResolverPass;
import de.fraunhofer.aisec.cpg.passes.TemplateCallResolverHelperKt;
import de.fraunhofer.aisec.cpg.passes.VariableUsageResolver;
import de.fraunhofer.aisec.cpg.passes.inference.Inference;
import de.fraunhofer.aisec.cpg.passes.inference.InferenceKt;
import de.fraunhofer.aisec.cpg.passes.order.DependsOn;
import de.fraunhofer.aisec.cpg.processing.strategy.Strategy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DependsOn(value=VariableUsageResolver.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u0000 <2\u00020\u0001:\u0001<B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\"\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001d\u001a\u00020\u00162\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J.\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000fH\u0002J(\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0010\u001a\u00020\u0011J&\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000f2\u0006\u0010%\u001a\u00020\u0005H\u0002J\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010'\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010(\u001a\u00020\b2\b\u0010)\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010*\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u001a\u0010/\u001a\u00020\b2\b\u00100\u001a\u0004\u0018\u00010\u001a2\u0006\u00101\u001a\u00020\u0014H\u0002J,\u00102\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\r2\b\u00103\u001a\u0004\u0018\u0001042\b\u0010)\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J&\u00105\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u00103\u001a\u0002062\b\u0010)\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00020\u0011J(\u00107\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u00103\u001a\u0002062\b\u0010)\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J.\u00108\u001a\b\u0012\u0004\u0012\u00020\u0005092\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010)\u001a\u0004\u0018\u00010\u001a2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0002J\u0010\u0010:\u001a\u00020;2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lde/fraunhofer/aisec/cpg/passes/CallResolver;", "Lde/fraunhofer/aisec/cpg/passes/SymbolResolverPass;", "()V", "containingType", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/FunctionDeclaration;", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "accept", "", "translationResult", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "cleanup", "createMethodDummies", "", "possibleContainingTypes", "", "call", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/CallExpression;", "fixInitializers", "node", "Lde/fraunhofer/aisec/cpg/graph/Node;", "getConstructorDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/ConstructorDeclaration;", "constructExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ConstructExpression;", "recordDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "getConstructorDeclarationDirectMatch", "signature", "getConstructorDeclarationForExplicitInvocation", "getInvocationCandidatesFromParents", "name", "", "possibleTypes", "getInvocationCandidatesFromRecord", "getOverridingCandidates", "possibleSubTypes", "declaration", "getPossibleContainingTypes", "handleArguments", "handleCallExpression", "curClass", "handleConstructExpression", "handleExplicitConstructorInvocation", "eci", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ExplicitConstructorInvocation;", "handleNode", "registerMethods", "currentClass", "currentNode", "resolveCallee", "callee", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "resolveMemberCallee", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/DeclaredReferenceExpression;", "resolveReferenceCallee", "retrieveInvocationCandidatesFromCall", "", "shouldSearchForInvokesInParent", "", "Companion", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nCallResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallResolver.kt\nde/fraunhofer/aisec/cpg/passes/CallResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,628:1\n1549#2:629\n1620#2,3:630\n1855#2,2:635\n1603#2,9:637\n1855#2:646\n1856#2:648\n1612#2:649\n1549#2:650\n1620#2,3:651\n1603#2,9:654\n1855#2:663\n1856#2:665\n1612#2:666\n1549#2:667\n1620#2,3:668\n1549#2:671\n1620#2,3:672\n766#2:676\n857#2,2:677\n1549#2:681\n1620#2,3:682\n1549#2:685\n1620#2,3:686\n1549#2:689\n1620#2,3:690\n766#2:693\n857#2,2:694\n288#2,2:696\n37#3,2:633\n37#3,2:679\n1#4:647\n1#4:664\n1#4:675\n*S KotlinDebug\n*F\n+ 1 CallResolver.kt\nde/fraunhofer/aisec/cpg/passes/CallResolver\n*L\n132#1:629\n132#1:630,3\n255#1:635,2\n335#1:637,9\n335#1:646\n335#1:648\n335#1:649\n344#1:650\n344#1:651,3\n384#1:654,9\n384#1:663\n384#1:665\n384#1:666\n393#1:667\n393#1:668,3\n452#1:671\n452#1:672,3\n500#1:676\n500#1:677,2\n516#1:681\n516#1:682,3\n529#1:685\n529#1:686,3\n530#1:689\n530#1:690,3\n541#1:693\n541#1:694,2\n600#1:696,2\n135#1:633,2\n511#1:679,2\n335#1:647\n384#1:664\n*E\n"})
public class CallResolver
extends SymbolResolverPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<FunctionDeclaration, Type> containingType = new LinkedHashMap();
    @NotNull
    private static final Logger LOGGER;

    @Override
    public void cleanup() {
        this.containingType.clear();
    }

    @Override
    public void accept(@NotNull TranslationResult translationResult) {
        Intrinsics.checkNotNullParameter((Object)translationResult, (String)"translationResult");
        this.setScopeManager(translationResult.getScopeManager());
        this.setConfig(translationResult.getConfig());
        this.setWalker(new SubgraphWalker.ScopedWalker(this.getScopeManager()));
        this.getWalker().registerHandler((arg_0, arg_1, arg_2) -> CallResolver.accept$lambda$0(this, arg_0, arg_1, arg_2));
        this.getWalker().registerHandler((arg_0, arg_1) -> CallResolver.accept$lambda$1(this, arg_0, arg_1));
        this.getWalker().registerHandler((arg_0, arg_1) -> CallResolver.accept$lambda$2(this, arg_0, arg_1));
        this.getWalker().registerHandler((arg_0, arg_1, arg_2) -> CallResolver.accept$lambda$3(this, arg_0, arg_1, arg_2));
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            this.getWalker().iterate(tu);
        }
        this.getWalker().clearCallbacks();
        this.getWalker().registerHandler((arg_0, arg_1) -> CallResolver.accept$lambda$4(this, arg_0, arg_1));
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            this.getWalker().iterate(tu);
        }
        this.getWalker().clearCallbacks();
        this.getWalker().registerHandler((arg_0, arg_1) -> CallResolver.accept$lambda$5(this, arg_0, arg_1));
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            this.getWalker().iterate(tu);
        }
    }

    private final void registerMethods(RecordDeclaration currentClass, Node currentNode) {
        if (currentNode instanceof MethodDeclaration && currentClass != null) {
            Map<FunctionDeclaration, Type> map = this.containingType;
            Node node = currentNode;
            Type type = TypeParser.createFrom(currentClass.getName(), currentClass.getLanguage());
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"createFrom(currentClass.\u2026e, currentClass.language)");
            Type type2 = type;
            map.put((FunctionDeclaration)node, type2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void fixInitializers(Node node) {
        if (node instanceof VariableDeclaration) {
            Name typeString = ((VariableDeclaration)node).getType().getRoot().getName();
            if (this.getRecordMap().containsKey(typeString)) {
                Expression currInitializer = ((VariableDeclaration)node).getInitializer();
                if (currInitializer == null && ((VariableDeclaration)node).isImplicitInitializerAllowed()) {
                    ConstructExpression initializer2 = ExpressionBuilderKt.newConstructExpression$default(node, typeString, typeString + "()", null, 4, null);
                    initializer2.setImplicit(true);
                    ((VariableDeclaration)node).setInitializer(initializer2);
                    List<Node> list2 = ((VariableDeclaration)node).getTemplateParameters();
                    if (list2 != null) {
                        List<Node> it = list2;
                        boolean bl = false;
                        Companion.addImplicitTemplateParametersToCall(it, initializer2);
                    }
                } else if (!(currInitializer instanceof ConstructExpression) && currInitializer instanceof CallExpression && Intrinsics.areEqual((Object)((CallExpression)currInitializer).getName().getLocalName(), (Object)((VariableDeclaration)node).getType().getRoot().getName().getLocalName())) {
                    void $this$mapTo$iv$iv;
                    List<Expression> arguments2 = ((CallExpression)currInitializer).getArguments();
                    Iterable $this$map$iv = arguments2;
                    boolean $i$f$map = false;
                    Iterable bl = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void p0;
                        Node node2 = (Node)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(p0.getCode());
                    }
                    String signature2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                    ConstructExpression initializer3 = ExpressionBuilderKt.newConstructExpression$default(node, typeString, typeString + "(" + signature2 + ")", null, 4, null);
                    Collection $this$toTypedArray$iv = arguments2;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    Expression[] expressionArray = thisCollection$iv.toArray(new Expression[0]);
                    initializer3.setArguments(CollectionsKt.mutableListOf((Object[])Arrays.copyOf(expressionArray, expressionArray.length)));
                    initializer3.setImplicit(true);
                    ((VariableDeclaration)node).setInitializer(initializer3);
                    ((CallExpression)currInitializer).disconnectFromGraph();
                }
            }
        }
    }

    protected final void handleNode(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Node node2 = node;
        if (node2 instanceof TranslationUnitDeclaration) {
            this.setCurrentTU((TranslationUnitDeclaration)node);
        } else if (node2 instanceof ExplicitConstructorInvocation) {
            this.handleExplicitConstructorInvocation((ExplicitConstructorInvocation)node);
        } else if (node2 instanceof ConstructExpression) {
            this.handleArguments((CallExpression)node);
            this.handleConstructExpression((ConstructExpression)node);
        } else if (node2 instanceof CallExpression) {
            this.handleArguments((CallExpression)node);
            this.handleCallExpression(this.getScopeManager().getCurrentRecord(), (CallExpression)node);
        }
    }

    private final void handleCallExpression(RecordDeclaration curClass, CallExpression call) {
        List list2;
        Expression expression = call.getCallee();
        if ((expression != null ? expression.getType() : null) instanceof FunctionPointerType) {
            return;
        }
        Expression callee = call.getCallee();
        if (call.instantiatesTemplate() && call.getLanguage() instanceof HasTemplates) {
            List candidates;
            Language<? extends LanguageFrontend> language = call.getLanguage();
            Intrinsics.checkNotNull(language, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.frontends.HasTemplates");
            list2 = candidates = (List)((HasTemplates)((Object)language)).handleTemplateFunctionCalls(curClass, call, true, this.getScopeManager(), this.getCurrentTU()).component2();
        } else {
            list2 = this.resolveCallee(callee, curClass, call);
            if (list2 == null) {
                return;
            }
        }
        List candidates = list2;
        if (candidates.isEmpty()) {
            Set<Type> suitableBases = this.getPossibleContainingTypes(call);
            candidates = suitableBases.isEmpty() ? CollectionsKt.listOf((Object)InferenceKt.inferFunction$default(this.getCurrentTU(), call, false, 2, null)) : this.createMethodDummies(suitableBases, call);
        }
        call.setInvokes(candidates);
        if (callee instanceof DeclaredReferenceExpression) {
            ((DeclaredReferenceExpression)callee).setRefersTo((Declaration)CollectionsKt.firstOrNull(candidates));
        }
    }

    private final List<FunctionDeclaration> resolveCallee(Expression callee, RecordDeclaration curClass, CallExpression call) {
        List<FunctionDeclaration> list2;
        Expression expression = callee;
        if (expression instanceof MemberExpression) {
            list2 = this.resolveMemberCallee((DeclaredReferenceExpression)callee, curClass, call);
        } else if (expression instanceof DeclaredReferenceExpression) {
            list2 = this.resolveReferenceCallee((DeclaredReferenceExpression)callee, curClass, call);
        } else if (expression == null) {
            Util.warnWithFileLocation(call, Pass.Companion.getLog(), "Call expression without callee, maybe because of a parsing error", new Object[0]);
            list2 = null;
        } else {
            Util.errorWithFileLocation(call, Pass.Companion.getLog(), "Could not resolve callee of unsupported type " + callee.getClass(), new Object[0]);
            list2 = null;
        }
        return list2;
    }

    private final void handleArguments(CallExpression call) {
        Deque worklist = new ArrayDeque();
        Iterable $this$forEach$iv = call.getArguments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Expression it = (Expression)element$iv;
            boolean bl = false;
            worklist.push(it);
        }
        while (!worklist.isEmpty()) {
            Iterator<Node> it;
            Node curr = (Node)worklist.pop();
            if (curr instanceof CallExpression) {
                this.handleNode(curr);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue(Strategy.AST_FORWARD(curr), (String)"AST_FORWARD(curr)");
            while (it.hasNext()) {
                Node astChild = it.next();
                if (astChild instanceof RecordDeclaration) continue;
                worklist.push(astChild);
            }
        }
    }

    private final List<FunctionDeclaration> resolveReferenceCallee(DeclaredReferenceExpression callee, RecordDeclaration curClass, CallExpression call) {
        Language<? extends LanguageFrontend> language = call.getLanguage();
        if (curClass == null) {
            List candidates = language instanceof HasComplexCallResolution ? ((HasComplexCallResolution)((Object)language)).refineNormalCallResolution(call, this.getScopeManager(), this.getCurrentTU()) : CollectionsKt.toMutableList((Collection)ScopeManager.resolveFunction$default(this.getScopeManager(), call, null, 2, null));
            return candidates;
        }
        return this.resolveMemberCallee(callee, curClass, call);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FunctionDeclaration> resolveMemberCallee(@NotNull DeclaredReferenceExpression callee, @Nullable RecordDeclaration curClass, @NotNull CallExpression call) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable records2;
        Set<Type> possibleContainingTypes;
        List invocationCandidates;
        Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (callee instanceof MemberExpression && ((MemberExpression)callee).getBase() instanceof DeclaredReferenceExpression) {
            Expression expression = ((MemberExpression)callee).getBase();
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression");
            if (this.isSuperclassReference((DeclaredReferenceExpression)expression)) {
                MemberExpression memberExpression = (MemberExpression)callee;
                RecordDeclaration recordDeclaration = curClass;
                Intrinsics.checkNotNull((Object)recordDeclaration);
                JavaCallResolverHelperKt.handleSuperCall(this, memberExpression, recordDeclaration);
            }
        }
        if ((invocationCandidates = this.retrieveInvocationCandidatesFromCall(call, curClass, possibleContainingTypes = this.getPossibleContainingTypes(call))).isEmpty() && ((CharSequence)callee.getName().getLocalName()).length() > 0 && (!(callee.getLanguage() instanceof CPPLanguage) || this.shouldSearchForInvokesInParent(call))) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = possibleContainingTypes;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                RecordDeclaration it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Type it = (Type)element$iv$iv;
                boolean bl2 = false;
                if (this.getRecordMap().get(it.getRoot().getName()) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            records2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            invocationCandidates = CollectionsKt.toMutableList((Collection)this.getInvocationCandidatesFromParents(callee.getName().getLocalName(), call, (Set<RecordDeclaration>)records2));
        }
        records2 = invocationCandidates;
        List list2 = invocationCandidates;
        boolean $i$f$map = false;
        void $i$f$mapNotNull = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FunctionDeclaration $i$f$forEach = (FunctionDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getOverridingCandidates(possibleContainingTypes, (FunctionDeclaration)it));
        }
        list2.addAll(CollectionsKt.toMutableList((Collection)CollectionsKt.flatten((Iterable)((List)destination$iv$iv))));
        return invocationCandidates;
    }

    private final List<FunctionDeclaration> retrieveInvocationCandidatesFromCall(CallExpression call, RecordDeclaration curClass, Set<? extends Type> possibleContainingTypes) {
        List list2;
        if (call.getLanguage() instanceof HasComplexCallResolution) {
            Language<? extends LanguageFrontend> language = call.getLanguage();
            Intrinsics.checkNotNull(language, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.frontends.HasComplexCallResolution");
            list2 = CollectionsKt.toMutableList((Collection)((HasComplexCallResolution)((Object)language)).refineMethodCallResolution(curClass, possibleContainingTypes, call, this.getScopeManager(), this.getCurrentTU(), this));
        } else {
            list2 = CollectionsKt.toMutableList((Collection)ScopeManager.resolveFunction$default(this.getScopeManager(), call, null, 2, null));
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FunctionDeclaration> createMethodDummies(Set<? extends Type> possibleContainingTypes, CallExpression call) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = possibleContainingTypes;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            RecordDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            Type it = (Type)element$iv$iv;
            boolean bl2 = false;
            RecordDeclaration record = this.getRecordMap().get(it.getRoot().getName());
            if (record == null) {
                Object object2 = this.getConfig();
                boolean bl3 = object2 != null && (object2 = ((TranslationConfiguration)object2).getInferenceConfiguration()) != null ? ((InferenceConfiguration)object2).getInferRecords() : false;
                if (bl3 && (record = Inference.inferRecordDeclaration$default(InferenceKt.startInference(it), it, this.getCurrentTU(), null, 4, null)) != null) {
                    this.getRecordMap().put(it.getRoot().getName(), record);
                }
            }
            if (record == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void record;
            object = (RecordDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(InferenceKt.inferMethod$default((RecordDeclaration)record, call, false, 2, null));
        }
        return (List)destination$iv$iv;
    }

    private final boolean shouldSearchForInvokesInParent(CallExpression call) {
        return this.getScopeManager().resolveFunctionStopScopeTraversalOnDefinition(call).isEmpty();
    }

    private final void handleConstructExpression(ConstructExpression constructExpression) {
        Name typeName = constructExpression.getType().getName();
        RecordDeclaration recordDeclaration = this.getRecordMap().get(typeName);
        constructExpression.setInstantiates(recordDeclaration);
        for (TemplateDeclaration template : this.getTemplateList()) {
            int defaultDifference;
            if (!(template instanceof ClassTemplateDeclaration) || recordDeclaration == null || !template.getRealizations().contains(recordDeclaration) || constructExpression.getTemplateParameters().size() > template.getParameters().size() || (defaultDifference = template.getParameters().size() - constructExpression.getTemplateParameters().size()) > template.getParameterDefaults().size()) continue;
            TemplateCallResolverHelperKt.addRecursiveDefaultTemplateArgs(constructExpression, (ClassTemplateDeclaration)template);
            List<Node> missingNewParams = template.getParameterDefaults().subList(constructExpression.getTemplateParameters().size(), template.getParameterDefaults().size());
            for (Node missingParam : missingNewParams) {
                if (missingParam == null) continue;
                constructExpression.addTemplateParameter(missingParam, TemplateDeclaration.TemplateInitialization.DEFAULT);
            }
            constructExpression.setTemplateInstantiation(template);
            break;
        }
        if (recordDeclaration != null) {
            ConstructorDeclaration constructor = this.getConstructorDeclaration(constructExpression, recordDeclaration);
            constructExpression.setConstructor(constructor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleExplicitConstructorInvocation(ExplicitConstructorInvocation eci) {
        if (eci.getContainingClass() != null) {
            void $this$mapTo$iv$iv;
            Map<Name, RecordDeclaration> map = this.getRecordMap();
            LanguageProvider languageProvider = eci;
            String string = eci.getContainingClass();
            Intrinsics.checkNotNull((Object)string);
            RecordDeclaration recordDeclaration = map.get(NameKt.parseName(languageProvider, string));
            Iterable $this$map$iv = eci.getArguments();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Expression expression = (Expression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getType());
            }
            List signature2 = (List)destination$iv$iv;
            if (recordDeclaration != null) {
                ConstructorDeclaration constructor = this.getConstructorDeclarationForExplicitInvocation(signature2, recordDeclaration);
                List invokes = new ArrayList();
                invokes.add(constructor);
                eci.setInvokes(invokes);
            }
        }
    }

    private final Set<Type> getPossibleContainingTypes(Node node) {
        Set possibleTypes;
        block1: {
            block0: {
                possibleTypes = new LinkedHashSet();
                if (!(node instanceof MemberCallExpression)) break block0;
                Expression expression = ((MemberCallExpression)node).getBase();
                Intrinsics.checkNotNull((Object)expression);
                Expression base = expression;
                Type type = base.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"base.type");
                possibleTypes.add(type);
                List<Type> list2 = base.getPossibleSubTypes();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"base.possibleSubTypes");
                possibleTypes.addAll((Collection)list2);
                break block1;
            }
            Node node2 = this.getScopeManager().getCurrentRecord();
            if (node2 == null || (node2 = node2.toType()) == null) break block1;
            Node it = node2;
            boolean bl = false;
            possibleTypes.add(it);
        }
        return possibleTypes;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FunctionDeclaration> getInvocationCandidatesFromRecord(@Nullable RecordDeclaration recordDeclaration, @Nullable String name2, @NotNull CallExpression call) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (recordDeclaration == null) {
            return CollectionsKt.emptyList();
        }
        String string = Pattern.quote(recordDeclaration.getName().toString());
        Language<? extends LanguageFrontend> language = recordDeclaration.getLanguage();
        Intrinsics.checkNotNull(language);
        Pattern namePattern = Pattern.compile("(" + string + Regex.Companion.escape(language.getNamespaceDelimiter()) + ")?" + Pattern.quote(name2));
        if (call.getLanguage() instanceof HasComplexCallResolution) {
            Language<? extends LanguageFrontend> language2 = call.getLanguage();
            Intrinsics.checkNotNull(language2, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.frontends.HasComplexCallResolution");
            HasComplexCallResolution hasComplexCallResolution = (HasComplexCallResolution)((Object)language2);
            Intrinsics.checkNotNullExpressionValue((Object)namePattern, (String)"namePattern");
            list2 = hasComplexCallResolution.refineInvocationCandidatesFromRecord(recordDeclaration, call, namePattern);
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = recordDeclaration.getMethods();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MethodDeclaration it = (MethodDeclaration)element$iv$iv;
                boolean bl = false;
                if (!(namePattern.matcher(it.getName()).matches() && it.hasSignature(call.getSignature()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FunctionDeclaration> getInvocationCandidatesFromParents(String name2, CallExpression call, Set<RecordDeclaration> possibleTypes) {
        List list2;
        Collection $this$toTypedArray$iv = possibleTypes;
        boolean $i$f$toTypedArray = false;
        Iterable thisCollection$iv = $this$toTypedArray$iv;
        RecordDeclaration[] recordDeclarationArray = thisCollection$iv.toArray(new RecordDeclaration[0]);
        Set workingPossibleTypes = SetsKt.mutableSetOf((Object[])Arrays.copyOf(recordDeclarationArray, recordDeclarationArray.length));
        if (possibleTypes.isEmpty()) {
            list2 = CollectionsKt.emptyList();
        } else {
            Collection collection;
            Collection collection2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = possibleTypes;
            boolean $i$f$map = false;
            thisCollection$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Iterator iterator = (RecordDeclaration)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add(this.getInvocationCandidatesFromRecord((RecordDeclaration)it, name2, call));
            }
            List firstLevelCandidates = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            if (call.getLanguage() instanceof CPPLanguage) {
                workingPossibleTypes.removeIf(arg_0 -> CallResolver.getInvocationCandidatesFromParents$lambda$16((Function1)new Function1<RecordDeclaration, Boolean>(name2){
                    final /* synthetic */ String $name;
                    {
                        this.$name = $name;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull RecordDeclaration recordDeclaration) {
                        Intrinsics.checkNotNullParameter((Object)recordDeclaration, (String)"recordDeclaration");
                        return !CXXCallResolverHelperKt.shouldContinueSearchInParent(recordDeclaration, this.$name);
                    }
                }, arg_0));
            }
            if ((collection2 = (Collection)firstLevelCandidates).isEmpty()) {
                Set it;
                Collection collection4;
                Iterable $this$mapTo$iv$iv2;
                Iterable $this$map$iv2;
                boolean bl = false;
                $this$mapTo$iv$iv = workingPossibleTypes;
                boolean $i$f$map2 = false;
                void $i$f$mapTo2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    RecordDeclaration recordDeclaration = (RecordDeclaration)item$iv$iv;
                    collection4 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection4.add(((RecordDeclaration)((Object)it)).getSuperTypeDeclarations());
                }
                $this$map$iv2 = (List)destination$iv$iv2;
                $i$f$map2 = false;
                $this$mapTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    it = (Set)item$iv$iv;
                    collection4 = destination$iv$iv2;
                    boolean bl3 = false;
                    collection4.add(this.getInvocationCandidatesFromParents(name2, call, it));
                }
                collection = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
            } else {
                collection = collection2;
            }
            list2 = (List)collection;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<FunctionDeclaration> getOverridingCandidates(Set<? extends Type> possibleSubTypes, FunctionDeclaration declaration) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = declaration.getOverriddenBy();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FunctionDeclaration f = (FunctionDeclaration)element$iv$iv;
            boolean bl = false;
            if (!possibleSubTypes.contains(this.containingType.get(f))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final ConstructorDeclaration getConstructorDeclarationDirectMatch(List<? extends Type> signature2, RecordDeclaration recordDeclaration) {
        for (ConstructorDeclaration constructor : recordDeclaration.getConstructors()) {
            if (!constructor.hasSignature(signature2)) continue;
            return constructor;
        }
        return null;
    }

    private final ConstructorDeclaration getConstructorDeclaration(ConstructExpression constructExpression, RecordDeclaration recordDeclaration) {
        ConstructorDeclaration constructorDeclaration;
        List<Type> signature2 = constructExpression.getSignature();
        ConstructorDeclaration constructorCandidate = this.getConstructorDeclarationDirectMatch(signature2, recordDeclaration);
        if (constructorCandidate == null && constructExpression.getLanguage() instanceof HasDefaultArguments) {
            constructorCandidate = CXXCallResolverHelperKt.resolveConstructorWithDefaults(constructExpression, signature2, recordDeclaration);
        }
        if (constructorCandidate == null && constructExpression.getLanguage() instanceof CPPLanguage) {
            constructorCandidate = CXXCallResolverHelperKt.resolveConstructorWithImplicitCast(constructExpression, recordDeclaration);
        }
        if ((constructorDeclaration = constructorCandidate) == null) {
            constructorDeclaration = InferenceKt.startInference(recordDeclaration).createInferredConstructor(constructExpression.getSignature());
        }
        return constructorDeclaration;
    }

    private final ConstructorDeclaration getConstructorDeclarationForExplicitInvocation(List<? extends Type> signature2, RecordDeclaration recordDeclaration) {
        ConstructorDeclaration constructorDeclaration;
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = recordDeclaration.getConstructors();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ConstructorDeclaration it = (ConstructorDeclaration)element$iv;
                boolean bl = false;
                if (!it.hasSignature(signature2)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((constructorDeclaration = (ConstructorDeclaration)v0) == null) {
            constructorDeclaration = InferenceKt.startInference(recordDeclaration).createInferredConstructor(signature2);
        }
        return constructorDeclaration;
    }

    private static final void accept$lambda$0(CallResolver this$0, RecordDeclaration recordDeclaration, Node node, Node currNode) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SubgraphWalker.ScopedWalker scopedWalker = this$0.getWalker();
        Intrinsics.checkNotNullExpressionValue((Object)currNode, (String)"currNode");
        scopedWalker.collectDeclarations(currNode);
    }

    private static final void accept$lambda$1(CallResolver this$0, Node node, RecordDeclaration recordDeclaration) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this$0.findRecords(node);
    }

    private static final void accept$lambda$2(CallResolver this$0, Node node, RecordDeclaration recordDeclaration) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this$0.findTemplates(node);
    }

    private static final void accept$lambda$3(CallResolver this$0, RecordDeclaration currentClass, Node node, Node currentNode) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)currentNode, (String)"currentNode");
        this$0.registerMethods(currentClass, currentNode);
    }

    private static final void accept$lambda$4(CallResolver this$0, Node node, RecordDeclaration recordDeclaration) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this$0.fixInitializers(node);
    }

    private static final void accept$lambda$5(CallResolver this$0, Node node, RecordDeclaration recordDeclaration) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this$0.handleNode(node);
    }

    private static final boolean getInvocationCandidatesFromParents$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Logger logger = LoggerFactory.getLogger(CallResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(CallResolver::class.java)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lde/fraunhofer/aisec/cpg/passes/CallResolver$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "addImplicitTemplateParametersToCall", "", "templateParams", "", "Lde/fraunhofer/aisec/cpg/graph/Node;", "constructExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ConstructExpression;", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        public final void addImplicitTemplateParametersToCall(@NotNull List<? extends Node> templateParams, @NotNull ConstructExpression constructExpression) {
            Intrinsics.checkNotNullParameter(templateParams, (String)"templateParams");
            Intrinsics.checkNotNullParameter((Object)constructExpression, (String)"constructExpression");
            for (Node node : templateParams) {
                if (node instanceof TypeExpression) {
                    CallExpression.addTemplateParameter$default(constructExpression, ExpressionBuilderKt.duplicate((TypeExpression)node, true), null, 2, null);
                    continue;
                }
                if (!(node instanceof Literal)) continue;
                CallExpression.addTemplateParameter$default(constructExpression, ExpressionBuilderKt.duplicate((Literal)node, true), null, 2, null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

