/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.helpers.IdentitySet;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.helpers.TriConsumer;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.processing.IVisitor;
import de.fraunhofer.aisec.cpg.processing.strategy.Strategy;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.ogm.annotation.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u001b\u001c\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\b\u0010\r\u001a\u0004\u0018\u00010\fJ\u001e\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\r\u001a\u00020\fH\u0002J\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002J\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\b\u0010\r\u001a\u0004\u0018\u00010\fJ\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "fieldCache", "Ljava/util/HashMap;", "", "", "Ljava/lang/reflect/Field;", "flattenAST", "Lde/fraunhofer/aisec/cpg/graph/Node;", "n", "flattenASTInternal", "", "identitySet", "", "getAllFields", "", "classType", "Ljava/lang/Class;", "getAstChildren", "node", "getEOGPathEdges", "Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$Border;", "refreshType", "Border", "IterativeGraphWalker", "ScopedWalker", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nSubgraphWalker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubgraphWalker.kt\nde/fraunhofer/aisec/cpg/helpers/SubgraphWalker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,519:1\n766#2:520\n857#2:521\n1747#2,3:522\n858#2:525\n766#2:526\n857#2:527\n1747#2,3:528\n858#2:531\n*S KotlinDebug\n*F\n+ 1 SubgraphWalker.kt\nde/fraunhofer/aisec/cpg/helpers/SubgraphWalker\n*L\n245#1:520\n245#1:521\n246#1:522,3\n245#1:525\n249#1:526\n249#1:527\n250#1:528,3\n249#1:531\n*E\n"})
public final class SubgraphWalker {
    @NotNull
    public static final SubgraphWalker INSTANCE = new SubgraphWalker();
    private static final Logger LOGGER = LoggerFactory.getLogger(SubgraphWalker.class);
    @NotNull
    private static final HashMap<String, List<Field>> fieldCache = new HashMap();

    private SubgraphWalker() {
    }

    private final Collection<Field> getAllFields(Class<?> classType) {
        if (classType.getSuperclass() != null) {
            String cacheKey = classType.getName();
            if (fieldCache.containsKey(cacheKey)) {
                List<Field> list2 = fieldCache.get(cacheKey);
                Intrinsics.checkNotNull(list2);
                return list2;
            }
            ArrayList<Field> fields2 = new ArrayList<Field>();
            Class<?> clazz = classType.getSuperclass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"classType.superclass");
            fields2.addAll(this.getAllFields(clazz));
            Field[] fieldArray = classType.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"classType.declaredFields");
            Field[] fieldArray2 = fieldArray;
            fields2.addAll(CollectionsKt.listOf((Object[])Arrays.copyOf(fieldArray2, fieldArray2.length)));
            Map map = fieldCache;
            Intrinsics.checkNotNullExpressionValue((Object)cacheKey, (String)"cacheKey");
            map.put(cacheKey, fields2);
            return fields2;
        }
        return new ArrayList();
    }

    @JvmStatic
    @NotNull
    public static final List<Node> getAstChildren(@Nullable Node node) {
        ArrayList children2 = new ArrayList();
        if (node == null) {
            return children2;
        }
        Class<?> classType = node.getClass();
        for (Field field : INSTANCE.getAllFields(classType)) {
            String[] stringArray;
            SubGraph subGraph = field.getAnnotation(SubGraph.class);
            if (subGraph == null || !CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray = subGraph.value(), stringArray.length)).contains("AST")) continue;
            try {
                List list2;
                field.trySetAccessible();
                List obj = field.get(node);
                field.setAccessible(false);
                if (obj == null) continue;
                boolean outgoing = true;
                if (field.getAnnotation(Relationship.class) != null) {
                    boolean bl = outgoing = field.getAnnotation(Relationship.class).direction() == Relationship.Direction.OUTGOING;
                }
                if (PropertyEdge.Companion.checkForPropertyEdge(field, (Object)obj)) {
                    obj = PropertyEdge.Companion.unwrap(obj, outgoing);
                }
                Intrinsics.checkNotNullExpressionValue((Object)obj, (String)"obj");
                if (list2 instanceof Node) {
                    children2.add(obj);
                    continue;
                }
                if (list2 instanceof Collection) {
                    List list3 = obj;
                    Intrinsics.checkNotNull(list3, (String)"null cannot be cast to non-null type kotlin.collections.Collection<de.fraunhofer.aisec.cpg.graph.Node>");
                    children2.addAll(list3);
                    continue;
                }
                List list4 = obj;
                Intrinsics.checkNotNullExpressionValue(list4, (String)"obj");
                throw new AnnotationFormatError("Found @field:SubGraph(\"AST\") on field of type " + list4.getClass() + " but can only used with node graph classes or collections of graph nodes");
            }
            catch (IllegalAccessException ex) {
                LOGGER.error("Error while retrieving AST children: {}", (Object)ex.getMessage());
            }
        }
        return children2;
    }

    @NotNull
    public final List<Node> flattenAST(@Nullable Node n) {
        if (n == null) {
            return new ArrayList();
        }
        IdentitySet identitySet = new IdentitySet();
        this.flattenASTInternal(identitySet, n);
        return identitySet.toSortedList();
    }

    private final void flattenASTInternal(Set<Node> identitySet, Node n) {
        if (!identitySet.add(n)) {
            return;
        }
        for (Node child : SubgraphWalker.getAstChildren(n)) {
            this.flattenASTInternal(identitySet, child);
        }
    }

    @NotNull
    public final Border getEOGPathEdges(@Nullable Node n) {
        boolean $i$f$any;
        Iterable $this$any$iv;
        Node node;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Border border = new Border();
        List<Node> flattedASTTree = this.flattenAST(n);
        List eogNodes2 = flattedASTTree.stream().filter(arg_0 -> SubgraphWalker.getEOGPathEdges$lambda$0(getEOGPathEdges.eogNodes.1.INSTANCE, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(eogNodes2, (String)"eogNodes");
        Iterable iterable = eogNodes2;
        Border border2 = border;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block8: {
                node = (Node)element$iv$iv;
                boolean bl2 = false;
                $this$any$iv = node.getPrevEOG();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Node prev = (Node)element$iv;
                        boolean bl3 = false;
                        if (!(!eogNodes2.contains(prev))) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        border2.setEntries((List)destination$iv$iv);
        $this$filter$iv = eogNodes2;
        border2 = border;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block9: {
                node = (Node)element$iv$iv;
                boolean bl4 = false;
                $this$any$iv = node.getNextEOG();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Node next = (Node)element$iv;
                        boolean bl5 = false;
                        if (!(!eogNodes2.contains(next))) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        border2.setExits((List)destination$iv$iv);
        return border;
    }

    public final void refreshType(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        node.accept(SubgraphWalker::refreshType$lambda$5, new IVisitor<Node>(){

            public void visit(@NotNull Node child) {
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                if (child instanceof HasType) {
                    ((HasType)((Object)child)).refreshType();
                }
            }
        });
    }

    private static final boolean getEOGPathEdges$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Iterator refreshType$lambda$5(Node x) {
        Node node = x;
        Intrinsics.checkNotNull((Object)node);
        return Strategy.AST_FORWARD(node);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$Border;", "", "()V", "entries", "", "Lde/fraunhofer/aisec/cpg/graph/Node;", "getEntries", "()Ljava/util/List;", "setEntries", "(Ljava/util/List;)V", "exits", "getExits", "setExits", "cpg-core"})
    public static final class Border {
        @NotNull
        private List<? extends Node> entries = new ArrayList();
        @NotNull
        private List<? extends Node> exits = new ArrayList();

        @NotNull
        public final List<Node> getEntries() {
            return this.entries;
        }

        public final void setEntries(@NotNull List<? extends Node> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
            this.entries = list2;
        }

        @NotNull
        public final List<Node> getExits() {
            return this.exits;
        }

        public final void setExits(@NotNull List<? extends Node> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
            this.exits = list2;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0005J\u0014\u0010\u0016\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bJ\u001c\u0010\u0018\u001a\u00020\u00122\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\rJ\u0014\u0010\u0019\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bR.\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0010\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$IterativeGraphWalker;", "", "()V", "<set-?>", "Ljava/util/Deque;", "Lde/fraunhofer/aisec/cpg/graph/Node;", "backlog", "getBacklog", "()Ljava/util/Deque;", "onNodeVisit", "", "Ljava/util/function/Consumer;", "onNodeVisit2", "Ljava/util/function/BiConsumer;", "onScopeExit", "todo", "Lkotlin/Pair;", "clearCallbacks", "", "getTodo", "iterate", "root", "registerOnNodeVisit", "callback", "registerOnNodeVisit2", "registerOnScopeExit", "cpg-core"})
    @SourceDebugExtension(value={"SMAP\nSubgraphWalker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubgraphWalker.kt\nde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$IterativeGraphWalker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,519:1\n1549#2:520\n1620#2,3:521\n*S KotlinDebug\n*F\n+ 1 SubgraphWalker.kt\nde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$IterativeGraphWalker\n*L\n376#1:520\n376#1:521,3\n*E\n"})
    public static final class IterativeGraphWalker {
        @Nullable
        private Deque<Pair<Node, Node>> todo;
        @Nullable
        private Deque<Node> backlog;
        @NotNull
        private final List<Consumer<Node>> onNodeVisit = new ArrayList();
        @NotNull
        private final List<BiConsumer<Node, Node>> onNodeVisit2 = new ArrayList();
        @NotNull
        private final List<Consumer<Node>> onScopeExit = new ArrayList();

        @Nullable
        public final Deque<Node> getBacklog() {
            return this.backlog;
        }

        public final void iterate(@NotNull Node root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.todo = new ArrayDeque();
            this.backlog = new ArrayDeque();
            Set seen = new LinkedHashSet();
            Deque<Pair<Node, Node>> deque = this.todo;
            if (deque != null) {
                deque.push((Pair<Node, Node>)new Pair((Object)root, null));
            }
            while (true) {
                Deque<Pair<Node, Node>> deque2 = this.todo;
                Intrinsics.checkNotNull(deque2, (String)"null cannot be cast to non-null type java.util.ArrayDeque<kotlin.Pair<de.fraunhofer.aisec.cpg.graph.Node, de.fraunhofer.aisec.cpg.graph.Node?>>");
                if (((ArrayDeque)deque2).isEmpty()) break;
                Deque<Pair<Node, Node>> deque3 = this.todo;
                Intrinsics.checkNotNull(deque3, (String)"null cannot be cast to non-null type java.util.ArrayDeque<kotlin.Pair<de.fraunhofer.aisec.cpg.graph.Node, de.fraunhofer.aisec.cpg.graph.Node?>>");
                Pair pair = (Pair)((ArrayDeque)deque3).pop();
                Node current = (Node)pair.component1();
                Node parent = (Node)pair.component2();
                Deque<Node> deque4 = this.backlog;
                Intrinsics.checkNotNull(deque4, (String)"null cannot be cast to non-null type java.util.ArrayDeque<de.fraunhofer.aisec.cpg.graph.Node>");
                if (!((ArrayDeque)deque4).isEmpty()) {
                    Deque<Node> deque5 = this.backlog;
                    Intrinsics.checkNotNull(deque5, (String)"null cannot be cast to non-null type java.util.ArrayDeque<de.fraunhofer.aisec.cpg.graph.Node>");
                    if (((Node)((ArrayDeque)deque5).peek()).equals(current)) {
                        Deque<Node> deque6 = this.backlog;
                        Intrinsics.checkNotNull(deque6, (String)"null cannot be cast to non-null type java.util.ArrayDeque<de.fraunhofer.aisec.cpg.graph.Node>");
                        Node exiting = (Node)((ArrayDeque)deque6).pop();
                        this.onScopeExit.forEach(arg_0 -> IterativeGraphWalker.iterate$lambda$0(exiting, arg_0));
                        continue;
                    }
                }
                Deque<Pair<Node, Node>> deque7 = this.todo;
                Intrinsics.checkNotNull(deque7, (String)"null cannot be cast to non-null type java.util.ArrayDeque<kotlin.Pair<de.fraunhofer.aisec.cpg.graph.Node, de.fraunhofer.aisec.cpg.graph.Node?>>");
                ((ArrayDeque)deque7).push(new Pair((Object)current, (Object)parent));
                this.onNodeVisit.forEach(arg_0 -> IterativeGraphWalker.iterate$lambda$1(current, arg_0));
                this.onNodeVisit2.forEach(arg_0 -> IterativeGraphWalker.iterate$lambda$2(current, parent, arg_0));
                List unseenChildren2 = SubgraphWalker.getAstChildren(current).stream().filter(Predicate.not(arg_0 -> IterativeGraphWalker.iterate$lambda$3((Function1)new Function1<Node, Boolean>((Set<Node>)seen){
                    final /* synthetic */ Set<Node> $seen;
                    {
                        this.$seen = $seen;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Node o) {
                        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                        return this.$seen.contains(o);
                    }
                }, arg_0))).collect(Collectors.toList());
                Intrinsics.checkNotNullExpressionValue(unseenChildren2, (String)"unseenChildren");
                seen.addAll(unseenChildren2);
                Stream stream = unseenChildren2.stream();
                Intrinsics.checkNotNullExpressionValue(stream, (String)"unseenChildren.stream()");
                Util.reverse(stream).forEach(arg_0 -> IterativeGraphWalker.iterate$lambda$4((Function1)new Function1<Node, Unit>(this, current){
                    final /* synthetic */ IterativeGraphWalker this$0;
                    final /* synthetic */ Node $current;
                    {
                        this.this$0 = $receiver;
                        this.$current = $current;
                        super(1);
                    }

                    public final void invoke(@NotNull Node child) {
                        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                        Deque deque = IterativeGraphWalker.access$getTodo$p(this.this$0);
                        Intrinsics.checkNotNull((Object)deque, (String)"null cannot be cast to non-null type java.util.ArrayDeque<kotlin.Pair<de.fraunhofer.aisec.cpg.graph.Node, de.fraunhofer.aisec.cpg.graph.Node?>>");
                        ((ArrayDeque)deque).push(new Pair((Object)child, (Object)this.$current));
                    }
                }, arg_0));
                Deque<Node> deque8 = this.backlog;
                Intrinsics.checkNotNull(deque8, (String)"null cannot be cast to non-null type java.util.ArrayDeque<de.fraunhofer.aisec.cpg.graph.Node>");
                ((ArrayDeque)deque8).push(current);
            }
        }

        public final void registerOnNodeVisit(@NotNull Consumer<Node> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.onNodeVisit.add(callback);
        }

        public final void registerOnNodeVisit2(@NotNull BiConsumer<Node, Node> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.onNodeVisit2.add(callback);
        }

        public final void registerOnScopeExit(@NotNull Consumer<Node> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.onScopeExit.add(callback);
        }

        public final void clearCallbacks() {
            this.onNodeVisit.clear();
            this.onScopeExit.clear();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Deque<Node> getTodo() {
            List list2;
            Deque<Pair<Node, Node>> deque = this.todo;
            if (deque != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = deque;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((Node)it.getFirst());
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = null;
            }
            Collection collection = list2;
            return new ArrayDeque(collection);
        }

        private static final void iterate$lambda$0(Node $exiting, Consumer c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            c.accept($exiting);
        }

        private static final void iterate$lambda$1(Node $current, Consumer c) {
            Intrinsics.checkNotNullParameter((Object)$current, (String)"$current");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            c.accept($current);
        }

        private static final void iterate$lambda$2(Node $current, Node $parent, BiConsumer c) {
            Intrinsics.checkNotNullParameter((Object)$current, (String)"$current");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            c.accept($current, $parent);
        }

        private static final boolean iterate$lambda$3(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final void iterate$lambda$4(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        public static final /* synthetic */ Deque access$getTodo$p(IterativeGraphWalker $this) {
            return $this.todo;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\fJ*\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u00182\u0006\u0010\u0019\u001a\u00020\f2\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u001bH\u0007J,\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\f2\u001a\u0010\u001d\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\nH\u0002J\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\fJ\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\fH\u0002J\"\u0010\"\u001a\u00020\u00142\u001a\u0010\u001d\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\nJ\u001c\u0010\"\u001a\u00020\u00142\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b0#R(\u0010\b\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\r\u001a \u0012\u0004\u0012\u00020\f\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\t0\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$ScopedWalker;", "", "lang", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "(Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;)V", "scopeManager", "Lde/fraunhofer/aisec/cpg/ScopeManager;", "(Lde/fraunhofer/aisec/cpg/ScopeManager;)V", "handlers", "", "Lde/fraunhofer/aisec/cpg/helpers/TriConsumer;", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "Lde/fraunhofer/aisec/cpg/graph/Node;", "nodeToParentBlockAndContainedValueDeclarations", "", "Lorg/apache/commons/lang3/tuple/Pair;", "Lde/fraunhofer/aisec/cpg/graph/declarations/ValueDeclaration;", "walker", "Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$IterativeGraphWalker;", "clearCallbacks", "", "collectDeclarations", "current", "getDeclarationForScope", "Ljava/util/Optional;", "scope", "predicate", "Ljava/util/function/Predicate;", "handleNode", "handler", "iterate", "root", "leaveScope", "exiting", "registerHandler", "Ljava/util/function/BiConsumer;", "cpg-core"})
    public static final class ScopedWalker {
        @NotNull
        private final Map<Node, org.apache.commons.lang3.tuple.Pair<Node, List<ValueDeclaration>>> nodeToParentBlockAndContainedValueDeclarations;
        @Nullable
        private IterativeGraphWalker walker;
        @NotNull
        private final ScopeManager scopeManager;
        @NotNull
        private final List<TriConsumer<RecordDeclaration, Node, Node>> handlers;

        public ScopedWalker(@NotNull LanguageFrontend lang) {
            Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
            this.nodeToParentBlockAndContainedValueDeclarations = new IdentityHashMap();
            this.handlers = new ArrayList();
            this.scopeManager = lang.getScopeManager();
        }

        public ScopedWalker(@NotNull ScopeManager scopeManager) {
            Intrinsics.checkNotNullParameter((Object)scopeManager, (String)"scopeManager");
            this.nodeToParentBlockAndContainedValueDeclarations = new IdentityHashMap();
            this.handlers = new ArrayList();
            this.scopeManager = scopeManager;
        }

        public final void clearCallbacks() {
            this.handlers.clear();
        }

        public final void registerHandler(@NotNull TriConsumer<RecordDeclaration, Node, Node> handler) {
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            this.handlers.add(handler);
        }

        public final void registerHandler(@NotNull BiConsumer<Node, RecordDeclaration> handler) {
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            this.handlers.add((arg_0, arg_1, arg_2) -> ScopedWalker.registerHandler$lambda$0(handler, arg_0, arg_1, arg_2));
        }

        public final void iterate(@NotNull Node root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.walker = new IterativeGraphWalker();
            this.handlers.forEach(arg_0 -> ScopedWalker.iterate$lambda$2(this, arg_0));
            IterativeGraphWalker iterativeGraphWalker = this.walker;
            Intrinsics.checkNotNull((Object)iterativeGraphWalker);
            iterativeGraphWalker.registerOnScopeExit(arg_0 -> ScopedWalker.iterate$lambda$3(this, arg_0));
            IterativeGraphWalker iterativeGraphWalker2 = this.walker;
            Intrinsics.checkNotNull((Object)iterativeGraphWalker2);
            iterativeGraphWalker2.iterate(root);
        }

        private final void handleNode(Node current, TriConsumer<RecordDeclaration, Node, Node> handler) {
            this.scopeManager.enterScopeIfExists(current);
            IterativeGraphWalker iterativeGraphWalker = this.walker;
            Intrinsics.checkNotNull((Object)iterativeGraphWalker);
            Deque<Node> deque = iterativeGraphWalker.getBacklog();
            Intrinsics.checkNotNull(deque);
            Node parent = deque.peek();
            handler.accept(this.scopeManager.getCurrentRecord(), parent, current);
        }

        private final void leaveScope(Node exiting) {
            this.scopeManager.leaveScope(exiting);
        }

        public final void collectDeclarations(@NotNull Node current) {
            block1: {
                Node parentBlock;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                    parentBlock = null;
                    IterativeGraphWalker iterativeGraphWalker = this.walker;
                    Intrinsics.checkNotNull((Object)iterativeGraphWalker);
                    Deque<Node> deque = iterativeGraphWalker.getBacklog();
                    Intrinsics.checkNotNull(deque);
                    for (Node node : deque) {
                        if (!(node instanceof RecordDeclaration) && !(node instanceof CompoundStatement) && !(node instanceof FunctionDeclaration) && !(node instanceof TranslationUnitDeclaration)) continue;
                        parentBlock = node;
                        break;
                    }
                    this.nodeToParentBlockAndContainedValueDeclarations.put(current, (org.apache.commons.lang3.tuple.Pair<Node, List<ValueDeclaration>>)new MutablePair((Object)parentBlock, new ArrayList()));
                    if (!(current instanceof ValueDeclaration)) break block1;
                    LOGGER.trace("Adding variable {}", (Object)current.getCode());
                    if (parentBlock != null) break block2;
                    LOGGER.warn("Parent block is empty during subgraph run");
                    break block1;
                }
                Object object = this.nodeToParentBlockAndContainedValueDeclarations.get(parentBlock);
                if (object == null || (object = (List)object.getRight()) == null) break block1;
                object.add(current);
            }
        }

        @Deprecated(message="The scope manager should be used instead.\n      ")
        @NotNull
        public final Optional<? extends ValueDeclaration> getDeclarationForScope(@NotNull Node scope, @NotNull Predicate<ValueDeclaration> predicate) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Node currentScope = scope;
            while (this.nodeToParentBlockAndContainedValueDeclarations.containsKey(scope)) {
                org.apache.commons.lang3.tuple.Pair<Node, List<ValueDeclaration>> entry;
                Intrinsics.checkNotNull(this.nodeToParentBlockAndContainedValueDeclarations.get(currentScope));
                for (ValueDeclaration val : (List)entry.getRight()) {
                    if (!predicate.test(val)) continue;
                    Optional<ValueDeclaration> optional = Optional.of(val);
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"of(`val`)");
                    return optional;
                }
                Object object = entry.getLeft();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"entry.left");
                currentScope = (Node)object;
            }
            Optional optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
            return optional;
        }

        private static final void registerHandler$lambda$0(BiConsumer $handler, RecordDeclaration currClass, Node node, Node currNode) {
            Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
            Intrinsics.checkNotNullParameter((Object)currNode, (String)"currNode");
            $handler.accept(currNode, currClass);
        }

        private static final void iterate$lambda$2$lambda$1(ScopedWalker this$0, TriConsumer $h, Node n) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$h, (String)"$h");
            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
            this$0.handleNode(n, $h);
        }

        private static final void iterate$lambda$2(ScopedWalker this$0, TriConsumer h) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)h, (String)"h");
            IterativeGraphWalker iterativeGraphWalker = this$0.walker;
            Intrinsics.checkNotNull((Object)iterativeGraphWalker);
            iterativeGraphWalker.registerOnNodeVisit(arg_0 -> ScopedWalker.iterate$lambda$2$lambda$1(this$0, h, arg_0));
        }

        private static final void iterate$lambda$3(ScopedWalker this$0, Node exiting) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)exiting, (String)"exiting");
            this$0.leaveScope(exiting);
        }
    }
}

