/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class CommonPath {
    private CommonPath() {
    }

    @Nullable
    public static File commonPath(Collection<File> paths) {
        File result;
        if (paths.isEmpty()) {
            return null;
        }
        StringBuilder longestPrefix = new StringBuilder();
        List splittedPaths = paths.stream().map(File::getAbsolutePath).map(p -> p.split(Pattern.quote(File.separator))).sorted(Comparator.comparingInt(s -> ((String[])s).length)).collect(Collectors.toList());
        String[] shortest = (String[])splittedPaths.get(0);
        int i = 0;
        while (i < shortest.length) {
            String part = shortest[i];
            int position = i++;
            if (!splittedPaths.stream().allMatch(p -> p[position].equals(part))) break;
            longestPrefix.append(part).append(File.separator);
        }
        if ((result = new File(longestPrefix.toString())).exists()) {
            return CommonPath.getNearestDirectory(result);
        }
        return null;
    }

    private static File getNearestDirectory(File file) {
        if (file.isDirectory()) {
            return file;
        }
        return CommonPath.getNearestDirectory(file.getParentFile());
    }
}

