/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.types;

import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.SecondOrderType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.Objects;

public class ReferenceType
extends Type
implements SecondOrderType {
    private Type reference;

    private ReferenceType() {
    }

    public ReferenceType(Type reference) {
        this.setLanguage(reference.getLanguage());
        this.setName(reference.getName().append("&"));
        this.reference = reference;
    }

    public ReferenceType(Type type, Type reference) {
        super(type);
        this.setLanguage(reference.getLanguage());
        this.setName(reference.getName().append("&"));
        this.reference = reference;
    }

    public ReferenceType(Type.Storage storage, Type.Qualifier qualifier, Type reference) {
        this.setName(reference.getName().append("&"));
        this.storage = storage != null ? storage : Type.Storage.AUTO;
        this.qualifier = qualifier;
        this.origin = Type.Origin.UNRESOLVED;
        this.reference = reference;
        this.setLanguage(reference.getLanguage());
    }

    @Override
    public Type reference(PointerType.PointerOrigin pointerOrigin) {
        return new PointerType(this, pointerOrigin);
    }

    @Override
    public Type dereference() {
        return this.reference.dereference();
    }

    @Override
    public Type duplicate() {
        return new ReferenceType(this, this.reference);
    }

    @Override
    public Type getElementType() {
        return this.reference;
    }

    @Override
    public void setElementType(Type reference) {
        this.reference = reference;
    }

    @Override
    public boolean isSimilar(Type t) {
        return t instanceof ReferenceType && ((ReferenceType)t).getElementType().equals(this) && super.isSimilar(t);
    }

    public void refreshName() {
        this.setName(this.reference.getName().append("&"));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReferenceType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReferenceType that = (ReferenceType)o;
        return Objects.equals(this.reference, that.reference);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.reference);
    }

    @Override
    public String toString() {
        return "ReferenceType{reference=" + this.reference + ", typeName='" + this.getName() + "', storage=" + this.getStorage() + ", qualifier=" + this.getQualifier() + ", origin=" + this.getTypeOrigin() + "}";
    }
}

