/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.types;

import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.types.SecondOrderType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.Objects;
import org.neo4j.ogm.annotation.Relationship;

public class PointerType
extends Type
implements SecondOrderType {
    @Relationship(value="ELEMENT_TYPE")
    private Type elementType;
    private PointerOrigin pointerOrigin;

    private PointerType() {
    }

    public PointerType(Type elementType, PointerOrigin pointerOrigin) {
        this.setLanguage(elementType.getLanguage());
        if (pointerOrigin == PointerOrigin.ARRAY) {
            this.setName(elementType.getName().append("[]"));
        } else {
            this.setName(elementType.getName().append("*"));
        }
        this.pointerOrigin = pointerOrigin;
        this.elementType = elementType;
    }

    public PointerType(Type type, Type elementType, PointerOrigin pointerOrigin) {
        super(type);
        this.setLanguage(elementType.getLanguage());
        if (pointerOrigin == PointerOrigin.ARRAY) {
            this.setName(elementType.getName().append("[]"));
        } else {
            this.setName(elementType.getName().append("*"));
        }
        this.pointerOrigin = pointerOrigin;
        this.elementType = elementType;
    }

    @Override
    public PointerType reference(PointerOrigin origin) {
        if (origin == null) {
            origin = PointerOrigin.ARRAY;
        }
        return new PointerType(this, origin);
    }

    @Override
    public Type dereference() {
        return this.elementType;
    }

    @Override
    public void refreshNames() {
        if (this.getElementType() instanceof PointerType) {
            this.getElementType().refreshNames();
        }
        Object localName = this.elementType.getName().getLocalName();
        localName = this.pointerOrigin == PointerOrigin.ARRAY ? (String)localName + "[]" : (String)localName + "*";
        Name fullTypeName = new Name((String)localName, this.elementType.getName().getParent(), this.elementType.getName().getDelimiter());
        this.setName(fullTypeName);
    }

    @Override
    public Type duplicate() {
        return new PointerType(this, this.elementType.duplicate(), this.pointerOrigin);
    }

    public boolean isArray() {
        return this.pointerOrigin == PointerOrigin.ARRAY;
    }

    @Override
    public boolean isSimilar(Type t) {
        if (!(t instanceof PointerType)) {
            return false;
        }
        PointerType pointerType = (PointerType)t;
        return this.getReferenceDepth() == pointerType.getReferenceDepth() && this.getElementType().isSimilar(pointerType.getRoot()) && super.isSimilar(t);
    }

    public PointerOrigin getPointerOrigin() {
        return this.pointerOrigin;
    }

    @Override
    public Type getElementType() {
        return this.elementType;
    }

    @Override
    public int getReferenceDepth() {
        int depth = 1;
        Type containedType = this.elementType;
        while (containedType instanceof PointerType) {
            ++depth;
            containedType = ((PointerType)containedType).getElementType();
        }
        return depth;
    }

    @Override
    public void setElementType(Type elementType) {
        this.elementType = elementType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PointerType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PointerType that = (PointerType)o;
        return Objects.equals(this.elementType, that.elementType) && Objects.equals((Object)this.pointerOrigin, (Object)that.pointerOrigin);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.elementType, this.pointerOrigin});
    }

    public static enum PointerOrigin {
        POINTER,
        ARRAY;

    }
}

