/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.types;

import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.neo4j.ogm.annotation.Relationship;

public class ObjectType
extends Type
implements HasType.SecondaryTypeEdge {
    private final Modifier modifier;
    private RecordDeclaration recordDeclaration = null;
    @Relationship(value="GENERICS", direction=Relationship.Direction.OUTGOING)
    private List<PropertyEdge<Type>> generics;

    @Override
    public void updateType(Collection<Type> typeState) {
        if (this.generics == null) {
            return;
        }
        for (Type t : this.getGenerics()) {
            for (Type t2 : typeState) {
                if (!t2.equals(t)) continue;
                this.replaceGenerics(t, t2);
            }
        }
    }

    public void replaceGenerics(Type oldType, Type newType) {
        if (this.generics == null) {
            return;
        }
        for (int i = 0; i < this.generics.size(); ++i) {
            PropertyEdge<Type> propertyEdge = this.generics.get(i);
            if (!propertyEdge.getEnd().equals(oldType)) continue;
            propertyEdge.setEnd(newType);
        }
    }

    public ObjectType(String typeName, Type.Storage storage, Type.Qualifier qualifier, List<Type> generics, Modifier modifier, boolean primitive, Language<? extends LanguageFrontend> language) {
        super(typeName, storage, qualifier, language);
        this.generics = PropertyEdge.transformIntoOutgoingPropertyEdgeList(generics, this);
        this.modifier = modifier;
        this.primitive = primitive;
        this.setLanguage(language);
    }

    public ObjectType(Type type, List<Type> generics, Modifier modifier, boolean primitive, Language<? extends LanguageFrontend> language) {
        super(type);
        this.setLanguage(language);
        this.generics = PropertyEdge.transformIntoOutgoingPropertyEdgeList(generics, this);
        this.modifier = modifier;
        this.primitive = primitive;
    }

    public ObjectType() {
        this.generics = new ArrayList<PropertyEdge<Type>>();
        this.modifier = Modifier.NOT_APPLICABLE;
        this.primitive = false;
    }

    public List<Type> getGenerics() {
        ArrayList<Type> genericValues = new ArrayList<Type>();
        for (PropertyEdge<Type> edge : this.generics) {
            genericValues.add(edge.getEnd());
        }
        return Collections.unmodifiableList(genericValues);
    }

    public List<PropertyEdge<Type>> getGenericPropertyEdges() {
        return this.generics;
    }

    public RecordDeclaration getRecordDeclaration() {
        return this.recordDeclaration;
    }

    public void setRecordDeclaration(RecordDeclaration recordDeclaration) {
        this.recordDeclaration = recordDeclaration;
    }

    @Override
    public PointerType reference(PointerType.PointerOrigin pointerOrigin) {
        return new PointerType(this, pointerOrigin);
    }

    public PointerType reference() {
        return new PointerType(this, PointerType.PointerOrigin.POINTER);
    }

    @Override
    public Type dereference() {
        return UnknownType.getUnknownType(this.getLanguage());
    }

    @Override
    public Type duplicate() {
        ObjectType newObject = new ObjectType(this, this.getGenerics(), this.modifier, this.primitive, this.getLanguage());
        newObject.setLanguage(this.getLanguage());
        return newObject;
    }

    public void setGenerics(List<Type> generics) {
        this.generics = PropertyEdge.transformIntoOutgoingPropertyEdgeList(generics, this);
    }

    public void addGeneric(Type generic) {
        PropertyEdge<Type> propertyEdge = new PropertyEdge<Type>(this, generic);
        propertyEdge.addProperty(Properties.INDEX, this.generics.size());
        this.generics.add(propertyEdge);
    }

    public void addGenerics(List<Type> generics) {
        for (Type generic : generics) {
            this.addGeneric(generic);
        }
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    @Override
    public boolean isSimilar(Type t) {
        return t instanceof ObjectType && this.getGenerics().equals(((ObjectType)t).getGenerics()) && super.isSimilar(t);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectType that = (ObjectType)o;
        return Objects.equals(this.getGenerics(), that.getGenerics()) && PropertyEdge.propertyEqualsList(this.generics, that.generics) && this.primitive == that.primitive && this.modifier.equals((Object)that.modifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.generics, this.modifier, this.primitive});
    }

    public static enum Modifier {
        SIGNED,
        UNSIGNED,
        NOT_APPLICABLE;

    }
}

