/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.AccessValues;
import de.fraunhofer.aisec.cpg.graph.AssignmentTarget;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.ogm.annotation.Relationship;

public class DeclaredReferenceExpression
extends Expression
implements HasType.TypeListener,
AssignmentTarget {
    @Relationship(value="REFERS_TO")
    @Nullable
    private Declaration refersTo;
    private AccessValues access = AccessValues.READ;
    private boolean staticAccess = false;

    public boolean isStaticAccess() {
        return this.staticAccess;
    }

    public void setStaticAccess(boolean staticAccess) {
        this.staticAccess = staticAccess;
    }

    @Nullable
    public Declaration getRefersTo() {
        return this.refersTo;
    }

    @Nullable
    public <T extends VariableDeclaration> T getRefersToAs(Class<T> clazz) {
        if (this.refersTo == null) {
            return null;
        }
        return (T)(clazz.isAssignableFrom(this.refersTo.getClass()) ? (VariableDeclaration)clazz.cast(this.refersTo) : null);
    }

    public AccessValues getAccess() {
        return this.access;
    }

    public void setRefersTo(@Nullable Declaration refersTo) {
        if (refersTo == null) {
            return;
        }
        Declaration current = this.refersTo;
        if (current != null) {
            if (current instanceof ValueDeclaration) {
                ((ValueDeclaration)current).unregisterTypeListener(this);
            }
            if (current instanceof HasType.TypeListener) {
                this.unregisterTypeListener((HasType.TypeListener)((Object)current));
            }
        }
        this.refersTo = refersTo;
        if (refersTo instanceof ValueDeclaration) {
            ((ValueDeclaration)refersTo).addUsage(this);
        }
        if (this.refersTo instanceof ValueDeclaration) {
            ((ValueDeclaration)this.refersTo).registerTypeListener(this);
        }
        if (this.refersTo instanceof HasType.TypeListener) {
            this.registerTypeListener((HasType.TypeListener)((Object)this.refersTo));
        }
    }

    @Override
    public void typeChanged(HasType src, List<HasType> root, Type oldType) {
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        Type previous = this.type;
        this.setType(src.getPropagationType(), root);
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, List<HasType> root) {
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        root.remove(this);
        ArrayList<Type> subTypes = new ArrayList<Type>(this.getPossibleSubTypes());
        subTypes.addAll(src.getPossibleSubTypes());
        this.setPossibleSubTypes(subTypes, root);
    }

    @Override
    @NotNull
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).append((Object)super.toString()).append("refersTo", (Object)this.refersTo).toString();
    }

    public void setAccess(AccessValues access) {
        this.access = access;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeclaredReferenceExpression)) {
            return false;
        }
        DeclaredReferenceExpression that = (DeclaredReferenceExpression)o;
        return super.equals(that) && Objects.equals(this.refersTo, that.refersTo);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

