/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.AccessValues;
import de.fraunhofer.aisec.cpg.graph.Assignment;
import de.fraunhofer.aisec.cpg.graph.AssignmentTarget;
import de.fraunhofer.aisec.cpg.graph.HasBase;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.ogm.annotation.Transient;

public class BinaryOperator
extends Expression
implements HasType.TypeListener,
Assignment,
HasBase {
    @SubGraph(value={"AST"})
    private Expression lhs;
    @SubGraph(value={"AST"})
    private Expression rhs;
    private String operatorCode;
    @Transient
    public static final List<String> compoundOperators = List.of("*=", "/=", "%=", "+=", "-=", "<<=", ">>=", "&=", "^=", "|=");

    public Expression getLhs() {
        return this.lhs;
    }

    public <T extends Expression> T getLhsAs(Class<T> clazz) {
        return (T)(clazz.isInstance(this.lhs) ? (Expression)clazz.cast(this.lhs) : null);
    }

    public void setLhs(Expression lhs2) {
        if (this.lhs != null) {
            this.disconnectOldLhs();
        }
        this.lhs = lhs2;
        if (lhs2 != null) {
            this.connectNewLhs(lhs2);
        }
    }

    private void connectNewLhs(Expression lhs2) {
        lhs2.registerTypeListener(this);
        if ("=".equals(this.operatorCode)) {
            if (lhs2 instanceof DeclaredReferenceExpression) {
                ((DeclaredReferenceExpression)lhs2).setAccess(AccessValues.WRITE);
            }
            if (lhs2 instanceof HasType.TypeListener) {
                this.registerTypeListener((HasType.TypeListener)((Object)lhs2));
                this.registerTypeListener((HasType.TypeListener)((Object)this.lhs));
            }
        } else if (compoundOperators.contains(this.operatorCode)) {
            if (lhs2 instanceof DeclaredReferenceExpression) {
                ((DeclaredReferenceExpression)lhs2).setAccess(AccessValues.READWRITE);
            }
            if (lhs2 instanceof HasType.TypeListener) {
                this.registerTypeListener((HasType.TypeListener)((Object)lhs2));
                this.registerTypeListener((HasType.TypeListener)((Object)this.lhs));
            }
        }
    }

    private void disconnectOldLhs() {
        this.lhs.unregisterTypeListener(this);
        if ("=".equals(this.operatorCode) && this.lhs instanceof HasType.TypeListener) {
            this.unregisterTypeListener((HasType.TypeListener)((Object)this.lhs));
        }
    }

    public Expression getRhs() {
        return this.rhs;
    }

    public <T extends Expression> T getRhsAs(Class<T> clazz) {
        return (T)(clazz.isInstance(this.rhs) ? (Expression)clazz.cast(this.rhs) : null);
    }

    public void setRhs(Expression rhs) {
        if (this.rhs != null) {
            this.disconnectOldRhs();
        }
        this.rhs = rhs;
        if (rhs != null) {
            this.connectNewRhs(rhs);
        }
    }

    private void connectNewRhs(Expression rhs) {
        rhs.registerTypeListener(this);
        if ("=".equals(this.operatorCode) && rhs instanceof HasType.TypeListener) {
            this.registerTypeListener((HasType.TypeListener)((Object)rhs));
        }
    }

    private void disconnectOldRhs() {
        this.rhs.unregisterTypeListener(this);
        if ("=".equals(this.operatorCode) && this.rhs instanceof HasType.TypeListener) {
            this.unregisterTypeListener((HasType.TypeListener)((Object)this.rhs));
        }
    }

    @Override
    public String getOperatorCode() {
        return this.operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }

    @Override
    public void typeChanged(HasType src, List<HasType> root, Type oldType) {
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        Type previous = this.type;
        if (this.operatorCode.equals("=")) {
            this.setType(src.getPropagationType(), root);
        } else if (this.lhs != null && "java.lang.String".equals(this.lhs.getType().toString()) || this.rhs != null && "java.lang.String".equals(this.rhs.getType().toString())) {
            this.getPossibleSubTypes().clear();
            this.setType(TypeParser.createFrom("java.lang.String", this.getLanguage()), root);
        } else if ((this.operatorCode.equals(".*") || this.operatorCode.equals("->*")) && src != null && src == this.rhs) {
            this.setType(src.getPropagationType(), root);
        }
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, List<HasType> root) {
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        ArrayList<Type> subTypes = new ArrayList<Type>(this.getPossibleSubTypes());
        subTypes.addAll(src.getPossibleSubTypes());
        this.setPossibleSubTypes(subTypes, root);
    }

    @Override
    @NotNull
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).append("lhs", (Object)(this.lhs == null ? "null" : this.lhs.getName())).append("rhs", (Object)(this.rhs == null ? "null" : this.rhs.getName())).append("operatorCode", (Object)this.operatorCode).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinaryOperator)) {
            return false;
        }
        BinaryOperator that = (BinaryOperator)o;
        return super.equals(that) && Objects.equals(this.lhs, that.lhs) && Objects.equals(this.rhs, that.rhs) && Objects.equals(this.operatorCode, that.operatorCode);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    @Nullable
    public AssignmentTarget getTarget() {
        return this.isAssignment() ? (this.lhs instanceof AssignmentTarget ? (AssignmentTarget)((Object)this.lhs) : null) : null;
    }

    @Override
    @Nullable
    public Expression getValue() {
        return this.isAssignment() ? this.rhs : null;
    }

    public boolean isAssignment() {
        return this.operatorCode.equals("=");
    }

    @Override
    @Nullable
    public Expression getBase() {
        if (this.operatorCode.equals(".*") || this.operatorCode.equals("->*")) {
            return this.lhs;
        }
        return null;
    }
}

