/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.StatementHolder;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.ogm.annotation.Relationship;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0006\"\u0004\b\u0007\u0010\bR*\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000b0\n8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lde/fraunhofer/aisec/cpg/graph/statements/CompoundStatement;", "Lde/fraunhofer/aisec/cpg/graph/statements/Statement;", "Lde/fraunhofer/aisec/cpg/graph/StatementHolder;", "()V", "isStaticBlock", "", "()Z", "setStaticBlock", "(Z)V", "statementEdges", "", "Lde/fraunhofer/aisec/cpg/graph/edge/PropertyEdge;", "getStatementEdges", "()Ljava/util/List;", "setStatementEdges", "(Ljava/util/List;)V", "equals", "other", "", "hashCode", "", "toString", "", "cpg-core"})
public final class CompoundStatement
extends Statement
implements StatementHolder {
    @Relationship(value="STATEMENTS", direction=Relationship.Direction.OUTGOING)
    @SubGraph(value={"AST"})
    @NotNull
    private List<PropertyEdge<Statement>> statementEdges = new ArrayList();
    private boolean isStaticBlock;

    @Override
    @NotNull
    public List<PropertyEdge<Statement>> getStatementEdges() {
        return this.statementEdges;
    }

    @Override
    public void setStatementEdges(@NotNull List<PropertyEdge<Statement>> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.statementEdges = list2;
    }

    public final boolean isStaticBlock() {
        return this.isStaticBlock;
    }

    public final void setStaticBlock(boolean bl) {
        this.isStaticBlock = bl;
    }

    @Override
    @NotNull
    public String toString() {
        String string = new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ToStringBuilder(this, TO\u2026er.toString()).toString()");
        return string;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompoundStatement)) {
            return false;
        }
        return super.equals(other) && Intrinsics.areEqual(this.getStatements(), ((CompoundStatement)other).getStatements()) && PropertyEdge.Companion.propertyEqualsList(this.getStatementEdges(), ((CompoundStatement)other).getStatementEdges());
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{super.hashCode(), this.getStatements()};
        return Objects.hash(objectArray);
    }

    @Override
    @NotNull
    public List<Statement> getStatements() {
        return StatementHolder.DefaultImpls.getStatements(this);
    }

    @Override
    public void setStatements(@NotNull List<? extends Statement> value) {
        StatementHolder.DefaultImpls.setStatements(this, value);
    }

    @Override
    public void addStatement(@NotNull Statement s) {
        StatementHolder.DefaultImpls.addStatement(this, s);
    }
}

