/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.scopes;

import de.fraunhofer.aisec.cpg.graph.DeclarationHolder;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TypedefDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.scopes.Scope;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.helpers.Util;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u000bJ\u0016\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lde/fraunhofer/aisec/cpg/graph/scopes/ValueDeclarationScope;", "Lde/fraunhofer/aisec/cpg/graph/scopes/Scope;", "astNode", "Lde/fraunhofer/aisec/cpg/graph/Node;", "(Lde/fraunhofer/aisec/cpg/graph/Node;)V", "getAstNode", "()Lde/fraunhofer/aisec/cpg/graph/Node;", "setAstNode", "typedefs", "", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "Lde/fraunhofer/aisec/cpg/graph/declarations/TypedefDeclaration;", "getTypedefs", "()Ljava/util/Map;", "valueDeclarations", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/ValueDeclaration;", "getValueDeclarations", "()Ljava/util/List;", "setValueDeclarations", "(Ljava/util/List;)V", "addDeclaration", "", "declaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/Declaration;", "addToAST", "", "addTypedef", "typedef", "addValueDeclaration", "valueDeclaration", "Companion", "cpg-core"})
public class ValueDeclarationScope
extends Scope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Node astNode;
    @NotNull
    private transient List<ValueDeclaration> valueDeclarations;
    @NotNull
    private final transient Map<Type, TypedefDeclaration> typedefs;
    @NotNull
    private static final Logger log;

    public ValueDeclarationScope(@Nullable Node astNode) {
        super(astNode);
        this.astNode = astNode;
        this.valueDeclarations = new ArrayList();
        this.typedefs = new LinkedHashMap();
    }

    @Override
    @Nullable
    public Node getAstNode() {
        return this.astNode;
    }

    @Override
    public void setAstNode(@Nullable Node node) {
        this.astNode = node;
    }

    @NotNull
    public final List<ValueDeclaration> getValueDeclarations() {
        return this.valueDeclarations;
    }

    public final void setValueDeclarations(@NotNull List<ValueDeclaration> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.valueDeclarations = list2;
    }

    @NotNull
    public final Map<Type, TypedefDeclaration> getTypedefs() {
        return this.typedefs;
    }

    public final void addTypedef(@NotNull TypedefDeclaration typedef) {
        Intrinsics.checkNotNullParameter((Object)typedef, (String)"typedef");
        this.typedefs.put(typedef.getAlias(), typedef);
    }

    public void addDeclaration(@NotNull Declaration declaration, boolean addToAST) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof ValueDeclaration) {
            this.addValueDeclaration((ValueDeclaration)declaration, addToAST);
        } else {
            Util.errorWithFileLocation(declaration, log, "A non ValueDeclaration can not be added to a DeclarationScope", new Object[0]);
        }
    }

    public final void addValueDeclaration(@NotNull ValueDeclaration valueDeclaration, boolean addToAST) {
        Intrinsics.checkNotNullParameter((Object)valueDeclaration, (String)"valueDeclaration");
        this.valueDeclarations.add(valueDeclaration);
        if (addToAST) {
            if (this.getAstNode() instanceof DeclarationHolder) {
                Node node = this.getAstNode();
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.DeclarationHolder");
                DeclarationHolder holder = (DeclarationHolder)((Object)node);
                holder.addDeclaration(valueDeclaration);
            } else {
                Util.errorWithFileLocation(valueDeclaration, log, "Trying to add a value declaration to a scope which does not have a declaration holder AST node", new Object[0]);
            }
        }
    }

    @NotNull
    protected static final Logger getLog() {
        return Companion.getLog();
    }

    static {
        Logger logger = LoggerFactory.getLogger(ValueDeclarationScope.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(ValueDeclarationScope::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lde/fraunhofer/aisec/cpg/graph/scopes/ValueDeclarationScope$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog$annotations", "getLog", "()Lorg/slf4j/Logger;", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLog() {
            return log;
        }

        @JvmStatic
        protected static /* synthetic */ void getLog$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

