/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.scopes;

import de.fraunhofer.aisec.cpg.graph.DeclarationHolder;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.scopes.ValueDeclarationScope;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0002R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lde/fraunhofer/aisec/cpg/graph/scopes/StructureDeclarationScope;", "Lde/fraunhofer/aisec/cpg/graph/scopes/ValueDeclarationScope;", "astNode", "Lde/fraunhofer/aisec/cpg/graph/Node;", "(Lde/fraunhofer/aisec/cpg/graph/Node;)V", "getAstNode", "()Lde/fraunhofer/aisec/cpg/graph/Node;", "setAstNode", "structureDeclarations", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/Declaration;", "getStructureDeclarations", "()Ljava/util/List;", "setStructureDeclarations", "(Ljava/util/List;)V", "addDeclaration", "", "declaration", "addToAST", "", "addStructureDeclaration", "cpg-core"})
public class StructureDeclarationScope
extends ValueDeclarationScope {
    @Nullable
    private Node astNode;
    @NotNull
    private transient List<Declaration> structureDeclarations;

    public StructureDeclarationScope(@Nullable Node astNode) {
        super(astNode);
        this.astNode = astNode;
        this.structureDeclarations = new ArrayList();
    }

    @Override
    @Nullable
    public final Node getAstNode() {
        return this.astNode;
    }

    @Override
    public final void setAstNode(@Nullable Node node) {
        this.astNode = node;
    }

    @NotNull
    public final List<Declaration> getStructureDeclarations() {
        return this.structureDeclarations;
    }

    public final void setStructureDeclarations(@NotNull List<Declaration> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.structureDeclarations = list2;
    }

    private final void addStructureDeclaration(Declaration declaration) {
        this.structureDeclarations.add(declaration);
        if (this.astNode instanceof DeclarationHolder) {
            Node node = this.astNode;
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.DeclarationHolder");
            DeclarationHolder holder = (DeclarationHolder)((Object)node);
            holder.addDeclaration(declaration);
        } else {
            ValueDeclarationScope.getLog().error("Trying to add a value declaration to a scope which does not have a declaration holder AST node");
        }
    }

    @Override
    public void addDeclaration(@NotNull Declaration declaration, boolean addToAST) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof ValueDeclaration) {
            this.addValueDeclaration((ValueDeclaration)declaration, addToAST);
        } else {
            this.addStructureDeclaration(declaration);
        }
    }
}

