/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.scopes;

import com.fasterxml.jackson.annotation.JsonBackReference;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.scopes.GlobalScope;
import de.fraunhofer.aisec.cpg.graph.scopes.LoopScope;
import de.fraunhofer.aisec.cpg.graph.scopes.SwitchScope;
import de.fraunhofer.aisec.cpg.graph.statements.LabelStatement;
import de.fraunhofer.aisec.cpg.helpers.NameConverter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.typeconversion.Convert;

@NodeEntity
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u001bJ\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u000203R \u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u0004\u0018\u00010\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R&\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR \u0010 \u001a\u0004\u0018\u00010!8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R \u0010&\u001a\u0004\u0018\u00010\u00008\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0010\"\u0004\b(\u0010)R\u001c\u0010*\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u00065"}, d2={"Lde/fraunhofer/aisec/cpg/graph/scopes/Scope;", "", "astNode", "Lde/fraunhofer/aisec/cpg/graph/Node;", "(Lde/fraunhofer/aisec/cpg/graph/Node;)V", "getAstNode", "()Lde/fraunhofer/aisec/cpg/graph/Node;", "setAstNode", "children", "", "getChildren", "()Ljava/util/List;", "setChildren", "(Ljava/util/List;)V", "globalScope", "getGlobalScope", "()Lde/fraunhofer/aisec/cpg/graph/scopes/Scope;", "id", "", "getId", "()Ljava/lang/Long;", "setId", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "labelStatements", "", "", "Lde/fraunhofer/aisec/cpg/graph/statements/LabelStatement;", "getLabelStatements", "()Ljava/util/Map;", "setLabelStatements", "(Ljava/util/Map;)V", "name", "Lde/fraunhofer/aisec/cpg/graph/Name;", "getName", "()Lde/fraunhofer/aisec/cpg/graph/Name;", "setName", "(Lde/fraunhofer/aisec/cpg/graph/Name;)V", "parent", "getParent", "setParent", "(Lde/fraunhofer/aisec/cpg/graph/scopes/Scope;)V", "scopedName", "getScopedName", "()Ljava/lang/String;", "setScopedName", "(Ljava/lang/String;)V", "addLabelStatement", "", "labelStatement", "isBreakable", "", "isContinuable", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Scope.kt\nde/fraunhofer/aisec/cpg/graph/scopes/Scope\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public abstract class Scope {
    @Relationship(value="SCOPE", direction=Relationship.Direction.INCOMING)
    @JsonBackReference
    @Nullable
    private Node astNode;
    @Id
    @GeneratedValue
    @Nullable
    private Long id;
    @Nullable
    private String scopedName;
    @Convert(value=NameConverter.class)
    @Nullable
    private Name name;
    @Relationship(value="PARENT", direction=Relationship.Direction.OUTGOING)
    @Nullable
    private Scope parent;
    @Relationship(value="PARENT", direction=Relationship.Direction.INCOMING)
    @NotNull
    private transient List<Scope> children;
    @NotNull
    private transient Map<String, LabelStatement> labelStatements;

    public Scope(@Nullable Node astNode) {
        this.astNode = astNode;
        this.children = new ArrayList();
        this.labelStatements = new LinkedHashMap();
    }

    @Nullable
    public Node getAstNode() {
        return this.astNode;
    }

    public void setAstNode(@Nullable Node node) {
        this.astNode = node;
    }

    @Nullable
    public final Long getId() {
        return this.id;
    }

    public final void setId(@Nullable Long l) {
        this.id = l;
    }

    @Nullable
    public final String getScopedName() {
        return this.scopedName;
    }

    public final void setScopedName(@Nullable String string) {
        this.scopedName = string;
    }

    @Nullable
    public final Name getName() {
        return this.name;
    }

    public final void setName(@Nullable Name name2) {
        this.name = name2;
    }

    @Nullable
    public final Scope getParent() {
        return this.parent;
    }

    public final void setParent(@Nullable Scope scope) {
        this.parent = scope;
    }

    @NotNull
    public final List<Scope> getChildren() {
        return this.children;
    }

    public final void setChildren(@NotNull List<Scope> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.children = list2;
    }

    @NotNull
    public final Map<String, LabelStatement> getLabelStatements() {
        return this.labelStatements;
    }

    public final void setLabelStatements(@NotNull Map<String, LabelStatement> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.labelStatements = map;
    }

    public final void addLabelStatement(@NotNull LabelStatement labelStatement) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)labelStatement, (String)"labelStatement");
            String string = labelStatement.getLabel();
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            this.labelStatements.put(it, labelStatement);
        }
    }

    public final boolean isBreakable() {
        return this instanceof LoopScope || this instanceof SwitchScope;
    }

    public final boolean isContinuable() {
        return this instanceof LoopScope;
    }

    @Nullable
    public final Scope getGlobalScope() {
        Scope scope = this;
        while (!(scope instanceof GlobalScope)) {
            if (scope == null) {
                return null;
            }
            scope = scope.parent;
        }
        return scope;
    }
}

