/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.declarations;

import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.types.FunctionPointerType;
import de.fraunhofer.aisec.cpg.graph.types.ReferenceType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.Transient;

public abstract class ValueDeclaration
extends Declaration
implements HasType {
    protected Type type = UnknownType.getUnknownType();
    protected List<Type> possibleSubTypes = new ArrayList<Type>();
    @Relationship(value="USAGE")
    protected List<PropertyEdge<DeclaredReferenceExpression>> usageEdges = new ArrayList<PropertyEdge<DeclaredReferenceExpression>>();
    @Transient
    private final Set<HasType.TypeListener> typeListeners = new HashSet<HasType.TypeListener>();

    @Override
    public Type getType() {
        Type result = TypeManager.isTypeSystemActive() ? (this.type != null ? this.type : UnknownType.getUnknownType()) : (Type)TypeManager.getInstance().getTypeCache().computeIfAbsent(this, n -> Collections.emptyList()).stream().findAny().orElse(UnknownType.getUnknownType());
        return result;
    }

    public List<DeclaredReferenceExpression> getUsages() {
        return PropertyEdge.unwrap(this.usageEdges, true);
    }

    public List<PropertyEdge<DeclaredReferenceExpression>> getUsageEdges() {
        return this.usageEdges;
    }

    public void setUsages(List<DeclaredReferenceExpression> usages) {
        this.usageEdges = usages.stream().map(ref -> {
            PropertyEdge<DeclaredReferenceExpression> edge = new PropertyEdge<DeclaredReferenceExpression>(this, (DeclaredReferenceExpression)ref);
            edge.addProperty(Properties.ACCESS, (Object)ref.getAccess());
            return edge;
        }).collect(Collectors.toList());
    }

    public void setUsageEdges(List<PropertyEdge<DeclaredReferenceExpression>> usageEdges) {
        this.usageEdges = usageEdges;
    }

    public void addUsageEdge(PropertyEdge<DeclaredReferenceExpression> usageEdge) {
        this.usageEdges.add(usageEdge);
    }

    public void addUsage(DeclaredReferenceExpression reference) {
        PropertyEdge<DeclaredReferenceExpression> usageEdge = new PropertyEdge<DeclaredReferenceExpression>(this, reference);
        usageEdge.addProperty(Properties.ACCESS, (Object)reference.getAccess());
        this.usageEdges.add(usageEdge);
    }

    @Override
    public Type getPropagationType() {
        if (this.type instanceof ReferenceType) {
            return ((ReferenceType)this.type).getElementType();
        }
        return this.getType();
    }

    @Override
    public void setType(Type type, List<HasType> root) {
        if (!TypeManager.isTypeSystemActive()) {
            TypeManager.getInstance().cacheType(this, type);
            return;
        }
        if (root == null) {
            root = new ArrayList<HasType>();
        }
        if (type == null || root.contains(this) || TypeManager.getInstance().isUnknown(type) || this.type instanceof FunctionPointerType && !(type instanceof FunctionPointerType)) {
            return;
        }
        Type oldType = this.type;
        type = type.duplicate();
        type.setQualifier(this.type.getQualifier().merge(type.getQualifier()));
        HashSet<Type> subTypes = new HashSet<Type>();
        for (Type t : this.getPossibleSubTypes()) {
            if (t.isSimilar(type)) continue;
            subTypes.add(t);
        }
        subTypes.add(type);
        this.type = TypeManager.getInstance().registerType(TypeManager.getInstance().getCommonType(subTypes, this).orElse(type));
        ArrayList<Type> newSubtypes = new ArrayList<Type>();
        for (Type s : subTypes) {
            if (!TypeManager.getInstance().isSupertypeOf(this.type, s, this)) continue;
            newSubtypes.add(TypeManager.getInstance().registerType(s));
        }
        this.setPossibleSubTypes(newSubtypes);
        if (Objects.equals(oldType, type)) {
            return;
        }
        root.add(this);
        for (HasType.TypeListener l : this.typeListeners) {
            if (l.equals(this)) continue;
            l.typeChanged(this, root, oldType);
        }
    }

    @Override
    public void resetTypes(Type type) {
        List<Type> oldSubTypes = this.getPossibleSubTypes();
        Type oldType = this.type;
        this.type = type;
        this.setPossibleSubTypes(List.of(type));
        ArrayList<ValueDeclaration> root = new ArrayList<ValueDeclaration>(List.of(this));
        if (!Objects.equals(oldType, type)) {
            this.typeListeners.stream().filter(l -> !l.equals(this)).forEach(l -> l.typeChanged(this, root, oldType));
        }
        if (oldSubTypes.size() != 1 || !oldSubTypes.contains(type)) {
            this.typeListeners.stream().filter(l -> !l.equals(this)).forEach(l -> l.possibleSubTypesChanged(this, root));
        }
    }

    @Override
    public void registerTypeListener(HasType.TypeListener listener) {
        ArrayList<HasType> root = new ArrayList<HasType>(List.of(this));
        this.typeListeners.add(listener);
        listener.typeChanged(this, root, this.type);
        listener.possibleSubTypesChanged(this, root);
    }

    @Override
    public void unregisterTypeListener(HasType.TypeListener listener) {
        this.typeListeners.remove(listener);
    }

    @Override
    public Set<HasType.TypeListener> getTypeListeners() {
        return this.typeListeners;
    }

    @Override
    public List<Type> getPossibleSubTypes() {
        if (!TypeManager.isTypeSystemActive()) {
            return TypeManager.getInstance().getTypeCache().getOrDefault(this, Collections.emptyList());
        }
        return this.possibleSubTypes;
    }

    @Override
    public void setPossibleSubTypes(List<Type> possibleSubTypes, @NotNull List<HasType> root) {
        possibleSubTypes = possibleSubTypes.stream().filter(Predicate.not(TypeManager.getInstance()::isUnknown)).distinct().collect(Collectors.toList());
        if (!TypeManager.isTypeSystemActive()) {
            possibleSubTypes.forEach(t -> TypeManager.getInstance().cacheType(this, (Type)t));
            return;
        }
        if (root.contains(this)) {
            return;
        }
        List<Type> oldSubTypes = this.possibleSubTypes;
        this.possibleSubTypes = possibleSubTypes;
        if (new HashSet<Type>(oldSubTypes).containsAll(this.getPossibleSubTypes())) {
            return;
        }
        root.add(this);
        for (HasType.TypeListener listener : this.typeListeners) {
            if (listener.equals(this)) continue;
            listener.possibleSubTypesChanged(this, root);
        }
    }

    @Override
    public void refreshType() {
        ArrayList<HasType> root = new ArrayList<HasType>(List.of(this));
        for (HasType.TypeListener l : this.typeListeners) {
            l.typeChanged(this, root, this.type);
            l.possibleSubTypesChanged(this, root);
        }
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValueDeclaration)) {
            return false;
        }
        ValueDeclaration that = (ValueDeclaration)o;
        return super.equals(that) && Objects.equals(this.type, that.type) && Objects.equals(this.possibleSubTypes, that.possibleSubTypes);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void updateType(Type type) {
        this.type = type;
    }

    @Override
    public void updatePossibleSubtypes(List<Type> types2) {
        this.possibleSubTypes = types2;
    }
}

