/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.declarations;

import de.fraunhofer.aisec.cpg.graph.HasInitializer;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.ogm.annotation.Relationship;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010 \u001a\u00020\u00122\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0002J\b\u0010#\u001a\u00020$H\u0016J\u001e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020(0\u001aH\u0016J\b\u0010*\u001a\u00020\u001bH\u0016J&\u0010+\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020(0\u001a2\u0006\u0010,\u001a\u00020-H\u0016R\u001e\u0010\u0005\u001a\u00020\u00008F@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR*\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0016@VX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006."}, d2={"Lde/fraunhofer/aisec/cpg/graph/declarations/FieldDeclaration;", "Lde/fraunhofer/aisec/cpg/graph/declarations/ValueDeclaration;", "Lde/fraunhofer/aisec/cpg/graph/HasType$TypeListener;", "Lde/fraunhofer/aisec/cpg/graph/HasInitializer;", "()V", "definition", "getDefinition", "()Lde/fraunhofer/aisec/cpg/graph/declarations/FieldDeclaration;", "setDefinition", "(Lde/fraunhofer/aisec/cpg/graph/declarations/FieldDeclaration;)V", "value", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "initializer", "getInitializer", "()Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "setInitializer", "(Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;)V", "isArray", "", "()Z", "setArray", "(Z)V", "isDefinition", "isImplicitInitializerAllowed", "setImplicitInitializerAllowed", "modifiers", "", "", "getModifiers", "()Ljava/util/List;", "setModifiers", "(Ljava/util/List;)V", "equals", "other", "", "hashCode", "", "possibleSubTypesChanged", "", "src", "Lde/fraunhofer/aisec/cpg/graph/HasType;", "root", "toString", "typeChanged", "oldType", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "cpg-core"})
public final class FieldDeclaration
extends ValueDeclaration
implements HasType.TypeListener,
HasInitializer {
    @SubGraph(value={"AST"})
    @Nullable
    private Expression initializer;
    private boolean isDefinition;
    @Relationship(value="DEFINES")
    @NotNull
    private FieldDeclaration definition = this;
    private boolean isImplicitInitializerAllowed;
    private boolean isArray;
    @NotNull
    private List<String> modifiers = new ArrayList();

    @Override
    @Nullable
    public Expression getInitializer() {
        return this.initializer;
    }

    @Override
    public void setInitializer(@Nullable Expression value) {
        if (this.initializer != null) {
            this.isDefinition = true;
            Expression expression = this.initializer;
            if (expression != null) {
                expression.unregisterTypeListener(this);
            }
            if (this.initializer instanceof HasType.TypeListener) {
                Expression expression2 = this.initializer;
                Intrinsics.checkNotNull((Object)expression2, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.HasType.TypeListener");
                this.unregisterTypeListener((HasType.TypeListener)((Object)expression2));
            }
        }
        this.initializer = value;
        if (value != null) {
            value.registerTypeListener(this);
            if (value instanceof HasType.TypeListener) {
                this.registerTypeListener((HasType.TypeListener)((Object)value));
            }
        }
    }

    @NotNull
    public final FieldDeclaration getDefinition() {
        return this.isDefinition ? this : this.definition;
    }

    public final void setDefinition(@NotNull FieldDeclaration fieldDeclaration) {
        Intrinsics.checkNotNullParameter((Object)fieldDeclaration, (String)"<set-?>");
        this.definition = fieldDeclaration;
    }

    public final boolean isImplicitInitializerAllowed() {
        return this.isImplicitInitializerAllowed;
    }

    public final void setImplicitInitializerAllowed(boolean bl) {
        this.isImplicitInitializerAllowed = bl;
    }

    public final boolean isArray() {
        return this.isArray;
    }

    public final void setArray(boolean bl) {
        this.isArray = bl;
    }

    @NotNull
    public final List<String> getModifiers() {
        return this.modifiers;
    }

    public final void setModifiers(@NotNull List<String> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.modifiers = list2;
    }

    public void typeChanged(@NotNull HasType src, @NotNull List<? extends HasType> root, @NotNull Type oldType) {
        Type type;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter(root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)oldType, (String)"oldType");
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        if (!TypeManager.getInstance().isUnknown(this.type) && Intrinsics.areEqual((Object)src.getPropagationType(), (Object)oldType)) {
            return;
        }
        Type previous = this.type;
        if (src == this.getInitializer() && this.getInitializer() instanceof InitializerListExpression) {
            if (this.isArray) {
                type = src.getType();
            } else {
                if (!TypeManager.getInstance().isUnknown(this.type)) {
                    return;
                }
                type = src.getType().dereference();
            }
        } else {
            type = src.getPropagationType();
        }
        Type newType = type;
        this.setType(newType, root);
        if (!Intrinsics.areEqual((Object)previous, (Object)this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    public void possibleSubTypesChanged(@NotNull HasType src, @NotNull List<? extends HasType> root) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter(root, (String)"root");
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        List subTypes = new ArrayList(this.getPossibleSubTypes());
        List<Type> list2 = src.getPossibleSubTypes();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"src.possibleSubTypes");
        subTypes.addAll((Collection)list2);
        this.setPossibleSubTypes(subTypes, root);
    }

    @Override
    @NotNull
    public String toString() {
        String string = new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("initializer", (Object)this.getInitializer()).append("modifiers", this.modifiers).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ToStringBuilder(this, TO\u2026)\n            .toString()");
        return string;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FieldDeclaration)) {
            return false;
        }
        return super.equals(other) && Intrinsics.areEqual((Object)this.getInitializer(), (Object)((FieldDeclaration)other).getInitializer()) && Intrinsics.areEqual(this.modifiers, ((FieldDeclaration)other).modifiers);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{super.hashCode(), this.getInitializer(), this.modifiers};
        return Objects.hash(objectArray);
    }
}

