/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.cpp.CLanguage;
import de.fraunhofer.aisec.cpg.graph.DeclarationBuilderKt;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.LanguageProvider;
import de.fraunhofer.aisec.cpg.graph.MetadataProvider;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.ScopeProvider;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TypedefDeclaration;
import de.fraunhofer.aisec.cpg.graph.scopes.NameScope;
import de.fraunhofer.aisec.cpg.graph.scopes.RecordScope;
import de.fraunhofer.aisec.cpg.graph.scopes.Scope;
import de.fraunhofer.aisec.cpg.graph.scopes.TemplateScope;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.ParameterizedType;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.ReferenceType;
import de.fraunhofer.aisec.cpg.graph.types.SecondOrderType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import de.fraunhofer.aisec.cpg.graph.types.WrapState;
import de.fraunhofer.aisec.cpg.helpers.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeManager {
    private static final Logger log = LoggerFactory.getLogger(TypeManager.class);
    private static final Pattern funPointerPattern = Pattern.compile("\\(?\\*(?<alias>[^()]+)\\)?\\(.*\\)");
    @NotNull
    private static TypeManager instance = new TypeManager();
    private static boolean typeSystemActive = true;
    @NotNull
    private final Map<HasType, List<Type>> typeCache = Collections.synchronizedMap(new IdentityHashMap());
    @NotNull
    private final Map<Type, RecordDeclaration> typeToRecord = Collections.synchronizedMap(new HashMap());
    @NotNull
    private final Map<RecordDeclaration, List<ParameterizedType>> recordToTypeParameters = Collections.synchronizedMap(new HashMap());
    @NotNull
    private final Map<TemplateDeclaration, List<ParameterizedType>> templateToTypeParameters = Collections.synchronizedMap(new HashMap());
    @NotNull
    private final Map<Type, List<Type>> typeState = Collections.synchronizedMap(new HashMap());
    private final Set<Type> firstOrderTypes = Collections.synchronizedSet(new HashSet());
    private final Set<Type> secondOrderTypes = Collections.synchronizedSet(new HashSet());

    public static void reset() {
        instance = new TypeManager();
    }

    @Nullable
    public ParameterizedType getTypeParameter(RecordDeclaration recordDeclaration, String name2) {
        if (this.recordToTypeParameters.containsKey(recordDeclaration)) {
            for (ParameterizedType parameterizedType : this.recordToTypeParameters.get(recordDeclaration)) {
                if (!parameterizedType.getName().toString().equals(name2)) continue;
                return parameterizedType;
            }
        }
        return null;
    }

    public void addTypeParameter(RecordDeclaration recordDeclaration, List<ParameterizedType> typeParameters) {
        this.recordToTypeParameters.put(recordDeclaration, typeParameters);
    }

    @Nullable
    public ParameterizedType getTypeParameter(TemplateDeclaration templateDeclaration, String name2) {
        if (this.templateToTypeParameters.containsKey(templateDeclaration)) {
            for (ParameterizedType parameterizedType : this.templateToTypeParameters.get(templateDeclaration)) {
                if (!parameterizedType.getName().toString().equals(name2)) continue;
                return parameterizedType;
            }
        }
        return null;
    }

    @NotNull
    public List<ParameterizedType> getAllParameterizedType(TemplateDeclaration templateDeclaration) {
        if (this.templateToTypeParameters.containsKey(templateDeclaration)) {
            return this.templateToTypeParameters.get(templateDeclaration);
        }
        return new ArrayList<ParameterizedType>();
    }

    public ParameterizedType searchTemplateScopeForDefinedParameterizedTypes(Scope scope, String name2) {
        TemplateDeclaration template;
        ParameterizedType parameterizedType;
        Node node;
        if (scope instanceof TemplateScope && (node = scope.getAstNode()) instanceof TemplateDeclaration && (parameterizedType = this.getTypeParameter(template = (TemplateDeclaration)node, name2)) != null) {
            return parameterizedType;
        }
        return scope.getParent() != null ? this.searchTemplateScopeForDefinedParameterizedTypes(scope.getParent(), name2) : null;
    }

    public void addTypeParameter(TemplateDeclaration templateDeclaration, ParameterizedType typeParameter) {
        if (this.templateToTypeParameters.containsKey(templateDeclaration)) {
            this.templateToTypeParameters.get(templateDeclaration).add(typeParameter);
        } else {
            ArrayList<ParameterizedType> typeParameters = new ArrayList<ParameterizedType>();
            typeParameters.add(typeParameter);
            this.templateToTypeParameters.put(templateDeclaration, typeParameters);
        }
    }

    public ParameterizedType createOrGetTypeParameter(TemplateDeclaration templateDeclaration, String typeName, Language<? extends LanguageFrontend> language) {
        ParameterizedType parameterizedType = this.getTypeParameter(templateDeclaration, typeName);
        if (parameterizedType != null) {
            return parameterizedType;
        }
        parameterizedType = new ParameterizedType(typeName, language);
        this.addTypeParameter(templateDeclaration, parameterizedType);
        return parameterizedType;
    }

    @NotNull
    public Map<Type, List<Type>> getTypeState() {
        return this.typeState;
    }

    public <T extends Type> T registerType(T t) {
        if (t.isFirstOrderType()) {
            this.firstOrderTypes.add(t);
        } else {
            this.secondOrderTypes.add(t);
            this.registerType(((SecondOrderType)((Object)t)).getElementType());
        }
        return t;
    }

    public Set<Type> getFirstOrderTypes() {
        return this.firstOrderTypes;
    }

    public Set<Type> getSecondOrderTypes() {
        return this.secondOrderTypes;
    }

    public boolean typeExists(String name2) {
        return this.firstOrderTypes.stream().anyMatch(type -> type.getRoot().getName().toString().equals(name2));
    }

    private TypeManager() {
    }

    @NotNull
    public static TypeManager getInstance() {
        return instance;
    }

    public static boolean isTypeSystemActive() {
        return typeSystemActive;
    }

    public static void setTypeSystemActive(boolean active) {
        typeSystemActive = active;
    }

    @NotNull
    public Map<HasType, List<Type>> getTypeCache() {
        return this.typeCache;
    }

    public synchronized void cacheType(HasType node, Type type) {
        List types2;
        if (!this.isUnknown(type) && !(types2 = this.typeCache.computeIfAbsent(node, n -> new ArrayList())).contains(type)) {
            types2.add(type);
        }
    }

    public static boolean isPrimitive(Type type, Language<? extends LanguageFrontend> language) {
        return language.getPrimitiveTypes().contains(type.getTypeName());
    }

    public boolean isUnknown(Type type) {
        return type instanceof UnknownType;
    }

    public boolean containsParameterizedType(List<Type> generics) {
        for (Type t : generics) {
            if (!(t instanceof ParameterizedType)) continue;
            return true;
        }
        return false;
    }

    public boolean stopPropagation(Type type, Type newType) {
        if (type instanceof ObjectType && newType instanceof ObjectType && ((ObjectType)type).getGenerics() != null && ((ObjectType)newType).getGenerics() != null && type.getName().equals(newType.getName())) {
            return this.containsParameterizedType(((ObjectType)newType).getGenerics()) && !this.containsParameterizedType(((ObjectType)type).getGenerics());
        }
        return false;
    }

    private Optional<Type> rewrapType(Type type, int depth, PointerType.PointerOrigin[] pointerOrigins, boolean reference, ReferenceType referenceType) {
        if (depth > 0) {
            for (int i = depth - 1; i >= 0; --i) {
                type = type.reference(pointerOrigins[i]);
            }
        }
        if (reference) {
            referenceType.setElementType(type);
            return Optional.of(referenceType);
        }
        return Optional.of(type);
    }

    private Set<Type> unwrapTypes(Collection<Type> types2, WrapState wrapState) {
        Type t2;
        HashSet<Type> original = new HashSet<Type>(types2);
        HashSet<Type> unwrappedTypes = new HashSet<Type>();
        PointerType.PointerOrigin[] pointerOrigins = new PointerType.PointerOrigin[]{};
        int depth = 0;
        int counter = 0;
        boolean reference = false;
        ReferenceType referenceType = null;
        Type t1 = types2.stream().findAny().orElse(null);
        if (t1 instanceof ReferenceType) {
            for (Type t : types2) {
                referenceType = (ReferenceType)t;
                if (!referenceType.isSimilar(t)) {
                    return Collections.emptySet();
                }
                unwrappedTypes.add(((ReferenceType)t).getElementType());
                reference = true;
            }
            types2 = unwrappedTypes;
        }
        if ((t2 = (Type)types2.stream().findAny().orElse(null)) instanceof PointerType) {
            for (Type t : types2) {
                if (counter == 0) {
                    depth = t.getReferenceDepth();
                    ++counter;
                }
                if (t.getReferenceDepth() != depth) {
                    return Collections.emptySet();
                }
                unwrappedTypes.add(t.getRoot());
                pointerOrigins = new PointerType.PointerOrigin[depth];
                Type containedType = t2;
                int i = 0;
                pointerOrigins[i] = ((PointerType)containedType).getPointerOrigin();
                while (containedType instanceof PointerType) {
                    if (!((containedType = ((PointerType)containedType).getElementType()) instanceof PointerType)) continue;
                    pointerOrigins[++i] = ((PointerType)containedType).getPointerOrigin();
                }
            }
        }
        wrapState.setDepth(depth);
        wrapState.setPointerOrigin(pointerOrigins);
        wrapState.setReference(reference);
        wrapState.setReferenceType(referenceType);
        if (unwrappedTypes.isEmpty() && !original.isEmpty()) {
            return original;
        }
        return unwrappedTypes;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Optional<Type> getCommonType(@NotNull Collection<Type> types2, ScopeProvider provider) {
        void var8_11;
        boolean sameType;
        boolean bl = sameType = types2.stream().map(t -> t.getClass().getCanonicalName()).collect(Collectors.toSet()).size() == 1;
        if (!sameType) {
            return Optional.empty();
        }
        WrapState wrapState = new WrapState();
        if ((types2 = this.unwrapTypes(types2, wrapState)).isEmpty()) {
            return Optional.empty();
        }
        if (types2.size() == 1) {
            return this.rewrapType(types2.iterator().next(), wrapState.getDepth(), wrapState.getPointerOrigins(), wrapState.isReference(), wrapState.getReferenceType());
        }
        Scope scope = provider.getScope();
        if (scope == null) {
            return Optional.empty();
        }
        Scope globalScope = provider.getScope().getGlobalScope();
        if (globalScope == null) {
            return Optional.empty();
        }
        for (Scope scope2 : globalScope.getChildren()) {
            if (scope2 instanceof RecordScope && scope2.getAstNode() instanceof RecordDeclaration) {
                this.typeToRecord.put(((RecordDeclaration)scope2.getAstNode()).toType(), (RecordDeclaration)scope2.getAstNode());
            }
            if (!(scope2 instanceof NameScope)) continue;
            for (Scope child2 : scope2.getChildren()) {
                if (!(child2 instanceof RecordScope) || !(child2.getAstNode() instanceof RecordDeclaration)) continue;
                this.typeToRecord.put(((RecordDeclaration)child2.getAstNode()).toType(), (RecordDeclaration)child2.getAstNode());
            }
        }
        List allAncestors = types2.stream().map(t -> this.typeToRecord.getOrDefault(t, null)).filter(Objects::nonNull).map(r -> this.getAncestors((RecordDeclaration)r, 0)).collect(Collectors.toList());
        for (Set ancestors : allAncestors) {
            Optional<Ancestor> farthest = ancestors.stream().max(Comparator.comparingInt(Ancestor::getDepth));
            if (!farthest.isPresent()) continue;
            int maxDepth = farthest.get().getDepth();
            ancestors.forEach(a -> a.setDepth(maxDepth - a.getDepth()));
        }
        HashSet hashSet = new HashSet();
        for (int i = 0; i < allAncestors.size(); ++i) {
            if (i == 0) {
                var8_11.addAll((Collection)allAncestors.get(i));
                continue;
            }
            Set others = (Set)allAncestors.get(i);
            HashSet newCommonAncestors = new HashSet();
            for (Ancestor curr : var8_11) {
                Optional<Ancestor> toRetain = others.stream().filter(a -> a.equals(curr)).map(a -> curr.getDepth() >= a.getDepth() ? curr : a).findFirst();
                toRetain.ifPresent(newCommonAncestors::add);
            }
            HashSet hashSet2 = newCommonAncestors;
        }
        Optional<Ancestor> lca = var8_11.stream().max(Comparator.comparingInt(Ancestor::getDepth));
        Optional<Type> commonType = lca.map(a -> TypeParser.createFrom(a.getRecord().getName(), a.getRecord().getLanguage()));
        if (!commonType.isPresent()) {
            return commonType;
        }
        Type finalType = commonType.get();
        return this.rewrapType(finalType, wrapState.getDepth(), wrapState.getPointerOrigins(), wrapState.isReference(), wrapState.getReferenceType());
    }

    private Set<Ancestor> getAncestors(RecordDeclaration recordDeclaration, int depth) {
        if (recordDeclaration.getSuperTypes().isEmpty()) {
            HashSet<Ancestor> ret = new HashSet<Ancestor>();
            ret.add(new Ancestor(recordDeclaration, depth));
            return ret;
        }
        Set<Ancestor> ancestors = recordDeclaration.getSuperTypes().stream().map(s -> this.typeToRecord.getOrDefault(s, null)).filter(Objects::nonNull).map(s -> this.getAncestors((RecordDeclaration)s, depth + 1)).flatMap(Collection::stream).collect(Collectors.toSet());
        ancestors.add(new Ancestor(recordDeclaration, depth));
        return ancestors;
    }

    public boolean isSupertypeOf(Type superType, Type subType, MetadataProvider provider) {
        Language<? extends LanguageFrontend> language = null;
        if (superType.getReferenceDepth() != subType.getReferenceDepth()) {
            return false;
        }
        if (provider instanceof LanguageProvider) {
            LanguageProvider languageProvider = (LanguageProvider)provider;
            language = languageProvider.getLanguage();
        }
        if (language instanceof CLanguage && this.checkArrayAndPointer(superType, subType)) {
            return true;
        }
        if (superType instanceof ReferenceType) {
            ReferenceType referenceType = (ReferenceType)superType;
            return this.isSupertypeOf(referenceType.getElementType(), subType, provider);
        }
        if (!(provider instanceof ScopeProvider)) {
            return false;
        }
        ScopeProvider scopeProvider = (ScopeProvider)provider;
        Optional<Type> commonType = this.getCommonType(new HashSet<Type>(List.of(superType, subType)), scopeProvider);
        if (commonType.isPresent()) {
            return commonType.get().equals(superType);
        }
        try {
            Class<?> superCls = Class.forName(superType.getTypeName());
            Class<?> subCls = Class.forName(subType.getTypeName());
            return superCls.isAssignableFrom(subCls);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    public boolean checkArrayAndPointer(Type first, Type second) {
        int secondDepth;
        int firstDepth = first.getReferenceDepth();
        if (firstDepth == (secondDepth = second.getReferenceDepth())) {
            return first.getRoot().getName().equals(second.getRoot().getName()) && first.isSimilar(second);
        }
        return false;
    }

    public void cleanup() {
        this.typeToRecord.clear();
    }

    private Type getTargetType(Type currTarget, String alias) {
        if (alias.contains("(") && alias.contains("*")) {
            return TypeParser.createFrom(currTarget.getName() + " " + alias, currTarget.getLanguage());
        }
        if (alias.endsWith("]")) {
            return currTarget.reference(PointerType.PointerOrigin.ARRAY);
        }
        if (alias.contains("*")) {
            int depth = StringUtils.countMatches((CharSequence)alias, (char)'*');
            for (int i = 0; i < depth; ++i) {
                currTarget = currTarget.reference(PointerType.PointerOrigin.POINTER);
            }
            return currTarget;
        }
        return currTarget;
    }

    private Type getAlias(String alias, @NotNull Language<? extends LanguageFrontend> language) {
        if (alias.contains("(") && alias.contains("*")) {
            Matcher matcher = funPointerPattern.matcher(alias);
            if (matcher.find()) {
                return TypeParser.createIgnoringAlias(matcher.group("alias"), language);
            }
            log.error("Could not find alias name in function pointer typedef: {}", (Object)alias);
            return TypeParser.createIgnoringAlias(alias, language);
        }
        alias = alias.split("\\[")[0];
        alias = alias.replace("*", "");
        return TypeParser.createIgnoringAlias(alias, language);
    }

    @NotNull
    public Declaration createTypeAlias(@NotNull LanguageFrontend frontend, String rawCode, Type target, String aliasString) {
        String cleanedPart = Util.removeRedundantParentheses(aliasString);
        Type currTarget = this.getTargetType(target, cleanedPart);
        Type alias = this.getAlias(cleanedPart, frontend.getLanguage());
        if (alias instanceof SecondOrderType) {
            Type chain = alias.duplicate();
            chain.setRoot(currTarget);
            currTarget = chain;
            currTarget.refreshNames();
            alias = alias.getRoot();
        }
        TypedefDeclaration typedef = DeclarationBuilderKt.newTypedefDeclaration(frontend, currTarget, alias, rawCode);
        frontend.getScopeManager().addTypedef(typedef);
        return typedef;
    }

    public Type resolvePossibleTypedef(Type alias, ScopeManager scopeManager) {
        Type finalToCheck = alias.getRoot();
        Optional<Type> applicable = scopeManager.getCurrentTypedefs().stream().filter(t -> t.getAlias().getRoot().equals(finalToCheck)).findAny().map(TypedefDeclaration::getType);
        if (applicable.isEmpty()) {
            return alias;
        }
        return TypeParser.reWrapType(alias, applicable.get());
    }

    private static class Ancestor {
        private final RecordDeclaration recordDeclaration;
        private int depth;

        public Ancestor(RecordDeclaration recordDeclaration, int depth) {
            this.recordDeclaration = recordDeclaration;
            this.depth = depth;
        }

        public RecordDeclaration getRecord() {
            return this.recordDeclaration;
        }

        public int getDepth() {
            return this.depth;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public int hashCode() {
            return Objects.hash(this.recordDeclaration);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Ancestor)) {
                return false;
            }
            Ancestor ancestor = (Ancestor)o;
            return Objects.equals(this.recordDeclaration, ancestor.recordDeclaration);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).append("record", (Object)this.recordDeclaration.getName()).append("depth", this.depth).toString();
        }
    }
}

