/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.cpp;

import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.ProblemNode;
import de.fraunhofer.aisec.cpg.helpers.Util;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00060\u0005B\u001b\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0004\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/cpp/CXXHandler;", "S", "Lde/fraunhofer/aisec/cpg/graph/Node;", "T", "", "Lde/fraunhofer/aisec/cpg/frontends/Handler;", "Lde/fraunhofer/aisec/cpg/frontends/cpp/CXXLanguageFrontend;", "configConstructor", "Ljava/util/function/Supplier;", "lang", "(Ljava/util/function/Supplier;Lde/fraunhofer/aisec/cpg/frontends/cpp/CXXLanguageFrontend;)V", "handle", "ctx", "(Ljava/lang/Object;)Lde/fraunhofer/aisec/cpg/graph/Node;", "handleNode", "node", "handleNotSupported", "name", "", "(Ljava/lang/Object;Ljava/lang/String;)Lde/fraunhofer/aisec/cpg/graph/Node;", "cpg-core"})
public abstract class CXXHandler<S extends Node, T>
extends Handler<S, T, CXXLanguageFrontend> {
    public CXXHandler(@NotNull Supplier<S> configConstructor, @NotNull CXXLanguageFrontend lang) {
        Intrinsics.checkNotNullParameter(configConstructor, (String)"configConstructor");
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        super(configConstructor, (LanguageFrontend)lang);
    }

    @Override
    @Nullable
    public S handle(@NotNull T ctx) {
        ASTNode astNode;
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        if (!((CXXLanguageFrontend)this.getFrontend()).getConfig().getLoadIncludes() && ctx instanceof ASTNode && (astNode = (ASTNode)ctx).getFileLocation() != null && astNode.getFileLocation().getContextInclusionStatement() != null) {
            Handler.getLog().debug("Skip parsing include file" + astNode.getContainingFilename());
            return null;
        }
        S node = this.handleNode(ctx);
        if (node != null && ((Node)node).getLocation() == null) {
            ((CXXLanguageFrontend)this.getFrontend()).setCodeAndLocation(node, ctx);
        }
        ((CXXLanguageFrontend)this.getFrontend()).setComment(node, ctx);
        if (node != null) {
            ((CXXLanguageFrontend)this.getFrontend()).process(ctx, (Node)node);
        }
        return node;
    }

    @NotNull
    public abstract S handleNode(@NotNull T var1);

    @NotNull
    protected final S handleNotSupported(@NotNull T node, @NotNull String name2) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Object[] objectArray = new Object[]{name2};
        Util.errorWithFileLocation(this.getFrontend(), node, Handler.getLog(), "Parsing of type {} is not supported (yet)", objectArray);
        Object s = this.getConfigConstructor().get();
        Intrinsics.checkNotNullExpressionValue(s, (String)"this.configConstructor.get()");
        Node cpgNode = (Node)s;
        if (cpgNode instanceof ProblemNode) {
            ((ProblemNode)((Object)cpgNode)).setProblem("Parsing of type " + name2 + " is not supported (yet)");
        }
        return (S)cpgNode;
    }
}

