/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.statements.GotoStatement;
import de.fraunhofer.aisec.cpg.graph.statements.LabelStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\nH\u0016J$\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00012\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\tH\u0016J0\u0010\u0019\u001a\u00020\u00132\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\u00102\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\tH\u0016R \u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u00048\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\t0\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR6\u0010\u000f\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\t0\b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/ProcessedListener;", "", "()V", "interestingStatements", "", "Ljava/lang/Class;", "Lde/fraunhofer/aisec/cpg/graph/statements/Statement;", "objectListeners", "", "Ljava/util/function/BiConsumer;", "Lde/fraunhofer/aisec/cpg/graph/Node;", "getObjectListeners", "()Ljava/util/Map;", "setObjectListeners", "(Ljava/util/Map;)V", "predicateListeners", "Ljava/util/function/BiPredicate;", "processedMapping", "clearProcessed", "", "process", "from", "to", "registerObjectListener", "biConsumer", "registerPredicateListener", "predicate", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nProcessedListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessedListener.kt\nde/fraunhofer/aisec/cpg/frontends/ProcessedListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1747#2,3:120\n*S KotlinDebug\n*F\n+ 1 ProcessedListener.kt\nde/fraunhofer/aisec/cpg/frontends/ProcessedListener\n*L\n67#1:120,3\n*E\n"})
public class ProcessedListener {
    @JvmField
    @NotNull
    protected List<? extends Class<? extends Statement>> interestingStatements;
    @JvmField
    @NotNull
    protected Map<BiPredicate<Object, Node>, BiConsumer<Object, Node>> predicateListeners;
    @JvmField
    @NotNull
    protected Map<Object, Node> processedMapping;
    @NotNull
    private Map<Object, BiConsumer<Object, Node>> objectListeners;

    public ProcessedListener() {
        Object[] objectArray = new Class[]{GotoStatement.class, LabelStatement.class};
        this.interestingStatements = CollectionsKt.listOf((Object[])objectArray);
        this.predicateListeners = new LinkedHashMap();
        this.processedMapping = new LinkedHashMap();
        this.objectListeners = new LinkedHashMap();
    }

    @NotNull
    protected final Map<Object, BiConsumer<Object, Node>> getObjectListeners() {
        return this.objectListeners;
    }

    protected final void setObjectListeners(@NotNull Map<Object, BiConsumer<Object, Node>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.objectListeners = map;
    }

    public final void clearProcessed() {
        this.objectListeners.clear();
        this.predicateListeners.clear();
        this.processedMapping.clear();
    }

    public void process(@NotNull Object from2, @NotNull Node to2) {
        BiConsumer<Object, Node> listener;
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to2, (String)"to");
            Iterable $this$any$iv = this.interestingStatements;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object entry : $this$any$iv) {
                    Class c = (Class)entry;
                    boolean bl2 = false;
                    if (!(c.isInstance(from2) || c.isInstance(to2))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            this.processedMapping.put(from2, to2);
        }
        if ((listener = this.objectListeners.get(from2)) != null) {
            listener.accept(from2, to2);
            this.objectListeners.remove(from2);
        }
        Map newPredicateListeners = new LinkedHashMap();
        for (Map.Entry entry : this.predicateListeners.entrySet()) {
            BiPredicate key = (BiPredicate)entry.getKey();
            BiConsumer value = (BiConsumer)entry.getValue();
            if (key.test(from2, to2)) {
                value.accept(from2, to2);
                continue;
            }
            newPredicateListeners.put(key, value);
        }
        this.predicateListeners = newPredicateListeners;
    }

    public void registerObjectListener(@NotNull Object from2, @NotNull BiConsumer<Object, Node> biConsumer) {
        Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
        Intrinsics.checkNotNullParameter(biConsumer, (String)"biConsumer");
        if (this.processedMapping.containsKey(from2)) {
            Node node = this.processedMapping.get(from2);
            Intrinsics.checkNotNull((Object)node);
            biConsumer.accept(from2, node);
        }
        this.objectListeners.put(from2, biConsumer);
    }

    public void registerPredicateListener(@NotNull BiPredicate<Object, Node> predicate, @NotNull BiConsumer<Object, Node> biConsumer) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Intrinsics.checkNotNullParameter(biConsumer, (String)"biConsumer");
        List matchingEntries = new ArrayList();
        for (Map.Entry<Object, Node> mapping : this.processedMapping.entrySet()) {
            if (!predicate.test(mapping.getKey(), mapping.getValue())) continue;
            matchingEntries.add(mapping);
        }
        for (Map.Entry<Object, Node> entry : matchingEntries) {
            Object key = entry.getKey();
            Node value = entry.getValue();
            biConsumer.accept(key, value);
        }
        this.predicateListeners.put(predicate, biConsumer);
    }
}

