/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.ProcessedListener;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.graph.CodeAndLocationProvider;
import de.fraunhofer.aisec.cpg.graph.LanguageProvider;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.NamespaceProvider;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.ScopeProvider;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.scopes.Scope;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import de.fraunhofer.aisec.cpg.sarif.Region;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\n\b&\u0018\u0000 D2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0001DB%\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010#\u001a\u00020$H\u0016J\u001d\u0010%\u001a\u0004\u0018\u00010&\"\u0004\b\u0000\u0010'2\u0006\u0010(\u001a\u0002H'H&\u00a2\u0006\u0002\u0010)J\u001e\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.J\u001d\u00100\u001a\u0004\u0018\u000101\"\u0004\b\u0000\u0010'2\u0006\u0010(\u001a\u0002H'H&\u00a2\u0006\u0002\u00102J\u000e\u00103\u001a\u00020&2\u0006\u0010+\u001a\u00020,J\u0016\u00104\u001a\u00020.2\u0006\u00105\u001a\u00020.2\u0006\u00106\u001a\u00020.J\u0010\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u000209H&J\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00100;J+\u0010<\u001a\u00020$\"\u0004\b\u0000\u0010=\"\u0004\b\u0001\u0010>2\u0006\u0010?\u001a\u0002H=2\b\u0010(\u001a\u0004\u0018\u0001H>H\u0016\u00a2\u0006\u0002\u0010@J)\u0010A\u001a\u00020$\"\u0004\b\u0000\u0010>\"\u0004\b\u0001\u0010'2\u0006\u0010B\u001a\u0002H>2\u0006\u0010C\u001a\u0002H'H&\u00a2\u0006\u0002\u0010@R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR$\u0010\n\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006E"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "Lde/fraunhofer/aisec/cpg/frontends/ProcessedListener;", "Lde/fraunhofer/aisec/cpg/graph/CodeAndLocationProvider;", "Lde/fraunhofer/aisec/cpg/graph/LanguageProvider;", "Lde/fraunhofer/aisec/cpg/graph/ScopeProvider;", "Lde/fraunhofer/aisec/cpg/graph/NamespaceProvider;", "language", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "config", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "scopeManager", "Lde/fraunhofer/aisec/cpg/ScopeManager;", "(Lde/fraunhofer/aisec/cpg/frontends/Language;Lde/fraunhofer/aisec/cpg/TranslationConfiguration;Lde/fraunhofer/aisec/cpg/ScopeManager;)V", "getConfig", "()Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "currentTU", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "getCurrentTU", "()Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "setCurrentTU", "(Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;)V", "getLanguage", "()Lde/fraunhofer/aisec/cpg/frontends/Language;", "namespace", "Lde/fraunhofer/aisec/cpg/graph/Name;", "getNamespace", "()Lde/fraunhofer/aisec/cpg/graph/Name;", "scope", "Lde/fraunhofer/aisec/cpg/graph/scopes/Scope;", "getScope", "()Lde/fraunhofer/aisec/cpg/graph/scopes/Scope;", "getScopeManager", "()Lde/fraunhofer/aisec/cpg/ScopeManager;", "setScopeManager", "(Lde/fraunhofer/aisec/cpg/ScopeManager;)V", "cleanup", "", "getCodeFromRawNode", "", "T", "astNode", "(Ljava/lang/Object;)Ljava/lang/String;", "getCodeOfSubregion", "node", "Lde/fraunhofer/aisec/cpg/graph/Node;", "nodeRegion", "Lde/fraunhofer/aisec/cpg/sarif/Region;", "subRegion", "getLocationFromRawNode", "Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "(Ljava/lang/Object;)Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "getNewLineType", "mergeRegions", "regionOne", "regionTwo", "parse", "file", "Ljava/io/File;", "parseAll", "", "setCodeAndLocation", "N", "S", "cpgNode", "(Ljava/lang/Object;Ljava/lang/Object;)V", "setComment", "s", "ctx", "Companion", "cpg-core"})
public abstract class LanguageFrontend
extends ProcessedListener
implements CodeAndLocationProvider,
LanguageProvider,
ScopeProvider,
NamespaceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Language<? extends LanguageFrontend> language;
    @NotNull
    private final TranslationConfiguration config;
    @NotNull
    private ScopeManager scopeManager;
    @Nullable
    private TranslationUnitDeclaration currentTU;
    private static final Logger log = LoggerFactory.getLogger(LanguageFrontend.class);

    public LanguageFrontend(@NotNull Language<? extends LanguageFrontend> language, @NotNull TranslationConfiguration config, @NotNull ScopeManager scopeManager) {
        Intrinsics.checkNotNullParameter(language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)scopeManager, (String)"scopeManager");
        this.language = language;
        this.config = config;
        this.scopeManager = scopeManager;
        this.scopeManager.setLang(this);
    }

    @Override
    @NotNull
    public Language<? extends LanguageFrontend> getLanguage() {
        return this.language;
    }

    @NotNull
    public final TranslationConfiguration getConfig() {
        return this.config;
    }

    @NotNull
    public final ScopeManager getScopeManager() {
        return this.scopeManager;
    }

    public final void setScopeManager(@NotNull ScopeManager scopeManager) {
        Intrinsics.checkNotNullParameter((Object)scopeManager, (String)"scopeManager");
        this.scopeManager = scopeManager;
        this.scopeManager.setLang(this);
    }

    @Nullable
    public final TranslationUnitDeclaration getCurrentTU() {
        return this.currentTU;
    }

    public final void setCurrentTU(@Nullable TranslationUnitDeclaration translationUnitDeclaration) {
        this.currentTU = translationUnitDeclaration;
    }

    @NotNull
    public final List<TranslationUnitDeclaration> parseAll() throws TranslationException {
        ArrayList<TranslationUnitDeclaration> units = new ArrayList<TranslationUnitDeclaration>();
        for (String component : this.config.getSoftwareComponents().keySet()) {
            List<File> list2 = this.config.getSoftwareComponents().get(component);
            Intrinsics.checkNotNull(list2);
            for (File sourceFile : list2) {
                units.add(this.parse(sourceFile));
            }
        }
        return units;
    }

    @NotNull
    public abstract TranslationUnitDeclaration parse(@NotNull File var1) throws TranslationException;

    @Nullable
    public abstract <T> String getCodeFromRawNode(T var1);

    @Nullable
    public abstract <T> PhysicalLocation getLocationFromRawNode(T var1);

    @Override
    public <N, S> void setCodeAndLocation(N cpgNode, @Nullable S astNode) {
        if (cpgNode instanceof Node && astNode != null) {
            if (this.config.codeInNodes) {
                String code = this.getCodeFromRawNode(astNode);
                if (code != null) {
                    ((Node)cpgNode).setCode(code);
                } else {
                    log.warn("Unexpected: No code for node {}", astNode);
                }
            }
            ((Node)cpgNode).setLocation(this.getLocationFromRawNode(astNode));
        }
    }

    @NotNull
    public final String getNewLineType(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String[] stringArray = new String[]{"\n\r", "\r\n", "\n"};
        List nls = CollectionsKt.listOf((Object[])stringArray);
        for (String nl : nls) {
            if (!StringsKt.endsWith$default((String)node.toString(), (String)nl, (boolean)false, (int)2, null)) continue;
            return nl;
        }
        log.debug("Could not determine newline type. Assuming \\n. {}", (Object)node);
        return "\n";
    }

    @NotNull
    public final String getCodeOfSubregion(@NotNull Node node, @NotNull Region nodeRegion, @NotNull Region subRegion) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)nodeRegion, (String)"nodeRegion");
        Intrinsics.checkNotNullParameter((Object)subRegion, (String)"subRegion");
        String string = node.getCode();
        if (string == null) {
            return "";
        }
        String code = string;
        String nlType = this.getNewLineType(node);
        int start = subRegion.getStartLine() == nodeRegion.getStartLine() ? subRegion.getStartColumn() - nodeRegion.getStartColumn() : StringUtils.ordinalIndexOf((CharSequence)code, (CharSequence)nlType, (int)(subRegion.getStartLine() - nodeRegion.getStartLine())) + subRegion.getStartColumn();
        int end = subRegion.getEndLine() == nodeRegion.getStartLine() ? subRegion.getEndColumn() - nodeRegion.getStartColumn() : StringUtils.ordinalIndexOf((CharSequence)code, (CharSequence)nlType, (int)(subRegion.getEndLine() - nodeRegion.getStartLine())) + subRegion.getEndColumn();
        String string2 = code.substring(start, end);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string2;
    }

    @NotNull
    public final Region mergeRegions(@NotNull Region regionOne, @NotNull Region regionTwo) {
        Intrinsics.checkNotNullParameter((Object)regionOne, (String)"regionOne");
        Intrinsics.checkNotNullParameter((Object)regionTwo, (String)"regionTwo");
        Region ret = new Region();
        if (regionOne.getStartLine() < regionTwo.getStartLine() || regionOne.getStartLine() == regionTwo.getStartLine() && regionOne.getStartColumn() < regionTwo.getStartColumn()) {
            ret.setStartLine(regionOne.getStartLine());
            ret.setStartColumn(regionOne.getStartColumn());
        } else {
            ret.setStartLine(regionTwo.getStartLine());
            ret.setStartColumn(regionTwo.getStartColumn());
        }
        if (regionOne.getEndLine() > regionTwo.getEndLine() || regionOne.getEndLine() == regionTwo.getEndLine() && regionOne.getEndColumn() > regionTwo.getEndColumn()) {
            ret.setEndLine(regionOne.getEndLine());
            ret.setEndColumn(regionOne.getStartColumn());
        } else {
            ret.setEndLine(regionTwo.getEndLine());
            ret.setEndColumn(regionTwo.getEndColumn());
        }
        return ret;
    }

    public void cleanup() {
        this.clearProcessed();
    }

    public abstract <S, T> void setComment(S var1, T var2);

    @Override
    @Nullable
    public Scope getScope() {
        return this.scopeManager.getCurrentScope();
    }

    @Override
    @Nullable
    public Name getNamespace() {
        return this.scopeManager.getCurrentNamespace();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

