/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends;

import de.fraunhofer.aisec.cpg.frontends.HandlerInterface;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.ProcessedListener;
import de.fraunhofer.aisec.cpg.graph.CodeAndLocationProvider;
import de.fraunhofer.aisec.cpg.graph.LanguageProvider;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.NamespaceProvider;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.ProblemNode;
import de.fraunhofer.aisec.cpg.graph.ScopeProvider;
import de.fraunhofer.aisec.cpg.graph.scopes.Scope;
import de.fraunhofer.aisec.cpg.helpers.Util;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 6*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u0003*\b\b\u0002\u0010\u0004*\u00020\u00052\u00020\u00062\u00020\u00072\u00020\b2\u00020\t:\u00016B\u001b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0006\u0010\f\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\rJ\u0016\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001b2\u0006\u0010*\u001a\u00020+H\u0002J\u0017\u0010,\u001a\u0004\u0018\u00018\u00002\u0006\u0010-\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010.J\u000e\u0010/\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001bH\u0002J+\u00100\u001a\u000201\"\u0004\b\u0003\u00102\"\u0004\b\u0004\u0010\u00012\u0006\u00103\u001a\u0002H22\b\u00104\u001a\u0004\u0018\u0001H\u0001H\u0016\u00a2\u0006\u0002\u00105R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\f\u001a\u00028\u0002X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018RX\u0010\u0019\u001aF\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u001b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001c0\u001aj\"\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u001b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001c`\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u0004\u0018\u00010!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0016\u0010$\u001a\u0004\u0018\u00010%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/Handler;", "S", "Lde/fraunhofer/aisec/cpg/graph/Node;", "T", "L", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "Lde/fraunhofer/aisec/cpg/graph/LanguageProvider;", "Lde/fraunhofer/aisec/cpg/graph/CodeAndLocationProvider;", "Lde/fraunhofer/aisec/cpg/graph/ScopeProvider;", "Lde/fraunhofer/aisec/cpg/graph/NamespaceProvider;", "configConstructor", "Ljava/util/function/Supplier;", "frontend", "(Ljava/util/function/Supplier;Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;)V", "getConfigConstructor", "()Ljava/util/function/Supplier;", "getFrontend", "()Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "setFrontend", "(Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;)V", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "language", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "getLanguage", "()Lde/fraunhofer/aisec/cpg/frontends/Language;", "map", "Ljava/util/HashMap;", "Ljava/lang/Class;", "Lde/fraunhofer/aisec/cpg/frontends/HandlerInterface;", "Lkotlin/collections/HashMap;", "getMap", "()Ljava/util/HashMap;", "namespace", "Lde/fraunhofer/aisec/cpg/graph/Name;", "getNamespace", "()Lde/fraunhofer/aisec/cpg/graph/Name;", "scope", "Lde/fraunhofer/aisec/cpg/graph/scopes/Scope;", "getScope", "()Lde/fraunhofer/aisec/cpg/graph/scopes/Scope;", "typeOfT", "getBaseClass", "type", "Ljava/lang/reflect/Type;", "handle", "ctx", "(Ljava/lang/Object;)Lde/fraunhofer/aisec/cpg/graph/Node;", "retrieveTypeParameter", "setCodeAndLocation", "", "N", "cpgNode", "astNode", "(Ljava/lang/Object;Ljava/lang/Object;)V", "Companion", "cpg-core"})
public abstract class Handler<S extends Node, T, L extends LanguageFrontend>
implements LanguageProvider,
CodeAndLocationProvider,
ScopeProvider,
NamespaceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Supplier<S> configConstructor;
    @NotNull
    private L frontend;
    @NotNull
    private final HashMap<Class<? extends T>, HandlerInterface<S, T>> map;
    @Nullable
    private final Class<?> typeOfT;
    @NotNull
    private static final Logger log;

    public Handler(@NotNull Supplier<S> configConstructor, @NotNull L frontend) {
        Intrinsics.checkNotNullParameter(configConstructor, (String)"configConstructor");
        Intrinsics.checkNotNullParameter(frontend, (String)"frontend");
        this.configConstructor = configConstructor;
        this.frontend = frontend;
        this.map = new HashMap();
        this.typeOfT = this.retrieveTypeParameter();
    }

    @NotNull
    protected final Supplier<S> getConfigConstructor() {
        return this.configConstructor;
    }

    @NotNull
    public final L getFrontend() {
        return this.frontend;
    }

    public final void setFrontend(@NotNull L l) {
        Intrinsics.checkNotNullParameter(l, (String)"<set-?>");
        this.frontend = l;
    }

    @NotNull
    protected final HashMap<Class<? extends T>, HandlerInterface<S, T>> getMap() {
        return this.map;
    }

    @Nullable
    public S handle(T ctx) {
        Object[] objectArray;
        ASTNode astNode;
        Object ret = null;
        if (ctx == null) {
            log.error("ctx is NULL. This can happen when ast children are optional in {}. Called by {}", this.getClass(), (Object)Thread.currentThread().getStackTrace()[2]);
            return null;
        }
        if (!((LanguageFrontend)this.frontend).getConfig().getLoadIncludes() && ctx instanceof ASTNode && (astNode = (ASTNode)ctx).getFileLocation() != null && astNode.getFileLocation().getContextInclusionStatement() != null) {
            log.debug("Skip parsing include file {}", (Object)astNode.getContainingFilename());
            return null;
        }
        Class<?> toHandle = ctx.getClass();
        HandlerInterface handler = (HandlerInterface)((Map)this.map).get(toHandle);
        while (handler == null) {
            Intrinsics.checkNotNullExpressionValue(toHandle.getSuperclass(), (String)"toHandle.superclass");
            handler = (HandlerInterface)((Map)this.map).get(toHandle);
            if (handler != null) {
                String string = ctx.getClass().getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ctx.javaClass.simpleName");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"LiteralExpr", (boolean)false, (int)2, null)) {
                    objectArray = new Object[]{ctx.getClass(), toHandle};
                    Util.errorWithFileLocation(this.frontend, ctx, log, "No handler for type {}, resolving for its superclass {}.", objectArray);
                }
            }
            if (!Intrinsics.areEqual(toHandle, this.typeOfT) && (this.typeOfT == null || this.typeOfT.isAssignableFrom(toHandle))) continue;
        }
        if (handler != null) {
            s = (Object[])handler.handle(ctx);
            if (s != null) {
                if (s.getLocation() == null) {
                    ((LanguageFrontend)this.frontend).setCodeAndLocation((Object[])s, ctx);
                }
                ((LanguageFrontend)this.frontend).setComment((Object[])s, ctx);
            }
            ret = s;
        } else {
            s = new Object[]{ctx.getClass()};
            Util.errorWithFileLocation(this.frontend, ctx, log, "Parsing of type {} is not supported (yet)", s);
            ret = (Node)this.configConstructor.get();
            if (ret instanceof ProblemNode) {
                Object problem = ret;
                ProblemNode problemNode = (ProblemNode)problem;
                String string = "Parsing of type {} is not supported (yet)";
                Object[] objectArray2 = new Object[]{ctx.getClass()};
                String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                problemNode.setProblem(string2);
            }
        }
        if (ret == null) {
            objectArray = new Object[]{ctx.getClass()};
            Util.errorWithFileLocation(this.frontend, ctx, log, "Parsing of type {} did not produce a proper CPG node", objectArray);
            ret = (Node)this.configConstructor.get();
        }
        ((ProcessedListener)this.frontend).process(ctx, (Node)ret);
        return (S)ret;
    }

    private final Class<?> retrieveTypeParameter() {
        Class<?> clazz = this.getClass();
        while (clazz.getSuperclass() != null && !Intrinsics.areEqual(clazz.getSuperclass(), Handler.class)) {
            Intrinsics.checkNotNullExpressionValue(clazz.getSuperclass(), (String)"clazz.superclass");
        }
        Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getActualTypeArguments()[1];
            Intrinsics.checkNotNullExpressionValue((Object)rawType, (String)"rawType");
            return this.getBaseClass(rawType);
        }
        log.error("Could not determine generic type of raw AST node in handler");
        return null;
    }

    private final Class<?> getBaseClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            Type type2 = ((ParameterizedType)type).getRawType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type.rawType");
            return this.getBaseClass(type2);
        }
        return null;
    }

    @NotNull
    public Language<L> getLanguage() {
        Language<? extends LanguageFrontend> language = ((LanguageFrontend)this.frontend).getLanguage();
        Intrinsics.checkNotNull(language, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.frontends.Language<L of de.fraunhofer.aisec.cpg.frontends.Handler>");
        return language;
    }

    @Override
    public <N, S> void setCodeAndLocation(N cpgNode, @Nullable S astNode) {
        ((LanguageFrontend)this.frontend).setCodeAndLocation(cpgNode, astNode);
    }

    @Override
    @Nullable
    public Scope getScope() {
        return ((LanguageFrontend)this.frontend).getScope();
    }

    @Override
    @Nullable
    public Name getNamespace() {
        return ((LanguageFrontend)this.frontend).getNamespace();
    }

    @NotNull
    protected static final Logger getLog() {
        return Companion.getLog();
    }

    static {
        Logger logger = LoggerFactory.getLogger(Handler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(Handler::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/Handler$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog$annotations", "getLog", "()Lorg/slf4j/Logger;", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLog() {
            return log;
        }

        @JvmStatic
        protected static /* synthetic */ void getLog$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

