/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends;

import de.fraunhofer.aisec.cpg.frontends.FrontendUtils;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.NamespaceDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import de.fraunhofer.aisec.cpg.sarif.Region;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/FrontendUtils;", "", "()V", "Companion", "cpg-core"})
public final class FrontendUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOGGER = LoggerFactory.getLogger(FrontendUtils.class);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J0\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/FrontendUtils$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getEndColumnIndex", "", "posPrefix", "", "end", "matchCommentToNode", "", "comment", "location", "Lde/fraunhofer/aisec/cpg/sarif/Region;", "tu", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "parseColumnPositionsFromFile", "fileContent", "nodeLength", "nodeOffset", "startingLineNumber", "endingLineNumber", "cpg-core"})
    @SourceDebugExtension(value={"SMAP\nFrontendUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendUtils.kt\nde/fraunhofer/aisec/cpg/frontends/FrontendUtils$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n766#2:207\n857#2:208\n858#2:210\n800#2,11:211\n1360#2:222\n1446#2,2:223\n766#2:225\n857#2,2:226\n1448#2,3:228\n766#2:231\n857#2,2:232\n766#2:234\n857#2,2:235\n1#3:209\n*S KotlinDebug\n*F\n+ 1 FrontendUtils.kt\nde/fraunhofer/aisec/cpg/frontends/FrontendUtils$Companion\n*L\n124#1:207\n124#1:208\n124#1:210\n146#1:211,11\n146#1:222\n146#1:223,2\n147#1:225\n147#1:226,2\n146#1:228,3\n155#1:231\n155#1:232,2\n176#1:234\n176#1:235,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Region parseColumnPositionsFromFile(@NotNull String fileContent, int nodeLength, int nodeOffset, int startingLineNumber, int endingLineNumber) {
            Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
            int startColumn = 1;
            for (int i = nodeOffset - 1; 1 < i; --i) {
                if (i >= fileContent.length()) {
                    LOGGER.warn("Requested index {} exceeds length of translation unit code ({})", (Object)i, (Object)fileContent.length());
                    return null;
                }
                if (fileContent.charAt(i) == '\n') break;
                ++startColumn;
            }
            int endColumn = this.getEndColumnIndex(fileContent, nodeOffset + nodeLength);
            Region region = new Region(startingLineNumber, startColumn, endingLineNumber, endColumn);
            return region;
        }

        private final int getEndColumnIndex(String posPrefix, int end) {
            int mutableEnd = end;
            int column = 1;
            try {
                if (mutableEnd - 1 >= posPrefix.length() || posPrefix.charAt(mutableEnd - 1) == '\n') {
                    mutableEnd = Math.min(mutableEnd - 1, posPrefix.length() - 1);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LanguageFrontend.Companion.getLog().error("could not update end ", (Throwable)e);
            }
            for (int i = mutableEnd - 1; 1 < i && posPrefix.charAt(i) != '\n'; --i) {
                ++column;
            }
            return column;
        }

        /*
         * WARNING - void declaration
         */
        public final void matchCommentToNode(@NotNull String comment, @NotNull Region location, @NotNull TranslationUnitDeclaration tu) {
            String string;
            int closestLine;
            void $this$filterTo$iv$iv;
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            NamespaceDeclaration it;
            Iterable $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)tu, (String)"tu");
            List<Node> nodes = SubgraphWalker.INSTANCE.flattenAST(tu);
            Iterable $this$filter$iv = nodes;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Region nodeRegion;
                Region region;
                Region region2;
                Iterator it2 = (Node)element$iv$iv;
                boolean bl = false;
                if (((Node)((Object)it2)).getLocation() != null) {
                    boolean bl2 = false;
                    region2 = ((PhysicalLocation)((Object)it)).getRegion();
                } else {
                    region2 = null;
                }
                Region region3 = region = region2;
                if (region3 == null) {
                    v2 = new Region();
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)region3, (String)"it.location?.let { it.region } ?: Region()");
                    v2 = nodeRegion = region;
                }
                boolean bl3 = !(nodeRegion.getStartLine() > location.getStartLine() || nodeRegion.getEndLine() < location.getEndLine() || nodeRegion.getStartLine() == location.getStartLine() && nodeRegion.getStartColumn() > location.getStartColumn() || nodeRegion.getEndLine() == location.getEndLine() && nodeRegion.getEndColumn() < location.getEndColumn());
                if (!bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List enclosingNodes = (List)destination$iv$iv;
            if (!enclosingNodes.contains(tu)) {
                enclosingNodes = CollectionsKt.plus((Collection)enclosingNodes, (Object)tu);
            }
            Node smallestEnclosingNode = (Node)CollectionsKt.first((List)CollectionsKt.sortedWith((Iterable)enclosingNodes, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Node it = (Node)a;
                    boolean bl = false;
                    String string = it.getCode();
                    it = (Node)b;
                    Comparable comparable = string != null ? (Comparable)Integer.valueOf(string.length()) : (Comparable)Integer.valueOf(10000);
                    bl = false;
                    String string2 = it.getCode();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(string2 != null ? (Comparable)Integer.valueOf(string2.length()) : (Comparable)Integer.valueOf(10000)));
                }
            }));
            List children2 = CollectionsKt.toMutableList((Collection)SubgraphWalker.getAstChildren(smallestEnclosingNode));
            $this$filterTo$iv$iv2 = children2;
            List list2 = children2;
            boolean $i$f$filterIsInstance = false;
            void $i$f$filterTo22 = $this$filterIsInstance$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof NamespaceDeclaration)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv2;
            boolean $i$f$flatMap = false;
            $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$filterTo$iv$iv3;
                it = (NamespaceDeclaration)element$iv$iv;
                boolean bl = false;
                Iterable $this$filter$iv2 = SubgraphWalker.getAstChildren(it);
                boolean $i$f$filter22 = false;
                Iterable iterable2 = $this$filter$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv3) {
                    Node it3 = (Node)element$iv$iv2;
                    boolean bl4 = false;
                    if (!(!children2.contains(it3))) continue;
                    destination$iv$iv3.add(element$iv$iv2);
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            list2.addAll((List)destination$iv$iv2);
            Iterable $this$filter$iv3 = children2;
            boolean $i$f$filter23 = false;
            destination$iv$iv2 = $this$filter$iv3;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Region nodeRegion;
                Region $i$f$filter22;
                Node it4 = (Node)element$iv$iv;
                boolean bl = false;
                PhysicalLocation physicalLocation = it4.getLocation();
                Region region = $i$f$filter22 = physicalLocation != null ? physicalLocation.getRegion() : null;
                if (region == null) {
                    v6 = new Region();
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)region, (String)"it.location?.region ?: Region()");
                    v6 = nodeRegion = $i$f$filter22;
                }
                boolean bl5 = nodeRegion.getStartLine() >= location.getEndLine() && (nodeRegion.getStartLine() > location.getEndLine() || nodeRegion.getStartColumn() >= location.getEndColumn());
                if (!bl5) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            List successors = (List)destination$iv$iv4;
            Function1[] $i$f$filter23 = new Function1[]{matchCommentToNode.closest.1.INSTANCE, matchCommentToNode.closest.2.INSTANCE};
            Node closest2 = (Node)CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)successors, (Comparator)ComparisonsKt.compareBy((Function1[])$i$f$filter23)));
            Object object = closest2;
            int n = object != null && (object = ((Node)object).getLocation()) != null && (object = ((PhysicalLocation)object).getRegion()) != null ? ((Region)object).getStartLine() : (closestLine = location.getEndLine() + 1);
            if (closest2 == null || closestLine > location.getEndLine()) {
                void $this$filterTo$iv$iv4;
                Iterable $this$filter$iv4 = children2;
                boolean $i$f$filter3 = false;
                Iterable element$iv$iv = $this$filter$iv4;
                Collection destination$iv$iv5 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv3 : $this$filterTo$iv$iv4) {
                    Region nodeRegion;
                    Region region;
                    Node it5 = (Node)element$iv$iv3;
                    boolean bl = false;
                    PhysicalLocation physicalLocation = it5.getLocation();
                    Region region4 = region = physicalLocation != null ? physicalLocation.getRegion() : null;
                    if (region4 == null) {
                        v12 = new Region();
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)region4, (String)"it.location?.region ?: Region()");
                        v12 = nodeRegion = region;
                    }
                    boolean bl6 = nodeRegion.getEndLine() <= location.getStartLine() && (nodeRegion.getEndLine() < location.getStartLine() || nodeRegion.getEndColumn() <= location.getStartColumn());
                    if (!bl6) continue;
                    destination$iv$iv5.add(element$iv$iv3);
                }
                List predecessor = (List)destination$iv$iv5;
                Function1[] function1Array = new Function1[]{matchCommentToNode.closestPredecessor.1.INSTANCE, matchCommentToNode.closestPredecessor.2.INSTANCE};
                Node closestPredecessor2 = (Node)CollectionsKt.lastOrNull((List)CollectionsKt.sortedWith((Iterable)predecessor, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array)));
                Object object2 = closestPredecessor2;
                int n2 = object2 != null && (object2 = ((Node)object2).getLocation()) != null && (object2 = ((PhysicalLocation)object2).getRegion()) != null ? ((Region)object2).getEndLine() : (closestLine = location.getStartLine() - 1);
                if (closestPredecessor2 != null && closestLine == location.getStartLine()) {
                    closest2 = closestPredecessor2;
                }
            }
            if (closest2 == null) {
                closest2 = smallestEnclosingNode;
            }
            if ((string = closest2.getComment()) == null) {
                string = "";
            }
            closest2.setComment(string + comment);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

