/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0004\u0018\u0000 \u00162\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0003\u0016\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\tJ\u001c\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\tR#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R&\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/CompilationDatabase;", "Ljava/util/ArrayList;", "Lde/fraunhofer/aisec/cpg/frontends/CompilationDatabase$CompilationDatabaseEntry;", "Lkotlin/collections/ArrayList;", "()V", "components", "", "", "", "Ljava/io/File;", "getComponents", "()Ljava/util/Map;", "includePaths", "", "sourceFiles", "getSourceFiles", "()Ljava/util/List;", "symbols", "getIncludePaths", "file", "getSymbols", "", "Companion", "CompilationDatabaseEntry", "ParsedCompilationDatabaseEntry", "cpg-core"})
public final class CompilationDatabase
extends ArrayList<CompilationDatabaseEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<File, List<String>> includePaths = new LinkedHashMap();
    @NotNull
    private final Map<File, Map<String, String>> symbols = new LinkedHashMap();
    @NotNull
    private final Map<String, List<File>> components = new LinkedHashMap();

    @NotNull
    public final Map<String, List<File>> getComponents() {
        return this.components;
    }

    @NotNull
    public final List<File> getSourceFiles() {
        return CollectionsKt.toList((Iterable)this.includePaths.keySet());
    }

    @Nullable
    public final List<String> getIncludePaths(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.includePaths.get(file);
    }

    @Nullable
    public final Map<String, String> getSymbols(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.symbols.get(file);
    }

    @JvmStatic
    @NotNull
    public static final CompilationDatabase fromFile(@NotNull File file) {
        return Companion.fromFile(file);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JI\u0010\u0016\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001d"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/CompilationDatabase$CompilationDatabaseEntry;", "", "directory", "", "command", "arguments", "", "file", "output", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getArguments", "()Ljava/util/List;", "getCommand", "()Ljava/lang/String;", "getDirectory", "getFile", "getOutput", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "cpg-core"})
    public static final class CompilationDatabaseEntry {
        @Nullable
        private final String directory;
        @Nullable
        private final String command;
        @Nullable
        private final List<String> arguments;
        @NotNull
        private final String file;
        @Nullable
        private final String output;

        public CompilationDatabaseEntry(@Nullable String directory, @Nullable String command, @Nullable List<String> arguments2, @NotNull String file, @Nullable String output) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.directory = directory;
            this.command = command;
            this.arguments = arguments2;
            this.file = file;
            this.output = output;
        }

        public /* synthetic */ CompilationDatabaseEntry(String string, String string2, List list2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                list2 = null;
            }
            this(string, string2, list2, string3, string4);
        }

        @Nullable
        public final String getDirectory() {
            return this.directory;
        }

        @Nullable
        public final String getCommand() {
            return this.command;
        }

        @Nullable
        public final List<String> getArguments() {
            return this.arguments;
        }

        @NotNull
        public final String getFile() {
            return this.file;
        }

        @Nullable
        public final String getOutput() {
            return this.output;
        }

        @Nullable
        public final String component1() {
            return this.directory;
        }

        @Nullable
        public final String component2() {
            return this.command;
        }

        @Nullable
        public final List<String> component3() {
            return this.arguments;
        }

        @NotNull
        public final String component4() {
            return this.file;
        }

        @Nullable
        public final String component5() {
            return this.output;
        }

        @NotNull
        public final CompilationDatabaseEntry copy(@Nullable String directory, @Nullable String command, @Nullable List<String> arguments2, @NotNull String file, @Nullable String output) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new CompilationDatabaseEntry(directory, command, arguments2, file, output);
        }

        public static /* synthetic */ CompilationDatabaseEntry copy$default(CompilationDatabaseEntry compilationDatabaseEntry, String string, String string2, List list2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = compilationDatabaseEntry.directory;
            }
            if ((n & 2) != 0) {
                string2 = compilationDatabaseEntry.command;
            }
            if ((n & 4) != 0) {
                list2 = compilationDatabaseEntry.arguments;
            }
            if ((n & 8) != 0) {
                string3 = compilationDatabaseEntry.file;
            }
            if ((n & 0x10) != 0) {
                string4 = compilationDatabaseEntry.output;
            }
            return compilationDatabaseEntry.copy(string, string2, list2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "CompilationDatabaseEntry(directory=" + this.directory + ", command=" + this.command + ", arguments=" + this.arguments + ", file=" + this.file + ", output=" + this.output + ")";
        }

        public int hashCode() {
            int result = this.directory == null ? 0 : this.directory.hashCode();
            result = result * 31 + (this.command == null ? 0 : this.command.hashCode());
            result = result * 31 + (this.arguments == null ? 0 : ((Object)this.arguments).hashCode());
            result = result * 31 + this.file.hashCode();
            result = result * 31 + (this.output == null ? 0 : this.output.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompilationDatabaseEntry)) {
                return false;
            }
            CompilationDatabaseEntry compilationDatabaseEntry = (CompilationDatabaseEntry)other;
            if (!Intrinsics.areEqual((Object)this.directory, (Object)compilationDatabaseEntry.directory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.command, (Object)compilationDatabaseEntry.command)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.arguments, compilationDatabaseEntry.arguments)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.file, (Object)compilationDatabaseEntry.file)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.output, (Object)compilationDatabaseEntry.output);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\"\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\t\u001a\u00020\u000bH\u0002J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u00a8\u0006\u0014"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/CompilationDatabase$Companion;", "", "()V", "fromFile", "Lde/fraunhofer/aisec/cpg/frontends/CompilationDatabase;", "file", "Ljava/io/File;", "parseCommandLineArgs", "Lde/fraunhofer/aisec/cpg/frontends/CompilationDatabase$ParsedCompilationDatabaseEntry;", "command", "", "", "parseOutput", "output", "parseSymbols", "", "splitCommand", "splitSymbol", "Lkotlin/Pair;", "sym", "cpg-core"})
    @SourceDebugExtension(value={"SMAP\nCompilationDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilationDatabase.kt\nde/fraunhofer/aisec/cpg/frontends/CompilationDatabase$Companion\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,294:1\n50#2:295\n43#2:296\n361#3,7:297\n37#4,2:304\n1#5:306\n*S KotlinDebug\n*F\n+ 1 CompilationDatabase.kt\nde/fraunhofer/aisec/cpg/frontends/CompilationDatabase$Companion\n*L\n97#1:295\n97#1:296\n132#1:297,7\n154#1:304,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final CompilationDatabase fromFile(@NotNull File file) {
            ObjectMapper mapper;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String jsonStringFile = FilesKt.readText$default((File)file, null, (int)1, null);
            ObjectMapper $this$readValue$iv = mapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper());
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            CompilationDatabase db = (CompilationDatabase)$this$readValue$iv.readValue(jsonStringFile, (TypeReference)new TypeReference<CompilationDatabase>(){});
            for (CompilationDatabaseEntry entry : db) {
                Map map;
                Object object;
                void $this$getOrPut$iv;
                Object object2;
                String fileNameInTheObject = entry.getFile();
                File srcFile = new File(fileNameInTheObject);
                ParsedCompilationDatabaseEntry parsedEntry = entry.getArguments() != null ? this.parseCommandLineArgs(entry.getArguments()) : (entry.getCommand() != null ? this.parseCommandLineArgs(this.splitCommand(entry.getCommand())) : new ParsedCompilationDatabaseEntry(null, null, null, 7, null));
                String basedir = entry.getDirectory();
                if (!srcFile.isAbsolute() && basedir != null && Paths.get(basedir, object2 = new String[]{fileNameInTheObject}).toFile().exists()) {
                    String[] stringArray = new String[]{fileNameInTheObject};
                    File file2 = Paths.get(basedir, stringArray).toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"get(basedir, fileNameInTheObject).toFile()");
                    srcFile = file2;
                }
                if (srcFile.exists()) {
                    db.includePaths.put(srcFile, parsedEntry.getIncludes());
                }
                db.symbols.put(srcFile, entry.getArguments() != null ? this.parseSymbols(entry.getArguments()) : (entry.getCommand() != null ? this.parseSymbols(this.splitCommand(entry.getCommand())) : (Map<String, String>)new LinkedHashMap()));
                object2 = db.getComponents();
                String key$iv = parsedEntry.getComponent();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Collection)object).add(srcFile);
                if (parsedEntry.getArch() == null) continue;
                Map map2 = map = (Map)db.symbols.get(srcFile);
                if (map2 == null) continue;
                map2.put("__" + parsedEntry.getArch() + "__", "");
            }
            return db;
        }

        private final List<String> splitCommand(String command) {
            if (((CharSequence)command).length() == 0) {
                return CollectionsKt.emptyList();
            }
            String[] stringArray = new String[]{" "};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)command, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            return CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray2, stringArray2.length));
        }

        private final ParsedCompilationDatabaseEntry parseCommandLineArgs(List<String> command) {
            ParsedCompilationDatabaseEntry entry = new ParsedCompilationDatabaseEntry(null, null, null, 7, null);
            if (command.isEmpty()) {
                return entry;
            }
            for (int i = 0; i < command.size(); ++i) {
                String word = command.get(i);
                if (StringsKt.startsWith$default((String)word, (String)"-I", (boolean)false, (int)2, null)) {
                    if (word.length() == 2) {
                        if (i + 1 == command.size()) continue;
                        entry.getIncludes().add(command.get(++i));
                        continue;
                    }
                    List<String> list2 = entry.getIncludes();
                    String string = word.substring(2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    list2.add(string);
                    continue;
                }
                if (Intrinsics.areEqual((Object)word, (Object)"-isystem")) {
                    if (i + 1 == command.size()) continue;
                    entry.getIncludes().add(command.get(++i));
                    continue;
                }
                if (Intrinsics.areEqual((Object)word, (Object)"-isysroot")) {
                    if (i + 1 == command.size()) continue;
                    entry.getIncludes().add(command.get(++i) + "/usr/include");
                    continue;
                }
                if (Intrinsics.areEqual((Object)word, (Object)"-o")) {
                    if (i + 1 == command.size()) continue;
                    if (this.parseOutput(command.get(++i)) != null) {
                        String it;
                        boolean bl = false;
                        entry.setComponent(it);
                    }
                    continue;
                }
                if (!Intrinsics.areEqual((Object)word, (Object)"-arch") || i + 1 == command.size()) continue;
                entry.setArch(command.get(++i));
            }
            return entry;
        }

        private final Pair<String, String> splitSymbol(String sym) {
            if (StringsKt.contains$default((CharSequence)sym, (CharSequence)"=", (boolean)false, (int)2, null)) {
                String[] stringArray = new String[]{"="};
                List pair = StringsKt.split$default((CharSequence)sym, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
                return new Pair(pair.get(0), pair.get(1));
            }
            return new Pair((Object)sym, (Object)"");
        }

        private final Map<String, String> parseSymbols(List<String> command) {
            if (command.isEmpty()) {
                return new LinkedHashMap();
            }
            LinkedHashMap symbols = new LinkedHashMap();
            for (int i = 0; i < command.size(); ++i) {
                Pair<String, String> sym;
                String word = command.get(i);
                if (!StringsKt.startsWith$default((String)word, (String)"-D", (boolean)false, (int)2, null)) continue;
                if (word.length() == 2) {
                    if (i + 1 == command.size()) continue;
                    sym = this.splitSymbol(command.get(++i));
                    ((Map)symbols).put(sym.getFirst(), sym.getSecond());
                    continue;
                }
                String string = word.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                sym = this.splitSymbol(string);
                ((Map)symbols).put(sym.getFirst(), sym.getSecond());
            }
            return symbols;
        }

        private final String parseOutput(String output) {
            int dirIdx;
            boolean isLibrary = false;
            int cmakeIdx = StringsKt.indexOf$default((CharSequence)output, (String)"CMakeFiles/", (int)0, (boolean)false, (int)6, null);
            if (cmakeIdx < 0) {
                return null;
            }
            String string = output.substring(0, cmakeIdx);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String prefix = string;
            if (Intrinsics.areEqual((Object)prefix, (Object)"lib/")) {
                isLibrary = true;
            }
            if ((dirIdx = StringsKt.indexOf$default((CharSequence)output, (String)".dir/", (int)0, (boolean)false, (int)6, null)) < 0) {
                return null;
            }
            String string2 = output.substring(cmakeIdx + 11, dirIdx);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Object name2 = string2;
            if (isLibrary) {
                name2 = "lib" + (String)name2;
            }
            return name2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J/\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0004H\u00d6\u0001R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/CompilationDatabase$ParsedCompilationDatabaseEntry;", "", "includes", "", "", "component", "arch", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getArch", "()Ljava/lang/String;", "setArch", "(Ljava/lang/String;)V", "getComponent", "setComponent", "getIncludes", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "cpg-core"})
    public static final class ParsedCompilationDatabaseEntry {
        @NotNull
        private final List<String> includes;
        @NotNull
        private String component;
        @Nullable
        private String arch;

        public ParsedCompilationDatabaseEntry(@NotNull List<String> includes2, @NotNull String component, @Nullable String arch) {
            Intrinsics.checkNotNullParameter(includes2, (String)"includes");
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            this.includes = includes2;
            this.component = component;
            this.arch = arch;
        }

        public /* synthetic */ ParsedCompilationDatabaseEntry(List list2, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list2 = new ArrayList();
            }
            if ((n & 2) != 0) {
                string = "application";
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(list2, string, string2);
        }

        @NotNull
        public final List<String> getIncludes() {
            return this.includes;
        }

        @NotNull
        public final String getComponent() {
            return this.component;
        }

        public final void setComponent(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.component = string;
        }

        @Nullable
        public final String getArch() {
            return this.arch;
        }

        public final void setArch(@Nullable String string) {
            this.arch = string;
        }

        @NotNull
        public final List<String> component1() {
            return this.includes;
        }

        @NotNull
        public final String component2() {
            return this.component;
        }

        @Nullable
        public final String component3() {
            return this.arch;
        }

        @NotNull
        public final ParsedCompilationDatabaseEntry copy(@NotNull List<String> includes2, @NotNull String component, @Nullable String arch) {
            Intrinsics.checkNotNullParameter(includes2, (String)"includes");
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            return new ParsedCompilationDatabaseEntry(includes2, component, arch);
        }

        public static /* synthetic */ ParsedCompilationDatabaseEntry copy$default(ParsedCompilationDatabaseEntry parsedCompilationDatabaseEntry, List list2, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = parsedCompilationDatabaseEntry.includes;
            }
            if ((n & 2) != 0) {
                string = parsedCompilationDatabaseEntry.component;
            }
            if ((n & 4) != 0) {
                string2 = parsedCompilationDatabaseEntry.arch;
            }
            return parsedCompilationDatabaseEntry.copy(list2, string, string2);
        }

        @NotNull
        public String toString() {
            return "ParsedCompilationDatabaseEntry(includes=" + this.includes + ", component=" + this.component + ", arch=" + this.arch + ")";
        }

        public int hashCode() {
            int result = ((Object)this.includes).hashCode();
            result = result * 31 + this.component.hashCode();
            result = result * 31 + (this.arch == null ? 0 : this.arch.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsedCompilationDatabaseEntry)) {
                return false;
            }
            ParsedCompilationDatabaseEntry parsedCompilationDatabaseEntry = (ParsedCompilationDatabaseEntry)other;
            if (!Intrinsics.areEqual(this.includes, parsedCompilationDatabaseEntry.includes)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.component, (Object)parsedCompilationDatabaseEntry.component)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.arch, (Object)parsedCompilationDatabaseEntry.arch);
        }

        public ParsedCompilationDatabaseEntry() {
            this(null, null, null, 7, null);
        }
    }
}

