/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.TranslationManager;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.graph.Component;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.helpers.BenchmarkResults;
import de.fraunhofer.aisec.cpg.helpers.MeasurementHolder;
import de.fraunhofer.aisec.cpg.helpers.StatisticsHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000eH\u0016J\u000e\u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020\u0012J\u0012\u00101\u001a\u00020-2\b\u00102\u001a\u0004\u0018\u00010*H\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001d\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020 0%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020*0%8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0014\u00a8\u00064"}, d2={"Lde/fraunhofer/aisec/cpg/TranslationResult;", "Lde/fraunhofer/aisec/cpg/graph/Node;", "Lde/fraunhofer/aisec/cpg/helpers/StatisticsHolder;", "translationManager", "Lde/fraunhofer/aisec/cpg/TranslationManager;", "scopeManager", "Lde/fraunhofer/aisec/cpg/ScopeManager;", "(Lde/fraunhofer/aisec/cpg/TranslationManager;Lde/fraunhofer/aisec/cpg/ScopeManager;)V", "additionalNodes", "", "getAdditionalNodes", "()Ljava/util/Set;", "benchmarks", "", "Lde/fraunhofer/aisec/cpg/helpers/MeasurementHolder;", "getBenchmarks", "components", "", "Lde/fraunhofer/aisec/cpg/graph/Component;", "getComponents", "()Ljava/util/List;", "config", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "getConfig", "()Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "isCancelled", "", "()Z", "getScopeManager", "()Lde/fraunhofer/aisec/cpg/ScopeManager;", "scratch", "", "", "", "getScratch", "()Ljava/util/Map;", "translatedFiles", "", "getTranslatedFiles", "getTranslationManager", "()Lde/fraunhofer/aisec/cpg/TranslationManager;", "translationUnits", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "getTranslationUnits", "addBenchmark", "", "b", "addComponent", "sc", "addTranslationUnit", "tu", "Companion", "cpg-core"})
public final class TranslationResult
extends Node
implements StatisticsHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TranslationManager translationManager;
    @NotNull
    private final ScopeManager scopeManager;
    @SubGraph(value={"AST"})
    @NotNull
    private final List<Component> components;
    @NotNull
    private final Map<String, Object> scratch;
    @NotNull
    private final Set<Node> additionalNodes;
    @NotNull
    private final Set<MeasurementHolder> benchmarks;
    @NotNull
    public static final String SOURCE_LOCATIONS_TO_FRONTEND = "sourceLocationsToFrontend";
    @NotNull
    public static final String APPLICATION_LOCAL_NAME = "application";

    public TranslationResult(@NotNull TranslationManager translationManager, @NotNull ScopeManager scopeManager) {
        Intrinsics.checkNotNullParameter((Object)translationManager, (String)"translationManager");
        Intrinsics.checkNotNullParameter((Object)scopeManager, (String)"scopeManager");
        this.translationManager = translationManager;
        this.scopeManager = scopeManager;
        this.components = new ArrayList();
        this.scratch = new ConcurrentHashMap();
        this.additionalNodes = new HashSet();
        this.benchmarks = new LinkedHashSet();
    }

    @NotNull
    public final TranslationManager getTranslationManager() {
        return this.translationManager;
    }

    @NotNull
    public final ScopeManager getScopeManager() {
        return this.scopeManager;
    }

    @NotNull
    public final List<Component> getComponents() {
        return this.components;
    }

    @NotNull
    public final Map<String, Object> getScratch() {
        return this.scratch;
    }

    @NotNull
    public final Set<Node> getAdditionalNodes() {
        return this.additionalNodes;
    }

    @Override
    @NotNull
    public Set<MeasurementHolder> getBenchmarks() {
        return this.benchmarks;
    }

    public final boolean isCancelled() {
        return this.translationManager.isCancelled();
    }

    @NotNull
    public final List<TranslationUnitDeclaration> getTranslationUnits() {
        if (this.components.size() == 1) {
            List<TranslationUnitDeclaration> list2 = Collections.unmodifiableList(this.components.get(0).getTranslationUnits());
            Intrinsics.checkNotNullExpressionValue(list2, (String)"unmodifiableList(components[0].translationUnits)");
            return list2;
        }
        List result = new ArrayList();
        for (Component sc : this.components) {
            result.addAll((Collection)sc.getTranslationUnits());
        }
        return result;
    }

    @Deprecated(message="This should not be used anymore. Instead, the corresponding component should be\n        selected and the translation unit should be added there.")
    public final synchronized void addTranslationUnit(@Nullable TranslationUnitDeclaration tu) {
        Component swc = null;
        if (this.components.size() == 1) {
            swc = this.components.get(0);
        } else if (this.components.isEmpty()) {
            swc = new Component();
            swc.setName(new Name(APPLICATION_LOCAL_NAME, null, ""));
            this.components.add(swc);
        } else {
            for (Component component : this.components) {
                if (!Intrinsics.areEqual((Object)component.getName().getLocalName(), (Object)APPLICATION_LOCAL_NAME)) continue;
                swc = component;
                break;
            }
            if (swc == null) {
                swc = new Component();
                swc.setName(new Name(APPLICATION_LOCAL_NAME, null, ""));
                this.components.add(swc);
            }
        }
        List<TranslationUnitDeclaration> list2 = swc.getTranslationUnits();
        TranslationUnitDeclaration translationUnitDeclaration = tu;
        Intrinsics.checkNotNull((Object)translationUnitDeclaration);
        list2.add(translationUnitDeclaration);
    }

    public final synchronized void addComponent(@NotNull Component sc) {
        Intrinsics.checkNotNullParameter((Object)sc, (String)"sc");
        this.components.add(sc);
    }

    @Override
    public void addBenchmark(@NotNull MeasurementHolder b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.getBenchmarks().add(b);
    }

    @Override
    @NotNull
    public List<String> getTranslatedFiles() {
        List result = new ArrayList();
        this.components.forEach(arg_0 -> TranslationResult._get_translatedFiles_$lambda$2(result, arg_0));
        return result;
    }

    @Override
    @NotNull
    public TranslationConfiguration getConfig() {
        return this.translationManager.getConfig();
    }

    @Override
    @NotNull
    public BenchmarkResults getBenchmarkResults() {
        return StatisticsHolder.DefaultImpls.getBenchmarkResults(this);
    }

    private static final Name _get_translatedFiles_$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Name)$tmp0.invoke(p0);
    }

    private static final String _get_translatedFiles_$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final void _get_translatedFiles_$lambda$2(List $result, Component sc) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)sc, (String)"sc");
        List list2 = sc.getTranslationUnits().stream().map(arg_0 -> TranslationResult._get_translatedFiles_$lambda$2$lambda$0((Function1)translatedFiles.1.1.INSTANCE, arg_0)).map(arg_0 -> TranslationResult._get_translatedFiles_$lambda$2$lambda$1(translatedFiles.1.2.INSTANCE, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list2, (String)"sc.translationUnits\n    \u2026lect(Collectors.toList())");
        $result.addAll(list2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fraunhofer/aisec/cpg/TranslationResult$Companion;", "", "()V", "APPLICATION_LOCAL_NAME", "", "SOURCE_LOCATIONS_TO_FRONTEND", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

