/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg;

import de.fraunhofer.aisec.cpg.ScopeManager;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.TranslationManager;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.SupportsParallelParsing;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Component;
import de.fraunhofer.aisec.cpg.graph.Name;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.helpers.Benchmark;
import de.fraunhofer.aisec.cpg.helpers.MeasurementHolder;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.Pass;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KAnnotatedElement;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u0000 .2\u00020\u0001:\u0002-.B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J0\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010!\u001a\u00020\u0017H\u0002J\u0006\u0010\u0007\u001a\u00020\"J&\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0010H\u0002J,\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00170(2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u00152\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100*H\u0002J,\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00170(2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u00152\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100*H\u0002J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00170(2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006/"}, d2={"Lde/fraunhofer/aisec/cpg/TranslationManager;", "", "config", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "(Lde/fraunhofer/aisec/cpg/TranslationConfiguration;)V", "getConfig", "()Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "isCancelled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "passes", "", "Lde/fraunhofer/aisec/cpg/passes/Pass;", "getPasses", "()Ljava/util/List;", "language", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "Ljava/io/File;", "getLanguage", "(Ljava/io/File;)Lde/fraunhofer/aisec/cpg/frontends/Language;", "analyze", "Ljava/util/concurrent/CompletableFuture;", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "getFrontend", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "file", "scopeManager", "Lde/fraunhofer/aisec/cpg/ScopeManager;", "handleCompletion", "", "result", "usedFrontends", "", "sourceLocation", "f", "", "parse", "Ljava/util/Optional;", "component", "Lde/fraunhofer/aisec/cpg/graph/Component;", "parseParallel", "", "sourceLocations", "", "parseSequentially", "runFrontends", "Builder", "Companion", "cpg-core"})
@SourceDebugExtension(value={"SMAP\nTranslationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranslationManager.kt\nde/fraunhofer/aisec/cpg/TranslationManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n*L\n1#1,420:1\n1360#2:421\n1446#2,2:422\n288#2,2:425\n1448#2,3:427\n1855#2,2:430\n1855#2:432\n1855#2,2:433\n1856#2:435\n288#2,2:436\n1855#2,2:438\n1855#2,2:440\n20#3:424\n*S KotlinDebug\n*F\n+ 1 TranslationManager.kt\nde/fraunhofer/aisec/cpg/TranslationManager\n*L\n158#1:421\n158#1:422,2\n174#1:425,2\n158#1:427,3\n194#1:430,2\n236#1:432\n237#1:433,2\n236#1:435\n395#1:436,2\n113#1:438,2\n117#1:440,2\n174#1:424\n*E\n"})
public final class TranslationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TranslationConfiguration config;
    @NotNull
    private final AtomicBoolean isCancelled;
    private static final Logger log = LoggerFactory.getLogger(TranslationManager.class);

    private TranslationManager(TranslationConfiguration config) {
        this.config = config;
        this.isCancelled = new AtomicBoolean(false);
    }

    @NotNull
    public final TranslationConfiguration getConfig() {
        return this.config;
    }

    @NotNull
    public final CompletableFuture<TranslationResult> analyze() {
        TranslationResult result = new TranslationResult(this, new ScopeManager());
        CompletableFuture<TranslationResult> completableFuture = CompletableFuture.supplyAsync(() -> TranslationManager.analyze$lambda$2(result, this));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync {\n          \u2026         result\n        }");
        return completableFuture;
    }

    @NotNull
    public final List<Pass> getPasses() {
        return this.config.getRegisteredPasses();
    }

    public final boolean isCancelled() {
        return this.isCancelled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Set<LanguageFrontend> runFrontends(TranslationResult result, TranslationConfiguration config) throws TranslationException {
        usedFrontends = new LinkedHashSet<E>();
        for (String sc : this.config.getSoftwareComponents().keySet()) {
            block19: {
                block17: {
                    component = new Component();
                    component.setName(new Name(sc, null, null, 6, null));
                    result.addComponent(component);
                    v0 = this.config.getSoftwareComponents().get(sc);
                    Intrinsics.checkNotNull(v0);
                    sourceLocations = v0;
                    useParallelFrontends = false;
                    useParallelFrontends = config.getUseParallelFrontends();
                    $this$flatMap$iv = sourceLocations;
                    $i$f$flatMap = false;
                    var12_13 = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$flatMapTo = false;
                    for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                        block16: {
                            block14: {
                                block15: {
                                    file = (File)element$iv$iv;
                                    $i$a$-flatMap-TranslationManager$runFrontends$list$1 = false;
                                    if (!file.isDirectory()) break block15;
                                    v1 = Files.find(file.toPath(), 999, (BiPredicate<Path, BasicFileAttributes>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Z, runFrontends$lambda$5$lambda$3(java.nio.file.Path java.nio.file.attribute.BasicFileAttributes ), (Ljava/nio/file/Path;Ljava/nio/file/attribute/BasicFileAttributes;)Z)(), new FileVisitOption[0]).map((Function<Object, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, runFrontends$lambda$5$lambda$4(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Ljava/io/File;)((Function1)runFrontends.list.1.2.INSTANCE)).collect(Collectors.toList());
                                    break block16;
                                }
                                v2 = this.getLanguage(file);
                                frontendClass = v2 != null ? v2.getFrontend() : null;
                                var20_30 = this.getLanguage(file);
                                if (var20_30 == null || (var21_32 = var20_30.getFrontend()) == null) ** GOTO lbl-1000
                                var22_34 = (KAnnotatedElement)var21_32;
                                $i$f$findAnnotation = false;
                                $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                                $i$f$firstOrNull = false;
                                for (T element$iv$iv : $this$firstOrNull$iv$iv) {
                                    it$iv = (Annotation)element$iv$iv;
                                    $i$a$-firstOrNull-KAnnotatedElements$findAnnotation$1$iv = false;
                                    if (!(it$iv instanceof SupportsParallelParsing)) continue;
                                    v3 = element$iv$iv;
                                    break block14;
                                }
                                v3 = null;
                            }
                            if ((var30_42 = (SupportsParallelParsing)((Annotation)v3)) != null) {
                                v4 = var30_42.supported();
                            } else lbl-1000:
                            // 2 sources

                            {
                                v4 = supportsParallelParsing = true;
                            }
                            if (useParallelFrontends && !supportsParallelParsing) {
                                v5 = frontendClass;
                                TranslationManager.log.warn("Parallel frontends are not yet supported for the language frontend " + (v5 != null ? v5.getSimpleName() : null));
                                useParallelFrontends = false;
                            }
                            v1 = CollectionsKt.listOf((Object)file);
                        }
                        var32_44 = v1;
                        Intrinsics.checkNotNullExpressionValue(var32_44, (String)"if (file.isDirectory) {\n\u2026le)\n                    }");
                        list$iv$iv = var32_44;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                    if (!config.getUseUnityBuild()) break block17;
                    tmpFile = Files.createTempFile("compile", ".cpp", new FileAttribute[0]).toFile();
                    tmpFile.deleteOnExit();
                    $i$f$flatMap = new PrintWriter(tmpFile);
                    var12_13 = null;
                    try {
                        writer = (PrintWriter)$i$f$flatMap;
                        $i$a$-use-TranslationManager$runFrontends$1 = false;
                        $this$forEach$iv = list;
                        $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv) {
                            it = (File)element$iv;
                            $i$a$-forEach-TranslationManager$runFrontends$1$1 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            if (!CXXLanguageFrontend.CXX_EXTENSIONS.contains(Util.INSTANCE.getExtension(it))) continue;
                            if (config.getTopLevel() != null) {
                                topLevel = config.getTopLevel().toPath();
                                writer.write(StringsKt.trimIndent((String)("\n#include \"" + topLevel.relativize(it.toPath()) + "\"\n\n")));
                                continue;
                            }
                            writer.write(StringsKt.trimIndent((String)("\n#include \"" + it.getAbsolutePath() + "\"\n\n")));
                        }
                        writer = Unit.INSTANCE;
                    }
                    catch (Throwable writer) {
                        try {
                            var12_13 = writer;
                            throw writer;
                        }
                        catch (Throwable writer) {
                            CloseableKt.closeFinally((Closeable)$i$f$flatMap, (Throwable)var12_13);
                            throw writer;
                        }
                    }
                    CloseableKt.closeFinally((Closeable)$i$f$flatMap, var12_13);
                    sourceLocations = CollectionsKt.listOf((Object)tmpFile);
                    break block19;
                }
                sourceLocations = list;
            }
            TypeManager.setTypeSystemActive(config.getTypeSystemActiveInFrontend());
            usedFrontends.addAll((Collection)(useParallelFrontends != false ? this.parseParallel(component, result, sourceLocations) : this.parseSequentially(component, result, sourceLocations)));
            if (config.getTypeSystemActiveInFrontend()) continue;
            TypeManager.setTypeSystemActive(true);
            $this$forEach$iv = result.getComponents();
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                s = (Component)element$iv;
                $i$a$-forEach-TranslationManager$runFrontends$2 = false;
                $this$forEach$iv = s.getTranslationUnits();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (TranslationUnitDeclaration)element$iv;
                    $i$a$-forEach-TranslationManager$runFrontends$2$1 = false;
                    bench = new Benchmark(this.getClass(), "Activating types for " + it.getName(), true, null, 8, null);
                    result.getScopeManager().activateTypes(it);
                    bench.stop();
                }
            }
        }
        return usedFrontends;
    }

    private final Set<LanguageFrontend> parseParallel(Component component, TranslationResult result, Collection<? extends File> sourceLocations) {
        Set usedFrontends = new LinkedHashSet();
        log.info("Parallel parsing started");
        List futures = new ArrayList();
        List parallelScopeManagers = new ArrayList();
        Map futureToFile = new IdentityHashMap();
        for (File file : sourceLocations) {
            ScopeManager scopeManager = new ScopeManager();
            parallelScopeManagers.add(scopeManager);
            CompletableFuture<Optional> future = CompletableFuture.supplyAsync(() -> TranslationManager.parseParallel$lambda$10(this, component, scopeManager, file));
            Intrinsics.checkNotNullExpressionValue(future, (String)"future");
            futures.add(future);
            futureToFile.put(future, file);
        }
        for (CompletableFuture completableFuture : futures) {
            try {
                ((Optional)completableFuture.get()).ifPresent(arg_0 -> TranslationManager.parseParallel$lambda$11((Function1)new Function1<LanguageFrontend, Unit>(this, result, (Set<LanguageFrontend>)usedFrontends, (Map<CompletableFuture<Optional<LanguageFrontend>>, File>)futureToFile, (CompletableFuture<Optional<LanguageFrontend>>)completableFuture){
                    final /* synthetic */ TranslationManager this$0;
                    final /* synthetic */ TranslationResult $result;
                    final /* synthetic */ Set<LanguageFrontend> $usedFrontends;
                    final /* synthetic */ Map<CompletableFuture<Optional<LanguageFrontend>>, File> $futureToFile;
                    final /* synthetic */ CompletableFuture<Optional<LanguageFrontend>> $future;
                    {
                        this.this$0 = $receiver;
                        this.$result = $result;
                        this.$usedFrontends = $usedFrontends;
                        this.$futureToFile = $futureToFile;
                        this.$future = $future;
                        super(1);
                    }

                    public final void invoke(@NotNull LanguageFrontend f) {
                        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                        TranslationManager.access$handleCompletion(this.this$0, this.$result, this.$usedFrontends, this.$futureToFile.get(this.$future), f);
                    }
                }, arg_0));
            }
            catch (InterruptedException e) {
                log.error("Error parsing " + futureToFile.get(completableFuture), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                log.error("Error parsing " + futureToFile.get(completableFuture), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        result.getScopeManager().mergeFrom(parallelScopeManagers);
        log.info("Parallel parsing completed");
        return usedFrontends;
    }

    private final Set<LanguageFrontend> parseSequentially(Component component, TranslationResult result, Collection<? extends File> sourceLocations) throws TranslationException {
        Set usedFrontends = new LinkedHashSet();
        for (File file : sourceLocations) {
            log.info("Parsing {}", (Object)file.getAbsolutePath());
            this.parse(component, result.getScopeManager(), file).ifPresent(arg_0 -> TranslationManager.parseSequentially$lambda$12((Function1)new Function1<LanguageFrontend, Unit>(this, result, (Set<LanguageFrontend>)usedFrontends, file){
                final /* synthetic */ TranslationManager this$0;
                final /* synthetic */ TranslationResult $result;
                final /* synthetic */ Set<LanguageFrontend> $usedFrontends;
                final /* synthetic */ File $sourceLocation;
                {
                    this.this$0 = $receiver;
                    this.$result = $result;
                    this.$usedFrontends = $usedFrontends;
                    this.$sourceLocation = $sourceLocation;
                    super(1);
                }

                public final void invoke(@NotNull LanguageFrontend f) {
                    Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                    TranslationManager.access$handleCompletion(this.this$0, this.$result, this.$usedFrontends, this.$sourceLocation, f);
                }
            }, arg_0));
        }
        return usedFrontends;
    }

    private final void handleCompletion(TranslationResult result, Set<LanguageFrontend> usedFrontends, File sourceLocation, LanguageFrontend f) {
        Map sfToFe2;
        usedFrontends.add(f);
        Object object = result.getScratch().computeIfAbsent("sourceLocationsToFrontend", arg_0 -> TranslationManager.handleCompletion$lambda$13(handleCompletion.sfToFe.1.INSTANCE, arg_0));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.String>");
        Map map = sfToFe2 = TypeIntrinsics.asMutableMap((Object)object);
        File file = sourceLocation;
        Intrinsics.checkNotNull((Object)file);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceLocation!!.name");
        String string2 = string;
        String string3 = f.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"f.javaClass.simpleName");
        String string4 = string3;
        map.put(string2, string4);
    }

    private final Optional<LanguageFrontend> parse(Component component, ScopeManager scopeManager, File sourceLocation) throws TranslationException {
        LanguageFrontend frontend;
        block4: {
            frontend = null;
            try {
                frontend = this.getFrontend(sourceLocation, scopeManager);
                if (frontend == null) {
                    log.error("Found no parser frontend for " + sourceLocation.getName());
                    if (this.config.getFailOnError()) {
                        throw new TranslationException("Found no parser frontend for " + sourceLocation.getName());
                    }
                    Optional<LanguageFrontend> optional = Optional.empty();
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
                    return optional;
                }
                component.getTranslationUnits().add(frontend.parse(sourceLocation));
            }
            catch (TranslationException ex) {
                log.error("An error occurred during parsing of " + sourceLocation.getName() + ": " + ex.getMessage());
                if (!this.config.getFailOnError()) break block4;
                throw ex;
            }
        }
        Optional<LanguageFrontend> optional = Optional.ofNullable(frontend);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(frontend)");
        return optional;
    }

    private final LanguageFrontend getFrontend(File file, ScopeManager scopeManager) {
        LanguageFrontend languageFrontend;
        Language<?> language = this.getLanguage(file);
        if (language != null) {
            Object obj;
            try {
                obj = language.newFrontend(this.config, scopeManager);
            }
            catch (Exception e) {
                Exception exception = e;
                if (!(((exception instanceof InstantiationException ? true : exception instanceof IllegalAccessException) ? true : exception instanceof InvocationTargetException) ? true : exception instanceof NoSuchMethodException)) {
                    throw e;
                }
                log.error("Could not instantiate language frontend {}", (Object)language.getFrontend().getSimpleName(), (Object)e);
                obj = null;
            }
            languageFrontend = (LanguageFrontend)obj;
        } else {
            languageFrontend = null;
        }
        return languageFrontend;
    }

    private final Language<?> getLanguage(File $this$language) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.config.getLanguages();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Language it = (Language)element$iv;
                boolean bl = false;
                if (!it.handlesFile($this$language)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final TranslationResult analyze$lambda$2(TranslationResult $result, TranslationManager this$0) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Benchmark outerBench = new Benchmark(TranslationManager.class, "Translation into full graph", false, $result);
        Set executedPasses = new LinkedHashSet();
        Set<LanguageFrontend> executedFrontends = SetsKt.emptySet();
        try {
            Benchmark bench = new Benchmark(this$0.getClass(), "Executing Language Frontend", false, $result);
            executedFrontends = this$0.runFrontends($result, this$0.config);
            MeasurementHolder.addMeasurement$default(bench, null, null, 3, null);
            for (Pass pass : this$0.config.getRegisteredPasses()) {
                bench = new Benchmark(pass.getClass(), "Executing Pass", false, $result);
                if (pass.runsWithCurrentFrontend((Collection<? extends LanguageFrontend>)executedFrontends)) {
                    executedPasses.add(pass);
                    pass.accept($result);
                }
                MeasurementHolder.addMeasurement$default(bench, null, null, 3, null);
                if (!$result.isCancelled()) continue;
                log.warn("Analysis interrupted, stopping Pass evaluation");
            }
        }
        catch (TranslationException ex) {
            try {
                throw new CompletionException(ex);
            }
            catch (Throwable throwable) {
                MeasurementHolder.addMeasurement$default(outerBench, null, null, 3, null);
                if (!this$0.config.getDisableCleanup()) {
                    boolean bl;
                    Object it;
                    log.debug("Cleaning up {} Passes", (Object)executedPasses.size());
                    Iterable $this$forEach$iv = executedPasses;
                    boolean bl2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (Pass)element$iv;
                        bl = false;
                        ((Pass)it).cleanup();
                    }
                    log.debug("Cleaning up {} Frontends", (Object)executedFrontends.size());
                    $this$forEach$iv = executedFrontends;
                    boolean bl3 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (LanguageFrontend)element$iv;
                        bl = false;
                        ((LanguageFrontend)it).cleanup();
                    }
                    TypeManager.getInstance().cleanup();
                }
                throw throwable;
            }
        }
        MeasurementHolder.addMeasurement$default(outerBench, null, null, 3, null);
        if (!this$0.config.getDisableCleanup()) {
            Object it;
            log.debug("Cleaning up {} Passes", (Object)executedPasses.size());
            Iterable $this$forEach$iv = executedPasses;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Pass)element$iv;
                boolean bl = false;
                ((Pass)it).cleanup();
            }
            log.debug("Cleaning up {} Frontends", (Object)executedFrontends.size());
            $this$forEach$iv = executedFrontends;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LanguageFrontend)element$iv;
                boolean bl = false;
                ((LanguageFrontend)it).cleanup();
            }
            TypeManager.getInstance().cleanup();
        }
        return $result;
    }

    private static final boolean runFrontends$lambda$5$lambda$3(Path path, BasicFileAttributes fileAttr) {
        Intrinsics.checkNotNullParameter((Object)fileAttr, (String)"fileAttr");
        return fileAttr.isRegularFile();
    }

    private static final File runFrontends$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (File)$tmp0.invoke(p0);
    }

    private static final Optional parseParallel$lambda$10(TranslationManager this$0, Component $component, ScopeManager $scopeManager, File $sourceLocation) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$component, (String)"$component");
        Intrinsics.checkNotNullParameter((Object)$scopeManager, (String)"$scopeManager");
        Intrinsics.checkNotNullParameter((Object)$sourceLocation, (String)"$sourceLocation");
        try {
            return this$0.parse($component, $scopeManager, $sourceLocation);
        }
        catch (TranslationException e) {
            throw new RuntimeException("Error parsing " + $sourceLocation, e);
        }
    }

    private static final void parseParallel$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void parseSequentially$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Object handleCompletion$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    public static final /* synthetic */ void access$handleCompletion(TranslationManager $this, TranslationResult result, Set usedFrontends, File sourceLocation, LanguageFrontend f) {
        $this.handleCompletion(result, usedFrontends, sourceLocation, f);
    }

    public /* synthetic */ TranslationManager(TranslationConfiguration config, DefaultConstructorMarker $constructor_marker) {
        this(config);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lde/fraunhofer/aisec/cpg/TranslationManager$Builder;", "", "()V", "config", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "build", "Lde/fraunhofer/aisec/cpg/TranslationManager;", "cpg-core"})
    public static final class Builder {
        @NotNull
        private TranslationConfiguration config = TranslationConfiguration.Companion.builder().build();

        @NotNull
        public final Builder config(@NotNull TranslationConfiguration config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.config = config;
            return this;
        }

        @NotNull
        public final TranslationManager build() {
            return new TranslationManager(this.config, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/fraunhofer/aisec/cpg/TranslationManager$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "builder", "Lde/fraunhofer/aisec/cpg/TranslationManager$Builder;", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

