/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import de.fraunhofer.aisec.cpg.ConfigurationException;
import de.fraunhofer.aisec.cpg.InferenceConfiguration;
import de.fraunhofer.aisec.cpg.frontends.CompilationDatabase;
import de.fraunhofer.aisec.cpg.frontends.Language;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.cpp.CLanguage;
import de.fraunhofer.aisec.cpg.frontends.cpp.CPPLanguage;
import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguage;
import de.fraunhofer.aisec.cpg.passes.CallResolver;
import de.fraunhofer.aisec.cpg.passes.ControlFlowSensitiveDFGPass;
import de.fraunhofer.aisec.cpg.passes.DFGPass;
import de.fraunhofer.aisec.cpg.passes.EvaluationOrderGraphPass;
import de.fraunhofer.aisec.cpg.passes.FilenameMapper;
import de.fraunhofer.aisec.cpg.passes.FunctionPointerCallResolver;
import de.fraunhofer.aisec.cpg.passes.ImportResolver;
import de.fraunhofer.aisec.cpg.passes.JavaExternalTypeHierarchyResolver;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.TypeHierarchyResolver;
import de.fraunhofer.aisec.cpg.passes.TypeResolver;
import de.fraunhofer.aisec.cpg.passes.VariableUsageResolver;
import de.fraunhofer.aisec.cpg.passes.order.PassWithDependencies;
import de.fraunhofer.aisec.cpg.passes.order.PassWithDepsContainer;
import de.fraunhofer.aisec.cpg.passes.order.RegisterExtraPass;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KAnnotatedElements;
import kotlin.reflect.full.KClasses;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b&\u0018\u0000 D2\u00020\u0001:\u0002CDB\u00f7\u0001\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006\u0012\u0014\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00140\u0006\u0012\u0006\u0010\u0016\u001a\u00020\n\u0012\u0006\u0010\u0017\u001a\u00020\n\u0012\u0006\u0010\u0018\u001a\u00020\n\u0012\u0006\u0010\u0019\u001a\u00020\n\u0012\u0006\u0010\u001a\u001a\u00020\n\u0012\u0006\u0010\u001b\u001a\u00020\n\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u0012\u0006\u0010 \u001a\u00020\n\u0012\u0006\u0010!\u001a\u00020\n\u00a2\u0006\u0002\u0010\"J\b\u0010B\u001a\u00020\u0004H\u0016R\u0011\u0010!\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0010\u0010\u0016\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010$R\u001a\u0010\u0018\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010$\"\u0004\b)\u0010*R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010$R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010-R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010-R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001f\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00140\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010-R\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010$R\u0011\u0010 \u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010$R\u0011\u0010\u0017\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010$R\u0019\u00106\u001a\b\u0012\u0004\u0012\u00020\u00120\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010-R#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0017\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b;\u0010-R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u00109R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0011\u0010\u001b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010$R\u0011\u0010\u001a\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010$R\u0011\u0010\u0019\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010$\u00a8\u0006E"}, d2={"Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "", "symbols", "", "", "softwareComponents", "", "Ljava/io/File;", "topLevel", "debugParser", "", "failOnError", "loadIncludes", "includePaths", "Ljava/nio/file/Path;", "includeWhitelist", "includeBlocklist", "passes", "Lde/fraunhofer/aisec/cpg/passes/Pass;", "languages", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "codeInNodes", "processAnnotations", "disableCleanup", "useUnityBuild", "useParallelFrontends", "typeSystemActiveInFrontend", "inferenceConfiguration", "Lde/fraunhofer/aisec/cpg/InferenceConfiguration;", "compilationDatabase", "Lde/fraunhofer/aisec/cpg/frontends/CompilationDatabase;", "matchCommentsToNodes", "addIncludesToGraph", "(Ljava/util/Map;Ljava/util/Map;Ljava/io/File;ZZZLjava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;ZZZZZZLde/fraunhofer/aisec/cpg/InferenceConfiguration;Lde/fraunhofer/aisec/cpg/frontends/CompilationDatabase;ZZ)V", "getAddIncludesToGraph", "()Z", "getCompilationDatabase", "()Lde/fraunhofer/aisec/cpg/frontends/CompilationDatabase;", "getDebugParser", "getDisableCleanup", "setDisableCleanup", "(Z)V", "getFailOnError", "getIncludeBlocklist", "()Ljava/util/List;", "getIncludePaths", "getIncludeWhitelist", "getInferenceConfiguration", "()Lde/fraunhofer/aisec/cpg/InferenceConfiguration;", "getLanguages", "getLoadIncludes", "getMatchCommentsToNodes", "getProcessAnnotations", "registeredPasses", "getRegisteredPasses", "getSoftwareComponents", "()Ljava/util/Map;", "sourceLocations", "getSourceLocations", "getSymbols", "getTopLevel", "()Ljava/io/File;", "getTypeSystemActiveInFrontend", "getUseParallelFrontends", "getUseUnityBuild", "toString", "Builder", "Companion", "cpg-core"})
public final class TranslationConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, String> symbols;
    @NotNull
    private final Map<String, List<File>> softwareComponents;
    @Nullable
    private final File topLevel;
    private final boolean debugParser;
    private final boolean failOnError;
    private final boolean loadIncludes;
    @NotNull
    private final List<Path> includePaths;
    @NotNull
    private final List<Path> includeWhitelist;
    @NotNull
    private final List<Path> includeBlocklist;
    @NotNull
    private final List<Language<? extends LanguageFrontend>> languages;
    private boolean disableCleanup;
    @JvmField
    public final boolean codeInNodes;
    private final boolean processAnnotations;
    private final boolean useUnityBuild;
    private final boolean useParallelFrontends;
    private final boolean typeSystemActiveInFrontend;
    @Nullable
    private final CompilationDatabase compilationDatabase;
    private final boolean matchCommentsToNodes;
    private final boolean addIncludesToGraph;
    @NotNull
    private final List<Pass> registeredPasses;
    @NotNull
    private final InferenceConfiguration inferenceConfiguration;
    private static final Logger log = LoggerFactory.getLogger(TranslationConfiguration.class);

    private TranslationConfiguration(Map<String, String> symbols, Map<String, ? extends List<? extends File>> softwareComponents, File topLevel, boolean debugParser, boolean failOnError, boolean loadIncludes, List<? extends Path> includePaths, List<? extends Path> includeWhitelist, List<? extends Path> includeBlocklist, List<? extends Pass> passes, List<? extends Language<? extends LanguageFrontend>> languages, boolean codeInNodes, boolean processAnnotations, boolean disableCleanup, boolean useUnityBuild, boolean useParallelFrontends, boolean typeSystemActiveInFrontend, InferenceConfiguration inferenceConfiguration, CompilationDatabase compilationDatabase, boolean matchCommentsToNodes, boolean addIncludesToGraph) {
        this.symbols = symbols;
        this.softwareComponents = softwareComponents;
        this.topLevel = topLevel;
        this.debugParser = debugParser;
        this.failOnError = failOnError;
        this.loadIncludes = loadIncludes;
        this.includePaths = includePaths;
        this.includeWhitelist = includeWhitelist;
        this.includeBlocklist = includeBlocklist;
        this.registeredPasses = passes;
        this.languages = languages;
        this.codeInNodes = codeInNodes;
        this.processAnnotations = processAnnotations;
        this.disableCleanup = disableCleanup;
        this.useUnityBuild = useUnityBuild;
        this.useParallelFrontends = useParallelFrontends;
        this.typeSystemActiveInFrontend = typeSystemActiveInFrontend;
        this.inferenceConfiguration = inferenceConfiguration;
        this.compilationDatabase = compilationDatabase;
        this.matchCommentsToNodes = matchCommentsToNodes;
        this.addIncludesToGraph = addIncludesToGraph;
    }

    @NotNull
    public final Map<String, String> getSymbols() {
        return this.symbols;
    }

    @NotNull
    public final Map<String, List<File>> getSoftwareComponents() {
        return this.softwareComponents;
    }

    @Nullable
    public final File getTopLevel() {
        return this.topLevel;
    }

    public final boolean getDebugParser() {
        return this.debugParser;
    }

    public final boolean getFailOnError() {
        return this.failOnError;
    }

    public final boolean getLoadIncludes() {
        return this.loadIncludes;
    }

    @NotNull
    public final List<Path> getIncludePaths() {
        return this.includePaths;
    }

    @NotNull
    public final List<Path> getIncludeWhitelist() {
        return this.includeWhitelist;
    }

    @NotNull
    public final List<Path> getIncludeBlocklist() {
        return this.includeBlocklist;
    }

    @NotNull
    public final List<Language<? extends LanguageFrontend>> getLanguages() {
        return this.languages;
    }

    public final boolean getDisableCleanup() {
        return this.disableCleanup;
    }

    public final void setDisableCleanup(boolean bl) {
        this.disableCleanup = bl;
    }

    public final boolean getProcessAnnotations() {
        return this.processAnnotations;
    }

    public final boolean getUseUnityBuild() {
        return this.useUnityBuild;
    }

    public final boolean getUseParallelFrontends() {
        return this.useParallelFrontends;
    }

    public final boolean getTypeSystemActiveInFrontend() {
        return this.typeSystemActiveInFrontend;
    }

    @Nullable
    public final CompilationDatabase getCompilationDatabase() {
        return this.compilationDatabase;
    }

    public final boolean getMatchCommentsToNodes() {
        return this.matchCommentsToNodes;
    }

    public final boolean getAddIncludesToGraph() {
        return this.addIncludesToGraph;
    }

    @JsonIdentityReference(alwaysAsId=true)
    @JsonIdentityInfo(property="name", generator=ObjectIdGenerators.PropertyGenerator.class)
    @NotNull
    public final List<Pass> getRegisteredPasses() {
        return this.registeredPasses;
    }

    @NotNull
    public final InferenceConfiguration getInferenceConfiguration() {
        return this.inferenceConfiguration;
    }

    @NotNull
    public final List<File> getSourceLocations() {
        List sourceLocations = new ArrayList();
        Iterator<Map.Entry<String, List<File>>> iterator = this.softwareComponents.entrySet().iterator();
        while (iterator.hasNext()) {
            List<File> value = iterator.next().getValue();
            sourceLocations.addAll((Collection)value);
        }
        return sourceLocations;
    }

    @NotNull
    public String toString() {
        String string = ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reflectionToString(this, ToStringStyle.JSON_STYLE)");
        return string;
    }

    public /* synthetic */ TranslationConfiguration(Map symbols, Map softwareComponents, File topLevel, boolean debugParser, boolean failOnError, boolean loadIncludes, List includePaths, List includeWhitelist, List includeBlocklist, List passes, List languages, boolean codeInNodes, boolean processAnnotations, boolean disableCleanup, boolean useUnityBuild, boolean useParallelFrontends, boolean typeSystemActiveInFrontend, InferenceConfiguration inferenceConfiguration, CompilationDatabase compilationDatabase, boolean matchCommentsToNodes, boolean addIncludesToGraph, DefaultConstructorMarker $constructor_marker) {
        this(symbols, softwareComponents, topLevel, debugParser, failOnError, loadIncludes, includePaths, includeWhitelist, includeBlocklist, passes, languages, codeInNodes, processAnnotations, disableCleanup, useUnityBuild, useParallelFrontends, typeSystemActiveInFrontend, inferenceConfiguration, compilationDatabase, matchCommentsToNodes, addIncludesToGraph);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/fraunhofer/aisec/cpg/TranslationConfiguration$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "builder", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration$Builder;", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010%\u001a\u00020&J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0004J\b\u0010(\u001a\u00020)H\u0002J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0004J\u0006\u0010*\u001a\u00020\u0000J\u0006\u0010+\u001a\u00020\u0000J\u0006\u0010\t\u001a\u00020\u0000J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\rJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u001cJ\u000e\u0010-\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\rJ\u000e\u0010-\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u001cJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u001cJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0004J\u000e\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u001cJ\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u00180\u001dH\u0002J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0004J\b\u00102\u001a\u000203H\u0002J\u001d\u00104\u001a\u00020\u0000\"\u0012\b\u0000\u00105\u0018\u0001*\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013H\u0086\bJ\u0016\u00104\u001a\u00020\u00002\u000e\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013J\u000e\u00104\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u001cJ\u000e\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0018J \u0010\u001a\u001a\u00020\u00002\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001bJ\u001f\u00109\u001a\u00020\u00002\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0:\"\u00020\u001e\u00a2\u0006\u0002\u0010;J\u0014\u00109\u001a\u00020\u00002\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\u001a\u0010\u001f\u001a\u00020\u00002\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0 J\u0010\u0010!\u001a\u00020\u00002\b\u0010!\u001a\u0004\u0018\u00010\u001eJ\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0004J \u0010<\u001a\u00020\u00002\u0018\u00106\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0014\u0018\u00010\u00130=J\u0010\u0010>\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0004J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00130\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lde/fraunhofer/aisec/cpg/TranslationConfiguration$Builder;", "", "()V", "addIncludesToGraph", "", "codeInNodes", "compilationDatabase", "Lde/fraunhofer/aisec/cpg/frontends/CompilationDatabase;", "debugParser", "disableCleanup", "failOnError", "includeBlocklist", "", "Ljava/nio/file/Path;", "includePaths", "includeWhitelist", "inferenceConfiguration", "Lde/fraunhofer/aisec/cpg/InferenceConfiguration;", "languages", "Lde/fraunhofer/aisec/cpg/frontends/Language;", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "loadIncludes", "matchCommentsToNodes", "passes", "Lde/fraunhofer/aisec/cpg/passes/Pass;", "processAnnotations", "softwareComponents", "", "", "", "Ljava/io/File;", "symbols", "", "topLevel", "typeSystemActiveInFrontend", "useParallelFrontends", "useUnityBuild", "build", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "b", "collectInitialPasses", "Lde/fraunhofer/aisec/cpg/passes/order/PassWithDepsContainer;", "defaultLanguages", "defaultPasses", "includeFile", "includePath", "configuration", "optionalLanguage", "className", "orderPasses", "registerExtraFrontendPasses", "", "registerLanguage", "T", "language", "registerPass", "pass", "sourceLocations", "", "([Ljava/io/File;)Lde/fraunhofer/aisec/cpg/TranslationConfiguration$Builder;", "unregisterLanguage", "Ljava/lang/Class;", "useCompilationDatabase", "cpg-core"})
    @SourceDebugExtension(value={"SMAP\nTranslationConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranslationConfiguration.kt\nde/fraunhofer/aisec/cpg/TranslationConfiguration$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n*L\n1#1,714:1\n1#2:715\n1549#3:716\n1620#3,3:717\n766#3:721\n857#3,2:722\n1855#3,2:724\n43#4:720\n*S KotlinDebug\n*F\n+ 1 TranslationConfiguration.kt\nde/fraunhofer/aisec/cpg/TranslationConfiguration$Builder\n*L\n456#1:716\n456#1:717,3\n612#1:721\n612#1:722,2\n613#1:724,2\n457#1:720\n*E\n"})
    public static final class Builder {
        @NotNull
        private Map<String, List<File>> softwareComponents = new HashMap();
        @NotNull
        private final List<Language<? extends LanguageFrontend>> languages = new ArrayList();
        @Nullable
        private File topLevel;
        private boolean debugParser;
        private boolean failOnError;
        private boolean loadIncludes;
        @NotNull
        private Map<String, String> symbols = MapsKt.emptyMap();
        @NotNull
        private final List<Path> includePaths = new ArrayList();
        @NotNull
        private final List<Path> includeWhitelist = new ArrayList();
        @NotNull
        private final List<Path> includeBlocklist = new ArrayList();
        @NotNull
        private final List<Pass> passes = new ArrayList();
        private boolean codeInNodes = true;
        private boolean processAnnotations;
        private boolean disableCleanup;
        private boolean useUnityBuild;
        private boolean useParallelFrontends;
        private boolean typeSystemActiveInFrontend = true;
        @NotNull
        private InferenceConfiguration inferenceConfiguration = new InferenceConfiguration.Builder(false, false, false, 7, null).build();
        @Nullable
        private CompilationDatabase compilationDatabase;
        private boolean matchCommentsToNodes;
        private boolean addIncludesToGraph = true;

        @NotNull
        public final Builder symbols(@NotNull Map<String, String> symbols) {
            Intrinsics.checkNotNullParameter(symbols, (String)"symbols");
            this.symbols = symbols;
            return this;
        }

        @NotNull
        public final Builder sourceLocations(File ... sourceLocations) {
            Intrinsics.checkNotNullParameter((Object)sourceLocations, (String)"sourceLocations");
            this.softwareComponents.put("application", ArraysKt.toMutableList((Object[])sourceLocations));
            return this;
        }

        @NotNull
        public final Builder sourceLocations(@NotNull List<? extends File> sourceLocations) {
            Intrinsics.checkNotNullParameter(sourceLocations, (String)"sourceLocations");
            this.softwareComponents.put("application", CollectionsKt.toMutableList((Collection)sourceLocations));
            return this;
        }

        @NotNull
        public final Builder softwareComponents(@NotNull Map<String, List<File>> softwareComponents) {
            Intrinsics.checkNotNullParameter(softwareComponents, (String)"softwareComponents");
            this.softwareComponents = softwareComponents;
            return this;
        }

        @NotNull
        public final Builder useCompilationDatabase(@Nullable CompilationDatabase compilationDatabase) {
            this.compilationDatabase = compilationDatabase;
            return this;
        }

        @NotNull
        public final Builder topLevel(@Nullable File topLevel) {
            this.topLevel = topLevel;
            return this;
        }

        @NotNull
        public final Builder debugParser(boolean debugParser) {
            this.debugParser = debugParser;
            return this;
        }

        @NotNull
        public final Builder matchCommentsToNodes(boolean matchCommentsToNodes) {
            this.matchCommentsToNodes = matchCommentsToNodes;
            return this;
        }

        @NotNull
        public final Builder addIncludesToGraph(boolean addIncludesToGraph) {
            this.addIncludesToGraph = addIncludesToGraph;
            return this;
        }

        @NotNull
        public final Builder failOnError(boolean failOnError) {
            this.failOnError = failOnError;
            return this;
        }

        @NotNull
        public final Builder loadIncludes(boolean loadIncludes) {
            this.loadIncludes = loadIncludes;
            return this;
        }

        @NotNull
        public final Builder includePath(@NotNull String includePath) {
            Intrinsics.checkNotNullParameter((Object)includePath, (String)"includePath");
            Path path = Path.of(includePath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(includePath)");
            this.includePaths.add(path);
            return this;
        }

        @NotNull
        public final Builder includePath(@NotNull Path includePath) {
            Intrinsics.checkNotNullParameter((Object)includePath, (String)"includePath");
            this.includePaths.add(includePath);
            return this;
        }

        @NotNull
        public final Builder includeWhitelist(@NotNull String includeFile) {
            Intrinsics.checkNotNullParameter((Object)includeFile, (String)"includeFile");
            Path path = Path.of(includeFile, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(includeFile)");
            this.includeWhitelist.add(path);
            return this;
        }

        @NotNull
        public final Builder includeWhitelist(@NotNull Path includeFile) {
            Intrinsics.checkNotNullParameter((Object)includeFile, (String)"includeFile");
            this.includeWhitelist.add(includeFile);
            return this;
        }

        @NotNull
        public final Builder disableCleanup() {
            this.disableCleanup = true;
            return this;
        }

        @NotNull
        public final Builder includeBlocklist(@NotNull String includeFile) {
            Intrinsics.checkNotNullParameter((Object)includeFile, (String)"includeFile");
            Path path = Path.of(includeFile, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(includeFile)");
            this.includeBlocklist.add(path);
            return this;
        }

        @NotNull
        public final Builder includeBlocklist(@NotNull Path includeFile) {
            Intrinsics.checkNotNullParameter((Object)includeFile, (String)"includeFile");
            this.includeBlocklist.add(includeFile);
            return this;
        }

        @NotNull
        public final Builder registerPass(@NotNull Pass pass) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            this.passes.add(pass);
            return this;
        }

        @NotNull
        public final Builder registerLanguage(@NotNull Language<? extends LanguageFrontend> language) {
            Intrinsics.checkNotNullParameter(language, (String)"language");
            this.languages.add(language);
            log.info("Registered language frontend '" + Reflection.getOrCreateKotlinClass(language.getClass()).getSimpleName() + "' for following file types: " + language.getFileExtensions());
            return this;
        }

        public final /* synthetic */ <T extends Language<? extends LanguageFrontend>> Builder registerLanguage() {
            block0: {
                boolean $i$f$registerLanguage = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                Object object = KClasses.getPrimaryConstructor((KClass)Reflection.getOrCreateKotlinClass(Language.class));
                if (object == null || (object = (Language)object.call(new Object[0])) == null) break block0;
                Language it = (Language)object;
                boolean bl = false;
                this.registerLanguage(it);
            }
            return this;
        }

        @NotNull
        public final Builder registerLanguage(@NotNull String className) throws ConfigurationException {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            try {
                Language loadedClass;
                Class<?> clazz = Class.forName(className);
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(className)");
                Object object = KClasses.createInstance((KClass)JvmClassMappingKt.getKotlinClass(clazz));
                Language language = loadedClass = object instanceof Language ? (Language)object : null;
                if (loadedClass == null) {
                    throw new ConfigurationException("Failed casting supposed language class '" + className + "'. It does not seem to be an implementation of Language<*>.");
                }
                this.registerLanguage(loadedClass);
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to load and instantiate class from FQN '" + className + "'. Possible causes of this error:\n- the given class is unavailable in the class path\n- the given class does not have a single no-arg constructor\n");
            }
            return this;
        }

        @NotNull
        public final Builder unregisterLanguage(@NotNull Class<? extends Language<? extends LanguageFrontend>> language) {
            Intrinsics.checkNotNullParameter(language, (String)"language");
            this.languages.removeIf(arg_0 -> Builder.unregisterLanguage$lambda$1((Function1)new Function1<Language<? extends LanguageFrontend>, Boolean>(language){
                final /* synthetic */ Class<? extends Language<? extends LanguageFrontend>> $language;
                {
                    this.$language = $language;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@Nullable Language<? extends LanguageFrontend> obj) {
                    return this.$language.isInstance(obj);
                }
            }, arg_0));
            return this;
        }

        @NotNull
        public final Builder defaultPasses() {
            this.registerPass(new TypeHierarchyResolver());
            this.registerPass(new JavaExternalTypeHierarchyResolver());
            this.registerPass(new ImportResolver());
            this.registerPass(new VariableUsageResolver());
            this.registerPass(new CallResolver());
            this.registerPass(new DFGPass());
            this.registerPass(new FunctionPointerCallResolver());
            this.registerPass(new EvaluationOrderGraphPass());
            this.registerPass(new TypeResolver());
            this.registerPass(new ControlFlowSensitiveDFGPass());
            this.registerPass(new FilenameMapper());
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private final void registerExtraFrontendPasses() throws ConfigurationException {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.languages;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                Language language = (Language)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getFrontend());
            }
            for (KClass frontend : (List)destination$iv$iv) {
                KAnnotatedElement $this$findAnnotations$iv = (KAnnotatedElement)frontend;
                boolean $i$f$findAnnotations = false;
                List extraPasses = KAnnotatedElements.findAnnotations((KAnnotatedElement)$this$findAnnotations$iv, (KClass)Reflection.getOrCreateKotlinClass(RegisterExtraPass.class));
                if (!(!((Collection)extraPasses).isEmpty())) continue;
                for (RegisterExtraPass p : extraPasses) {
                    Pass pass;
                    KFunction kFunction = KClasses.getPrimaryConstructor((KClass)Reflection.getOrCreateKotlinClass(p.value()));
                    Pass pass2 = pass = kFunction != null ? (Pass)kFunction.call(new Object[0]) : null;
                    if (pass != null) {
                        this.registerPass(pass);
                        log.info("Registered an extra (frontend dependent) default dependency: {}", (Object)Reflection.getOrCreateKotlinClass(p.value()));
                        continue;
                    }
                    throw new ConfigurationException("Failed to load frontend because we could not register required pass dependency: " + frontend.getSimpleName());
                }
            }
        }

        @NotNull
        public final Builder defaultLanguages() {
            this.registerLanguage(new CLanguage());
            this.registerLanguage(new CPPLanguage());
            this.registerLanguage(new JavaLanguage());
            return this;
        }

        @NotNull
        public final Builder optionalLanguage(@NotNull String className) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            try {
                builder = this.registerLanguage(className);
            }
            catch (ConfigurationException e) {
                builder = this;
            }
            return builder;
        }

        @NotNull
        public final Builder codeInNodes(boolean b) {
            this.codeInNodes = b;
            return this;
        }

        @NotNull
        public final Builder processAnnotations(boolean b) {
            this.processAnnotations = b;
            return this;
        }

        @NotNull
        public final Builder useUnityBuild(boolean b) {
            this.useUnityBuild = b;
            return this;
        }

        @NotNull
        public final Builder useParallelFrontends(boolean b) {
            this.useParallelFrontends = b;
            return this;
        }

        @NotNull
        public final Builder typeSystemActiveInFrontend(boolean b) {
            this.typeSystemActiveInFrontend = b;
            return this;
        }

        @NotNull
        public final Builder inferenceConfiguration(@NotNull InferenceConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            this.inferenceConfiguration = configuration;
            return this;
        }

        @NotNull
        public final TranslationConfiguration build() throws ConfigurationException {
            if (this.useParallelFrontends && this.typeSystemActiveInFrontend) {
                log.warn("Not disabling the type system during the frontend phase is not recommended when using the parallel frontends feature! This may result in erroneous results.");
            }
            this.registerExtraFrontendPasses();
            return new TranslationConfiguration(this.symbols, this.softwareComponents, this.topLevel, this.debugParser, this.failOnError, this.loadIncludes, this.includePaths, this.includeWhitelist, this.includeBlocklist, this.orderPasses(), this.languages, this.codeInNodes, this.processAnnotations, this.disableCleanup, this.useUnityBuild, this.useParallelFrontends, this.typeSystemActiveInFrontend, this.inferenceConfiguration, this.compilationDatabase, this.matchCommentsToNodes, this.addIncludesToGraph, null);
        }

        /*
         * WARNING - void declaration
         */
        private final PassWithDepsContainer collectInitialPasses() {
            PassWithDepsContainer workingList = new PassWithDepsContainer();
            for (Pass p : this.passes) {
                Set<Class<? extends Pass>> executeBefore = p.getExecuteBefore$cpg_core();
                for (Class<? extends Pass> eb : executeBefore) {
                    void $this$forEach$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    Iterable iterable = this.passes;
                    boolean $i$f$filter = false;
                    Iterator iterator = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Pass it = (Pass)element$iv$iv;
                        boolean bl = false;
                        if (!eb.isInstance(it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Pass it = (Pass)element$iv;
                        boolean bl = false;
                        it.addSoftDependency(p.getClass());
                    }
                }
            }
            for (Pass p : this.passes) {
                boolean passFound = false;
                Iterator<Object> iterator = workingList.getWorkingList().iterator();
                while (iterator.hasNext()) {
                    Pass pass = ((PassWithDependencies)iterator.next()).component1();
                    if (!Intrinsics.areEqual(pass.getClass(), p.getClass())) continue;
                    passFound = true;
                    break;
                }
                if (passFound) continue;
                Set deps = new HashSet();
                deps.addAll((Collection)p.getHardDependencies$cpg_core());
                deps.addAll((Collection)p.getSoftDependencies$cpg_core());
                workingList.addToWorkingList(new PassWithDependencies(p, deps));
            }
            return workingList;
        }

        private final List<Pass> orderPasses() throws ConfigurationException {
            log.info("Passes before enforcing order: {}", this.passes);
            List result = new ArrayList();
            PassWithDepsContainer workingList = this.collectInitialPasses();
            log.debug("Working list after initial scan: {}", (Object)workingList);
            workingList.addMissingDependencies();
            log.debug("Working list after adding missing dependencies: {}", (Object)workingList);
            if (workingList.getFirstPasses().size() > 1) {
                log.error("Too many passes require to be executed as first pass: {}", workingList.getWorkingList());
                throw new ConfigurationException("Too many passes require to be executed as first pass.");
            }
            if (workingList.getLastPasses().size() > 1) {
                log.error("Too many passes require to be executed as last pass: {}", workingList.getLastPasses());
                throw new ConfigurationException("Too many passes require to be executed as last pass.");
            }
            Pass firstPass = workingList.getAndRemoveFirstPass();
            if (firstPass != null) {
                result.add(firstPass);
            }
            while (!workingList.isEmpty()) {
                Pass p = workingList.getAndRemoveFirstPassWithoutDependencies();
                if (p != null) {
                    result.add(p);
                    continue;
                }
                throw new ConfigurationException("Failed to satisfy ordering requirements.");
            }
            log.info("Passes after enforcing order: {}", (Object)result);
            return result;
        }

        private static final boolean unregisterLanguage$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

