/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.sarif;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class Region
implements Comparable<Region> {
    static final Region UNKNOWN_REGION = new Region();
    private int startLine;
    private int startColumn;
    private int endLine;
    private int endColumn;

    public Region(int startLine, int startColumn, int endLine, int endColumn) {
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public Region() {
        this(-1, -1, -1, -1);
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public void setStartColumn(int startColumn) {
        this.startColumn = startColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.startLine);
        sb.append(":");
        sb.append(this.startColumn);
        sb.append("-");
        sb.append(this.endLine);
        sb.append(":");
        sb.append(this.endColumn);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Region)) {
            return false;
        }
        Region that = (Region)obj;
        return this.startLine == that.startLine && this.startColumn == that.startColumn && this.endLine == that.endLine && this.endColumn == that.endColumn;
    }

    @Override
    public int compareTo(@NotNull Region region) {
        int comparisonValue = Integer.compare(this.getStartLine(), region.getStartLine());
        if (comparisonValue != 0) {
            return comparisonValue;
        }
        comparisonValue = Integer.compare(this.getStartColumn(), region.getStartColumn());
        if (comparisonValue != 0) {
            return comparisonValue;
        }
        comparisonValue = Integer.compare(this.getEndLine(), region.getEndLine());
        if (comparisonValue != 0) {
            return -comparisonValue;
        }
        comparisonValue = Integer.compare(this.getEndColumn(), region.getEndColumn());
        if (comparisonValue != 0) {
            return -comparisonValue;
        }
        return comparisonValue;
    }

    public int hashCode() {
        return Objects.hash(this.startColumn, this.startLine, this.endColumn, this.endLine);
    }
}

