/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.processing.strategy;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import java.util.Collections;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class Strategy {
    private Strategy() {
    }

    @NotNull
    public static Iterator<Node> NO_STRATEGY(@NotNull Node x) {
        return Collections.emptyIterator();
    }

    @NotNull
    public static Iterator<Node> EOG_FORWARD(@NotNull Node x) {
        return x.getNextEOG().iterator();
    }

    @NotNull
    public static Iterator<Node> EOG_BACKWARD(@NotNull Node x) {
        return x.getPrevEOG().iterator();
    }

    @NotNull
    public static Iterator<Node> DFG_FORWARD(@NotNull Node x) {
        return x.getNextDFG().iterator();
    }

    @NotNull
    public static Iterator<Node> DFG_BACKWARD(@NotNull Node x) {
        return x.getPrevDFG().iterator();
    }

    @NotNull
    public static Iterator<Node> AST_FORWARD(@NotNull Node x) {
        return SubgraphWalker.getAstChildren(x).iterator();
    }
}

